<?php

/**
 * Contao Open Source CMS
 *
 * @author    Jimmy Nogherot
 * @license   Payant
 * @copyright Tabula Rasa
 */

use trdev\ContaoTypechampBundle\Classes\TypeChamp;

$t = basename(__FILE__, '.php');

/**
 * Table tl_bien
 */
$GLOBALS['TL_DCA'][$t] = array(

    // Config
    'config'      => array(
        'dataContainer'    => 'Table',
        'pTable'           => 'tl_carte',
        'enableVersioning' => false, //True si tu veux du versionning
        'sql'              => array(
            'keys' => array(
                'id' => 'primary',
            ),
        ),
    ),

    // List
    'list'        => array(
        'sorting'           => array(
            'mode'        => 1,
            'fields'      => array('name'),
            'panelLayout' => 'filter;sort,search,limit',
            'flag'        => 11, //https://docs.contao.org/dev/reference/dca/fields/#reference
        ),
        'label'             => array(
            'fields'      => array('name'),
            'showColumns' => true,
        ),
        'global_operations' => array(
            'all' => array(
                'label'      => &$GLOBALS['TL_LANG']['MSC']['all'],
                'href'       => 'act=select',
                'class'      => 'header_edit_all',
                'attributes' => 'onclick="Backend.getScrollOffset();" accesskey="e"',
            ),
        ),
        'operations'        => array(
            'edit'   => array(
                'label' => &$GLOBALS['TL_LANG'][$t]['edit'],
                'href'  => 'act=edit',
                'icon'  => 'edit.gif',
            ),
            'copy'   => array(
                'label' => &$GLOBALS['TL_LANG'][$t]['copy'],
                'href'  => 'act=copy',
                'icon'  => 'copy.gif',
            ),
            'delete' => array(
                'label'      => &$GLOBALS['TL_LANG'][$t]['delete'],
                'href'       => 'act=delete',
                'icon'       => 'delete.gif',
                'attributes' => 'onclick="if(!confirm(\'' . $GLOBALS['TL_LANG']['MSC']['deleteConfirm'] . '\'))return false;Backend.getScrollOffset()"',
            ),
            'show'   => array(
                'label' => &$GLOBALS['TL_LANG'][$t]['show'],
                'href'  => 'act=show',
                'icon'  => 'show.gif',
            ),
        ),
    ),

    // Select
    'select'      => array(
        'buttons_callback' => array(),
    ),

    // Edit
    'edit'        => array(
        'buttons_callback' => array(),
    ),

    // Palettes
    'palettes'    => array(
        '__selector__' => array(''),
        'default'      => 'posX,posY,type,image;{fr},name,description,son,lien,video;{en},name_en,description_en,son_en,lien_en,video_en',
    ),

    // Subpalettes
    'subpalettes' => array(
        '' => 'text',
    ),

    // Fields
    'fields'      => array(
        'id'             => array(
            'sql' => "int(10) unsigned NOT NULL auto_increment",
        ),
        'tstamp'         => array(
            'sql' => "int(10) unsigned NOT NULL default '0'",
        ),
        'pid'            => TypeChamp::selectTable('tl_carte.id'),
        'posX'           => TypeChamp::number(),
        'posY'           => TypeChamp::number(),
        'type'           => TypeChamp::selectTable('tl_type_point.name'),
        'image'          => TypeChamp::fichier(),
        //Version FR
        'name'           => TypeChamp::text(true),
        'description'    => TypeChamp::textarea(),
        'son'            => TypeChamp::fichier(),
        'lien'           => TypeChamp::text(),
        'video'          => TypeChamp::text(),
        //Version Anglaise
        'name_en'        => TypeChamp::text(),
        'description_en' => TypeChamp::textarea(),
        'son_en'         => TypeChamp::fichier(),
        'lien_en'        => TypeChamp::text(),
        'video_en'       => TypeChamp::text(),
    ),
);

class tl_carte_item extends Backend
{
// public function editColumns($row, $label, DataContainer $dc, $args)
    // {
    //     $args[0] = date('d/m/Y H:i', $args[0]);
    //     $args[6] = FonctionsBlandin::printPrice($args[6]);
    // return $args;
    //}

}
