<?php

/**
 * Contao Open Source CMS
 *
 *
 * @package   CRER
 * @author    Jimmy Nogherot
 * @license   Not free
 * @copyright Tabula Rasa
 */

namespace trdev\ContaoPetitescdcBundle\Module;

/**
 * Front end module "Toolbar RGAA".
 *
 * @author Jimmy Nogherot (Tabularasa)
 */
class ModuleChangementLangue extends \Module
{
    protected $strTemplate = 'mod_changement_langue';

    public function generate()
    {
        if (TL_MODE == 'BE') {
            /** @var \BackendTemplate|object $objTemplate */
            $objTemplate = new \BackendTemplate('be_wildcard');

            $objTemplate->wildcard = '### MODULE CHANGEMENT DE LANGUE ###';
            $objTemplate->title    = $this->headline;
            $objTemplate->id       = $this->id;
            $objTemplate->link     = $this->name;
            $objTemplate->href     = 'contao/main.php?do=themes&amp;table=tl_module&amp;act=edit&amp;id=' . $this->id;

            return $objTemplate->parse();
        }

        return parent::generate();
    }
    /**
     * Template
     * @var string
     */

    protected function compile()
    {
        $this->Template->langues = [
            (object) [
                'name' => 'Français',
                'url'  => $this->getUrl(),
                'flag' => '/files/tabularasa/images/design/flag_fr.png',
            ],
            (object) [
                'name' => 'English',
                'url'  => $this->getUrl('en'),
                'flag' => '/files/tabularasa/images/design/flag_en.png',
            ],
        ];
    }

    private function getUrl($param = null)
    {
        global $objPage;

        $url = $objPage->getAbsoluteUrl();

        if (!$param) {
            return $url;
        }

        $exp = explode('?', $url);

        return $exp[0] . '?lang=' . $param;
    }
}
