<?php

namespace trdev\ContaoPetitescdcBundle\Model;

use Contao\FilesModel;

class CarteModel extends \Model
{
    protected static $strTable = 'tl_carte';

    public function getHeight()
    {
        return $this->getSize('height');
    }

    private function getSize($type)
    {
        $img   = $this->urlImg();
        $sizes = getimagesize($img);
        return ($type == 'width') ? $sizes[0] : $sizes[1];
    }

    public function getWidth()
    {
        return $this->getSize('width');
    }

    public function urlImg()
    {
        $img = FilesModel::findByUuid($this->image);
        if (!$img) {
            return '';
        }
        return $img->path;
    }

    public function printMentions()
    {
        $champ = 'mentions';
        if (Input::get('lang')) {
            $champ .= "_" . Input::get('lang');
        }

        return $str;
    }
}

class_alias(CarteModel::class, 'CarteModel');
