<?php

namespace trdev\ContaoPetitescdcBundle\Model;

use Contao\FilesModel;
use Contao\Input;
use trdev\ContaoFonctionsBundle\Util\FcAddons;

class CarteItemModel extends \Model
{
    protected static $strTable = 'tl_carte_item';

    /**
     * renvoi la bonne information en fonction de la langue
     *
     * @param  [type] $p -> paramètre, nom du champ dans la base
     * @return string
     */
    public function print($p)
    {
        $noLang = ['image'];
        $champ  = $p;

        if (Input::get('lang') && !in_array($champ, $noLang)) {
            $champ .= "_" . Input::get('lang');
        }

        if (!$this->{$champ}) {
            if (!$this->{$p}) {
                return '';
            }
            $champ = $p;
        }

        switch ($p) {
            case 'name':
                return $this->{$champ};
            case 'image':
                $img = FilesModel::findByUuid($this->image);
                return sprintf('<img src="%s"/>', $img->path);
                break;
            case 'video':
                $lien = FcAddons::GetYoutubeId($this->{$champ});
                return sprintf('<div class="players" data-id="%s"></div>', $lien[0]);
                //return sprintf('<iframe class="ytPlayer" type="text/html" src="http://www.youtube.com/embed/%s?autoplay=0" frameborder="0></iframe>', $lien[0]);
                break;
            case 'son':
                $file = FilesModel::findByUuid($this->{$champ});
                return sprintf('<audio controls><source src="%s"></audio>', $file->path);
                break;
            case 'lien':
                return sprintf('<a target="_blank" title="" href="%s">%s</a>', $this->{$champ}, $this->getEnSavoirPlus());
                break;
            default:
                return sprintf('<p class="%s">%s</p>', $champ, $this->{$champ});
                break;
        }
    }

    private function getEnSavoirPlus()
    {
        switch (Input::get('lang')) {
            case 'en':
                return 'Read more';
                break;
            default:
                return 'En savoir plus';
                break;
        }
    }
}

class_alias(CarteItemModel::class, 'CarteItemModel');
