<?php

namespace trdev\ContaoPetitescdcBundle\Element;

use Contao\Input;
use Contao\RequestToken;
use Contao\System;
use trdev\ContaoPetitescdcBundle\Model\CarteItemModel;
use trdev\ContaoPetitescdcBundle\Model\CarteModel;
use trdev\ContaoPetitescdcBundle\Model\TypePointModel;

class ceParametrage extends \ContentElement
{
    //Javascript et CSS additionnels a l'élément
    private $javascripts = [
        'https://www.youtube.com/iframe_api',
        '/bundles/contaopetitescdc/js/sweetalert2@11',
        '/bundles/contaopetitescdc/js/isMobile.min.js',
        '/bundles/contaopetitescdc/js/craftmapedition.js',
        '/bundles/contaopetitescdc/js/carteedition.min.js',
    ];
    private $styles = [];

    protected $strTemplate = "ce_parametrage";

    public function generate()
    {
        if (TL_MODE == 'BE') {
            /** @var \BackendTemplate|object $objTemplate */
            $objTemplate = new \BackendTemplate('be_wildcard');

            $objTemplate->wildcard = '### PARAMETRAGE ###';
            $objTemplate->title    = $this->headline;
            $objTemplate->id       = $this->id;
            $objTemplate->link     = $this->name;
            $objTemplate->href     = 'contao/main.php?do=themes&amp;table=tl_module&amp;act=edit&amp;id=' . $this->id;

            return $objTemplate->parse();
        } else {
            if (Count($this->javascripts) > 0) {
                foreach ($this->javascripts as $js) {
                    $GLOBALS['TL_JAVASCRIPT'][] = $js;
                }
            }

            if (Count($this->styles) > 0) {
                foreach ($this->styles as $css) {
                    $GLOBALS['TL_CSS'][] = $css;
                }
            }
        }

        if (!isset($_GET['items']) && \Config::get('useAutoItem') && isset($_GET['auto_item'])) {
            \Input::setGet('items', \Input::get('auto_item'));
        }

        return parent::generate();
    }

    protected function compile()
    {
        if (Input::post('FORM_SUBMIT')) {
            $this->postDatas();
        }

        if (Input::get('items')) {
            $GLOBALS['TL_HEAD'][]    = \Contao\Template::generateInlineStyle(TypePointModel::getAllIcons());
            $this->Template->editMod = true;
            $this->Template->carte   = CarteModel::findByAlias(Input::get('items'));
            $this->Template->markers = CarteItemModel::findByPid($this->Template->carte->id);
            $env                     = ($_ENV['APP_ENV'] == "dev") ? true : false;
            $this->Template->rt      = new RequestToken();
            \Contao\System::loadLanguageFile('tl_carte_item', 'fr');
        }
    }

    private function postDatas()
    {
        $res  =
        $code = 200;
        try {
            $item         = (Input::post('id') == '') ? new CarteItemModel() : CarteItemModel::findByPk(Input::post('id'));
            $item->posX   = Input::post('posX');
            $item->posY   = Input::post('posY');
            $item->name   = Input::post('name');
            $item->pid    = Input::post('pid');
            $item->tstamp = time();

            $item->save();
        } catch (\Throwable $th) {
            $res  = self::ajaxError($th);
            $code = 500;
        }

        echo \json_encode($res);
        exit($code);
    }
}
