<?php

namespace trdev\ContaoPetitescdcBundle\Element;

use Contao\Input;
use trdev\ContaoPetitescdcBundle\Model\CarteItemModel;
use trdev\ContaoPetitescdcBundle\Model\CarteModel;
use trdev\ContaoPetitescdcBundle\Model\TypePointModel;

class ceCarte extends \ContentElement
{
    //Javascript et CSS additionnels a l'élément
    private $javascripts = [
        'https://www.youtube.com/iframe_api',
        '/bundles/contaopetitescdc/js/sweetalert2@11',
        '/bundles/contaopetitescdc/js/isMobile.min.js',
        '/bundles/contaopetitescdc/js/craftmap.js',
        '/bundles/contaopetitescdc/js/carte.min.js',
    ];
    private $styles = [];

    protected $strTemplate = "ce_carte";

    public function generate()
    {
        if (TL_MODE == 'BE') {
            /** @var \BackendTemplate|object $objTemplate */
            $objTemplate = new \BackendTemplate('be_wildcard');

            $objTemplate->wildcard = '### CARTE ###';
            $objTemplate->title    = $this->headline;
            $objTemplate->id       = $this->id;
            $objTemplate->link     = $this->name;
            $objTemplate->href     = 'contao/main.php?do=themes&amp;table=tl_module&amp;act=edit&amp;id=' . $this->id;

            return $objTemplate->parse();
        } else {
            if (Count($this->javascripts) > 0) {
                foreach ($this->javascripts as $js) {
                    $GLOBALS['TL_JAVASCRIPT'][] = $js;
                }
            }

            if (Count($this->styles) > 0) {
                foreach ($this->styles as $css) {
                    $GLOBALS['TL_CSS'][] = $css;
                }
            }
        }

        if (!isset($_GET['items']) && \Config::get('useAutoItem') && isset($_GET['auto_item'])) {
            \Input::setGet('items', \Input::get('auto_item'));
        }

        return parent::generate();
    }

    protected function compile()
    {
        $GLOBALS['TL_HEAD'][]    = \Contao\Template::generateInlineStyle(TypePointModel::getAllIcons());
        $this->Template->carte   = CarteModel::findByPk($this->selectedMap);
        $this->Template->markers = CarteItemModel::findByPid($this->Template->carte->id);
        $env                     = ($_ENV['APP_ENV'] == "dev") ? true : false;
    }
}
