<?php

/**
 * Contao Open Source CMS
 *
 * Copyright (c) 2005-2016 Leo Feyer
 *
 * @license LGPL-3.0+
 */

namespace trdev\ContaoFonctionsBundle\Widget\Backend;

use Contao\Widget;
use trdev\ContaoFonctionsBundle\Util\FcAddons;

/**
 * Provide methods to handle CHMOD tables.
 *
 * @author Leo Feyer <https://github.com/leofeyer>
 */
class widgetTableau extends Widget
{
    protected $blnSubmitInput  = true;
    protected $blnForAttribute = true;
    protected $strTemplate     = 'be_widget';

    public function generate(): string
    {

        $return = '<table id="ctrl_tarifs" class="tl_chmod"><tr><th></th>';
        foreach ($this->arrConfiguration["cols"] as $col) {
            $return .= "<th>$col</th>";
        }
        $return .= '</tr>';

        if (isset($this->varValue)) {
            if (is_array($this->varValue)) {
                $values = $this->varValue;
            } else {
                $values = unserialize($this->varValue);
            }
        } else {
            $values = null;
        }

        $fieldName = $this->strName;

        foreach ($this->arrConfiguration["rows"] as $row) {
            $lblRow = FcAddons::generateAlias($row);
            $return .= "<tr><th scope='row'>$row</th>";
            foreach ($this->arrConfiguration["cols"] as $col) {
                $lblCol  = FcAddons::generateAlias($col);
                $rowName = $lblRow . "_" . $lblCol;
                $fName   = $fieldName . "[" . $rowName . "]";
                $value   = ($values != null && $values[$rowName] != "") ? $values[$rowName] : "";
                $return .= "<td><input type='text' name='$fName' value='$value'/></td>";
            }
            $return .= "</tr>";
        }
        $return .= "</table>";
        return $return;
    }
}
