<?php
/**
 * Contao Open Source CMS
 *
 *
 * @package   Contao
 * @author    Jimmy Nogherot
 * @license   Not free
 * @copyright Tabula Rasa
 */

namespace trdev\ContaoFonctionsBundle\Util;

/**
 * Addons avec des fonctions utiles
 */
class Notification extends \Contao\Controller
{
    private $titre   = '';
    private $niveau  = '';
    private $message = '';
    private $niveaux = array(
        's' => 'success',
        'e' => 'error',
        'w' => 'warning',
        'i' => 'info',
        'q' => 'question',
    );

    public function __construct($titre, $niveau = '', $message = '', $delais = 3000)
    {
        $this->titre   = $titre;
        $this->message = ($message != '') ? $message : '';
        $this->niveau  = ($niveau != '') ? $this->niveaux[$niveau] : '';

        $this->print();

        return $this;
    }

    function print() {
        $datas = array(
            'data-titre'  => $this->titre,
            'data-niveau' => $this->niveau,
            'data-text'   => $this->text,
            'data-delais' => $this->delais,
        );

        $txtDatas = [];
        foreach ($datas as $key => $value) {
            $txtDatas[] = $key . '="' . $value . '"';
        }
        $str = '<div class="showNotif" ' . implode(' ', $txtDatas) . '></div>';
        echo $str;
    }
}
