<?php
/**
 * Contao Open Source CMS
 *
 *
 * @package   Contao
 * @author    Jimmy Nogherot
 * @license   Not free
 * @copyright Tabula Rasa
 */

namespace trdev\ContaoFonctionsBundle\Util;

use Contao\System;
use Curl\Curl;
use IntlDateFormatter;
use Symfony\Component\Filesystem\Filesystem;
use Symfony\Component\Finder\SplFileInfo;
use trdev\ContaoFonctionsBundle\Model\SoumissionModel;

/**
 * Addons avec des fonctions utiles
 */
class FcAddons
{

    public static function importTemplates()
    {
        $fics = \TemplateLoader::getFiles();

        $objFilesystem = new Filesystem();
        $container     = System::getContainer();
        $strCacheDir   = $container->getParameter('kernel.cache_dir');

        foreach (System::getContainer()->get('contao.resource_finder')->findIn('templates')->name('*.html.twig') as $file) {
            /** @var SplFileInfo $file */
            \TemplateLoader::addFile($file->getBasename('.html.twig'), rtrim($objFilesystem->makePathRelative($file->getPath(), $container->getParameter('kernel.project_dir')), '/'));
        }
    }

    public static function testTemplate()
    {
        $fics = \TemplateLoader::getFiles();
        if (!isset($fics[$template])) {
            $objFilesystem = new Filesystem();
            $container     = System::getContainer();
            $strCacheDir   = $container->getParameter('kernel.cache_dir');

            foreach (System::getContainer()->get('contao.resource_finder')->findIn('templates')->name('*.html.twig') as $file) {
                /** @var SplFileInfo $file */
                \TemplateLoader::addFile($file->getBasename('.html.twig'), rtrim($objFilesystem->makePathRelative($file->getPath(), $container->getParameter('kernel.project_dir')), '/'));
            }
        }
    }

    public static function setMetaOg(\PageModel $objPage, \LayoutModel $objLayout, \PageRegular $objPageRegular)
    {
        $actual_link = self::getURL();

        $metas                   = array();
        $metas['og:title']       = $objPage->pageTitle . ' - ' . $objPage->mainTitle;
        $metas['og:type']        = "website";
        $metas['og:url']         = $actual_link;
        $metas['og:description'] = $objPage->description;
        $metas['fb:app_id']      = '227831649213510';

        if (isset($GLOBALS['META']) && is_array($GLOBALS['META'])) {
            foreach ($GLOBALS['META'] as $key => $value) {
                $metas[$key] = $value;
            }
        }

        $GLOBALS['META'] = $metas;

        if (!isset($GLOBALS['META']['og:image']) && isset($GLOBALS['TL_CONFIG']['logoMeta'])) {
            $img                         = unserialize($GLOBALS['TL_CONFIG']['logoMeta'])[0];
            $file                        = \FilesModel::findByUuid($img);
            $protocol                    = (!empty($_SERVER['HTTPS']) && $_SERVER['HTTPS'] !== 'off' || $_SERVER['SERVER_PORT'] == 443) ? "https://" : "http://";
            $url                         = $protocol . $_SERVER["HTTP_HOST"] . '/' . $file->path;
            $GLOBALS['META']['og:image'] = $url;
        }
    }

    public static function localFr()
    {
        setlocale(LC_TIME, 'fr_FR.utf8', 'fra');
    }

    public static function generateAlias($str)
    {
        $res = \Contao\StringUtil::generateAlias($str);
        $res = self::removeAccents($str);
        $res = strtolower($res);
        $res = str_replace(" ", "_", $res);
        $res = str_replace("'", "_", $res);
        $res = str_replace('"', "_", $res);
        $res = str_replace('(', "", $res);
        $res = str_replace(')', "", $res);
        $res = str_replace('[', "", $res);
        $res = str_replace(']', "", $res);
        $res = str_replace('{', "", $res);
        $res = str_replace('}', "", $res);

        return $res;
    }

    /*
     * Regarde si un tableau contiens toute les valeurs d'un autre tableau
     */
    public static function arrayMultipleContain($array, $keys)
    {
        if ($array && $keys) {
            $count = 0;
            if (!is_array($keys)) {
                $keys = func_get_args();
                array_shift($keys);
            }
            foreach ($keys as $key) {
                if (in_array($key, $array)) {
                    $count++;
                }
            }
            return count($keys) === $count;
        }
    }
    /*
     * Charge le JQuery et JS pour le BackEnd
     * $scripts = Tableau avec liste des scripts (chemin)
     */
    public static function BE_scripts($scripts)
    {
        foreach ($scripts as $s) {
            $GLOBALS['TL_JAVASCRIPT'][] = $s;
        }
    }
    /*
     * Charge les CSS pour le BackEnd
     * $scripts = Tableau avec liste des scripts (chemin)
     */
    public static function BE_styles($scripts)
    {
        foreach ($scripts as $s) {
            $GLOBALS['TL_CSS'][] = $s;
        }
    }

    public static function changerGroupe($id, $gp, $concat = false)
    {
        $objUser  = \MemberModel::findByPk($id);
        $arrModif = array();
        if ($concat == true) {
            $arrModif = unserialize($objUser->groups);
            array_push($arrModif, $gp);
            $arrModif = serialize($arrModif);
        } else {
            $arrModif = serialize(array($gp));
        }
        $objUser->groups = $arrModif;
        $objUser->save();
    }

    /*
     * Convertie une date en timestamp ou inversement
     */
    public static function convertDate($date = null, $format = null)
    {
        if (!$date) {
            $date = time();
        }
        $res = "";
        if (self::isValidTimeStamp($date)) {
            if ($format) {
                $res = date($format, $date);
            } else {
                $res = date("Y-m-d", $date);
            }
        } else {
            $res = strtotime($date);
        }
        return $res;
    }

    /*
     * convertis tous les blob du resultat en valeur originelle
     */
    public static function deserializeDatas($e)
    {
        if ($e != null || $e != "") {
            if (is_object($e)) {
                foreach ($e as $o) {
                    foreach ($o->row() as $key => $value) {
                        $o->$key = self::deserializeDatas($value);
                    }
                }
            } elseif (is_array($e)) {
                foreach ($e as $key => $value) {
                    $e[$key] = self::deserializeDatas($value);
                }
            } elseif (substr($e, 0, 2) == "a:") {
                $e = deserialize($e);
            }
            return $e;
        } else {
            return null;
        }
    }

    /*
     * Télécharge une page (Utile pour les API)
     */
    public static function downloadPage($url)
    {
        $ch = new curl();
        $ch->setOpt(CURLOPT_URL, $url);
        $ch->setOpt(CURLOPT_FAILONERROR, 1);
        $ch->setOpt(CURLOPT_FOLLOWLOCATION, 1);
        $ch->setOpt(CURLOPT_RETURNTRANSFER, 1);
        $ch->setOpt(CURLOPT_TIMEOUT, 15);
        $ch->get($url);
        $retValue = $ch->response;
        $ch->close();
        return $retValue;
        /*
    $ch = curl_init();
    curl_setopt($ch, CURLOPT_URL, $url);
    curl_setopt($ch, CURLOPT_FAILONERROR, 1);
    curl_setopt($ch, CURLOPT_FOLLOWLOCATION, 1);
    curl_setopt($ch, CURLOPT_RETURNTRANSFER, 1);
    curl_setopt($ch, CURLOPT_TIMEOUT, 15);
    $retValue = curl_exec($ch);
    curl_close($ch);
    return $retValue;
     */
    }

    /*
     * Dump quand on est sur le debug
     * /!\ Ne fonctionne que sur Contao4 /!\
     */
    public static function dump($item)
    {
        if (strpos($_SERVER["REQUEST_URI"], "app_dev.php") > -1) {
            Dump($item);
        }
    }

    /*
     * Charge le JS pour le FrontEnd
     * $map = clé google map
     * $fichiers = Tableau avec liste des scripts (chemin)
     */
    public static function FE_scripts($fichiers, $map = null)
    {
        if ($map) {
            $GLOBALS['TL_JAVASCRIPT'][] = 'https://maps.googleapis.com/maps/api/js?key=' . $map;
        }
        foreach ($fichiers as $f) {
            if (!self::scriptExist($GLOBALS['TL_JAVASCRIPT'], $f)) {
                $GLOBALS['TL_JAVASCRIPT'][] = $f;
            }
        }
    }

    public static function scriptExist($arr, $item)
    {
        $base = explode("?", basename($item))[0];
        foreach ($arr as $a) {
            if (strpos($a, $base) != false) {
                return true;
            }
        }
        return false;
    }

    /*
     * Charge le JS pour le FrontEnd
     * $map = clé google map
     * $fichiers = Tableau avec liste des scripts (chemin)
     */
    public static function FE_styles($fichiers)
    {
        self::FE_css($fichiers);
    }
    public static function FE_css($fichiers)
    {
        foreach ($fichiers as $f) {
            $GLOBALS['TL_CSS'][] = $f;
        }
    }

    /*
     * Retourne l'URL de la page
     */
    public static function getURL()
    {
        $protocol = (!empty($_SERVER['HTTPS']) && $_SERVER['HTTPS'] !== 'off' || $_SERVER['SERVER_PORT'] == 443) ? "https://" : "http://";
        //$protocol = strtolower(substr($_SERVER["SERVER_PROTOCOL"],0,strpos( $_SERVER["SERVER_PROTOCOL"],'/'))).'://';
        $url = $protocol . $_SERVER["HTTP_HOST"] . explode('?', $_SERVER["REQUEST_URI"])[0];
        return $url;
    }

    /*
     * Retourne l'id d'une vidéo Youtube depuis son URL
     */
    public static function GetYoutubeId($url)
    {
        $video_id = preg_split("/(=|&#61;)/", $url); // http://www.youtube.com/watch?v=...
        if (empty($video_id[1])) {
            $video_id = explode("/v/", $url); //http://www.youtube.com/watch/v/
            if (empty($video_id[1])) {
                $video_id = explode(".be/", $url); //http://www.youtu.be/
            }
        }
        // For videos like http://www.youtube.com/watch/v/..
        $video_id = preg_split("/(&|&#38;)/", $video_id[1]); // Deleting any other params
        return $video_id;
    }

    /*
     * Retourne l'id d'une vidéo Youtube depuis son URL
     */
    public static function GetYoutubeUrl($url)
    {
        $video_id = preg_split("/(=|&#61;)/", $url); // http://www.youtube.com/watch?v=...
        if (empty($video_id[1])) {
            $video_id = explode("/v/", $url); //http://www.youtube.com/watch/v/
            if (empty($video_id[1])) {
                $video_id = explode(".be/", $url); //http://www.youtu.be/
            }
        }
        // For videos like http://www.youtube.com/watch/v/..
        $video_id = preg_split("/(&|&#38;)/", $video_id[1]); // Deleting any other params
        $video_id = "https://www.youtube.com/embed/" . $video_id[0];
        return $video_id;
    }

    /*
     * Test si la chaine est en binaire
     */
    public static function isBinary($str)
    {
        if ($str != "") {
            return preg_match('~[^\x20-\x7E\t\r\n]~', $str) > 0;
        } else {
            return false;
        }
    }

    /*
     * Test si la chaine est un timeStamp
     */
    public static function isValidTimeStamp($timestamp)
    {
        $check = (is_int($timestamp) or is_float($timestamp))
        ? $timestamp
        : (string) (int) $timestamp;
        return ($check === $timestamp)
            and ((int) $timestamp <= PHP_INT_MAX)
            and ((int) $timestamp >= ~PHP_INT_MAX);
    }

    /*
     ** JSONIFY - Converti un objet contao en JSON
     */
    public static function Jsonify($obj)
    {
        if (is_array($obj)) {
            foreach ($obj as $key => $value) {
                if (self::isBinary($value)) {
                    $file      = \FilesModel::findByUuid($value);
                    $obj[$key] = $file->path;
                }
            }
            return $obj;
        } else {
            $res = array();
            foreach ($obj as $o) {
                foreach ($o->row() as $key => $value) {
                    if (!is_array($o->$key)) {
                        if (self::isBinary($value)) {
                            $file    = \FilesModel::findByUuid($value);
                            $o->$key = $file->path;
                        }
                    } else {
                        $o->$key = self::Jsonify($value);
                    }
                }
                array_push($res, $o->row());
            }
            $ch = trim(json_encode($res));
            return $ch;
        }
    }

    /*
     * Ecrit dans les logs et prépare le résultat pour mon suivi par mail
     * @str: string = La chaine à ajouter aux logs
     *
     */
    public static function logStr($str)
    {
        $t = TL_GENERAL;
        \System::log($str, __METHOD__, $t);
        $GLOBALS["log"] .= "$str\r\n";
    }

    /*
     * Fait un beau var_dump d'une variable
     */
    public static function print_log($str)
    {
        print_r("<pre>");
        var_dump($str);
        print_r("</pre>");
    }

    /*
     * Remplace les accents par des caractère de base
     */
    public static function removeAccents($string)
    {
        if (!preg_match('/[\x80-\xff]/', $string)) {
            return $string;
        }

        $chars = array(
            // Decompositions for Latin-1 Supplement
            chr(195) . chr(128) => 'A', chr(195) . chr(129)  => 'A',
            chr(195) . chr(130) => 'A', chr(195) . chr(131)  => 'A',
            chr(195) . chr(132) => 'A', chr(195) . chr(133)  => 'A',
            chr(195) . chr(135) => 'C', chr(195) . chr(136)  => 'E',
            chr(195) . chr(137) => 'E', chr(195) . chr(138)  => 'E',
            chr(195) . chr(139) => 'E', chr(195) . chr(140)  => 'I',
            chr(195) . chr(141) => 'I', chr(195) . chr(142)  => 'I',
            chr(195) . chr(143) => 'I', chr(195) . chr(145)  => 'N',
            chr(195) . chr(146) => 'O', chr(195) . chr(147)  => 'O',
            chr(195) . chr(148) => 'O', chr(195) . chr(149)  => 'O',
            chr(195) . chr(150) => 'O', chr(195) . chr(153)  => 'U',
            chr(195) . chr(154) => 'U', chr(195) . chr(155)  => 'U',
            chr(195) . chr(156) => 'U', chr(195) . chr(157)  => 'Y',
            chr(195) . chr(159) => 's', chr(195) . chr(160)  => 'a',
            chr(195) . chr(161) => 'a', chr(195) . chr(162)  => 'a',
            chr(195) . chr(163) => 'a', chr(195) . chr(164)  => 'a',
            chr(195) . chr(165) => 'a', chr(195) . chr(167)  => 'c',
            chr(195) . chr(168) => 'e', chr(195) . chr(169)  => 'e',
            chr(195) . chr(170) => 'e', chr(195) . chr(171)  => 'e',
            chr(195) . chr(172) => 'i', chr(195) . chr(173)  => 'i',
            chr(195) . chr(174) => 'i', chr(195) . chr(175)  => 'i',
            chr(195) . chr(177) => 'n', chr(195) . chr(178)  => 'o',
            chr(195) . chr(179) => 'o', chr(195) . chr(180)  => 'o',
            chr(195) . chr(181) => 'o', chr(195) . chr(182)  => 'o',
            chr(195) . chr(182) => 'o', chr(195) . chr(185)  => 'u',
            chr(195) . chr(186) => 'u', chr(195) . chr(187)  => 'u',
            chr(195) . chr(188) => 'u', chr(195) . chr(189)  => 'y',
            chr(195) . chr(191) => 'y',
            // Decompositions for Latin Extended-A
            chr(196) . chr(128) => 'A', chr(196) . chr(129)  => 'a',
            chr(196) . chr(130) => 'A', chr(196) . chr(131)  => 'a',
            chr(196) . chr(132) => 'A', chr(196) . chr(133)  => 'a',
            chr(196) . chr(134) => 'C', chr(196) . chr(135)  => 'c',
            chr(196) . chr(136) => 'C', chr(196) . chr(137)  => 'c',
            chr(196) . chr(138) => 'C', chr(196) . chr(139)  => 'c',
            chr(196) . chr(140) => 'C', chr(196) . chr(141)  => 'c',
            chr(196) . chr(142) => 'D', chr(196) . chr(143)  => 'd',
            chr(196) . chr(144) => 'D', chr(196) . chr(145)  => 'd',
            chr(196) . chr(146) => 'E', chr(196) . chr(147)  => 'e',
            chr(196) . chr(148) => 'E', chr(196) . chr(149)  => 'e',
            chr(196) . chr(150) => 'E', chr(196) . chr(151)  => 'e',
            chr(196) . chr(152) => 'E', chr(196) . chr(153)  => 'e',
            chr(196) . chr(154) => 'E', chr(196) . chr(155)  => 'e',
            chr(196) . chr(156) => 'G', chr(196) . chr(157)  => 'g',
            chr(196) . chr(158) => 'G', chr(196) . chr(159)  => 'g',
            chr(196) . chr(160) => 'G', chr(196) . chr(161)  => 'g',
            chr(196) . chr(162) => 'G', chr(196) . chr(163)  => 'g',
            chr(196) . chr(164) => 'H', chr(196) . chr(165)  => 'h',
            chr(196) . chr(166) => 'H', chr(196) . chr(167)  => 'h',
            chr(196) . chr(168) => 'I', chr(196) . chr(169)  => 'i',
            chr(196) . chr(170) => 'I', chr(196) . chr(171)  => 'i',
            chr(196) . chr(172) => 'I', chr(196) . chr(173)  => 'i',
            chr(196) . chr(174) => 'I', chr(196) . chr(175)  => 'i',
            chr(196) . chr(176) => 'I', chr(196) . chr(177)  => 'i',
            chr(196) . chr(178) => 'IJ', chr(196) . chr(179) => 'ij',
            chr(196) . chr(180) => 'J', chr(196) . chr(181)  => 'j',
            chr(196) . chr(182) => 'K', chr(196) . chr(183)  => 'k',
            chr(196) . chr(184) => 'k', chr(196) . chr(185)  => 'L',
            chr(196) . chr(186) => 'l', chr(196) . chr(187)  => 'L',
            chr(196) . chr(188) => 'l', chr(196) . chr(189)  => 'L',
            chr(196) . chr(190) => 'l', chr(196) . chr(191)  => 'L',
            chr(197) . chr(128) => 'l', chr(197) . chr(129)  => 'L',
            chr(197) . chr(130) => 'l', chr(197) . chr(131)  => 'N',
            chr(197) . chr(132) => 'n', chr(197) . chr(133)  => 'N',
            chr(197) . chr(134) => 'n', chr(197) . chr(135)  => 'N',
            chr(197) . chr(136) => 'n', chr(197) . chr(137)  => 'N',
            chr(197) . chr(138) => 'n', chr(197) . chr(139)  => 'N',
            chr(197) . chr(140) => 'O', chr(197) . chr(141)  => 'o',
            chr(197) . chr(142) => 'O', chr(197) . chr(143)  => 'o',
            chr(197) . chr(144) => 'O', chr(197) . chr(145)  => 'o',
            chr(197) . chr(146) => 'OE', chr(197) . chr(147) => 'oe',
            chr(197) . chr(148) => 'R', chr(197) . chr(149)  => 'r',
            chr(197) . chr(150) => 'R', chr(197) . chr(151)  => 'r',
            chr(197) . chr(152) => 'R', chr(197) . chr(153)  => 'r',
            chr(197) . chr(154) => 'S', chr(197) . chr(155)  => 's',
            chr(197) . chr(156) => 'S', chr(197) . chr(157)  => 's',
            chr(197) . chr(158) => 'S', chr(197) . chr(159)  => 's',
            chr(197) . chr(160) => 'S', chr(197) . chr(161)  => 's',
            chr(197) . chr(162) => 'T', chr(197) . chr(163)  => 't',
            chr(197) . chr(164) => 'T', chr(197) . chr(165)  => 't',
            chr(197) . chr(166) => 'T', chr(197) . chr(167)  => 't',
            chr(197) . chr(168) => 'U', chr(197) . chr(169)  => 'u',
            chr(197) . chr(170) => 'U', chr(197) . chr(171)  => 'u',
            chr(197) . chr(172) => 'U', chr(197) . chr(173)  => 'u',
            chr(197) . chr(174) => 'U', chr(197) . chr(175)  => 'u',
            chr(197) . chr(176) => 'U', chr(197) . chr(177)  => 'u',
            chr(197) . chr(178) => 'U', chr(197) . chr(179)  => 'u',
            chr(197) . chr(180) => 'W', chr(197) . chr(181)  => 'w',
            chr(197) . chr(182) => 'Y', chr(197) . chr(183)  => 'y',
            chr(197) . chr(184) => 'Y', chr(197) . chr(185)  => 'Z',
            chr(197) . chr(186) => 'z', chr(197) . chr(187)  => 'Z',
            chr(197) . chr(188) => 'z', chr(197) . chr(189)  => 'Z',
            chr(197) . chr(190) => 'z', chr(197) . chr(191)  => 's',
        );

        $string = strtr($string, $chars);

        return $string;
    }

    /*
     * Envoyer un email
     */
    public static function sendEmail($f, $t, $o, $m)
    {
        $to = $t;

        $headers = "From: contact@tabularasa.fr\n";
        $headers .= "Reply-To: " . $f . "\n";
        $headers .= "MIME-version: 1.0\n";
        $headers .= "Content-type: text/html; charset= iso-8859-1\n";

        $subject = $o;

        $message = "<html><head></head><body>";
        $message .= $m;
        $message .= "</body></html>";

        if (mail($to, $subject, $message, $headers)) {
            return true;
        } else {
            return false;
        }
    }

    /*
     * Creer des champs pour formulaire
     * $flds = array()
     */
    public static function setFields($flds)
    {
        foreach ($flds as $f) {
            switch ($f["type"]) {
                case 'text':
                case 'email':
                case 'date':
                    ?>
                    <div class="form_field" id="<?=$f["name"]?>">
                        <label for="<?=$f["name"]?>"><?=$f["titre"]?></label>
                        <input
                            type="<?=$f["type"]?>"
                            name="<?=$f["name"]?>"
                            value="<?=$f["default"]?>"
                            <?=($f["requis"]) ? "required" : ""?>
                            <?=($f["pattern"]) ? "pattern='" . $f["pattern"] . "'" : ""?>
                        >
                    </div>
                <?php break;
                case 'checkbox': ?>
                     <div class="form_field" id="<?=$f["name"]?>">
                        <label><input type="checkbox" name="<?=$f["name"]?>" <?=($f["default"] == 1) ? "checked" : ""?>/> <?=$f["titre"]?></label>
                     </div>
                <?php break;
                case 'select': ?>
                    <div class="form_field" id="<?=$f["name"]?>">
                        <label for="<?=$f["name"]?>"><?=$f["titre"]?></label>
                        <select name="<?=$f["name"]?>">
                        <?php foreach ($f["liste"] as $i): ?>
                            <option value="<?=$i?>" <?=($f["default"] == $i) ? "selected" : ""?>><?=$i?></option>
                        <?php endforeach;?>
                        </select>
                    </div>
                <?php break;
                case 'hidden': ?>
                    <input type="hidden" name="<?=$f["name"]?>" value="<?=$f["default"]?>">
                <?php break;
            }
        }
    }

    /*
     * Retourne la bonne url, utile lors du passage à la prod car urlrewrite ne foncitonne pas sur wamp
     * $url = nom de la page
     * $options = paramètres à rajouter array("id=2","toto=tata")
     */
    public static function setUrl($url, $options = null)
    {
        $protocol = ($_SERVER["HTTPS"] == "on") ? "https://" : "http://";
        //$protocol = strtolower(substr($_SERVER["SERVER_PROTOCOL"],0,strpos( $_SERVER["SERVER_PROTOCOL"],'/'))).'://';
        $result = $protocol . $_SERVER['SERVER_NAME'];

        if (strpos(explode('?', $_SERVER['REQUEST_URI'])[0], 'index.php') !== false) {
            //Local
            $result .= "/index.php/" . $url . ".html";
        } else {
            //prod
            $result .= "/" . $url . ".html";
        }

        if ($options) {
            $op = array();
            foreach ($options as $key => $value) {
                array_push($op, "$key=$value");
            }
            $result .= "?" . implode("&", $op);
        }
        return $result;
    }

    /*
     * Affiche une photo depuis un champs
     * $fld = Champ de l'image
     * $t = Titre de l'image, ALT
     */
    public static function showPhotos($fld, $t)
    {
        $res = "";
        if (Count($fld) > 0) {
            $file = \FilesModel::findByUuid($fld);
            $res .= '<img src="' . $file->path . '" alt="' . $t . '">';
        }
        return $res;
    }

    public static function showLazyPhotoOld($fld, $t = "", $isLity = false)
    {
        $res = "";
        if ($fld) {
            $file = \FilesModel::findByUuid($fld);
            $img  = \Image::get($file->path, 50, null);
            $lity = ($isLity === true) ? 'data-lity="true"' : '';
            $res  = '<img style="width:100%" src="/' . $img . '" data-src="/' . $file->path . '" alt="' . $t . '" class="lazyload" ' . $lity . '>';
        }
        return $res;
    }

    public static function cropImage($path, $width = 1600, $height = 1000, $format = 'proportional')
    {
        $container  = System::getContainer();
        $projectDir = $container->getParameter('kernel.project_dir');
        try {
            $image = $container->get('contao.image.factory')->create($projectDir . '/' . $path, [$width, $height, $format])->getUrl($projectDir);
        } catch (\Throwable $th) {
            $image = $container->get('contao.image.image_factory')->create($projectDir . '/' . $path, [$width, $height, $format])->getUrl($projectDir);
        }
        return $image;
    }

    public static function showLightBox($fld, $titre, $galery = '')
    {
        $res = '';
        if ($fld) {
            try {
                $file   = \FilesModel::findByUuid($fld);
                $lowRes = self::cropImage($file->path, 50, 50, 'crop'); //Image basse résolution
                $full   = self::cropImage($file->path); //Image en grand (max 1600 car au dela on s'en fou finalement);
                if ($galery != '') {
                    return sprintf('<a href="%s" class="glightbox data-gallery="galerie"><img style="width:100%" src="%s" data-src="%s" alt="%s" class="lazyload"></a>', $full, $lowRes, $full, $t);
                } else {
                    return sprintf('<a href="%s" class="glightbox" ><img style="width:100%" src="%s" data-src="%s" alt="%s" class="lazyload"></a>', $full, $lowRes, $full, $t);
                }

            } catch (\Throwable $th) {
                if ($_ENV['APP_ENV'] == 'dev') {
                    throw ($th);
                }
                $res = self::showLazyPhotoOld($fld, $t, $true);
            }
        }
        return $res;
    }

    public static function showLazyPhoto($fld, $t = "", $isLity = false)
    {
        //Nouvelle version, en vu des changement de contao 5. Je trouvai l'ancienne méthode plus simple mais bon...
        $res = "";
        if ($fld) {
            try {
                $file = \FilesModel::findByUuid($fld);
                if ($file != null) {
                    if (pathinfo($file->path)['extension'] == 'gif') {
                        $res = '<img style="width:100%" src="/' . $file->path . '" alt="' . $t . '">';
                    } else {
                        $lowRes = self::cropImage($file->path, 50, 50, 'crop'); //Image basse résolution
                        $full   = self::cropImage($file->path); //Image en grand (max 1600 car au dela on s'en fou finalement);
                        $lity   = ($isLity === true) ? 'data-lity="true"' : '';
                        $res    = '<img style="width:100%" src="/' . $lowRes . '" data-src="/' . $full . '" alt="' . $t . '" class="lazyload" ' . $lity . '>';
                    }
                }
            } catch (\Throwable $th) {
                if ($_ENV['APP_ENV'] == 'dev') {
                    throw ($th);
                }
                $res = self::showLazyPhotoOld($fld, $t, $isLity);
            }
        }
        return $res;
    }

    public static function showLazyFromPath($path, $t = "", $isLity = false)
    {
        $res = "";
        if ($path) {
            $img  = \Image::get($path, 50, null);
            $lity = ($isLity === true) ? 'data-lity="true"' : '';
            $res  = '<img style="width:100%" src="/' . $img . '" data-src="/' . $path . '" alt="' . $t . '" class="lazyload" ' . $lity . '>';
        }
        return $res;
    }

    /*
     * Retourne une iframe pour les vidéo Youtube
     */
    public static function showYoutube($fld)
    {
        $res = array();
        if (Count($fld) > 0 && $fld[0]["cl_liens"] != "") {
            foreach ($fld as $e) {
                $url = self::GetYoutubeUrl($e["cl_liens"]);
                array_push($res, '<iframe src="' . $url . '" allowfullscreen="" kwframeid="1" width="800" height="450" frameborder="0"></iframe>');
            }
        }
        return $res;
    }

    public static function triParLabel($a, $b)
    {
        if ($a["label"] == $b["label"]) {
            return 0;
        }
        return ($a["label"] < $b["label"]) ? -1 : 1;
    }

    public function saveSubmission($submittedData, $formData, $files, $labels, $form)
    {
        if (isset($form) && $form->journaliserSoumission == '1') {
            $sub                 = new SoumissionModel();
            $sub->tstamp         = time();
            $sub->dateSoumission = time();
            $sub->pid            = $form->id;
            $content             = '';
            foreach ($submittedData as $key => $value) {
                if ($value != '') {
                    $lbl = ($labels[$key] != '') ? $labels[$key] : $key;
                    $content .= '<b>' . $lbl . ' : </b>' . $value . '<br/>';
                }
            }
            $sub->contenu = $content;
            $sub->save();
        }

        //Envoi de mail au destinataire si on a un champ de type destinataire
        $message       = '';
        $email         = null;
        $destinataires = array();
        foreach ($submittedData as $key => $value) {
            $col = array(
                'name = ?',
                'pid = ?',
            );
            $val = array(
                $key,
                $form->id,
            );
            $fld = \FormFieldModel::findOneBy($col, $val);
            if ($fld->type == 'dest') {
                $liste = unserialize($fld->listeDestinataires);
                foreach ($liste as $dests) {
                    $alias = self::generateAlias($dests['nom']);
                    if (is_array($submittedData[$key])) {
                        foreach ($submittedData[$key] as $choix) {
                            if ($alias == $choix) {
                                $destinataires = array_merge($destinataires, explode(',', $dests['emails']));
                                if (is_null($email)) {
                                    $email           = new \Email();
                                    $email->from     = $GLOBALS['TL_ADMIN_EMAIL'];
                                    $email->fromName = $GLOBALS['TL_ADMIN_NAME'];
                                    $email->subject  = $form->title;
                                    $message .= ($arrLabels[$key] ?? ucfirst($key)) . ': ' . implode(', ', $submittedData[$key]) . "<br/>";
                                }
                                $email->subject = $email->subject . ' - ' . $dests['nom'];
                            }
                        }
                    } else {
                        if ($alias == $submittedData[$key]) {
                            $destinataires   = explode(',', $dests['emails']);
                            $email           = new \Email();
                            $email->from     = $GLOBALS['TL_ADMIN_EMAIL'];
                            $email->fromName = $GLOBALS['TL_ADMIN_NAME'];
                            $email->subject  = $form->title . ' - ' . $dests['nom'];
                            $message .= ($arrLabels[$key] ?? ucfirst($key)) . ': ' . $dests['nom'] . "<br/>";
                        }
                    }
                }
            } else {
                $message .= ($arrLabels[$key] ?? ucfirst($key)) . ': ' . (\is_array($value) ? implode(', ', $value) : $value) . "<br/>";
            }
        }

        if (!is_null($email)) {
            $email->html = $message;
            foreach ($destinataires as $d) {
                $email->sendTo($d);
            }
        }
        if ($form->confirmationMail == '1') {
            $dest            = $submittedData[$form->receveurConfirmation];
            $email           = new \Email();
            $email->from     = $GLOBALS['TL_ADMIN_EMAIL'];
            $email->fromName = $GLOBALS['TL_ADMIN_NAME'];
            $email->subject  = $form->objetConfirmation;
            $email->html     = $form->textConfirmation;

            if ($dest) {
                $email->sendTo($dest);
            }
        }
    }

    #region Ajout du filigrame sur les images
    public static function putWatermark($imgUrl, $wmkUrl)
    {
        if (str_starts_with($wmkUrl, '/')) {
            $wmkUrl = substr($wmkUrl, 1);
        }

        $type         = exif_imagetype($imgUrl); // [] if you don't have exif you could use getImageSize()
        $allowedTypes = array(
            1, // [] gif
            2, // [] jpg
            3, // [] png
            6, // [] bmp
            18, // WEBP
        );

        if (in_array($type, $allowedTypes)) {
            $source    = self::imageCreateFromAny($imgUrl);
            $watermark = self::imageCreateFromAny($wmkUrl);

            // get the width and height of the watermark image
            $water_width  = imagesx($watermark);
            $water_height = imagesy($watermark);

            // get the width and height of the main image image
            $main_width  = imagesx($source);
            $main_height = imagesy($source);

            // Set the dimension of the area you want to place your watermark we use 0
            // from x-axis and 0 from y-axis
            $dime_x = 15;
            $dime_y = ($main_height - $water_height) - 15;

            // copy both the images
            imagecopy($source, $watermark, $dime_x, $dime_y, 0, 0, $water_width, $water_height);

            imagejpeg($source, $imgUrl, 100);

        }

        return null;
    }

    public static function imageCreateFromAny($filepath)
    {
        $type         = exif_imagetype($filepath); // [] if you don't have exif you could use getImageSize()
        $allowedTypes = array(
            1, // [] gif
            2, // [] jpg
            3, // [] png
            6, // [] bmp
            18, // WEBP
        );
        if (!in_array($type, $allowedTypes)) {
            return false;
        }
        switch ($type) {
            case 1:
                $im = imageCreateFromGif($filepath);
                break;
            case 2:
                $im = imageCreateFromJpeg($filepath);
                break;
            case 3:
                $im = imageCreateFromPng($filepath);
                break;
            case 6:
                $im = imageCreateFromBmp($filepath);
                break;
            case 18:
                $im = imageCreateFromWebp($filepath);
                break;
        }
        return $im;
    }
    #endregion

    #region getRequestToken : Donne un nouveau Request Token
    public static function getRequestToken()
    {
        $token = new \RequestToken();
        return $token->get();
    }
    #endregion

    #region dateFormat : Ressort une date au format et en français (PHP8 Friendly)
    /**
     * dateFormat
     * Ressort une date au format et en français (PHP8 Friendly)
     *
     * @param  [int] $date,
     * @param  string $pattern https://unicode-org.github.io/icu/userguide/format_parse/datetime/
     * @return string
     */
    public static function dateFormat($date, $pattern = 'eeee d LLLL Y')
    {
        $format = IntlDateFormatter::create(
            'fr_FR',
            IntlDateFormatter::FULL,
            IntlDateFormatter::FULL,
            'Europe/Paris',
            IntlDateFormatter::GREGORIAN
        );
        $format->setPattern($pattern);
        return datefmt_format($format, $date);
    }
    #endregion
}
