let ajaxRequest = function (params, url = "", debug = null) {
    this.params = params;
    this.url = url != "" ? url : "/ajax.html?";
    this.debug = debug;

    this.isDebug = function () {
        if (this.debug === null) {
            let name = "debug";
            if (location.search.indexOf(name) > -1) {
                this.debug = true;
            } else {
                this.debug = false;
            }
        }
    };

    this.exec = function () {
        this.isDebug();
        let urlFinale = this.url,
            $ = jQuery;
        if (urlFinale.slice(-1) != "&" && urlFinale.slice(-1) != "?") {
            urlFinale += "&";
        }
        urlFinale += $.param(this.params);
        if (this.debug === true) {
            console.log(urlFinale);
        }
        return new Promise((resolve, reject) => {
            setTimeout(() => {
                $.ajax({
                    url: urlFinale,
                    type: "GET",
                    success: function (code_html) {
                        if (this.debug === true) {
                            console.log(code_html);
                        }
                        let json = $.parseJSON(code_html);
                        if (json.result == "error") {
                            alert("Erreur Ajax : " + json.details.msg);
                        }
                        resolve(json);
                    },
                    error: function (error) {
                        console.error(error);
                        reject(error);
                    },
                });
            }, 1000);
        });
    };
};
