<?php

/**
 * Contao Open Source CMS
 *
 * Copyright (c) 2005-2016 Leo Feyer
 *
 * @license LGPL-3.0+
 */

namespace Contao;

/**
 * Class FormSelectMenu
 *
 * @property integer $mSize
 * @property boolean $mandatory
 * @property boolean $multiple
 * @property array   $options
 * @property boolean $chosen
 *
 * @author Leo Feyer <https://github.com/leofeyer>
 */
class FormSelectMenuWithTables extends \FormSelectMenu
{
    /**
     * Add specific attributes
     *
     * @param string $strKey   The attribute name
     * @param mixed  $varValue The attribute value
     */
    public function __set($strKey, $varValue)
    {
        if ($strKey == "options") {
            $field = FormFieldModel::findOneById($this->id);
            if ($field->optionOuTable == "table") {
                if ($field->tableOptions != "") {
                    $this->import("Database");
                    $db  = $this->Database->prepare("SELECT * FROM " . $field->tableOptions)->execute();
                    $res = array();
                    if ($field->optionVide == "1") {
                        $res[] = array(
                            "value" => '',
                            "label" => " - ",
                        );
                    }
                    while ($db->next()) {
                        $champs = array(
                            'name', 'firstname', 'nom', 'id',
                        );
                        foreach ($champs as $ch) {
                            if (isset($db->{$ch})) {
                                $id    = ($field->valueAsId == '1') ? $db->id : $db->{$ch};
                                $res[] = array(
                                    "value" => $id,
                                    "label" => $db->{$ch},
                                );
                                break;
                            }
                        }
                    }
                    usort($res, "trdev\ContaoFonctionsBundle\Util\FcAddons::triParLabel");
                    $this->arrOptions = $res;
                }
            } else {
                parent::__set($strKey, $varValue);
            }
        } else {
            parent::__set($strKey, $varValue);
        }
    }
}
