<?php

namespace Contao;

use trdev\ContaoFonctionsBundle\Util\FcAddons;

class FormDestinatairesField extends \Widget
{

    /**
     * Submit user input
     *
     * @var boolean
     */
    protected $blnSubmitInput = true;

    /**
     * Add a for attribute
     *
     * @var boolean
     */
    protected $blnForAttribute = true;

    /**
     * Template
     *
     * @var string
     */
    protected $strTemplate = 'form_destinataires';

    /**
     * The CSS class prefix
     *
     * @var string
     */
    protected $strPrefix = 'widget widget-tags';

    /**
     * Add specific attributes
     *
     * @param string $strKey   The attribute key
     * @param mixed  $varValue The attribute value
     */
    public function __set($strKey, $varValue)
    {
        switch ($strKey) {
            case 'listeDestinataires':
                $dests = unserialize($varValue);
                $res   = array();
                foreach ($dests as $key => $value) {
                    $alias = FcAddons::generateAlias($value['nom']);
                    $res[] = array(
                        "value" => $alias,
                        "label" => $value['nom'],
                    );
                }
                $this->arrOptions = $res;
                break;
            case 'mandatory':
                if ($varValue) {
                    $this->arrAttributes['required'] = 'required';
                } else {
                    unset($this->arrAttributes['required']);
                }
                parent::__set($strKey, $varValue);
                break;
            default:
                parent::__set($strKey, $varValue);
                break;
        }
    }

    /**
     * Return a parameter
     *
     * @param string $strKey The parameter key
     *
     * @return mixed The parameter value
     */
    public function __get($strKey)
    {
        switch ($strKey) {
            default:
                return parent::__get($strKey);
                break;
        }
    }

    /**
     * Generate the widget and return it as string
     *
     * @return string The widget markup
     */
    public function generate()
    {
        return sprintf(
            '###%s###',
            $this->strName,
        );
    }
}
class_alias(FormDestinatairesField::class, 'FormDestinatairesField');
