<?php

/**
 * Contao Open Source CMS
 *
 * @author    Jimmy Nogherot
 * @license   Payant
 * @copyright Tabula Rasa
 */

/**
 * Table tl_soumission
 */
$GLOBALS['TL_DCA']['tl_soumission'] = array(

    // Config
    'config'      => array(
        'dataContainer'    => 'Table',
        'enableVersioning' => false,
        'ptable'           => 'tl_form',
        'sql'              => array(
            'keys' => array(
                'id' => 'primary',
            ),
        ),
    ),

    // List
    'list'        => array(
        'sorting'           => array(
            'mode'        => 1,
            'fields'      => array('dateSoumission'),
            'panelLayout' => 'filter;sort,search,limit',
            'flag'        => 8, //https://docs.contao.org/dev/reference/dca/fields/#reference
        ),
        'label'             => array(
            'fields'         => array('dateSoumission'),
            'label_callback' => array('tl_soumission', 'setLabel'),
        ),
        'global_operations' => array(
            'all' => array(
                'label'      => &$GLOBALS['TL_LANG']['MSC']['all'],
                'href'       => 'act=select',
                'class'      => 'header_edit_all',
                'attributes' => 'onclick="Backend.getScrollOffset();" accesskey="e"',
            ),
        ),
        'operations'        => array(
            'edit'   => array
            (
                'href' => 'act=edit',
                'icon' => 'edit.svg',
            ),
            'copy'   => array
            (
                'href' => 'act=copy',
                'icon' => 'copy.svg',
            ),
            'delete' => array
            (
                'href'       => 'act=delete',
                'icon'       => 'delete.svg',
                'attributes' => 'onclick="if(!confirm(\'' . ($GLOBALS['TL_LANG']['MSC']['deleteConfirm'] ?? null) . '\'))return false;Backend.getScrollOffset()"',
            ),
            'show'   => array
            (
                'href' => 'act=show',
                'icon' => 'show.svg',
            ),
        ),
    ),

    // Select
    'select'      => array(
        'buttons_callback' => array(),
    ),

    // Edit
    'edit'        => array(
        'buttons_callback' => array(),
    ),

    // Palettes
    'palettes'    => array(
        '__selector__' => array(''),
        'default'      => 'dateSoumission,contenu',
    ),

    // Subpalettes
    'subpalettes' => array(
        '' => 'text',
    ),

    // Fields
    'fields'      => array(
        'id'             => array(
            'sql' => "int(10) unsigned NOT NULL auto_increment",
        ),
        'tstamp'         => array(
            'sql' => "int(10) unsigned NOT NULL default '0'",
        ),
        'pid'            => array(
            'sql' => "int(10) unsigned NOT NULL default '0'",
        ),
        'dateSoumission' => array(
            'inputType' => 'text',
            'eval'      => array('rgxp' => 'datim', 'datepicker' => true, 'tl_class' => 'clr wizard'),
            'sql'       => "varchar(11) NOT NULL default ''",
        ),
        'contenu'        => array(
            'inputType' => 'textarea',
            'eval'      => array('tl_class' => 'clr', 'rte' => 'tinyNews', 'helpwizard' => true),
            'sql'       => array(
                'type'    => 'text',
                'notnull' => false,
            ),
        ),
    ),
);

class tl_soumission extends Backend
{
    public function setLabel($arrRow)
    {
        return date('d/m/Y H:i', $arrRow['dateSoumission']);
    }
}
