<?php

/**
 * Contao Open Source CMS
 *
 * Copyright (c) Jimmy NOGHEROT
 *
 * @license LGPL-3.0+
 */

$GLOBALS['TL_DCA']['tl_content']['palettes']['videoLightBox']    = '{type_legend},type,cssID;{Tabularasa},urlVideo,titreVideo,imageVideo';
$GLOBALS['TL_DCA']['tl_content']['palettes']['popupAuto']        = '{type_legend},type,cssID;{Tabularasa},typePopup,titrePopup,textePopup,okPopup,lienOkPopup,cancelPopup,{protected_legend:hide},guests,protected';
$GLOBALS['TL_DCA']['tl_content']['palettes']['carteOSM']         = '{type_legend},type,cssID;{Tabularasa},ouvertParDefaut,baseZoom,maxZoom,minZoom,width,height,markers';
$GLOBALS['TL_DCA']['tl_content']['palettes']['mediaElem']        = '{type_legend},type,headline,cssID;{Tabularasa},typeMedia,urlMedia';
$GLOBALS['TL_DCA']['tl_content']['palettes']['photo360']         = '{type_legend},type,cssID;{Tabularasa},titre360,image360';
$GLOBALS['TL_DCA']['tl_content']['palettes']['backgroundVideo']  = '{type_legend},type,cssID;{Tabularasa},backgroundVideo,backgroundImage';
$GLOBALS['TL_DCA']['tl_content']['palettes']['compteARebours']   = '{type_legend},type,cssID;{Tabularasa},compteARebours,formatCAR';
$GLOBALS['TL_DCA']['tl_content']['palettes']['blocDivStart']     = '{type_legend},type,cssID;{Tabularasa},typeDeBloc,href,blocAttributs';
$GLOBALS['TL_DCA']['tl_content']['palettes']['blocDivEnd']       = '{type_legend},type,cssID;{Tabularasa},blocDivStartParent';
$GLOBALS['TL_DCA']['tl_content']['palettes']['tagline']          = '{type_legend},type,cssID;{Tabularasa},tags,boucle,vitesseAvance,vitesseRecule';
$GLOBALS['TL_DCA']['tl_content']['palettes']['vignette']         = '{type_legend},type,cssID;{Tabularasa},imageFond,surTitre,headline,sousTitre,url,target';
$GLOBALS['TL_DCA']['tl_content']['palettes']['vignetteSansLien'] = '{type_legend},type,cssID;{Tabularasa},imageFond,surTitre,headline,sousTitre';

$GLOBALS['TL_DCA']['tl_content']['config']['onsubmit_callback'][] = array('tl_content_tr', 'majBloc');
$GLOBALS['TL_DCA']['tl_content']['config']['onload_callback'][]   = array('tl_content_tr', 'ajoutChoix');

//$GLOBALS['TL_DCA']['tl_content']['palettes']['backgroundVideo'] = '{type_legend},type,cssID;{Tabularasa},backgroundVideo,backgroundImage,height,width';

$GLOBALS['TL_DCA']['tl_content']['fields']['backgroundVideo'] = array(
    'inputType' => 'fileTree',
    'eval'      => array('multiple' => false, 'isGallery' => false, 'filesOnly' => true, 'fieldType' => 'radio', 'tl_class' => 'clr'),
    'sql'       => "blob NULL",
);
$GLOBALS['TL_DCA']['tl_content']['fields']['backgroundImage'] = array(
    'inputType' => 'fileTree',
    'eval'      => array('multiple' => false, 'isGallery' => false, 'filesOnly' => true, 'extensions' => Config::get('validImageTypes'), 'fieldType' => 'radio', 'tl_class' => 'clr'),
    'sql'       => "blob NULL",
);
$GLOBALS['TL_DCA']['tl_content']['fields']['urlVideo'] = array(
    'inputType' => 'text',
    'eval'      => array('tl_class' => 'w50'),
    'sql'       => "varchar(255) NOT NULL default ''",
);
$GLOBALS['TL_DCA']['tl_content']['fields']['titreVideo'] = array(
    'inputType' => 'text',
    'eval'      => array('tl_class' => 'clr'),
    'sql'       => "varchar(255) NOT NULL default ''",
);
$GLOBALS['TL_DCA']['tl_content']['fields']['imageVideo'] = array(
    'inputType' => 'fileTree',
    'eval'      => array('multiple' => false, 'isGallery' => false, 'filesOnly' => true, 'extensions' => Config::get('validImageTypes'), 'fieldType' => 'radio', 'tl_class' => 'clr'),
    'sql'       => "blob NULL",
);
$GLOBALS['TL_DCA']['tl_content']['fields']['titrePopup'] = array(
    'inputType' => 'text',
    'eval'      => array('tl_class' => 'w50'),
    'sql'       => "varchar(255) NOT NULL default ''",
);
$GLOBALS['TL_DCA']['tl_content']['fields']['titrePopup'] = array(
    'inputType' => 'text',
    'eval'      => array('tl_class' => 'w50'),
    'sql'       => "varchar(255) NOT NULL default ''",
);
$GLOBALS['TL_DCA']['tl_content']['fields']['textePopup'] = array(
    'inputType' => 'textarea',
    'eval'      => array('tl_class' => 'clr', 'rte' => 'tinyNews'),
    'sql'       => "mediumtext NULL",
);
$GLOBALS['TL_DCA']['tl_content']['fields']['typePopup'] = array(
    'inputType' => 'select',
    'options'   => array(
        'none'     => 'Aucun',
        'success'  => 'Succès',
        'error'    => 'Erreur',
        'warning'  => 'Avertissement',
        'info'     => 'Information',
        'question' => 'Question',
    ),
    'eval'      => array('tl_class' => 'clr'),
    'sql'       => "varchar(255) NOT NULL default ''",
);
$GLOBALS['TL_DCA']['tl_content']['fields']['okPopup'] = array(
    'inputType' => 'text',
    'eval'      => array('tl_class' => 'w50'),
    'sql'       => "varchar(255) NOT NULL default ''",
);
$GLOBALS['TL_DCA']['tl_content']['fields']['lienOkPopup'] = array(
    'inputType' => 'text',
    'eval'      => array('tl_class' => 'w50'),
    'sql'       => "varchar(255) NOT NULL default ''",
);
$GLOBALS['TL_DCA']['tl_content']['fields']['cancelPopup'] = array(
    'inputType' => 'text',
    'eval'      => array('tl_class' => 'w50'),
    'sql'       => "varchar(255) NOT NULL default ''",
);

$GLOBALS['TL_DCA']['tl_content']['fields']['markers'] = array(
    'inputType' => 'multiColumnWizard',
    'eval'      => array(
        'tl_class'     => 'clr',
        'columnFields' => array(
            'cl_titre' => array(
                'label'     => &$GLOBALS['TL_LANG']['tl_content']['cl_titre'],
                'inputType' => 'text',
            ),
            'cl_lat'   => array(
                'label'     => &$GLOBALS['TL_LANG']['tl_content']['cl_lat'],
                'inputType' => 'text',
            ),
            'cl_lng'   => array(
                'label'     => &$GLOBALS['TL_LANG']['tl_content']['cl_lng'],
                'inputType' => 'text',
            ),
        ),
    ),
    'sql'       => "blob NULL",
);
$GLOBALS['TL_DCA']['tl_content']['fields']['baseZoom'] = array(
    'inputType' => 'text',
    'eval'      => array('tl_class' => 'w50'),
    'sql'       => "varchar(255) NOT NULL default '14'",
);
$GLOBALS['TL_DCA']['tl_content']['fields']['maxZoom'] = array(
    'inputType' => 'text',
    'eval'      => array('tl_class' => 'w50'),
    'sql'       => "varchar(255) NOT NULL default ''",
);
$GLOBALS['TL_DCA']['tl_content']['fields']['minZoom'] = array(
    'inputType' => 'text',
    'eval'      => array('tl_class' => 'w50'),
    'sql'       => "varchar(255) NOT NULL default ''",
);
$GLOBALS['TL_DCA']['tl_content']['fields']['height'] = array(
    'inputType' => 'text',
    'eval'      => array('tl_class' => 'w50'),
    'sql'       => "varchar(255) NOT NULL default ''",
);
$GLOBALS['TL_DCA']['tl_content']['fields']['width'] = array(
    'inputType' => 'text',
    'eval'      => array('tl_class' => 'w50'),
    'sql'       => "varchar(255) NOT NULL default ''",
);

$GLOBALS['TL_DCA']['tl_content']['fields']['typeMedia'] = array(
    'inputType' => 'select',
    'options'   => array(
        'none'        => 'Aucun',
        'youtube'     => 'Youtube',
        'dailymotion' => 'Dailymotion',
        'soundcloud'  => 'Soundcloud',
        //'spotify'=>'Spotify',
    ),
    'eval'      => array('tl_class' => 'clr'),
    'sql'       => "varchar(255) NOT NULL default ''",
);
$GLOBALS['TL_DCA']['tl_content']['fields']['urlMedia'] = array(
    'inputType' => 'text',
    'eval'      => array('tl_class' => 'w50'),
    'sql'       => "varchar(255) NOT NULL default ''",
);
$GLOBALS['TL_DCA']['tl_content']['fields']['image360'] = array(
    'inputType' => 'fileTree',
    'eval'      => array('multiple' => false, 'isGallery' => false, 'filesOnly' => true, 'extensions' => Config::get('validImageTypes'), 'fieldType' => 'radio', 'tl_class' => 'clr'),
    'sql'       => "blob NULL",
);
$GLOBALS['TL_DCA']['tl_content']['fields']['titre360'] = array(
    'inputType' => 'text',
    'eval'      => array('tl_class' => 'w50'),
    'sql'       => "varchar(255) NOT NULL default ''",
);
$GLOBALS['TL_DCA']['tl_content']['fields']['compteARebours'] = array(
    'exclude'   => true,
    'inputType' => 'text',
    'eval'      => array('rgxp' => 'datim', 'mandatory' => true, 'doNotCopy' => true, 'datepicker' => true, 'tl_class' => 'w50 wizard'),
    'sql'       => "int(10) unsigned NULL",
);
$GLOBALS['TL_DCA']['tl_content']['fields']['formatCAR'] = array(
    'inputType' => 'textarea',
    'default'   => '%j jours, %h heures, %m minutes, %s secondes',
    'eval'      => array('tl_class' => 'clr'),
    'sql'       => "mediumtext NULL",
);

$GLOBALS['TL_DCA']['tl_content']['fields']['ouvertParDefaut'] = array(
    'exclude'   => true,
    'filter'    => true,
    'inputType' => 'checkbox',
    'sql'       => "char(1) NOT NULL default '1'",
);

//Bloc de div
$GLOBALS['TL_DCA']['tl_content']['fields']['typeDeBloc'] = array(
    'inputType' => 'text',
    'eval'      => array('tl_class' => 'clr'),
    'sql'       => "varchar(255) NOT NULL default 'div'",
);
$GLOBALS['TL_DCA']['tl_content']['fields']['blocAttributs'] = array(
    'inputType' => 'multiColumnWizard',
    'eval'      => array(
        'tl_class'     => 'clr',
        'columnFields' => array(
            'titreAttribut'  => array(
                'label'     => &$GLOBALS['TL_LANG']['tl_content']['titreAttribut'],
                'inputType' => 'text',
            ),
            'valeurAttribut' => array(
                'label'     => &$GLOBALS['TL_LANG']['tl_content']['valeurAttribut'],
                'inputType' => 'text',
            ),
        ),
    ),
    'sql'       => "blob NULL",
);
$GLOBALS['TL_DCA']['tl_content']['fields']['blocDivStartParent'] = array(
    'exclude'    => true,
    'search'     => true,
    'inputType'  => 'select',
    'foreignKey' => "tl_content.CONCAT(pid,' ',id,' ',type)",
    'eval'       => array('multiple' => false, 'mandatory' => false, 'isGallery' => true, 'chosen' => true, 'includeBlankOption' => true, 'tl_class' => 'clr'),
    'sql'        => "varchar(255) NOT NULL default ''",
);
$GLOBALS['TL_DCA']['tl_content']['fields']['href'] = array(
    'label'     => &$GLOBALS['TL_LANG']['MSC']['url'],
    'exclude'   => true,
    'search'    => true,
    'inputType' => 'text',
    'eval'      => array('mandatory' => false, 'rgxp' => 'url', 'decodeEntities' => true, 'maxlength' => 255, 'fieldType' => 'radio', 'filesOnly' => true, 'tl_class' => 'w50 wizard'),
    'wizard'    => array(
        array('tl_content', 'pagePicker'),
    ),
    'sql'       => "varchar(255) NOT NULL default ''",
);

$GLOBALS['TL_DCA']['tl_content']['fields']['tags'] = array(
    'inputType' => 'textarea',
    'eval'      => array('tl_class' => 'clr'),
    'sql'       => "mediumtext NULL",
);
$GLOBALS['TL_DCA']['tl_content']['fields']['boucle'] = array(
    'inputType' => 'checkbox',
    'eval'      => array('tl_class' => 'w50'),
    'sql'       => "char(1) NOT NULL default '0'",
);
$GLOBALS['TL_DCA']['tl_content']['fields']['vitesseAvance'] = array(
    'inputType' => 'text',
    'eval'      => array('tl_class' => 'clr w50'),
    'sql'       => "INT(10) NOT NULL default 100",
);
$GLOBALS['TL_DCA']['tl_content']['fields']['vitesseRecule'] = array(
    'inputType' => 'text',
    'eval'      => array('tl_class' => 'w50'),
    'sql'       => "INT(10) NOT NULL default 75",
);

//BLOC VIGNETTE
$GLOBALS['TL_DCA']['tl_content']['fields']['imageFond'] = array(
    'inputType' => 'fileTree',
    'eval'      => array(
        'mandatory'  => true,
        'multiple'   => false,
        'isGallery'  => false,
        'filesOnly'  => true,
        'extensions' => Config::get('validImageTypes'),
        'fieldType'  => 'radio',
        'tl_class'   => 'clr',
    ),
    'sql'       => "blob NULL",
);
$GLOBALS['TL_DCA']['tl_content']['fields']['surTitre'] = array(
    'inputType' => 'text',
    'eval'      => array('tl_class' => 'clr'),
    'sql'       => "varchar(255) NOT NULL default ''",
);


$GLOBALS['TL_DCA']['tl_content']['fields']['sousTitre'] = array(
    'inputType' => 'text',
    'eval'      => array('tl_class' => 'clr', 'maxlength' => 400, 'explanation' => 'sousTitreExplanation'),
    'sql'       => "varchar(400) NOT NULL default ''",
    'explanation' => array(
        'sousTitreExplanation' => 'Le contenu ne doit pas dépasser 400 caractères.'
    ),
);


$GLOBALS['TL_DCA']['tl_content']['fields']['milleCent'] = array(
    'inputType' => 'checkbox',
    'eval'      => array('tl_class' => 'clr w50'),
    'sql'       => "char(1) NOT NULL default '0'",
);

$GLOBALS['TL_DCA']['tl_content']['fields']['contenuInverse'] = array(
    'inputType' => 'checkbox',
    'eval'      => array('tl_class' => 'w50'),
    'sql'       => "char(1) NOT NULL default '0'",
);

$GLOBALS['TL_DCA']['tl_content']['fields']['boucle'] = array(
    'inputType' => 'checkbox',
    'eval'      => array('tl_class' => 'w50'),
    'sql'       => "char(1) NOT NULL default '0'",
);

$GLOBALS['TL_DCA']['tl_content']['fields']['marginTop'] = array(
    'inputType' => 'select',
    'eval'      => array('tl_class' => 'clr w50', 'includeBlankOption' => true),
    'options'   => $GLOBALS['MARGINS'],
    'sql'       => "varchar(255) NOT NULL default ''",
);

$GLOBALS['TL_DCA']['tl_content']['fields']['marginBottom'] = array(
    'inputType' => 'select',
    'eval'      => array('tl_class' => 'w50', 'includeBlankOption' => true),
    'options'   => $GLOBALS['MARGINS'],
    'sql'       => "varchar(255) NOT NULL default ''",
);

class tl_content_tr extends tl_content
{

    public function ajoutChoix()
    {
        foreach ($GLOBALS['TL_DCA']['tl_content']['palettes'] as $key => $p) {
            if (is_string($p) && strpos($p, 'cssID') > -1) {
                $str = str_replace('cssID', 'cssID;{paramsAvance},contenuCentre,contenuInverse,milleCent,marginTop,marginBottom', $p);
                //$str                                               = str_replace('cssID', 'cssID;{paramsAvance},contenuCentre,contenuInverse', $p);
                $GLOBALS['TL_DCA']['tl_content']['palettes'][$key] = $str;
            }
        }
    }

    public function majBloc(DataContainer $dc)
    {
        if ($dc->activeRecord->type != 'blocDivStart' || $dc->activeRecord->typeDeBloc == "") {
            return '';
        }
        $type  = $dc->activeRecord->typeDeBloc;
        $child = \ContentModel::findByBlocDivStartParent($dc->activeRecord->id);
        if ($child == null) {
            $child                     = new \ContentModel();
            $child->pid                = $dc->activeRecord->pid;
            $child->type               = "blocDivEnd";
            $child->blocDivStartParent = $dc->activeRecord->id;
            $child->sorting            = $dc->activeRecord->sorting + 1;
        }
        $child->typeDeBloc = $dc->activeRecord->typeDeBloc;
        $child->save();
    }
}
