<?php

/**
 * Contao Open Source CMS
 *
 * @author    Jimmy Nogherot
 * @license   Payant
 * @copyright Tabula Rasa
 */

/**
 * Table tl_bug
 */
$GLOBALS['TL_DCA']['tl_bug'] = array(

    // Config
    'config'      => array(
        'dataContainer'    => 'Table',
        'enableVersioning' => false,
        'sql'              => array(
            'keys' => array(
                'id' => 'primary',
            ),
        ),
    ),

    // List
    'list'        => array(
        'sorting'           => array(
            'mode'        => 2,
            'fields'      => array('tstamp', 'corrige'),
            'panelLayout' => 'filter;sort,search,limit',
            'flag'        => 6, //https://docs.contao.org/dev/reference/dca/fields/#reference
        ),
        'label'             => array(
            'fields'      => array('tstamp', 'url', 'description', 'corrige'),
            'format'      => '%s',
            'showColumns' => true,
        ),
        'global_operations' => array(
            'all' => array(
                'label'      => &$GLOBALS['TL_LANG']['MSC']['all'],
                'href'       => 'act=select',
                'class'      => 'header_edit_all',
                'attributes' => 'onclick="Backend.getScrollOffset();" accesskey="e"',
            ),
        ),
        'operations'        => array(
            'edit'   => array
            (
                'href' => 'act=edit',
                'icon' => 'edit.svg',
            ),
            'copy'   => array
            (
                'href' => 'act=copy',
                'icon' => 'copy.svg',
            ),
            'delete' => array
            (
                'href'       => 'act=delete',
                'icon'       => 'delete.svg',
                'attributes' => 'onclick="if(!confirm(\'' . ($GLOBALS['TL_LANG']['MSC']['deleteConfirm'] ?? null) . '\'))return false;Backend.getScrollOffset()"',
            ),
            'show'   => array
            (
                'href' => 'act=show',
                'icon' => 'show.svg',
            ),
        ),
    ),

    // Select
    'select'      => array(
        'buttons_callback' => array(),
    ),

    // Edit
    'edit'        => array(
        'buttons_callback' => array(),
    ),

    // Palettes
    'palettes'    => array(
        '__selector__' => array(''),
        'default'      => 'url,description,corrige',
    ),

    // Subpalettes
    'subpalettes' => array(
        '' => 'text',
    ),

    // Fields
    'fields'      => array(
        'id'          => array(
            'sql' => "int(10) unsigned NOT NULL auto_increment",
        ),
        'tstamp'      => array(
            'sql' => "int(10) unsigned NOT NULL default '0'",
        ),
        //////////////////////////////////////////////////////////////////////////////
        //COORDONNEES
        //////////////////////////////////////////////////////////////////////////////
        'url'         => array(
            'inputType' => 'text',
            'eval'      => array('tl_class' => 'clr w50', 'fe_class' => 'col-6'),
            'sql'       => array(
                'type'    => 'string',
                'length'  => 255,
                'default' => '',
            ),
        ),
        'description' => array(
            'inputType' => 'textarea',
            'eval'      => array('tl_class' => 'clr'),
            'sql'       => array(
                'type'    => 'text',
                'notnull' => false,
            ),
        ),
        'corrige'     => array(
            'inputType' => 'checkbox',
            'eval'      => array(
                'tl_class' => 'w50',
            ),
            'sql'       => array(
                'type'    => 'string',
                'length'  => 1,
                'default' => '0',
            ),
        ),
    ),
);

class tl_bug extends Backend
{

}
