<?php

/**
 * Contao Open Source CMS
 *
 * Copyright (c) Jimmy NOGHEROT
 *
 * @license LGPL-3.0+
 */
$GLOBALS['TL_DCA']['tl_article']['config']['onload_callback'][] = array('tl_article_tr', 'ajoutChoix');

$GLOBALS['TL_DCA']['tl_article']['fields']['contenuCentre'] = array(
    'inputType' => 'checkbox',
    'eval'      => array('tl_class' => 'clr w50'),
    'sql'       => "char(1) NOT NULL default '0'",
);

$GLOBALS['TL_DCA']['tl_article']['fields']['milleCent'] = array(
    'inputType' => 'checkbox',
    'eval'      => array('tl_class' => 'clr w50'),
    'sql'       => "char(1) NOT NULL default '0'",
);

$GLOBALS['TL_DCA']['tl_article']['fields']['contenuInverse'] = array(
    'inputType' => 'checkbox',
    'eval'      => array('tl_class' => 'w50'),
    'sql'       => "char(1) NOT NULL default '0'",
);

$GLOBALS['TL_DCA']['tl_article']['fields']['marginTop'] = array(
    'inputType' => 'select',
    'eval'      => array('tl_class' => 'clr w50', 'includeBlankOption' => true),
    'options'   => $GLOBALS['MARGINS'],
    'sql'       => "varchar(255) NOT NULL default ''",
);

$GLOBALS['TL_DCA']['tl_article']['fields']['marginBottom'] = array(
    'inputType' => 'select',
    'eval'      => array('tl_class' => 'w50', 'includeBlankOption' => true),
    'options'   => $GLOBALS['MARGINS'],
    'sql'       => "varchar(255) NOT NULL default ''",
);

class tl_article_tr extends tl_article
{

    public function ajoutChoix()
    {
        foreach ($GLOBALS['TL_DCA']['tl_article']['palettes'] as $key => $p) {
            if (is_string($p) && strpos($p, 'cssID') > -1) {
                $str = str_replace('cssID', 'cssID;{paramsAvance},contenuCentre,contenuInverse,milleCent,marginTop,marginBottom', $p);
                //$str                                               = str_replace('cssID', 'cssID;{paramsAvance},contenuCentre,contenuInverse', $p);
                $GLOBALS['TL_DCA']['tl_article']['palettes'][$key] = $str;
            }
        }
    }

    public function majBloc(DataContainer $dc)
    {
        if ($dc->activeRecord->type != 'blocDivStart' || $dc->activeRecord->typeDeBloc == "") {
            return '';
        }
        $type  = $dc->activeRecord->typeDeBloc;
        $child = \ContentModel::findByBlocDivStartParent($dc->activeRecord->id);
        if ($child == null) {
            $child                     = new \ContentModel();
            $child->pid                = $dc->activeRecord->pid;
            $child->type               = "blocDivEnd";
            $child->blocDivStartParent = $dc->activeRecord->id;
            $child->sorting            = $dc->activeRecord->sorting + 1;
        }
        $child->typeDeBloc = $dc->activeRecord->typeDeBloc;
        $child->save();
    }
}
