<?php

/**
 * Contao Open Source CMS
 *
 *
 * @package   Fonctions Contao
 * @author    Jimmy Nogherot
 * @license   Not free
 * @copyright Tabula Rasa
 */

/**
 * Insert Tags
 */
use trdev\ContaoFonctionsBundle\Element\backgroundVideo;
use trdev\ContaoFonctionsBundle\Element\blocDivEnd;
use trdev\ContaoFonctionsBundle\Element\blocDivStart;
use trdev\ContaoFonctionsBundle\Element\carteOSM;
use trdev\ContaoFonctionsBundle\Element\compteARebours;
use trdev\ContaoFonctionsBundle\Element\mediaElem;
use trdev\ContaoFonctionsBundle\Element\photo360;
use trdev\ContaoFonctionsBundle\Element\popupAuto;
use trdev\ContaoFonctionsBundle\Element\tagline;
use trdev\ContaoFonctionsBundle\Element\videoLightBox;
use trdev\ContaoFonctionsBundle\Element\vignette;
use trdev\ContaoFonctionsBundle\Element\vignetteSansLien;
use trdev\ContaoFonctionsBundle\Model\OverArticleModel;
use trdev\ContaoFonctionsBundle\Model\OverContentModel;
use trdev\ContaoFonctionsBundle\Module\ModuleBug;
use trdev\ContaoFonctionsBundle\Module\ModuleGoToTop;
use trdev\ContaoFonctionsBundle\Module\ModuleGoToTopGoogleFont;
use trdev\ContaoFonctionsBundle\Module\ModuleNewsReaderWithOg;
use trdev\ContaoFonctionsBundle\Module\ModuleToolbarRGAA;
use trdev\ContaoFonctionsBundle\Util\customIT;
use trdev\ContaoFonctionsBundle\Util\FcAddons;
use trdev\ContaoFonctionsBundle\Widget\Backend\widgetTableau;

$GLOBALS['TL_MODELS']['tl_content'] = OverContentModel::class;
$GLOBALS['TL_MODELS']['tl_article'] = OverArticleModel::class;
//trdev\ContaoFonctionsBundle\Util\FcAddons::importTemplates();

$GLOBALS['assetsFolder']['ContaoFonctionsBundle'] = "/bundles/contaofonctions/";

$GLOBALS['TL_HOOKS']['generatePage'][]      = array(FcAddons::class, 'setMetaOg');
$GLOBALS['TL_HOOKS']['replaceInsertTags'][] = array(customIT::class, 'mesInsertTags');
$GLOBALS['TL_HOOKS']['processFormData'][]   = array(FcAddons::class, 'saveSubmission');

$GLOBALS['TL_JAVASCRIPT'][] = ($_ENV['APP_ENV'] == "dev") ? $GLOBALS['assetsFolder']['ContaoFonctionsBundle'] . "js/full/ajaxRequest.js" : $GLOBALS['assetsFolder']['ContaoFonctionsBundle'] . "js/ajaxRequest.min.js";
if (TL_MODE != 'BE') {
    $GLOBALS['TL_CSS'][] = $GLOBALS['assetsFolder']['ContaoFonctionsBundle'] . "helpers/tagsInput/jquery.tagsinput.css";
    $GLOBALS['TL_CSS'][] = $GLOBALS['assetsFolder']['ContaoFonctionsBundle'] . "helpers/flatpickr/flatpickr.min.css";
    $GLOBALS['TL_CSS'][] = $GLOBALS['assetsFolder']['ContaoFonctionsBundle'] . "helpers/lity/lity.min.css";

    //$GLOBALS['TL_JAVASCRIPT'][] = $GLOBALS['assetsFolder']['ContaoFonctionsBundle']."jquery-3.6.0.min.js";
    $GLOBALS['TL_JAVASCRIPT'][] = $GLOBALS['assetsFolder']['ContaoFonctionsBundle'] . "helpers/moment-with-locales.js";
    //$GLOBALS['TL_JAVASCRIPT'][] = $GLOBALS['assetsFolder']['ContaoFonctionsBundle'] . "helpers/imask.min.js";
    $GLOBALS['TL_JAVASCRIPT'][] = "https://unpkg.com/imask@6.4.2/dist/imask.js";
    $GLOBALS['TL_JAVASCRIPT'][] = $GLOBALS['assetsFolder']['ContaoFonctionsBundle'] . "helpers/flatpickr/flatpickr.js";
    $GLOBALS['TL_JAVASCRIPT'][] = $GLOBALS['assetsFolder']['ContaoFonctionsBundle'] . "helpers/flatpickr/flatpickr-fr.js";
    $GLOBALS['TL_JAVASCRIPT'][] = $GLOBALS['assetsFolder']['ContaoFonctionsBundle'] . "helpers/tagsInput/jquery.tagsinput.js";
    $GLOBALS['TL_JAVASCRIPT'][] = $GLOBALS['assetsFolder']['ContaoFonctionsBundle'] . "helpers/lazyload.js";
    $GLOBALS['TL_JAVASCRIPT'][] = $GLOBALS['assetsFolder']['ContaoFonctionsBundle'] . "helpers/lity/lity.min.js";
    $GLOBALS['TL_JAVASCRIPT'][] = $GLOBALS['assetsFolder']['ContaoFonctionsBundle'] . "helpers/sweetalert2.all.min.js";
    $GLOBALS['TL_JAVASCRIPT'][] = $GLOBALS['assetsFolder']['ContaoFonctionsBundle'] . "js/slugify.min.js";
    $GLOBALS['TL_JAVASCRIPT'][] = $GLOBALS['assetsFolder']['ContaoFonctionsBundle'] . "js/frontendModules.min.js";
} else {
    $GLOBALS['TL_CSS'][] = $GLOBALS['assetsFolder']['ContaoFonctionsBundle'] . "css/be.css";
}

$GLOBALS['TL_FFL']['select'] = 'FormSelectMenuWithTables';
$GLOBALS['TL_FFL']['tags']   = 'FormTagsField';
$GLOBALS['TL_FFL']['dest']   = 'FormDestinatairesField';

$GLOBALS['MARGINS'] = array(
    '20px',
    '25px',
    '50px',
    '100px',
    '150px',
    '200px',
);

/**
 * Elements de contenu
 */
array_insert($GLOBALS['TL_CTE']['Tabularasa'], 1, array(
    'videoLightBox'    => videoLightBox::class,
    'popupAuto'        => popupAuto::class,
    'carteOSM'         => carteOSM::class,
    'mediaElem'        => mediaElem::class,
    'photo360'         => photo360::class,
    'backgroundVideo'  => backgroundVideo::class,
    'compteARebours'   => compteARebours::class,
    'blocDivStart'     => blocDivStart::class,
    'blocDivEnd'       => blocDivEnd::class,
    'tagline'          => tagline::class,
    'vignette'         => vignette::class,
    'vignetteSansLien' => vignetteSansLien::class,
));

$GLOBALS['TL_WRAPPERS']['start'][] = 'blocDivStart';
$GLOBALS['TL_WRAPPERS']['stop'][]  = 'blocDivEnd';

//////////////
//MODULES
//////////////
$GLOBALS['FE_MOD']['Tabularasa']['Tabularasa-goToTop']           = ModuleGoToTop::class;
$GLOBALS['FE_MOD']['Tabularasa']['Tabularasa-goToTopGoogleFont'] = ModuleGoToTopGoogleFont::class;
$GLOBALS['FE_MOD']['Tabularasa']['Tabularasa-RGAA']              = ModuleToolbarRGAA::class;
$GLOBALS['FE_MOD']['Tabularasa']['Tabularasa-bug']               = ModuleBug::class;

$GLOBALS['FE_MOD']['news']['newsreader'] = ModuleNewsReaderWithOg::class;

$GLOBALS['BE_FFL']['widget_tableau'] = widgetTableau::class;

/**
 * Back end modules
 */
array_insert($GLOBALS['BE_MOD']['system'], 99, array(
    'bugs' => array(
        'tables' => array('tl_bug'),
    ),
));

$GLOBALS['BE_MOD']['content']['form']['tables'][] = 'tl_soumission';
