<?php

/**
 * Contao Open Source CMS
 *
 * Copyright (c) 2005-2016 Leo Feyer
 *
 * @license LGPL-3.0+
 */

namespace trdev\ContaoFonctionsBundle\Module;

/**
 * Front end module "news reader".
 *
 * @author Leo Feyer <https://github.com/leofeyer>
 */
class ModuleNewsReaderWithOg extends \ModuleNewsReader
{
    public function generate()
    {
        return parent::generate();
    }

    protected function compile()
    {
        $objArticle = \NewsModel::findPublishedByParentAndIdOrAlias(\Input::get('items'), $this->news_archives);

        if ($objArticle->addImage == true) {
            $file                        = \FilesModel::findByUuid($objArticle->singleSRC);
            $protocol                    = (!empty($_SERVER['HTTPS']) && $_SERVER['HTTPS'] !== 'off' || $_SERVER['SERVER_PORT'] == 443) ? "https://" : "http://";
            $url                         = $protocol . $_SERVER["HTTP_HOST"] . '/' . $file->path;
            $GLOBALS['META']['og:image'] = $url;
            $GLOBALS['META']['og:type']  = 'article';
        }

        return parent::compile();
    }
}
