<?php

/**
 * Contao Open Source CMS
 *
 *
 * @package   CRER
 * @author    Jimmy Nogherot
 * @license   Not free
 * @copyright Tabula Rasa
 */

namespace trdev\ContaoFonctionsBundle\Module;

/**
 * Front end module "Toolbar RGAA".
 *
 * @author Jimmy Nogherot (Tabularasa)
 */
class ModuleGoToTop extends \Module
{
    protected $strTemplate = 'mod_goToTop';

    public function generate()
    {
        if (TL_MODE == 'BE') {
            /** @var \BackendTemplate|object $objTemplate */
            $objTemplate = new \BackendTemplate('be_wildcard');

            $objTemplate->wildcard = '### Module GO TO TOP ###';
            $objTemplate->title    = $this->headline;
            $objTemplate->id       = $this->id;
            $objTemplate->link     = $this->name;
            $objTemplate->href     = 'contao/main.php?do=themes&amp;table=tl_module&amp;act=edit&amp;id=' . $this->id;

            return $objTemplate->parse();
        }

        return parent::generate();
    }
    /**
     * Template
     * @var string
     */

    protected function compile()
    {
    }
}
