<?php

/**
 * Contao Open Source CMS
 *
 *
 * @package   CRER
 * @author    Jimmy Nogherot
 * @license   Not free
 * @copyright Tabula Rasa
 */

namespace trdev\ContaoFonctionsBundle\Module;

use trdev\ContaoFonctionsBundle\Model\BugModel;

/**
 * Front end module "Toolbar RGAA".
 *
 * @author Jimmy Nogherot (Tabularasa)
 */
class ModuleBug extends \Module
{
    protected $strTemplate = 'mod_bug';

    public function generate()
    {
        if (TL_MODE == 'BE') {
            /** @var \BackendTemplate|object $objTemplate */
            $objTemplate = new \BackendTemplate('be_wildcard');

            $objTemplate->wildcard = '### Module BUG ###';
            $objTemplate->title    = $this->headline;
            $objTemplate->id       = $this->id;
            $objTemplate->link     = $this->name;
            $objTemplate->href     = 'contao/main.php?do=themes&amp;table=tl_module&amp;act=edit&amp;id=' . $this->id;

            return $objTemplate->parse();
        }

        return parent::generate();
    }
    /**
     * Template
     * @var string
     */

    protected function compile()
    {
        if (isset($_POST['bugPost']) && $_POST['bugPost'] == '1') {
            self::execPost();
        }
        $this->Template->path = $GLOBALS['assetsFolder']['ContaoFonctionsBundle'] . 'img/';
        $this->Template->rt   = '{{REQUEST_TOKEN}}';
    }

    public function execPost()
    {
        $res  = array('result' => 'success', 'data' => array());
        $code = 200;
        try {
            $bug              = new BugModel();
            $bug->tstamp      = time();
            $bug->url         = $_POST['url'];
            $bug->description = $_POST['description'];
            $bug->save();
            $html = "<h2>Nouveau dépôt de bug</h2>";
            $html .= "<p<b>URL: </b>" . $_POST['url'] . "</p>";
            $html .= "<p><b>Description: </b>" . $_POST['description'] . "</p>";
            //$email          = new \Email();
            //$email->subject = 'Nouveau bug';
            //$email->text    = $html;
            //$email->sendTo('jimmy@tabularasa.fr');
            $headers[] = 'MIME-Version: 1.0';
            $headers[] = 'From: BUGS <bugs@tabularasa.fr>';
            $headers[] = 'Content-type: text/html; charset=iso-8859-1';
            mail('jimmy@tabularasa.fr', 'Nouveau bug', $html, implode("\r\n", $headers));

        } catch (\Throwable $th) {
            $code = 500;
        }
        echo \json_encode($res);
        exit($code);
    }
}
