<?php

namespace trdev\ContaoFonctionsBundle\Model;

/**
 * Provide methods regarding Fiches podologie.
 */
class OverArticleModel extends \ArticleModel
{
    public function __construct($objResult = null)
    {
        parent::__construct($objResult);

        if (isset($this->cssID) && $this->cssID != '') {
            $liste   = unserialize($this->cssID);
            $classes = array();

            if (isset($this->contenuCentre) && $this->contenuCentre == '1') {
                $classes[] = 'centrer_contenu';
            }

            if (isset($this->contenuInverse) && $this->contenuInverse == '1') {
                $classes[] = (Count($classes) > 0) ? 'centrer_inversion_contenu' : 'aligner_inversion_contenu';
            }

            if (isset($this->milleCent) && $this->milleCent == '1') {
                $classes[] = 'milleCent';
            }

            if (isset($this->marginTop) && $this->marginTop != '') {
                $val       = 'top' . str_replace('px', '', $this->marginTop);
                $classes[] = $val;
            }

            if (isset($this->marginBottom) && $this->marginBottom != '') {
                $val       = 'bot' . str_replace('px', '', $this->marginBottom);
                $classes[] = $val;
            }

            if (Count($classes) > 0) {
                $liste[1] = ($liste[1] != '') ? $liste[1] . ' ' . implode(' ', $classes) : implode(' ', $classes);
            }

            $this->cssID = serialize($liste);
        }

        return $this;
    }
}

class_alias(OverArticleModel::class, 'OverArticleModel');
