<?php

namespace trdev\ContaoFonctionsBundle\Element;

use trdev\ContaoFonctionsBundle\Util\FcAddons;

class vignetteSansLien extends \ContentElement
{
    protected $strTemplate = "ce_vignette";

    public function generate()
    {
        if (TL_MODE == 'BE') {
            /** @var \BackendTemplate|object $objTemplate */
            $objTemplate = new \BackendTemplate('be_wildcard');

            $objTemplate->wildcard = '### VIGNETTE SANS LIEN ###';
            $objTemplate->title    = $this->headline;
            $objTemplate->id       = $this->id;
            $objTemplate->link     = $this->name;
            $objTemplate->href     = 'contao/main.php?do=themes&amp;table=tl_module&amp;act=edit&amp;id=' . $this->id;

            return $objTemplate->parse();
        }

        return parent::generate();
    }

    protected function compile()
    {
        if ($this->headline != '') {
            $titre                 = "<%s>%s</%s>";
            $this->Template->titre = sprintf($titre, $this->hl, $this->headline, $this->hl);
        }

        $img = \FilesModel::findByUuid($this->imageFond);
        $alt = ($this->headline != '') ? $this->headline : '';
        if ($img && $img->extension != 'svg') {
            $this->Template->img = FcAddons::showLazyPhoto($this->imageFond, $alt);
        } else {
            $this->Template->img = file_get_contents($img->path);
        }
    }
}
