<?php

namespace trdev\ContaoFonctionsBundle\Element;

use trdev\ContaoFonctionsBundle\Util\FcAddons;

class videoLightBox extends \ContentElement
{
    protected $strTemplate = 'ce_videoLightBox';

    public function generate()
    {
        if (TL_MODE == 'BE') {
            /** @var \BackendTemplate|object $objTemplate */
            $objTemplate = new \BackendTemplate('be_wildcard');

            $objTemplate->wildcard = '### VIDEO LIGHTBOX ###';
            $objTemplate->title    = $this->headline;
            $objTemplate->id       = $this->id;
            $objTemplate->link     = $this->name;
            $objTemplate->href     = 'contao/main.php?do=themes&amp;table=tl_module&amp;act=edit&amp;id=' . $this->id;

            return $objTemplate->parse();
        }

        return parent::generate();
    }

    protected function compile()
    {
        //FcAddons::FE_css(array("/files/tabularasa/css/lity.css"));
        //FcAddons::FE_scripts(array("/files/tabularasa/js/lity.js"));

        $this->Template->video = $this->urlVideo;
        if ($this->imageVideo) {
            $this->Template->image = \FilesModel::findByUuid($this->imageVideo)->path;
        } else {
            $this->Template->image = "https://img.youtube.com/vi/" . FcAddons::GetYoutubeId($this->urlVideo)[0] . "/maxresdefault.jpg";
        }

        if ($this->titreVideo) {
            $this->Template->titre = $this->titreVideo;
        }
    }
}
