<?php

namespace trdev\ContaoFonctionsBundle\Element;

use trdev\ContaoFonctionsBundle\Util\FcAddons;

class photo360 extends \ContentElement
{
    protected $strTemplate = 'ce_photo360';

    public function generate()
    {
        if (TL_MODE == 'BE') {
            /** @var \BackendTemplate|object $objTemplate */
            $objTemplate = new \BackendTemplate('be_wildcard');

            $objTemplate->wildcard = '### PHOTO 360 ###';
            $objTemplate->title    = $this->headline;
            $objTemplate->id       = $this->id;
            $objTemplate->link     = $this->name;
            $objTemplate->href     = 'contao/main.php?do=themes&amp;table=tl_module&amp;act=edit&amp;id=' . $this->id;

            return $objTemplate->parse();
        }

        return parent::generate();
    }

    protected function compile()
    {
        FcAddons::FE_css(array(
            $GLOBALS["fctAssets"] . "sphere/photo-sphere-viewer.min.css",
        ));

        FcAddons::FE_scripts(array(
            $GLOBALS["fctAssets"] . "sphere/three.min.js",
            $GLOBALS["fctAssets"] . "sphere/browser.min.js",
            $GLOBALS["fctAssets"] . "sphere/photo-sphere-viewer.min.js",
            $GLOBALS["fctAssets"] . "js/frontendModules.min.js",
        ));

        $this->Template->titre = $this->titre360;
        $this->Template->image = \FilesModel::findByUuid($this->image360);
    }
}
