<?php

namespace trdev\ContaoFonctionsBundle\Element;

class carteOSM extends \ContentElement
{
//Javascript et CSS additionnels a l'élément
    private $javascripts = ['https://unpkg.com/leaflet@1.4.0/dist/leaflet.js'];
    private $styles      = ['https://unpkg.com/leaflet@1.4.0/dist/leaflet.css'];

    protected $strTemplate = 'ce_carteOSM';

    public function generate()
    {
        if (TL_MODE == 'BE') {
            /** @var \BackendTemplate|object $objTemplate */
            $objTemplate = new \BackendTemplate('be_wildcard');

            $objTemplate->wildcard = '### Carte OSM ###';
            $objTemplate->title    = $this->headline;
            $objTemplate->id       = $this->id;
            $objTemplate->link     = $this->name;
            $objTemplate->href     = 'contao/main.php?do=themes&amp;table=tl_module&amp;act=edit&amp;id=' . $this->id;

            return $objTemplate->parse();
        } else {
            if (Count($this->javascripts) > 0) {
                foreach ($this->javascripts as $js) {
                    $GLOBALS['TL_JAVASCRIPT'][] = $js;
                }
            }

            if (Count($this->styles) > 0) {
                foreach ($this->styles as $css) {
                    $GLOBALS['TL_CSS'][] = $css;
                }
            }
        }

        return parent::generate();
    }

    protected function compile()
    {
        $this->Template->mapId   = rand(0, 999);
        $this->Template->markers = unserialize($this->markers);
        $this->Template->maxZoom = ($this->maxZoom != "") ? $this->maxZoom : 14;
        $this->Template->width   = ($this->width != "") ? $this->width : "100%";
        $this->Template->height  = ($this->height != "") ? $this->height : "100%";
        $this->Template->ouvert  = ($this->ouvertParDefaut == "1") ? true : false;
    }
}
