<?php

namespace trdev\ContaoFonctionsBundle\Element;

class blocDivStart extends \ContentElement
{
    protected $strTemplate = "ce_blocDivStart";

    public function generate()
    {
        if (TL_MODE == 'BE') {
            /** @var \BackendTemplate|object $objTemplate */
            $objTemplate = new \BackendTemplate('be_wildcard');

            $infos = array(
                ($this->cssID[0] && $this->cssID[0] != "") ? "Id = " . $this->cssID[0] : "",
                ($this->cssID[1] && $this->cssID[1] != "") ? "Class = " . $this->cssID[1] : "",
                ($this->href && $this->href != "") ? "href = " . $this->href : "",
            );
            $infos                 = array_filter($infos);
            $objTemplate->wildcard = '### BLOC ' . strtoupper($this->typeDeBloc) . ' DEPART ' . $this->id . ' ###<br/>' . implode("<br/>", $infos);
            $objTemplate->title    = $this->headline;
            $objTemplate->id       = $this->id;
            $objTemplate->link     = $this->name;
            $objTemplate->href     = 'contao/main.php?do=themes&amp;table=tl_module&amp;act=edit&amp;id=' . $this->id;

            return $objTemplate->parse();
        }

        return parent::generate();
    }

    protected function compile()
    {
        if ($this->typeDeBloc == "a") {
            $this->Template       = new \FrontendTemplate('ce_blocAStart');
            $this->Template->href = $this->href;
        }

        $datas = array();

        if ($this->cssID[0] != '') {
            $datas[] = 'id="' . $this->cssID[0] . '"';
        }
        if ($this->cssID[1] != '') {
            $datas[] = 'class="' . $this->cssID[1] . '"';
        }

        $attributs = (isset($this->blocAttributs) && $this->blocAttributs != "") ? unserialize($this->blocAttributs) : "";

        if (Count($attributs) > 0) {
            foreach ($attributs as $a) {
                if ($a['titreAttribut'] != "") {
                    $datas[] = $a['titreAttribut'] . '="' . $a['valeurAttribut'] . '"';
                }
            }
        }

        $this->Template->type      = $this->typeDeBloc;
        $this->Template->attributs = (Count($datas) > 0) ? implode(' ', $datas) : '';
    }
}
