<?php

namespace trdev\ContaoFonctionsBundle\Element;

class backgroundVideo extends \ContentElement
{
    //Javascript et CSS additionnels a l'élément
    private $javascripts = [
        'bundles/contaofonctions/helpers/backgroundVideo/new.js',
        'bundles/contaofonctions/js/backgroundvideo.min.js',
    ];
    private $styles = [];

    protected $strTemplate = 'ce_backgroundVideo';

    public function generate()
    {
        if (TL_MODE == 'BE') {
            /** @var \BackendTemplate|object $objTemplate */
            $objTemplate = new \BackendTemplate('be_wildcard');

            $objTemplate->wildcard = '### BACKGROUND VIDEO ###';
            $objTemplate->title    = $this->headline;
            $objTemplate->id       = $this->id;
            $objTemplate->link     = $this->name;
            $objTemplate->href     = 'contao/main.php?do=themes&amp;table=tl_module&amp;act=edit&amp;id=' . $this->id;

            return $objTemplate->parse();
        } else {
            if (Count($this->javascripts) > 0) {
                foreach ($this->javascripts as $js) {
                    $GLOBALS['TL_JAVASCRIPT'][] = $js;
                }
            }

            if (Count($this->styles) > 0) {
                foreach ($this->styles as $css) {
                    $GLOBALS['TL_CSS'][] = $css;
                }
            }
        }

        return parent::generate();
    }

    protected function compile()
    {
        $video                 = \FilesModel::findByUuid($this->backgroundVideo);
        $this->Template->video = "/" . $video->path;
        $image                 = \FilesModel::findByUuid($this->backgroundImage);
        $this->Template->image = "/" . $image->path;
    }
}
