<?php
/*
 * Copyright MADE/YOUR/DAY OG <mail@madeyourday.net>
 *
 * For the full copyright and license information, please view the LICENSE
 * file that was distributed with this source code.
 */

namespace MadeYourDay\RockSolidSlider\Module;

use Contao\ModuleEventlist;
use Contao\StringUtil;

/**
 * Slider Events Module
 *
 * @author Martin Auswöger <martin@madeyourday.net>
 */
class SliderEvents extends ModuleEventlist
{
	const TEMPLATE_SEPARATOR = '<!-- %%%___||| RockSolid Slider Event |||___%%% -->';

	/**
	 * Get an array of events (HTML output) generated by Contao\ModuleEventlist
	 *
	 * @return array Events HTML output or an empty array if no events are found.
	 */
	public function getEventItems()
	{
		$this->cal_calendar = $this->sortOutProtected(StringUtil::deserialize($this->cal_calendar, true));

		// Return if there are no calendars
		if (!is_array($this->cal_calendar) || empty($this->cal_calendar))
		{
			return array();
		}

		// Dummy template object to retrive data from the compile method
		$this->Template = new \stdClass;
		$this->perPage = 0;

		$parseTemplateHook = array(
			'MadeYourDay\\RockSolidSlider\\Slider',
			'parseEventsTemplateHook'
		);
		// Add the TEMPLATE_SEPARATOR to be able to split the output into single events
		$GLOBALS['TL_HOOKS']['parseFrontendTemplate'][] = $parseTemplateHook;

		$this->compile();

		// Remove the hook
		foreach ($GLOBALS['TL_HOOKS']['parseFrontendTemplate'] as $key => $hook) {
			if ($hook[0] === $parseTemplateHook[0] && $hook[1] === $parseTemplateHook[1]) {
				unset($GLOBALS['TL_HOOKS']['parseFrontendTemplate'][$key]);
			}
		}

		// Split the output into single event items
		$eventItems = explode(static::TEMPLATE_SEPARATOR, $this->Template->events);

		if (count($eventItems) < 2) {
			// No events found
			return array();
		}

		// Remove output before the first event
		array_shift($eventItems);

		return $eventItems;
	}
}
