<?php

namespace ContainerIPn4pxt;

use Symfony\Component\DependencyInjection\Argument\RewindableGenerator;
use Symfony\Component\DependencyInjection\ContainerInterface;
use Symfony\Component\DependencyInjection\Container;
use Symfony\Component\DependencyInjection\Exception\InvalidArgumentException;
use Symfony\Component\DependencyInjection\Exception\LogicException;
use Symfony\Component\DependencyInjection\Exception\RuntimeException;
use Symfony\Component\DependencyInjection\ParameterBag\FrozenParameterBag;
use Symfony\Component\DependencyInjection\ParameterBag\ParameterBagInterface;

/*
 * @internal This class has been auto-generated by the Symfony Dependency Injection Component.
 */
class Contao_ManagerBundle_HttpKernel_ContaoKernelProdContainer extends Container
{
    protected $containerDir;
    protected $targetDir;
    protected $parameters = [];
    private $buildParameters;
    protected $getService;

    public function __construct(array $buildParameters = [], $containerDir = __DIR__)
    {
        $this->getService = \Closure::fromCallable([$this, 'getService']);
        $this->buildParameters = $buildParameters;
        $this->containerDir = $containerDir;
        $this->targetDir = \dirname($containerDir);
        $this->parameters = $this->getDefaultParameters();

        $this->services = $this->privates = [];
        $this->syntheticIds = [
            'contao_manager.jwt_manager' => true,
            'contao_manager.plugin_loader' => true,
            'kernel' => true,
        ];
        $this->methodMap = [
            '.container.private.filesystem' => 'get_Container_Private_FilesystemService',
            '.container.private.security.authorization_checker' => 'get_Container_Private_Security_AuthorizationCheckerService',
            '.container.private.security.token_storage' => 'get_Container_Private_Security_TokenStorageService',
            '.container.private.session' => 'get_Container_Private_SessionService',
            '.container.private.twig' => 'get_Container_Private_TwigService',
            'Contao\\CoreBundle\\Controller\\Page\\ErrorPageController' => 'getErrorPageControllerService',
            'assets.packages' => 'getAssets_PackagesService',
            'cache.system' => 'getCache_SystemService',
            'contao.assets.assets_context' => 'getContao_Assets_AssetsContextService',
            'contao.csrf.token_manager' => 'getContao_Csrf_TokenManagerService',
            'contao.framework' => 'getContao_FrameworkService',
            'contao.intl.locales' => 'getContao_Intl_LocalesService',
            'contao.resource_finder' => 'getContao_ResourceFinderService',
            'contao.routing.nested_404_matcher' => 'getContao_Routing_Nested404MatcherService',
            'contao.routing.nested_matcher' => 'getContao_Routing_NestedMatcherService',
            'contao.routing.page_registry' => 'getContao_Routing_PageRegistryService',
            'contao.routing.scope_matcher' => 'getContao_Routing_ScopeMatcherService',
            'contao.security.token_checker' => 'getContao_Security_TokenCheckerService',
            'contao.twig.extension' => 'getContao_Twig_ExtensionService',
            'contao.twig.filesystem_loader' => 'getContao_Twig_FilesystemLoaderService',
            'debug.stopwatch' => 'getDebug_StopwatchService',
            'doctrine.dbal.default_connection' => 'getDoctrine_Dbal_DefaultConnectionService',
            'event_dispatcher' => 'getEventDispatcherService',
            'fos_http_cache.cache_manager' => 'getFosHttpCache_CacheManagerService',
            'fos_http_cache.http.symfony_response_tagger' => 'getFosHttpCache_Http_SymfonyResponseTaggerService',
            'fos_http_cache.proxy_client.symfony' => 'getFosHttpCache_ProxyClient_SymfonyService',
            'http_kernel' => 'getHttpKernelService',
            'knp_menu.matcher' => 'getKnpMenu_MatcherService',
            'monolog.logger.deprecation' => 'getMonolog_Logger_DeprecationService',
            'request_stack' => 'getRequestStackService',
            'router' => 'getRouterService',
            'security.authentication.trust_resolver' => 'getSecurity_Authentication_TrustResolverService',
            'security.firewall.map' => 'getSecurity_Firewall_MapService',
            'security.helper' => 'getSecurity_HelperService',
            'security.logout_url_generator' => 'getSecurity_LogoutUrlGeneratorService',
            'translator' => 'getTranslatorService',
            'uri_signer' => 'getUriSignerService',
            'contao.controller.backend_csv_import' => 'getContao_Controller_BackendCsvImportService',
            'contao.controller.images' => 'getContao_Controller_ImagesService',
            'contao.controller.insert_tags' => 'getContao_Controller_InsertTagsService',
            'Contao\\CoreBundle\\EventListener\\DataContainer\\ContentCompositionListener' => 'getContentCompositionListenerService',
            'Contao\\CoreBundle\\EventListener\\DataContainer\\PageTypeOptionsListener' => 'getPageTypeOptionsListenerService',
            'Contao\\CoreBundle\\EventListener\\DataContainer\\PageUrlListener' => 'getPageUrlListenerService',
            'contao.cache.clear_internal' => 'getContao_Cache_ClearInternalService',
            'contao.cache.warm_internal' => 'getContao_Cache_WarmInternalService',
            'contao.crawl.escargot_factory' => 'getContao_Crawl_EscargotFactoryService',
            'contao.image.image_factory' => 'getContao_Image_ImageFactoryService',
            'contao.image.image_sizes' => 'getContao_Image_ImageSizesService',
            'contao.image.resizer' => 'getContao_Image_ResizerService',
            'contao.opt-in' => 'getContao_OptinService',
            'Contao\\CoreBundle\\Cron\\Cron' => 'getCronService',
            'Contao\\CoreBundle\\Image\\Studio\\FigureRenderer' => 'getFigureRendererService',
            'Contao\\CoreBundle\\Routing\\ResponseContext\\CoreResponseContextFactory' => 'getCoreResponseContextFactoryService',
            'Contao\\CoreBundle\\Security\\TwoFactor\\BackupCodeManager' => 'getBackupCodeManagerService',
            'Contao\\CoreBundle\\Twig\\Extension\\ContaoExtension' => 'getContaoExtensionService',
            'Contao\\CoreBundle\\Util\\SimpleTokenParser' => 'getSimpleTokenParserService',
            'contao_manager.routing_loader' => 'getContaoManager_RoutingLoaderService',
            'contao.install_tool' => 'getContao_InstallToolService',
            'contao.install_tool_user' => 'getContao_InstallToolUserService',
            'contao.installer' => 'getContao_InstallerService',
            'cache_clearer' => 'getCacheClearerService',
            'filesystem' => 'getFilesystemService',
            'security.csrf.token_manager' => 'getSecurity_Csrf_TokenManagerService',
            'twig' => 'getTwigService',
            'security.authorization_checker' => 'getSecurity_AuthorizationCheckerService',
            'security.token_storage' => 'getSecurity_TokenStorageService',
            'security.encoder_factory' => 'getSecurity_EncoderFactoryService',
            'security.password_encoder' => 'getSecurity_PasswordEncoderService',
            'session' => 'getSessionService',
        ];
        $this->fileMap = [
            '.container.private.cache_clearer' => 'get_Container_Private_CacheClearerService',
            '.container.private.security.csrf.token_manager' => 'get_Container_Private_Security_Csrf_TokenManagerService',
            '.container.private.security.encoder_factory' => 'get_Container_Private_Security_EncoderFactoryService',
            '.container.private.security.password_encoder' => 'get_Container_Private_Security_PasswordEncoderService',
            'BugBuster\\CronBundle\\Controller\\BackendController' => 'getBackendControllerService',
            'BugBuster\\CronBundle\\Controller\\FrontendController' => 'getFrontendControllerService',
            'BugBuster\\CronBundle\\EventListener\\DataContainer\\SaveCallbackListener' => 'getSaveCallbackListenerService',
            'Contao\\CoreBundle\\Controller\\BackendController' => 'getBackendController2Service',
            'Contao\\CoreBundle\\Controller\\BackendCsvImportController' => 'getBackendCsvImportControllerService',
            'Contao\\CoreBundle\\Controller\\BackendPreviewController' => 'getBackendPreviewControllerService',
            'Contao\\CoreBundle\\Controller\\BackendPreviewSwitchController' => 'getBackendPreviewSwitchControllerService',
            'Contao\\CoreBundle\\Controller\\CaptchaController' => 'getCaptchaControllerService',
            'Contao\\CoreBundle\\Controller\\ContentElement\\MarkdownController' => 'getMarkdownControllerService',
            'Contao\\CoreBundle\\Controller\\ContentElement\\TemplateController' => 'getTemplateControllerService',
            'Contao\\CoreBundle\\Controller\\FaviconController' => 'getFaviconControllerService',
            'Contao\\CoreBundle\\Controller\\FrontendController' => 'getFrontendController2Service',
            'Contao\\CoreBundle\\Controller\\FrontendModule\\RootPageDependentModulesController' => 'getRootPageDependentModulesControllerService',
            'Contao\\CoreBundle\\Controller\\FrontendModule\\TemplateController' => 'getTemplateController2Service',
            'Contao\\CoreBundle\\Controller\\FrontendModule\\TwoFactorController' => 'getTwoFactorControllerService',
            'Contao\\CoreBundle\\Controller\\ImagesController' => 'getImagesControllerService',
            'Contao\\CoreBundle\\Controller\\InitializeController' => 'getInitializeControllerService',
            'Contao\\CoreBundle\\Controller\\InsertTagsController' => 'getInsertTagsControllerService',
            'Contao\\CoreBundle\\Controller\\Page\\RootPageController' => 'getRootPageControllerService',
            'Contao\\CoreBundle\\Controller\\PreviewLinkController' => 'getPreviewLinkControllerService',
            'Contao\\CoreBundle\\Controller\\RobotsTxtController' => 'getRobotsTxtControllerService',
            'Contao\\CoreBundle\\Controller\\SitemapController' => 'getSitemapControllerService',
            'Contao\\ManagerBundle\\Controller\\DebugController' => 'getDebugControllerService',
            'InspiredMinds\\ContaoWowJs\\EventListener\\HookListener' => 'getHookListenerService',
            'MenAtWork\\MultiColumnWizardBundle\\EventListener\\Contao\\ExecutePostActions' => 'getExecutePostActionsService',
            'MenAtWork\\MultiColumnWizardBundle\\EventListener\\Contao\\InitializeSystem' => 'getInitializeSystemService',
            'MenAtWork\\MultiColumnWizardBundle\\EventListener\\Contao\\LoadDataContainer' => 'getLoadDataContainerService',
            'MenAtWork\\MultiColumnWizardBundle\\EventListener\\Contao\\ParseTemplate' => 'getParseTemplateService',
            'Scheb\\TwoFactorBundle\\Model\\PersisterInterface' => 'getPersisterInterfaceService',
            'Scheb\\TwoFactorBundle\\Security\\TwoFactor\\Provider\\TwoFactorFormRendererInterface' => 'getTwoFactorFormRendererInterfaceService',
            'Symfony\\Bundle\\FrameworkBundle\\Controller\\RedirectController' => 'getRedirectControllerService',
            'Symfony\\Bundle\\FrameworkBundle\\Controller\\TemplateController' => 'getTemplateController3Service',
            'cache.app' => 'getCache_AppService',
            'cache.app_clearer' => 'getCache_AppClearerService',
            'cache.global_clearer' => 'getCache_GlobalClearerService',
            'cache.system_clearer' => 'getCache_SystemClearerService',
            'cache_warmer' => 'getCacheWarmerService',
            'console.command.public_alias.fos_http_cache.command.clear' => 'getConsole_Command_PublicAlias_FosHttpCache_Command_ClearService',
            'console.command.public_alias.fos_http_cache.command.invalidate_path' => 'getConsole_Command_PublicAlias_FosHttpCache_Command_InvalidatePathService',
            'console.command.public_alias.fos_http_cache.command.invalidate_regex' => 'getConsole_Command_PublicAlias_FosHttpCache_Command_InvalidateRegexService',
            'console.command.public_alias.fos_http_cache.command.refresh_path' => 'getConsole_Command_PublicAlias_FosHttpCache_Command_RefreshPathService',
            'console.command_loader' => 'getConsole_CommandLoaderService',
            'container.env_var_processors_locator' => 'getContainer_EnvVarProcessorsLocatorService',
            'contao.assets.files_context' => 'getContao_Assets_FilesContextService',
            'contao.cache.clearer' => 'getContao_Cache_ClearerService',
            'contao.cache.entity_tags' => 'getContao_Cache_EntityTagsService',
            'contao.cache.warmer' => 'getContao_Cache_WarmerService',
            'contao.command.install' => 'getContao_Command_InstallService',
            'contao.command.symlinks' => 'getContao_Command_SymlinksService',
            'contao.crawl.escargot.factory' => 'getContao_Crawl_Escargot_FactoryService',
            'contao.cron' => 'getContao_CronService',
            'contao.filesystem.dbafs_manager' => 'getContao_Filesystem_DbafsManagerService',
            'contao.fragment._contao.content_element.markdown' => 'getContao_Fragment_Contao_ContentElement_MarkdownService',
            'contao.fragment._contao.content_element.template' => 'getContao_Fragment_Contao_ContentElement_TemplateService',
            'contao.fragment._contao.frontend_module.root_page_dependent_modules' => 'getContao_Fragment_Contao_FrontendModule_RootPageDependentModulesService',
            'contao.fragment._contao.frontend_module.template' => 'getContao_Fragment_Contao_FrontendModule_TemplateService',
            'contao.fragment._contao.frontend_module.two_factor' => 'getContao_Fragment_Contao_FrontendModule_TwoFactorService',
            'contao.image.factory' => 'getContao_Image_FactoryService',
            'contao.image.imagine' => 'getContao_Image_ImagineService',
            'contao.image.imagine_svg' => 'getContao_Image_ImagineSvgService',
            'contao.image.legacy_resizer' => 'getContao_Image_LegacyResizerService',
            'contao.image.picture_factory' => 'getContao_Image_PictureFactoryService',
            'contao.image.picture_generator' => 'getContao_Image_PictureGeneratorService',
            'contao.image.preview_factory' => 'getContao_Image_PreviewFactoryService',
            'contao.image.sizes' => 'getContao_Image_SizesService',
            'contao.image.studio' => 'getContao_Image_StudioService',
            'contao.image.studio.figure_renderer' => 'getContao_Image_Studio_FigureRendererService',
            'contao.insert_tag.parser' => 'getContao_InsertTag_ParserService',
            'contao.intl.countries' => 'getContao_Intl_CountriesService',
            'contao.listener.MGEESJ7' => 'getContao_Listener_MGEESJ7Service',
            'contao.listener.data_container.content_composition' => 'getContao_Listener_DataContainer_ContentCompositionService',
            'contao.listener.data_container.cte_alias' => 'getContao_Listener_DataContainer_CteAliasService',
            'contao.listener.data_container.disable_app_configured_settings' => 'getContao_Listener_DataContainer_DisableAppConfiguredSettingsService',
            'contao.listener.data_container.disable_canonical_fields' => 'getContao_Listener_DataContainer_DisableCanonicalFieldsService',
            'contao.listener.data_container.layout_options' => 'getContao_Listener_DataContainer_LayoutOptionsService',
            'contao.listener.data_container.legacy_routing' => 'getContao_Listener_DataContainer_LegacyRoutingService',
            'contao.listener.data_container.member_groups' => 'getContao_Listener_DataContainer_MemberGroupsService',
            'contao.listener.data_container.page_routing' => 'getContao_Listener_DataContainer_PageRoutingService',
            'contao.listener.data_container.page_search' => 'getContao_Listener_DataContainer_PageSearchService',
            'contao.listener.data_container.page_type_options' => 'getContao_Listener_DataContainer_PageTypeOptionsService',
            'contao.listener.data_container.page_url' => 'getContao_Listener_DataContainer_PageUrlService',
            'contao.listener.data_container.page_use_ssl_default' => 'getContao_Listener_DataContainer_PageUseSslDefaultService',
            'contao.listener.data_container.preview_link' => 'getContao_Listener_DataContainer_PreviewLinkService',
            'contao.listener.data_container.record_preview' => 'getContao_Listener_DataContainer_RecordPreviewService',
            'contao.listener.data_container.reset_custom_template' => 'getContao_Listener_DataContainer_ResetCustomTemplateService',
            'contao.listener.data_container.theme_templates' => 'getContao_Listener_DataContainer_ThemeTemplatesService',
            'contao.listener.data_container.toggle_nodes_label' => 'getContao_Listener_DataContainer_ToggleNodesLabelService',
            'contao.listener.data_container.undo.jump_to_parent_button' => 'getContao_Listener_DataContainer_Undo_JumpToParentButtonService',
            'contao.listener.data_container.undo.label' => 'getContao_Listener_DataContainer_Undo_LabelService',
            'contao.listener.data_container.validate_custom_rgxp' => 'getContao_Listener_DataContainer_ValidateCustomRgxpService',
            'contao.listener.data_container_callback' => 'getContao_Listener_DataContainerCallbackService',
            'contao.listener.element_template_options' => 'getContao_Listener_ElementTemplateOptionsService',
            'contao.listener.fE48e1G' => 'getContao_Listener_FE48e1GService',
            'contao.listener.image_size_options' => 'getContao_Listener_ImageSizeOptionsService',
            'contao.listener.insert_tags.asset' => 'getContao_Listener_InsertTags_AssetService',
            'contao.listener.insert_tags.date' => 'getContao_Listener_InsertTags_DateService',
            'contao.listener.insert_tags.translation' => 'getContao_Listener_InsertTags_TranslationService',
            'contao.listener.module_template_options' => 'getContao_Listener_ModuleTemplateOptionsService',
            'contao.listener.widget.custom_rgxp' => 'getContao_Listener_Widget_CustomRgxpService',
            'contao.listener.widget.http_url' => 'getContao_Listener_Widget_HttpUrlService',
            'contao.listener.widget.root_page_dependent_select' => 'getContao_Listener_Widget_RootPageDependentSelectService',
            'contao.mailer.available_transports' => 'getContao_Mailer_AvailableTransportsService',
            'contao.menu.backend_builder' => 'getContao_Menu_BackendBuilderService',
            'contao.menu.renderer' => 'getContao_Menu_RendererService',
            'contao.opt_in' => 'getContao_OptIn2Service',
            'contao.picker.builder' => 'getContao_Picker_BuilderService',
            'contao.repository.remember_me' => 'getContao_Repository_RememberMeService',
            'contao.resource_locator' => 'getContao_ResourceLocatorService',
            'contao.routing.response_context_accessor' => 'getContao_Routing_ResponseContextAccessorService',
            'contao.routing.response_context_factory' => 'getContao_Routing_ResponseContextFactoryService',
            'contao.routing.url_generator' => 'getContao_Routing_UrlGeneratorService',
            'contao.search.indexer' => 'getContao_Search_IndexerService',
            'contao.security.frontend_preview_authenticator' => 'getContao_Security_FrontendPreviewAuthenticatorService',
            'contao.security.two_factor.authenticator' => 'getContao_Security_TwoFactor_AuthenticatorService',
            'contao.security.two_factor.backup_code_manager' => 'getContao_Security_TwoFactor_BackupCodeManagerService',
            'contao.security.two_factor.trusted_device_manager' => 'getContao_Security_TwoFactor_TrustedDeviceManagerService',
            'contao.slug' => 'getContao_SlugService',
            'contao.slug.generator' => 'getContao_Slug_GeneratorService',
            'contao.slug.valid_characters' => 'getContao_Slug_ValidCharactersService',
            'contao.string.html_decoder' => 'getContao_String_HtmlDecoderService',
            'contao.string.simple_token_parser' => 'getContao_String_SimpleTokenParserService',
            'contao.twig.interop.context_factory' => 'getContao_Twig_Interop_ContextFactoryService',
            'contao_calendar.listener.generate_page' => 'getContaoCalendar_Listener_GeneratePageService',
            'contao_calendar.listener.insert_tags' => 'getContaoCalendar_Listener_InsertTagsService',
            'contao_faq.listener.insert_tags' => 'getContaoFaq_Listener_InsertTagsService',
            'contao_installation.database.installer' => 'getContaoInstallation_Database_InstallerService',
            'contao_installation.install_tool' => 'getContaoInstallation_InstallToolService',
            'contao_installation.install_tool_user' => 'getContaoInstallation_InstallToolUserService',
            'contao_manager.routing.route_loader' => 'getContaoManager_Routing_RouteLoaderService',
            'contao_news.listener.generate_page' => 'getContaoNews_Listener_GeneratePageService',
            'contao_news.listener.insert_tags' => 'getContaoNews_Listener_InsertTagsService',
            'doctrine' => 'getDoctrineService',
            'doctrine.orm.default_entity_manager' => 'getDoctrine_Orm_DefaultEntityManagerService',
            'error_controller' => 'getErrorControllerService',
            'fragment.handler' => 'getFragment_HandlerService',
            'knp_menu.factory' => 'getKnpMenu_FactoryService',
            'mailer' => 'getMailerService',
            'monolog.logger.contao' => 'getMonolog_Logger_ContaoService',
            'monolog.logger.contao.access' => 'getMonolog_Logger_Contao_AccessService',
            'monolog.logger.contao.configuration' => 'getMonolog_Logger_Contao_ConfigurationService',
            'monolog.logger.contao.cron' => 'getMonolog_Logger_Contao_CronService',
            'monolog.logger.contao.email' => 'getMonolog_Logger_Contao_EmailService',
            'monolog.logger.contao.error' => 'getMonolog_Logger_Contao_ErrorService',
            'monolog.logger.contao.files' => 'getMonolog_Logger_Contao_FilesService',
            'monolog.logger.contao.forms' => 'getMonolog_Logger_Contao_FormsService',
            'monolog.logger.contao.general' => 'getMonolog_Logger_Contao_GeneralService',
            'nelmio_security.csp_reporter_controller' => 'getNelmioSecurity_CspReporterControllerService',
            'nelmio_security.ua_parser.ua_php' => 'getNelmioSecurity_UaParser_UaPhpService',
            'routing.loader' => 'getRouting_LoaderService',
            'scheb_two_factor.firewall_context' => 'getSchebTwoFactor_FirewallContextService',
            'scheb_two_factor.form_controller' => 'getSchebTwoFactor_FormControllerService',
            'security.authentication_utils' => 'getSecurity_AuthenticationUtilsService',
            'security.password_hasher_factory' => 'getSecurity_PasswordHasherFactoryService',
            'services_resetter' => 'getServicesResetterService',
        ];
        $this->aliases = [
            'Contao\\CoreBundle\\Csrf\\ContaoCsrfTokenManager' => 'contao.csrf.token_manager',
            'Contao\\CoreBundle\\Image\\Studio\\Studio' => 'contao.image.studio',
            'Contao\\CoreBundle\\Intl\\Countries' => 'contao.intl.countries',
            'Contao\\CoreBundle\\Intl\\Locales' => 'contao.intl.locales',
            'Contao\\CoreBundle\\Mailer\\AvailableTransports' => 'contao.mailer.available_transports',
            'Contao\\CoreBundle\\OptIn\\OptIn' => 'contao.opt_in',
            'Contao\\CoreBundle\\Routing\\Page\\PageRegistry' => 'contao.routing.page_registry',
            'Contao\\CoreBundle\\Routing\\ResponseContext\\ResponseContextAccessor' => 'contao.routing.response_context_accessor',
            'FOS\\HttpCacheBundle\\CacheManager' => 'fos_http_cache.cache_manager',
            'FOS\\HttpCacheBundle\\Http\\SymfonyResponseTagger' => 'fos_http_cache.http.symfony_response_tagger',
            'FOS\\HttpCache\\ResponseTagger' => 'fos_http_cache.http.symfony_response_tagger',
            'Scheb\\TwoFactorBundle\\Security\\TwoFactor\\TwoFactorFirewallContext' => 'scheb_two_factor.firewall_context',
            'database_connection' => 'doctrine.dbal.default_connection',
            'doctrine.orm.entity_manager' => 'doctrine.orm.default_entity_manager',
        ];

        $this->privates['service_container'] = function () {
            include_once \dirname(__DIR__, 4).'/vendor/doctrine/event-manager/src/EventManager.php';
            include_once \dirname(__DIR__, 4).'/vendor/symfony/doctrine-bridge/ContainerAwareEventManager.php';
            include_once \dirname(__DIR__, 4).'/vendor/psr/container/src/ContainerInterface.php';
            include_once \dirname(__DIR__, 4).'/vendor/symfony/service-contracts/ServiceProviderInterface.php';
            include_once \dirname(__DIR__, 4).'/vendor/symfony/service-contracts/ServiceLocatorTrait.php';
            include_once \dirname(__DIR__, 4).'/vendor/symfony/dependency-injection/ServiceLocator.php';
            include_once \dirname(__DIR__, 4).'/vendor/doctrine/dbal/src/Connection.php';
            include_once \dirname(__DIR__, 4).'/vendor/doctrine/doctrine-bundle/src/ConnectionFactory.php';
            include_once \dirname(__DIR__, 4).'/vendor/doctrine/dbal/src/Configuration.php';
            include_once \dirname(__DIR__, 4).'/vendor/doctrine/dbal/src/Schema/SchemaManagerFactory.php';
            include_once \dirname(__DIR__, 4).'/vendor/doctrine/dbal/src/Schema/LegacySchemaManagerFactory.php';
            include_once \dirname(__DIR__, 4).'/vendor/doctrine/dbal/src/Tools/DsnParser.php';
            include_once \dirname(__DIR__, 4).'/vendor/symfony/event-dispatcher/EventSubscriberInterface.php';
            include_once \dirname(__DIR__, 4).'/vendor/symfony/http-kernel/EventListener/ResponseListener.php';
            include_once \dirname(__DIR__, 4).'/vendor/symfony/http-kernel/EventListener/StreamedResponseListener.php';
            include_once \dirname(__DIR__, 4).'/vendor/symfony/http-kernel/EventListener/LocaleListener.php';
            include_once \dirname(__DIR__, 4).'/vendor/symfony/http-kernel/EventListener/ValidateRequestListener.php';
            include_once \dirname(__DIR__, 4).'/vendor/symfony/http-kernel/EventListener/ErrorListener.php';
            include_once \dirname(__DIR__, 4).'/vendor/symfony/dependency-injection/ParameterBag/ParameterBagInterface.php';
            include_once \dirname(__DIR__, 4).'/vendor/symfony/dependency-injection/ParameterBag/ParameterBag.php';
            include_once \dirname(__DIR__, 4).'/vendor/symfony/dependency-injection/ParameterBag/FrozenParameterBag.php';
            include_once \dirname(__DIR__, 4).'/vendor/symfony/dependency-injection/ParameterBag/ContainerBagInterface.php';
            include_once \dirname(__DIR__, 4).'/vendor/symfony/dependency-injection/ParameterBag/ContainerBag.php';
            include_once \dirname(__DIR__, 4).'/vendor/psr/event-dispatcher/src/EventDispatcherInterface.php';
            include_once \dirname(__DIR__, 4).'/vendor/symfony/event-dispatcher-contracts/EventDispatcherInterface.php';
            include_once \dirname(__DIR__, 4).'/vendor/symfony/event-dispatcher/EventDispatcherInterface.php';
            include_once \dirname(__DIR__, 4).'/vendor/symfony/event-dispatcher/EventDispatcher.php';
            include_once \dirname(__DIR__, 4).'/vendor/symfony/http-kernel/HttpKernelInterface.php';
            include_once \dirname(__DIR__, 4).'/vendor/symfony/http-kernel/TerminableInterface.php';
            include_once \dirname(__DIR__, 4).'/vendor/symfony/http-kernel/HttpKernel.php';
            include_once \dirname(__DIR__, 4).'/vendor/symfony/http-kernel/Controller/ControllerResolverInterface.php';
            include_once \dirname(__DIR__, 4).'/vendor/contao/core-bundle/src/HttpKernel/ControllerResolver.php';
            include_once \dirname(__DIR__, 4).'/vendor/symfony/http-kernel/Controller/ControllerResolver.php';
            include_once \dirname(__DIR__, 4).'/vendor/symfony/http-kernel/Controller/ContainerControllerResolver.php';
            include_once \dirname(__DIR__, 4).'/vendor/symfony/framework-bundle/Controller/ControllerResolver.php';
            include_once \dirname(__DIR__, 4).'/vendor/symfony/http-kernel/Controller/ArgumentResolverInterface.php';
            include_once \dirname(__DIR__, 4).'/vendor/symfony/http-kernel/Controller/ArgumentResolver.php';
            include_once \dirname(__DIR__, 4).'/vendor/symfony/http-kernel/ControllerMetadata/ArgumentMetadataFactoryInterface.php';
            include_once \dirname(__DIR__, 4).'/vendor/symfony/http-kernel/ControllerMetadata/ArgumentMetadataFactory.php';
            include_once \dirname(__DIR__, 4).'/vendor/symfony/http-foundation/RequestStack.php';
            include_once \dirname(__DIR__, 4).'/vendor/symfony/http-kernel/UriSigner.php';
            include_once \dirname(__DIR__, 4).'/vendor/symfony/config/ConfigCacheFactoryInterface.php';
            include_once \dirname(__DIR__, 4).'/vendor/symfony/config/ResourceCheckerConfigCacheFactory.php';
            include_once \dirname(__DIR__, 4).'/vendor/symfony/http-kernel/EventListener/LocaleAwareListener.php';
            include_once \dirname(__DIR__, 4).'/vendor/psr/cache/src/CacheItemPoolInterface.php';
            include_once \dirname(__DIR__, 4).'/vendor/symfony/cache/Adapter/AdapterInterface.php';
            include_once \dirname(__DIR__, 4).'/vendor/symfony/cache-contracts/CacheInterface.php';
            include_once \dirname(__DIR__, 4).'/vendor/psr/log/Psr/Log/LoggerAwareInterface.php';
            include_once \dirname(__DIR__, 4).'/vendor/symfony/service-contracts/ResetInterface.php';
            include_once \dirname(__DIR__, 4).'/vendor/symfony/cache/ResettableInterface.php';
            include_once \dirname(__DIR__, 4).'/vendor/psr/log/Psr/Log/LoggerAwareTrait.php';
            include_once \dirname(__DIR__, 4).'/vendor/symfony/cache/Traits/AbstractAdapterTrait.php';
            include_once \dirname(__DIR__, 4).'/vendor/symfony/cache-contracts/CacheTrait.php';
            include_once \dirname(__DIR__, 4).'/vendor/symfony/cache/Traits/ContractsTrait.php';
            include_once \dirname(__DIR__, 4).'/vendor/symfony/cache/Adapter/AbstractAdapter.php';
            include_once \dirname(__DIR__, 4).'/vendor/symfony/asset/Packages.php';
            include_once \dirname(__DIR__, 4).'/vendor/symfony/asset/PackageInterface.php';
            include_once \dirname(__DIR__, 4).'/vendor/symfony/asset/Package.php';
            include_once \dirname(__DIR__, 4).'/vendor/symfony/asset/PathPackage.php';
            include_once \dirname(__DIR__, 4).'/vendor/symfony/asset/VersionStrategy/VersionStrategyInterface.php';
            include_once \dirname(__DIR__, 4).'/vendor/symfony/asset/VersionStrategy/EmptyVersionStrategy.php';
            include_once \dirname(__DIR__, 4).'/vendor/symfony/asset/Context/ContextInterface.php';
            include_once \dirname(__DIR__, 4).'/vendor/symfony/asset/Context/RequestStackContext.php';
            include_once \dirname(__DIR__, 4).'/vendor/symfony/asset/VersionStrategy/StaticVersionStrategy.php';
            include_once \dirname(__DIR__, 4).'/vendor/symfony/http-kernel/HttpCache/SurrogateInterface.php';
            include_once \dirname(__DIR__, 4).'/vendor/symfony/http-kernel/HttpCache/AbstractSurrogate.php';
            include_once \dirname(__DIR__, 4).'/vendor/symfony/http-kernel/HttpCache/Esi.php';
            include_once \dirname(__DIR__, 4).'/vendor/symfony/http-kernel/EventListener/SurrogateListener.php';
            include_once \dirname(__DIR__, 4).'/vendor/symfony/http-kernel/EventListener/FragmentListener.php';
            include_once \dirname(__DIR__, 4).'/vendor/symfony/translation-contracts/TranslatorInterface.php';
            include_once \dirname(__DIR__, 4).'/vendor/symfony/translation/TranslatorBagInterface.php';
            include_once \dirname(__DIR__, 4).'/vendor/symfony/translation-contracts/LocaleAwareInterface.php';
            include_once \dirname(__DIR__, 4).'/vendor/symfony/translation/Translator.php';
            include_once \dirname(__DIR__, 4).'/vendor/symfony/http-kernel/CacheWarmer/WarmableInterface.php';
            include_once \dirname(__DIR__, 4).'/vendor/symfony/framework-bundle/Translation/Translator.php';
            include_once \dirname(__DIR__, 4).'/vendor/symfony/translation/Formatter/MessageFormatterInterface.php';
            include_once \dirname(__DIR__, 4).'/vendor/symfony/translation/Formatter/IntlFormatterInterface.php';
            include_once \dirname(__DIR__, 4).'/vendor/symfony/translation/Formatter/MessageFormatter.php';
            include_once \dirname(__DIR__, 4).'/vendor/symfony/translation-contracts/TranslatorTrait.php';
            include_once \dirname(__DIR__, 4).'/vendor/symfony/translation/IdentityTranslator.php';
            include_once \dirname(__DIR__, 4).'/vendor/symfony/http-kernel/EventListener/DebugHandlersListener.php';
            include_once \dirname(__DIR__, 4).'/vendor/symfony/http-kernel/Debug/FileLinkFormatter.php';
            include_once \dirname(__DIR__, 4).'/vendor/symfony/stopwatch/Stopwatch.php';
            include_once \dirname(__DIR__, 4).'/vendor/symfony/routing/RequestContext.php';
            include_once \dirname(__DIR__, 4).'/vendor/symfony/expression-language/ExpressionFunctionProviderInterface.php';
            include_once \dirname(__DIR__, 4).'/vendor/symfony/routing/Matcher/ExpressionLanguageProvider.php';
            include_once \dirname(__DIR__, 4).'/vendor/symfony/http-kernel/EventListener/RouterListener.php';
            include_once \dirname(__DIR__, 4).'/vendor/symfony/cache/PruneableInterface.php';
            include_once \dirname(__DIR__, 4).'/vendor/symfony/cache/Traits/ProxyTrait.php';
            include_once \dirname(__DIR__, 4).'/vendor/symfony/cache/Adapter/PhpArrayAdapter.php';
            include_once \dirname(__DIR__, 4).'/vendor/symfony/http-foundation/Session/SessionFactoryInterface.php';
            include_once \dirname(__DIR__, 4).'/vendor/symfony/http-foundation/Session/SessionFactory.php';
            include_once \dirname(__DIR__, 4).'/vendor/symfony/http-kernel/EventListener/AbstractSessionListener.php';
            include_once \dirname(__DIR__, 4).'/vendor/symfony/http-kernel/EventListener/SessionListener.php';
            include_once \dirname(__DIR__, 4).'/vendor/symfony/security-csrf/TokenGenerator/TokenGeneratorInterface.php';
            include_once \dirname(__DIR__, 4).'/vendor/symfony/security-csrf/TokenGenerator/UriSafeTokenGenerator.php';
            include_once \dirname(__DIR__, 4).'/vendor/psr/log/Psr/Log/LoggerInterface.php';
            include_once \dirname(__DIR__, 4).'/vendor/monolog/monolog/src/Monolog/ResettableInterface.php';
            include_once \dirname(__DIR__, 4).'/vendor/monolog/monolog/src/Monolog/Logger.php';
            include_once \dirname(__DIR__, 4).'/vendor/symfony/http-kernel/Log/DebugLoggerInterface.php';
            include_once \dirname(__DIR__, 4).'/vendor/symfony/monolog-bridge/Logger.php';
            include_once \dirname(__DIR__, 4).'/vendor/monolog/monolog/src/Monolog/Handler/HandlerInterface.php';
            include_once \dirname(__DIR__, 4).'/vendor/monolog/monolog/src/Monolog/Handler/Handler.php';
            include_once \dirname(__DIR__, 4).'/vendor/monolog/monolog/src/Monolog/Handler/ProcessableHandlerInterface.php';
            include_once \dirname(__DIR__, 4).'/vendor/monolog/monolog/src/Monolog/Handler/FormattableHandlerInterface.php';
            include_once \dirname(__DIR__, 4).'/vendor/monolog/monolog/src/Monolog/Handler/ProcessableHandlerTrait.php';
            include_once \dirname(__DIR__, 4).'/vendor/monolog/monolog/src/Monolog/Handler/FingersCrossedHandler.php';
            include_once \dirname(__DIR__, 4).'/vendor/monolog/monolog/src/Monolog/Handler/AbstractHandler.php';
            include_once \dirname(__DIR__, 4).'/vendor/monolog/monolog/src/Monolog/Handler/FormattableHandlerTrait.php';
            include_once \dirname(__DIR__, 4).'/vendor/monolog/monolog/src/Monolog/Handler/AbstractProcessingHandler.php';
            include_once \dirname(__DIR__, 4).'/vendor/monolog/monolog/src/Monolog/Handler/StreamHandler.php';
            include_once \dirname(__DIR__, 4).'/vendor/monolog/monolog/src/Monolog/Handler/RotatingFileHandler.php';
            include_once \dirname(__DIR__, 4).'/vendor/monolog/monolog/src/Monolog/Handler/FingersCrossed/ActivationStrategyInterface.php';
            include_once \dirname(__DIR__, 4).'/vendor/monolog/monolog/src/Monolog/Handler/FingersCrossed/ErrorLevelActivationStrategy.php';
            include_once \dirname(__DIR__, 4).'/vendor/symfony/monolog-bridge/Handler/FingersCrossed/HttpCodeActivationStrategy.php';
            include_once \dirname(__DIR__, 4).'/vendor/monolog/monolog/src/Monolog/Processor/ProcessorInterface.php';
            include_once \dirname(__DIR__, 4).'/vendor/monolog/monolog/src/Monolog/Processor/PsrLogMessageProcessor.php';
            include_once \dirname(__DIR__, 4).'/vendor/symfony/monolog-bridge/Handler/ConsoleHandler.php';
            include_once \dirname(__DIR__, 4).'/vendor/friendsofsymfony/http-cache-bundle/src/Http/RuleMatcherInterface.php';
            include_once \dirname(__DIR__, 4).'/vendor/friendsofsymfony/http-cache-bundle/src/Http/RuleMatcher.php';
            include_once \dirname(__DIR__, 4).'/vendor/symfony/http-foundation/RequestMatcherInterface.php';
            include_once \dirname(__DIR__, 4).'/vendor/friendsofsymfony/http-cache-bundle/src/Http/RequestMatcher/UnsafeRequestMatcher.php';
            include_once \dirname(__DIR__, 4).'/vendor/friendsofsymfony/http-cache-bundle/src/Http/ResponseMatcher/ResponseMatcherInterface.php';
            include_once \dirname(__DIR__, 4).'/vendor/friendsofsymfony/http-cache-bundle/src/Http/ResponseMatcher/NonErrorResponseMatcher.php';
            include_once \dirname(__DIR__, 4).'/vendor/friendsofsymfony/http-cache/src/ProxyClient/ProxyClient.php';
            include_once \dirname(__DIR__, 4).'/vendor/friendsofsymfony/http-cache/src/ProxyClient/HttpProxyClient.php';
            include_once \dirname(__DIR__, 4).'/vendor/friendsofsymfony/http-cache/src/ProxyClient/Invalidation/PurgeCapable.php';
            include_once \dirname(__DIR__, 4).'/vendor/friendsofsymfony/http-cache/src/ProxyClient/Invalidation/RefreshCapable.php';
            include_once \dirname(__DIR__, 4).'/vendor/friendsofsymfony/http-cache/src/ProxyClient/Invalidation/TagCapable.php';
            include_once \dirname(__DIR__, 4).'/vendor/friendsofsymfony/http-cache/src/ProxyClient/Invalidation/ClearCapable.php';
            include_once \dirname(__DIR__, 4).'/vendor/friendsofsymfony/http-cache/src/ProxyClient/Symfony.php';
            include_once \dirname(__DIR__, 4).'/vendor/friendsofsymfony/http-cache/src/ProxyClient/Dispatcher.php';
            include_once \dirname(__DIR__, 4).'/vendor/friendsofsymfony/http-cache/src/SymfonyCache/KernelDispatcher.php';
            include_once \dirname(__DIR__, 4).'/vendor/friendsofsymfony/http-cache/src/CacheInvalidator.php';
            include_once \dirname(__DIR__, 4).'/vendor/friendsofsymfony/http-cache-bundle/src/CacheManager.php';
            include_once \dirname(__DIR__, 4).'/vendor/friendsofsymfony/http-cache/src/ResponseTagger.php';
            include_once \dirname(__DIR__, 4).'/vendor/friendsofsymfony/http-cache-bundle/src/Http/SymfonyResponseTagger.php';
            include_once \dirname(__DIR__, 4).'/vendor/friendsofsymfony/http-cache/src/TagHeaderFormatter/TagHeaderFormatter.php';
            include_once \dirname(__DIR__, 4).'/vendor/friendsofsymfony/http-cache/src/TagHeaderFormatter/TagHeaderParser.php';
            include_once \dirname(__DIR__, 4).'/vendor/friendsofsymfony/http-cache/src/TagHeaderFormatter/MaxHeaderValueLengthFormatter.php';
            include_once \dirname(__DIR__, 4).'/vendor/friendsofsymfony/http-cache/src/TagHeaderFormatter/CommaSeparatedTagHeaderFormatter.php';
            include_once \dirname(__DIR__, 4).'/vendor/friendsofsymfony/http-cache-bundle/src/EventListener/AbstractRuleListener.php';
            include_once \dirname(__DIR__, 4).'/vendor/friendsofsymfony/http-cache-bundle/src/EventListener/TagListener.php';
            include_once \dirname(__DIR__, 4).'/vendor/friendsofsymfony/http-cache-bundle/src/Http/RequestMatcher/CacheableRequestMatcher.php';
            include_once \dirname(__DIR__, 4).'/vendor/friendsofsymfony/http-cache-bundle/src/Http/ResponseMatcher/CacheableResponseMatcher.php';
            include_once \dirname(__DIR__, 4).'/vendor/nelmio/cors-bundle/EventListener/CorsListener.php';
            include_once \dirname(__DIR__, 4).'/vendor/nelmio/cors-bundle/Options/ResolverInterface.php';
            include_once \dirname(__DIR__, 4).'/vendor/nelmio/cors-bundle/Options/Resolver.php';
            include_once \dirname(__DIR__, 4).'/vendor/nelmio/cors-bundle/Options/ProviderInterface.php';
            include_once \dirname(__DIR__, 4).'/vendor/nelmio/cors-bundle/Options/ConfigProvider.php';
            include_once \dirname(__DIR__, 4).'/vendor/contao/core-bundle/src/Cors/WebsiteRootsConfigProvider.php';
            include_once \dirname(__DIR__, 4).'/vendor/nelmio/cors-bundle/EventListener/CacheableResponseVaryListener.php';
            include_once \dirname(__DIR__, 4).'/vendor/nelmio/security-bundle/EventListener/AbstractContentTypeRestrictableListener.php';
            include_once \dirname(__DIR__, 4).'/vendor/nelmio/security-bundle/EventListener/ClickjackingListener.php';
            include_once \dirname(__DIR__, 4).'/vendor/nelmio/security-bundle/EventListener/ContentSecurityPolicyListener.php';
            include_once \dirname(__DIR__, 4).'/vendor/nelmio/security-bundle/ContentSecurityPolicy/DirectiveSet.php';
            include_once \dirname(__DIR__, 4).'/vendor/nelmio/security-bundle/ContentSecurityPolicy/PolicyManager.php';
            include_once \dirname(__DIR__, 4).'/vendor/nelmio/security-bundle/ContentSecurityPolicy/NonceGenerator.php';
            include_once \dirname(__DIR__, 4).'/vendor/nelmio/security-bundle/ContentSecurityPolicy/ShaComputer.php';
            include_once \dirname(__DIR__, 4).'/vendor/nelmio/security-bundle/EventListener/XssProtectionListener.php';
            include_once \dirname(__DIR__, 4).'/vendor/nelmio/security-bundle/EventListener/ContentTypeListener.php';
            include_once \dirname(__DIR__, 4).'/vendor/nelmio/security-bundle/EventListener/ReferrerPolicyListener.php';
            include_once \dirname(__DIR__, 4).'/vendor/scheb/2fa-bundle/Security/TwoFactor/Provider/TwoFactorProviderRegistry.php';
            include_once \dirname(__DIR__, 4).'/vendor/scheb/2fa-bundle/Security/TwoFactor/Provider/PreparationRecorderInterface.php';
            include_once \dirname(__DIR__, 4).'/vendor/scheb/2fa-bundle/Security/TwoFactor/Provider/TokenPreparationRecorder.php';
            include_once \dirname(__DIR__, 4).'/vendor/knplabs/knp-menu/src/Knp/Menu/Matcher/MatcherInterface.php';
            include_once \dirname(__DIR__, 4).'/vendor/knplabs/knp-menu/src/Knp/Menu/Matcher/Matcher.php';
            include_once \dirname(__DIR__, 4).'/vendor/symfony/security-core/Authentication/Token/Storage/TokenStorageInterface.php';
            include_once \dirname(__DIR__, 4).'/vendor/symfony/security-core/Authentication/Token/Storage/TokenStorage.php';
            include_once \dirname(__DIR__, 4).'/vendor/symfony/security-core/Authorization/AuthorizationCheckerInterface.php';
            include_once \dirname(__DIR__, 4).'/vendor/symfony/security-core/Security.php';
            include_once \dirname(__DIR__, 4).'/vendor/symfony/security-core/Authorization/Voter/VoterInterface.php';
            include_once \dirname(__DIR__, 4).'/vendor/symfony/security-core/Authorization/Voter/CacheableVoterInterface.php';
            include_once \dirname(__DIR__, 4).'/vendor/symfony/security-core/Authorization/Voter/RoleVoter.php';
            include_once \dirname(__DIR__, 4).'/vendor/symfony/security-http/Firewall.php';
            include_once \dirname(__DIR__, 4).'/vendor/symfony/security-bundle/EventListener/FirewallListener.php';
            include_once \dirname(__DIR__, 4).'/vendor/symfony/security-http/FirewallMapInterface.php';
            include_once \dirname(__DIR__, 4).'/vendor/symfony/security-bundle/Security/FirewallMap.php';
            include_once \dirname(__DIR__, 4).'/vendor/symfony/security-http/Logout/LogoutUrlGenerator.php';
            include_once \dirname(__DIR__, 4).'/vendor/symfony/security-http/RememberMe/ResponseListener.php';
            include_once \dirname(__DIR__, 4).'/vendor/scheb/2fa-bundle/Security/TwoFactor/Provider/TwoFactorProviderPreparationListener.php';
            include_once \dirname(__DIR__, 4).'/vendor/symfony/service-contracts/ServiceSubscriberInterface.php';
            include_once \dirname(__DIR__, 4).'/vendor/symfony/framework-bundle/Controller/AbstractController.php';
            include_once \dirname(__DIR__, 4).'/vendor/contao/core-bundle/src/Controller/AbstractController.php';
            include_once \dirname(__DIR__, 4).'/vendor/contao/core-bundle/src/Routing/Page/ContentCompositionInterface.php';
            include_once \dirname(__DIR__, 4).'/vendor/contao/core-bundle/src/Controller/Page/ErrorPageController.php';
            include_once \dirname(__DIR__, 4).'/vendor/contao/core-bundle/src/EventListener/BackendLocaleListener.php';
            include_once \dirname(__DIR__, 4).'/vendor/contao/core-bundle/src/EventListener/BackendNoindexListener.php';
            include_once \dirname(__DIR__, 4).'/vendor/contao/core-bundle/src/EventListener/BackendPreviewRedirectListener.php';
            include_once \dirname(__DIR__, 4).'/vendor/contao/core-bundle/src/EventListener/BackendRebuildCacheMessageListener.php';
            include_once \dirname(__DIR__, 4).'/vendor/contao/core-bundle/src/EventListener/ClearSessionDataListener.php';
            include_once \dirname(__DIR__, 4).'/vendor/contao/core-bundle/src/EventListener/CsrfTokenCookieSubscriber.php';
            include_once \dirname(__DIR__, 4).'/vendor/contao/core-bundle/src/EventListener/InitializeControllerListener.php';
            include_once \dirname(__DIR__, 4).'/vendor/contao/core-bundle/src/EventListener/InsecureInstallationListener.php';
            include_once \dirname(__DIR__, 4).'/vendor/contao/core-bundle/src/EventListener/InterestCohortListener.php';
            include_once \dirname(__DIR__, 4).'/vendor/contao/core-bundle/src/EventListener/LegacyLoginConstantsListener.php';
            include_once \dirname(__DIR__, 4).'/vendor/contao/core-bundle/src/EventListener/LocaleSubscriber.php';
            include_once \dirname(__DIR__, 4).'/vendor/contao/core-bundle/src/EventListener/MakeResponsePrivateListener.php';
            include_once \dirname(__DIR__, 4).'/vendor/contao/core-bundle/src/EventListener/MergeHttpHeadersListener.php';
            include_once \dirname(__DIR__, 4).'/vendor/contao/core-bundle/src/EventListener/PageTrailCacheTagsListener.php';
            include_once \dirname(__DIR__, 4).'/vendor/contao/core-bundle/src/EventListener/PreviewAuthenticationListener.php';
            include_once \dirname(__DIR__, 4).'/vendor/contao/core-bundle/src/EventListener/PreviewToolbarListener.php';
            include_once \dirname(__DIR__, 4).'/vendor/contao/core-bundle/src/EventListener/RefererIdListener.php';
            include_once \dirname(__DIR__, 4).'/vendor/contao/core-bundle/src/EventListener/RequestTokenListener.php';
            include_once \dirname(__DIR__, 4).'/vendor/symfony/security-http/Util/TargetPathTrait.php';
            include_once \dirname(__DIR__, 4).'/vendor/contao/core-bundle/src/EventListener/Security/TwoFactorFrontendListener.php';
            include_once \dirname(__DIR__, 4).'/vendor/contao/core-bundle/src/EventListener/ServiceUnavailableListener.php';
            include_once \dirname(__DIR__, 4).'/vendor/contao/core-bundle/src/EventListener/StoreRefererListener.php';
            include_once \dirname(__DIR__, 4).'/vendor/contao/core-bundle/src/EventListener/SubrequestCacheSubscriber.php';
            include_once \dirname(__DIR__, 4).'/vendor/contao/core-bundle/src/EventListener/UserSessionListener.php';
            include_once \dirname(__DIR__, 4).'/vendor/contao/core-bundle/src/Twig/Loader/AutoRefreshTemplateHierarchyListener.php';
            include_once \dirname(__DIR__, 4).'/vendor/contao/core-bundle/src/Asset/ContaoContext.php';
            include_once \dirname(__DIR__, 4).'/vendor/symfony/security-csrf/CsrfTokenManagerInterface.php';
            include_once \dirname(__DIR__, 4).'/vendor/symfony/security-csrf/CsrfTokenManager.php';
            include_once \dirname(__DIR__, 4).'/vendor/contao/core-bundle/src/Csrf/ContaoCsrfTokenManager.php';
            include_once \dirname(__DIR__, 4).'/vendor/symfony/security-csrf/TokenStorage/TokenStorageInterface.php';
            include_once \dirname(__DIR__, 4).'/vendor/contao/core-bundle/src/Csrf/MemoryTokenStorage.php';
            include_once \dirname(__DIR__, 4).'/vendor/contao/core-bundle/src/Fragment/FragmentRegistryInterface.php';
            include_once \dirname(__DIR__, 4).'/vendor/contao/core-bundle/src/Fragment/FragmentRegistry.php';
            include_once \dirname(__DIR__, 4).'/vendor/contao/core-bundle/src/ContaoFrameworkInterface.php';
            include_once \dirname(__DIR__, 4).'/vendor/contao/core-bundle/src/Framework/ContaoFrameworkInterface.php';
            include_once \dirname(__DIR__, 4).'/vendor/symfony/dependency-injection/ContainerAwareInterface.php';
            include_once \dirname(__DIR__, 4).'/vendor/symfony/dependency-injection/ContainerAwareTrait.php';
            include_once \dirname(__DIR__, 4).'/vendor/contao/core-bundle/src/Framework/ContaoFramework.php';
            include_once \dirname(__DIR__, 4).'/vendor/contao/core-bundle/src/Intl/Locales.php';
            include_once \dirname(__DIR__, 4).'/vendor/contao/core-bundle/src/Monolog/ContaoTableHandler.php';
            include_once \dirname(__DIR__, 4).'/vendor/contao/core-bundle/src/Monolog/ContaoTableProcessor.php';
            include_once \dirname(__DIR__, 4).'/vendor/contao/core-bundle/src/Config/ResourceFinderInterface.php';
            include_once \dirname(__DIR__, 4).'/vendor/contao/core-bundle/src/Config/ResourceFinder.php';
            include_once \dirname(__DIR__, 4).'/vendor/symfony/http-foundation/RequestMatcher.php';
            include_once \dirname(__DIR__, 4).'/vendor/symfony-cmf/routing/src/NestedMatcher/RouteFilterInterface.php';
            include_once \dirname(__DIR__, 4).'/vendor/contao/core-bundle/src/Routing/Matcher/DomainFilter.php';
            include_once \dirname(__DIR__, 4).'/vendor/contao/core-bundle/src/Routing/Matcher/PublishedFilter.php';
            include_once \dirname(__DIR__, 4).'/vendor/symfony/routing/Matcher/RequestMatcherInterface.php';
            include_once \dirname(__DIR__, 4).'/vendor/symfony-cmf/routing/src/NestedMatcher/NestedMatcher.php';
            include_once \dirname(__DIR__, 4).'/vendor/contao/core-bundle/src/Routing/Page/PageRegistry.php';
            include_once \dirname(__DIR__, 4).'/vendor/contao/core-bundle/src/Routing/Page/RouteConfig.php';
            include_once \dirname(__DIR__, 4).'/vendor/symfony-cmf/routing/src/RouteProviderInterface.php';
            include_once \dirname(__DIR__, 4).'/vendor/contao/core-bundle/src/Routing/AbstractPageRouteProvider.php';
            include_once \dirname(__DIR__, 4).'/vendor/contao/core-bundle/src/Routing/Route404Provider.php';
            include_once \dirname(__DIR__, 4).'/vendor/symfony-cmf/routing/src/Candidates/CandidatesInterface.php';
            include_once \dirname(__DIR__, 4).'/vendor/contao/core-bundle/src/Routing/Candidates/AbstractCandidates.php';
            include_once \dirname(__DIR__, 4).'/vendor/contao/core-bundle/src/Routing/Candidates/LocaleCandidates.php';
            include_once \dirname(__DIR__, 4).'/vendor/contao/core-bundle/src/Routing/RouteProvider.php';
            include_once \dirname(__DIR__, 4).'/vendor/contao/core-bundle/src/Routing/Candidates/LegacyCandidates.php';
            include_once \dirname(__DIR__, 4).'/vendor/contao/core-bundle/src/Routing/ScopeMatcher.php';
            include_once \dirname(__DIR__, 4).'/vendor/symfony/routing/RequestContextAwareInterface.php';
            include_once \dirname(__DIR__, 4).'/vendor/symfony/routing/Matcher/UrlMatcherInterface.php';
            include_once \dirname(__DIR__, 4).'/vendor/symfony/routing/Matcher/UrlMatcher.php';
            include_once \dirname(__DIR__, 4).'/vendor/symfony/routing/Matcher/RedirectableUrlMatcherInterface.php';
            include_once \dirname(__DIR__, 4).'/vendor/symfony/routing/Matcher/RedirectableUrlMatcher.php';
            include_once \dirname(__DIR__, 4).'/vendor/symfony-cmf/routing/src/NestedMatcher/FinalMatcherInterface.php';
            include_once \dirname(__DIR__, 4).'/vendor/contao/core-bundle/src/Routing/Matcher/UrlMatcher.php';
            include_once \dirname(__DIR__, 4).'/vendor/symfony/security-core/Authorization/AccessDecisionManagerInterface.php';
            include_once \dirname(__DIR__, 4).'/vendor/contao/core-bundle/src/Security/Authentication/AccessDecisionManager.php';
            include_once \dirname(__DIR__, 4).'/vendor/symfony/security-core/Authorization/AccessDecisionManager.php';
            include_once \dirname(__DIR__, 4).'/vendor/symfony/security-core/Authorization/Strategy/AccessDecisionStrategyInterface.php';
            include_once \dirname(__DIR__, 4).'/vendor/symfony/polyfill-php80/Resources/stubs/Stringable.php';
            include_once \dirname(__DIR__, 4).'/vendor/symfony/security-core/Authorization/Strategy/AffirmativeStrategy.php';
            include_once \dirname(__DIR__, 4).'/vendor/contao/core-bundle/src/Security/Authentication/Token/TokenChecker.php';
            include_once \dirname(__DIR__, 4).'/vendor/twig/twig/src/Extension/ExtensionInterface.php';
            include_once \dirname(__DIR__, 4).'/vendor/twig/twig/src/Extension/AbstractExtension.php';
            include_once \dirname(__DIR__, 4).'/vendor/contao/core-bundle/src/Twig/Extension/ContaoExtension.php';
            include_once \dirname(__DIR__, 4).'/vendor/twig/twig/src/Loader/LoaderInterface.php';
            include_once \dirname(__DIR__, 4).'/vendor/contao/core-bundle/src/Twig/Loader/ContaoFilesystemLoader.php';
            include_once \dirname(__DIR__, 4).'/vendor/contao/core-bundle/src/Twig/Loader/TemplateLocator.php';
            include_once \dirname(__DIR__, 4).'/vendor/contao/core-bundle/src/Twig/Loader/ThemeNamespace.php';
            include_once \dirname(__DIR__, 4).'/vendor/symfony/config/Loader/LoaderInterface.php';
            include_once \dirname(__DIR__, 4).'/vendor/symfony/config/Loader/Loader.php';
            include_once \dirname(__DIR__, 4).'/vendor/contao/core-bundle/src/Routing/FrontendLoader.php';
            include_once \dirname(__DIR__, 4).'/vendor/monolog/monolog/src/Monolog/Handler/NullHandler.php';
            include_once \dirname(__DIR__, 4).'/vendor/contao/core-bundle/src/Fragment/FragmentConfig.php';
            include_once \dirname(__DIR__, 4).'/vendor/contao/core-bundle/src/Translation/Translator.php';
            include_once \dirname(__DIR__, 4).'/vendor/symfony/routing/Generator/UrlGeneratorInterface.php';
            include_once \dirname(__DIR__, 4).'/vendor/symfony/routing/RouterInterface.php';
            include_once \dirname(__DIR__, 4).'/vendor/symfony-cmf/routing/src/ChainRouterInterface.php';
            include_once \dirname(__DIR__, 4).'/vendor/symfony-cmf/routing/src/ChainRouter.php';
            include_once \dirname(__DIR__, 4).'/vendor/symfony/routing/Router.php';
            include_once \dirname(__DIR__, 4).'/vendor/symfony/framework-bundle/Routing/Router.php';
            include_once \dirname(__DIR__, 4).'/vendor/symfony-cmf/routing/src/VersatileGeneratorInterface.php';
            include_once \dirname(__DIR__, 4).'/vendor/symfony-cmf/routing/src/ChainedRouterInterface.php';
            include_once \dirname(__DIR__, 4).'/vendor/symfony-cmf/routing/src/Enhancer/RouteEnhancerTrait.php';
            include_once \dirname(__DIR__, 4).'/vendor/symfony-cmf/routing/src/DynamicRouter.php';
            include_once \dirname(__DIR__, 4).'/vendor/symfony/routing/Generator/ConfigurableRequirementsInterface.php';
            include_once \dirname(__DIR__, 4).'/vendor/symfony/routing/Generator/UrlGenerator.php';
            include_once \dirname(__DIR__, 4).'/vendor/contao/core-bundle/src/Routing/PageUrlGenerator.php';
            include_once \dirname(__DIR__, 4).'/vendor/symfony-cmf/routing/src/Enhancer/RouteEnhancerInterface.php';
            include_once \dirname(__DIR__, 4).'/vendor/contao/core-bundle/src/Routing/Enhancer/InputEnhancer.php';
            include_once \dirname(__DIR__, 4).'/vendor/symfony-cmf/routing/src/ProviderBasedGenerator.php';
            include_once \dirname(__DIR__, 4).'/vendor/contao/core-bundle/src/Routing/LegacyRouteProvider.php';
            include_once \dirname(__DIR__, 4).'/vendor/symfony/security-core/Authentication/AuthenticationTrustResolverInterface.php';
            include_once \dirname(__DIR__, 4).'/vendor/scheb/2fa-bundle/Security/Authentication/AuthenticationTrustResolver.php';
            include_once \dirname(__DIR__, 4).'/vendor/symfony/security-core/Authentication/AuthenticationTrustResolver.php';
            include_once \dirname(__DIR__, 4).'/vendor/contao/core-bundle/src/Routing/Matcher/LegacyMatcher.php';
            include_once \dirname(__DIR__, 4).'/vendor/contao/core-bundle/src/Routing/Matcher/LanguageFilter.php';
            include_once \dirname(__DIR__, 4).'/vendor/symfony/filesystem/Filesystem.php';
            include_once \dirname(__DIR__, 4).'/vendor/twig/twig/src/Cache/CacheInterface.php';
            include_once \dirname(__DIR__, 4).'/vendor/twig/twig/src/Cache/FilesystemCache.php';
            include_once \dirname(__DIR__, 4).'/vendor/twig/twig/src/Extension/CoreExtension.php';
            include_once \dirname(__DIR__, 4).'/vendor/twig/twig/src/Extension/EscaperExtension.php';
            include_once \dirname(__DIR__, 4).'/vendor/twig/twig/src/Extension/OptimizerExtension.php';
            include_once \dirname(__DIR__, 4).'/vendor/twig/twig/src/Extension/StagingExtension.php';
            include_once \dirname(__DIR__, 4).'/vendor/twig/twig/src/ExtensionSet.php';
            include_once \dirname(__DIR__, 4).'/vendor/twig/twig/src/Template.php';
            include_once \dirname(__DIR__, 4).'/vendor/twig/twig/src/TemplateWrapper.php';
            include_once \dirname(__DIR__, 4).'/vendor/twig/twig/src/Environment.php';
            include_once \dirname(__DIR__, 4).'/vendor/twig/twig/src/Loader/ChainLoader.php';
            include_once \dirname(__DIR__, 4).'/vendor/twig/twig/src/Loader/FilesystemLoader.php';
            include_once \dirname(__DIR__, 4).'/vendor/contao/core-bundle/src/Twig/Loader/FailTolerantFilesystemLoader.php';
            include_once \dirname(__DIR__, 4).'/vendor/symfony/twig-bridge/Extension/CsrfExtension.php';
            include_once \dirname(__DIR__, 4).'/vendor/symfony/twig-bridge/Extension/TranslationExtension.php';
            include_once \dirname(__DIR__, 4).'/vendor/symfony/twig-bridge/Extension/AssetExtension.php';
            include_once \dirname(__DIR__, 4).'/vendor/symfony/twig-bridge/Extension/CodeExtension.php';
            include_once \dirname(__DIR__, 4).'/vendor/symfony/twig-bridge/Extension/RoutingExtension.php';
            include_once \dirname(__DIR__, 4).'/vendor/symfony/twig-bridge/Extension/YamlExtension.php';
            include_once \dirname(__DIR__, 4).'/vendor/symfony/twig-bridge/Extension/StopwatchExtension.php';
            include_once \dirname(__DIR__, 4).'/vendor/symfony/twig-bridge/Extension/ExpressionExtension.php';
            include_once \dirname(__DIR__, 4).'/vendor/symfony/twig-bridge/Extension/HttpKernelExtension.php';
            include_once \dirname(__DIR__, 4).'/vendor/symfony/twig-bridge/Extension/HttpFoundationExtension.php';
            include_once \dirname(__DIR__, 4).'/vendor/symfony/http-foundation/UrlHelper.php';
            include_once \dirname(__DIR__, 4).'/vendor/symfony/twig-bridge/Extension/LogoutUrlExtension.php';
            include_once \dirname(__DIR__, 4).'/vendor/symfony/twig-bridge/Extension/SecurityExtension.php';
            include_once \dirname(__DIR__, 4).'/vendor/symfony/security-http/Impersonate/ImpersonateUrlGenerator.php';
            include_once \dirname(__DIR__, 4).'/vendor/doctrine/doctrine-bundle/src/Twig/DoctrineExtension.php';
            include_once \dirname(__DIR__, 4).'/vendor/friendsofsymfony/http-cache-bundle/src/Twig/CacheTagExtension.php';
            include_once \dirname(__DIR__, 4).'/vendor/nelmio/security-bundle/Twig/NelmioCSPTwigExtension.php';
            include_once \dirname(__DIR__, 4).'/vendor/knplabs/knp-menu/src/Knp/Menu/Twig/MenuExtension.php';
            include_once \dirname(__DIR__, 4).'/vendor/knplabs/knp-menu/src/Knp/Menu/Twig/Helper.php';
            include_once \dirname(__DIR__, 4).'/vendor/knplabs/knp-menu/src/Knp/Menu/Renderer/RendererProviderInterface.php';
            include_once \dirname(__DIR__, 4).'/vendor/knplabs/knp-menu/src/Knp/Menu/Renderer/PsrProvider.php';
            include_once \dirname(__DIR__, 4).'/vendor/knplabs/knp-menu/src/Knp/Menu/Provider/MenuProviderInterface.php';
            include_once \dirname(__DIR__, 4).'/vendor/knplabs/knp-menu/src/Knp/Menu/Provider/ChainProvider.php';
            include_once \dirname(__DIR__, 4).'/vendor/knplabs/knp-menu/src/Knp/Menu/Util/MenuManipulator.php';
            include_once \dirname(__DIR__, 4).'/vendor/knplabs/knp-time-bundle/src/Twig/Extension/TimeExtension.php';
            include_once \dirname(__DIR__, 4).'/vendor/knplabs/knp-time-bundle/src/DateTimeFormatter.php';
            include_once \dirname(__DIR__, 4).'/vendor/sensiolabs/ansi-to-html/SensioLabs/AnsiConverter/Bridge/Twig/AnsiExtension.php';
            include_once \dirname(__DIR__, 4).'/vendor/symfony/twig-bridge/AppVariable.php';
            include_once \dirname(__DIR__, 4).'/vendor/twig/twig/src/RuntimeLoader/RuntimeLoaderInterface.php';
            include_once \dirname(__DIR__, 4).'/vendor/twig/twig/src/RuntimeLoader/ContainerRuntimeLoader.php';
            include_once \dirname(__DIR__, 4).'/vendor/symfony/twig-bundle/DependencyInjection/Configurator/EnvironmentConfigurator.php';
            include_once \dirname(__DIR__, 4).'/vendor/symfony/security-core/Authorization/AuthorizationChecker.php';
            include_once \dirname(__DIR__, 4).'/vendor/symfony/security-core/Authentication/Token/Storage/UsageTrackingTokenStorage.php';
            include_once \dirname(__DIR__, 4).'/vendor/symfony/http-foundation/Session/SessionInterface.php';
            include_once \dirname(__DIR__, 4).'/vendor/symfony/http-foundation/Session/Session.php';
            include_once \dirname(__DIR__, 4).'/vendor/symfony/http-foundation/Session/SessionBagInterface.php';
            include_once \dirname(__DIR__, 4).'/vendor/symfony/http-foundation/Session/Attribute/AttributeBagInterface.php';
            include_once \dirname(__DIR__, 4).'/vendor/symfony/http-foundation/Session/Attribute/AttributeBag.php';
            include_once \dirname(__DIR__, 4).'/vendor/contao/core-bundle/src/Session/Attribute/ArrayAttributeBag.php';
        };
    }

    public function compile(): void
    {
        throw new LogicException('You cannot compile a dumped container that was already compiled.');
    }

    public function isCompiled(): bool
    {
        return true;
    }

    public function getRemovedIds(): array
    {
        return require $this->containerDir.\DIRECTORY_SEPARATOR.'removed-ids.php';
    }

    protected function load($file, $lazyLoad = true)
    {
        if (class_exists($class = __NAMESPACE__.'\\'.$file, false)) {
            return $class::do($this, $lazyLoad);
        }

        if ('.' === $file[-4]) {
            $class = substr($class, 0, -4);
        } else {
            $file .= '.php';
        }

        $service = require $this->containerDir.\DIRECTORY_SEPARATOR.$file;

        return class_exists($class, false) ? $class::do($this, $lazyLoad) : $service;
    }

    protected function createProxy($class, \Closure $factory)
    {
        class_exists($class, false) || require __DIR__.'/'.$class.'.php';

        return $factory();
    }

    /*
     * Gets the public '.container.private.filesystem' shared service.
     *
     * @return \Symfony\Component\Filesystem\Filesystem
     */
    protected function get_Container_Private_FilesystemService()
    {
        return $this->services['.container.private.filesystem'] = new \Symfony\Component\Filesystem\Filesystem();
    }

    /*
     * Gets the public '.container.private.security.authorization_checker' shared service.
     *
     * @return \Symfony\Component\Security\Core\Authorization\AuthorizationChecker
     */
    protected function get_Container_Private_Security_AuthorizationCheckerService()
    {
        $a = ($this->privates['contao.security.access_decision_manager'] ?? $this->getContao_Security_AccessDecisionManagerService());

        if (isset($this->services['.container.private.security.authorization_checker'])) {
            return $this->services['.container.private.security.authorization_checker'];
        }

        return $this->services['.container.private.security.authorization_checker'] = new \Symfony\Component\Security\Core\Authorization\AuthorizationChecker(($this->services['.container.private.security.token_storage'] ?? $this->get_Container_Private_Security_TokenStorageService()), $a, false, false);
    }

    /*
     * Gets the public '.container.private.security.token_storage' shared service.
     *
     * @return \Symfony\Component\Security\Core\Authentication\Token\Storage\UsageTrackingTokenStorage
     */
    protected function get_Container_Private_Security_TokenStorageService()
    {
        return $this->services['.container.private.security.token_storage'] = new \Symfony\Component\Security\Core\Authentication\Token\Storage\UsageTrackingTokenStorage(($this->privates['security.untracked_token_storage'] ?? ($this->privates['security.untracked_token_storage'] = new \Symfony\Component\Security\Core\Authentication\Token\Storage\TokenStorage())), new \Symfony\Component\DependencyInjection\Argument\ServiceLocator($this->getService, [
            'request_stack' => ['services', 'request_stack', 'getRequestStackService', false],
        ], [
            'request_stack' => '?',
        ]));
    }

    /*
     * Gets the public '.container.private.session' shared service.
     *
     * @return \Symfony\Component\HttpFoundation\Session\Session
     */
    protected function get_Container_Private_SessionService()
    {
        $a = ($this->privates['session.factory'] ?? $this->getSession_FactoryService());

        if (isset($this->services['.container.private.session'])) {
            return $this->services['.container.private.session'];
        }

        $this->services['.container.private.session'] = $instance = $a->createSession();

        $b = new \Contao\CoreBundle\Session\Attribute\ArrayAttributeBag('_contao_be_attributes');
        $b->setName('contao_backend');
        $c = new \Contao\CoreBundle\Session\Attribute\ArrayAttributeBag('_contao_fe_attributes');
        $c->setName('contao_frontend');

        $instance->registerBag($b);
        $instance->registerBag($c);

        return $instance;
    }

    /*
     * Gets the public '.container.private.twig' shared service.
     *
     * @return \Twig\Environment
     */
    protected function get_Container_Private_TwigService()
    {
        $a = ($this->services['contao.twig.filesystem_loader'] ?? $this->getContao_Twig_FilesystemLoaderService());

        if (isset($this->services['.container.private.twig'])) {
            return $this->services['.container.private.twig'];
        }
        $b = new \Twig\Loader\ChainLoader();

        $c = new \Contao\CoreBundle\Twig\Loader\FailTolerantFilesystemLoader([], \dirname(__DIR__, 4));
        $c->addPath((\dirname(__DIR__, 4).'/vendor/knplabs/knp-menu/src/Knp/Menu/Resources/views'));
        $c->addPath((\dirname(__DIR__, 4).'/vendor/doctrine/doctrine-bundle/templates'), 'Doctrine');
        $c->addPath((\dirname(__DIR__, 4).'/vendor/doctrine/doctrine-bundle/templates'), '!Doctrine');
        $c->addPath((\dirname(__DIR__, 4).'/vendor/scheb/2fa-bundle/Resources/views'), 'SchebTwoFactor');
        $c->addPath((\dirname(__DIR__, 4).'/vendor/scheb/2fa-bundle/Resources/views'), '!SchebTwoFactor');
        $c->addPath((\dirname(__DIR__, 4).'/vendor/knplabs/knp-menu-bundle/src/Resources/views'), 'KnpMenu');
        $c->addPath((\dirname(__DIR__, 4).'/vendor/knplabs/knp-menu-bundle/src/Resources/views'), '!KnpMenu');
        $c->addPath((\dirname(__DIR__, 4).'/vendor/symfony/security-bundle/Resources/views'), 'Security');
        $c->addPath((\dirname(__DIR__, 4).'/vendor/symfony/security-bundle/Resources/views'), '!Security');
        $c->addPath((\dirname(__DIR__, 4).'/vendor/contao/core-bundle/src/Resources/views'), 'ContaoCore');
        $c->addPath((\dirname(__DIR__, 4).'/vendor/contao/core-bundle/src/Resources/views'), '!ContaoCore');
        $c->addPath((\dirname(__DIR__, 4).'/system/modules/Subcolumns/templates'), 'Subcolumns');
        $c->addPath((\dirname(__DIR__, 4).'/system/modules/Subcolumns/templates'), '!Subcolumns');
        $c->addPath((\dirname(__DIR__, 4).'/system/modules/mobile_menu/templates'), 'mobile_menu');
        $c->addPath((\dirname(__DIR__, 4).'/system/modules/mobile_menu/templates'), '!mobile_menu');
        $c->addPath((\dirname(__DIR__, 4).'/vendor/contao/installation-bundle/src/Resources/views'), 'ContaoInstallation');
        $c->addPath((\dirname(__DIR__, 4).'/vendor/contao/installation-bundle/src/Resources/views'), '!ContaoInstallation');
        $c->addPath((\dirname(__DIR__, 4).'/vendor/tabularasadev/contao-fonctions/src/templates'), 'ContaoFonctions');
        $c->addPath((\dirname(__DIR__, 4).'/vendor/tabularasadev/contao-fonctions/src/templates'), '!ContaoFonctions');
        $c->addPath((\dirname(__DIR__, 4).'/system/modules/dk_mmenu/templates'), 'dk_mmenu');
        $c->addPath((\dirname(__DIR__, 4).'/system/modules/dk_mmenu/templates'), '!dk_mmenu');
        $c->addPath((\dirname(__DIR__, 4).'/templates'));
        $c->addPath((\dirname(__DIR__, 4).'/vendor/symfony/twig-bridge/Resources/views/Email'), 'email');
        $c->addPath((\dirname(__DIR__, 4).'/vendor/symfony/twig-bridge/Resources/views/Email'), '!email');

        $b->addLoader($a);
        $b->addLoader($c);
        $b->addLoader(new \Twig\Loader\FilesystemLoader([], \dirname(__DIR__, 4)));

        $this->services['.container.private.twig'] = $instance = new \Twig\Environment($b, ['debug' => false, 'strict_variables' => false, 'autoescape' => 'name', 'cache' => ($this->targetDir.''.'/twig'), 'charset' => 'UTF-8']);

        $d = ($this->services['translator'] ?? $this->getTranslatorService());
        $e = ($this->services['router'] ?? $this->getRouterService());
        $f = ($this->services['request_stack'] ?? ($this->services['request_stack'] = new \Symfony\Component\HttpFoundation\RequestStack()));
        $g = ($this->services['.container.private.security.token_storage'] ?? $this->get_Container_Private_Security_TokenStorageService());
        $h = new \Knp\Menu\Util\MenuManipulator();
        $i = ($this->services['knp_menu.matcher'] ?? $this->getKnpMenu_MatcherService());
        $j = new \Symfony\Bridge\Twig\AppVariable();
        $j->setEnvironment('prod');
        $j->setDebug(false);
        if ($this->has('.container.private.security.token_storage')) {
            $j->setTokenStorage($g);
        }
        if ($this->has('request_stack')) {
            $j->setRequestStack($f);
        }

        $instance->addExtension(new \Symfony\Bridge\Twig\Extension\CsrfExtension());
        $instance->addExtension(new \Symfony\Bridge\Twig\Extension\TranslationExtension($d));
        $instance->addExtension(new \Symfony\Bridge\Twig\Extension\AssetExtension(($this->services['assets.packages'] ?? $this->getAssets_PackagesService())));
        $instance->addExtension(new \Symfony\Bridge\Twig\Extension\CodeExtension(($this->privates['debug.file_link_formatter'] ?? ($this->privates['debug.file_link_formatter'] = new \Symfony\Component\HttpKernel\Debug\FileLinkFormatter(NULL))), \dirname(__DIR__, 4), 'UTF-8'));
        $instance->addExtension(new \Symfony\Bridge\Twig\Extension\RoutingExtension($e));
        $instance->addExtension(new \Symfony\Bridge\Twig\Extension\YamlExtension());
        $instance->addExtension(new \Symfony\Bridge\Twig\Extension\StopwatchExtension(($this->services['debug.stopwatch'] ?? ($this->services['debug.stopwatch'] = new \Symfony\Component\Stopwatch\Stopwatch(true))), false));
        $instance->addExtension(new \Symfony\Bridge\Twig\Extension\ExpressionExtension());
        $instance->addExtension(new \Symfony\Bridge\Twig\Extension\HttpKernelExtension());
        $instance->addExtension(new \Symfony\Bridge\Twig\Extension\HttpFoundationExtension(new \Symfony\Component\HttpFoundation\UrlHelper($f, $e)));
        $instance->addExtension(new \Symfony\Bridge\Twig\Extension\LogoutUrlExtension(($this->services['security.logout_url_generator'] ?? $this->getSecurity_LogoutUrlGeneratorService())));
        $instance->addExtension(new \Symfony\Bridge\Twig\Extension\SecurityExtension(($this->services['.container.private.security.authorization_checker'] ?? $this->get_Container_Private_Security_AuthorizationCheckerService()), new \Symfony\Component\Security\Http\Impersonate\ImpersonateUrlGenerator($f, ($this->services['security.firewall.map'] ?? $this->getSecurity_Firewall_MapService()), $g)));
        $instance->addExtension(new \Doctrine\Bundle\DoctrineBundle\Twig\DoctrineExtension());
        $instance->addExtension(new \FOS\HttpCacheBundle\Twig\CacheTagExtension(($this->services['fos_http_cache.http.symfony_response_tagger'] ?? $this->getFosHttpCache_Http_SymfonyResponseTaggerService())));
        $instance->addExtension(new \Nelmio\SecurityBundle\Twig\NelmioCSPTwigExtension(($this->privates['nelmio_security.csp_listener'] ?? $this->getNelmioSecurity_CspListenerService()), ($this->privates['nelmio_security.sha_computer'] ?? ($this->privates['nelmio_security.sha_computer'] = new \Nelmio\SecurityBundle\ContentSecurityPolicy\ShaComputer('sha256')))));
        $instance->addExtension(new \Knp\Menu\Twig\MenuExtension(new \Knp\Menu\Twig\Helper(new \Knp\Menu\Renderer\PsrProvider(new \Symfony\Component\DependencyInjection\Argument\ServiceLocator($this->getService, [
            'list' => ['privates', 'knp_menu.renderer.list', 'getKnpMenu_Renderer_ListService', true],
            'twig' => ['privates', 'knp_menu.renderer.twig', 'getKnpMenu_Renderer_TwigService', true],
        ], [
            'list' => '?',
            'twig' => '?',
        ]), 'twig', [], false), new \Knp\Menu\Provider\ChainProvider(new RewindableGenerator(function () {
            yield 0 => ($this->privates['knp_menu.menu_provider.lazy'] ?? $this->load('getKnpMenu_MenuProvider_LazyService'));
            yield 1 => ($this->privates['knp_menu.menu_provider.builder_alias'] ?? $this->load('getKnpMenu_MenuProvider_BuilderAliasService'));
        }, 2)), $h, $i), $i, $h));
        $instance->addExtension(new \Knp\Bundle\TimeBundle\Twig\Extension\TimeExtension(new \Knp\Bundle\TimeBundle\DateTimeFormatter($d)));
        $instance->addExtension(($this->services['contao.twig.extension'] ?? $this->getContao_Twig_ExtensionService()));
        $instance->addExtension(new \SensioLabs\AnsiConverter\Bridge\Twig\AnsiExtension());
        $instance->addGlobal('app', $j);
        $instance->addRuntimeLoader(new \Twig\RuntimeLoader\ContainerRuntimeLoader(new \Symfony\Component\DependencyInjection\Argument\ServiceLocator($this->getService, [
            'Symfony\\Bridge\\Twig\\Extension\\CsrfRuntime' => ['privates', 'twig.runtime.security_csrf', 'getTwig_Runtime_SecurityCsrfService', true],
            'Symfony\\Bridge\\Twig\\Extension\\HttpKernelRuntime' => ['privates', 'twig.runtime.httpkernel', 'getTwig_Runtime_HttpkernelService', true],
            'Contao\\CoreBundle\\Twig\\Runtime\\FigureRendererRuntime' => ['privates', 'contao.twig.figure_renderer_runtime', 'getContao_Twig_FigureRendererRuntimeService', true],
            'Contao\\CoreBundle\\Twig\\Runtime\\InsertTagRuntime' => ['privates', 'contao.twig.insert_tag_runtime', 'getContao_Twig_InsertTagRuntimeService', true],
            'Contao\\CoreBundle\\Twig\\Runtime\\LegacyTemplateFunctionsRuntime' => ['privates', 'contao.twig.legacy_template_functions_runtime', 'getContao_Twig_LegacyTemplateFunctionsRuntimeService', true],
            'Contao\\CoreBundle\\Twig\\Runtime\\PictureConfigurationRuntime' => ['privates', 'contao.twig.picture_configuration_runtime', 'getContao_Twig_PictureConfigurationRuntimeService', true],
            'Contao\\CoreBundle\\Twig\\Runtime\\SchemaOrgRuntime' => ['privates', 'contao.twig.schema_org_runtime', 'getContao_Twig_SchemaOrgRuntimeService', true],
        ], [
            'Symfony\\Bridge\\Twig\\Extension\\CsrfRuntime' => '?',
            'Symfony\\Bridge\\Twig\\Extension\\HttpKernelRuntime' => '?',
            'Contao\\CoreBundle\\Twig\\Runtime\\FigureRendererRuntime' => '?',
            'Contao\\CoreBundle\\Twig\\Runtime\\InsertTagRuntime' => '?',
            'Contao\\CoreBundle\\Twig\\Runtime\\LegacyTemplateFunctionsRuntime' => '?',
            'Contao\\CoreBundle\\Twig\\Runtime\\PictureConfigurationRuntime' => '?',
            'Contao\\CoreBundle\\Twig\\Runtime\\SchemaOrgRuntime' => '?',
        ])));
        (new \Symfony\Bundle\TwigBundle\DependencyInjection\Configurator\EnvironmentConfigurator('F j, Y H:i', '%d days', NULL, 0, '.', ','))->configure($instance);

        return $instance;
    }

    /*
     * Gets the public 'Contao\CoreBundle\Controller\Page\ErrorPageController' shared service.
     *
     * @return \Contao\CoreBundle\Controller\Page\ErrorPageController
     */
    protected function getErrorPageControllerService()
    {
        $a = ($this->services['contao.framework'] ?? $this->getContao_FrameworkService());

        if (isset($this->services['Contao\\CoreBundle\\Controller\\Page\\ErrorPageController'])) {
            return $this->services['Contao\\CoreBundle\\Controller\\Page\\ErrorPageController'];
        }

        $this->services['Contao\\CoreBundle\\Controller\\Page\\ErrorPageController'] = $instance = new \Contao\CoreBundle\Controller\Page\ErrorPageController($a);

        $instance->setContainer(($this->privates['.service_locator.ZTa9e0W'] ?? $this->get_ServiceLocator_ZTa9e0WService())->withContext('Contao\\CoreBundle\\Controller\\Page\\ErrorPageController', $this));

        return $instance;
    }

    /*
     * Gets the public 'assets.packages' shared service.
     *
     * @return \Symfony\Component\Asset\Packages
     */
    protected function getAssets_PackagesService()
    {
        $a = new \Symfony\Component\Asset\VersionStrategy\EmptyVersionStrategy();
        $b = ($this->privates['router.request_context'] ?? $this->getRouter_RequestContextService());

        $this->services['assets.packages'] = $instance = new \Symfony\Component\Asset\Packages(new \Symfony\Component\Asset\PathPackage('', $a, new \Symfony\Component\Asset\Context\RequestStackContext(($this->services['request_stack'] ?? ($this->services['request_stack'] = new \Symfony\Component\HttpFoundation\RequestStack())), $b->getBaseUrl(), $b->isSecure())), new RewindableGenerator(function () {
            return new \EmptyIterator();
        }, 0));

        $c = ($this->services['contao.assets.assets_context'] ?? $this->getContao_Assets_AssetsContextService());
        $d = new \Symfony\Component\Asset\PathPackage('assets/ace', new \Symfony\Component\Asset\VersionStrategy\StaticVersionStrategy('1.35.4', '%s?v=%s'), $c);
        $e = new \Symfony\Component\Asset\PathPackage('assets/chosen', new \Symfony\Component\Asset\VersionStrategy\StaticVersionStrategy('1.2.5', '%s?v=%s'), $c);
        $f = new \Symfony\Component\Asset\PathPackage('assets/colorbox', new \Symfony\Component\Asset\VersionStrategy\StaticVersionStrategy('1.6.4.2', '%s?v=%s'), $c);
        $g = new \Symfony\Component\Asset\PathPackage('assets/colorpicker', new \Symfony\Component\Asset\VersionStrategy\StaticVersionStrategy('1.5.3', '%s?v=%s'), $c);
        $h = new \Symfony\Component\Asset\PathPackage('assets/contao', new \Symfony\Component\Asset\VersionStrategy\StaticVersionStrategy('9.3.6', '%s?v=%s'), $c);
        $i = new \Symfony\Component\Asset\PathPackage('assets/datepicker', new \Symfony\Component\Asset\VersionStrategy\StaticVersionStrategy('2.3.2', '%s?v=%s'), $c);
        $j = new \Symfony\Component\Asset\PathPackage('assets/dropzone', new \Symfony\Component\Asset\VersionStrategy\StaticVersionStrategy('5.9.3', '%s?v=%s'), $c);
        $k = new \Symfony\Component\Asset\PathPackage('assets/jquery', new \Symfony\Component\Asset\VersionStrategy\StaticVersionStrategy('3.7.1', '%s?v=%s'), $c);
        $l = new \Symfony\Component\Asset\PathPackage('assets/jquery-ui', new \Symfony\Component\Asset\VersionStrategy\StaticVersionStrategy('1.13.2', '%s?v=%s'), $c);
        $m = new \Symfony\Component\Asset\PathPackage('assets/mediabox', new \Symfony\Component\Asset\VersionStrategy\StaticVersionStrategy('1.5.4.3', '%s?v=%s'), $c);
        $n = new \Symfony\Component\Asset\PathPackage('assets/mootools', new \Symfony\Component\Asset\VersionStrategy\StaticVersionStrategy('1.6.0.9', '%s?v=%s'), $c);
        $o = new \Symfony\Component\Asset\PathPackage('assets/simplemodal', new \Symfony\Component\Asset\VersionStrategy\StaticVersionStrategy('2.1.2', '%s?v=%s'), $c);
        $p = new \Symfony\Component\Asset\PathPackage('assets/swipe', new \Symfony\Component\Asset\VersionStrategy\StaticVersionStrategy('2.2.2', '%s?v=%s'), $c);
        $q = new \Symfony\Component\Asset\PathPackage('assets/tablesort', new \Symfony\Component\Asset\VersionStrategy\StaticVersionStrategy('4.0.2', '%s?v=%s'), $c);
        $r = new \Symfony\Component\Asset\PathPackage('assets/tablesorter', new \Symfony\Component\Asset\VersionStrategy\StaticVersionStrategy('2.31.3.1', '%s?v=%s'), $c);
        $s = new \Symfony\Component\Asset\PathPackage('assets/tinymce4', new \Symfony\Component\Asset\VersionStrategy\StaticVersionStrategy('5.10.9', '%s?v=%s'), $c);

        $instance->addPackage('contao_core', new \Symfony\Component\Asset\PathPackage('bundles/contaocore', $a, $c));
        $instance->addPackage('contao_petitescdc', new \Symfony\Component\Asset\PathPackage('bundles/contaopetitescdc', $a, $c));
        $instance->addPackage('multi_column_wizard', new \Symfony\Component\Asset\PathPackage('bundles/multicolumnwizard', $a, $c));
        $instance->addPackage('contao_wow_js', new \Symfony\Component\Asset\PathPackage('bundles/contaowowjs', $a, $c));
        $instance->addPackage('contao_faq', new \Symfony\Component\Asset\PathPackage('bundles/contaofaq', $a, $c));
        $instance->addPackage('contao_comments', new \Symfony\Component\Asset\PathPackage('bundles/contaocomments', $a, $c));
        $instance->addPackage('j_query_in_contao_backend', new \Symfony\Component\Asset\PathPackage('bundles/jqueryincontaobackend', $a, $c));
        $instance->addPackage('contao_news', new \Symfony\Component\Asset\PathPackage('bundles/contaonews', $a, $c));
        $instance->addPackage('contao_fonctions', new \Symfony\Component\Asset\PathPackage('bundles/contaofonctions', $a, $c));
        $instance->addPackage('contao_calendar', new \Symfony\Component\Asset\PathPackage('bundles/contaocalendar', $a, $c));
        $instance->addPackage('contao_newsletter', new \Symfony\Component\Asset\PathPackage('bundles/contaonewsletter', $a, $c));
        $instance->addPackage('bug_buster_cron', new \Symfony\Component\Asset\PathPackage('bundles/bugbustercron', $a, $c));
        $instance->addPackage('rock_solid_slider', new \Symfony\Component\Asset\PathPackage('bundles/rocksolidslider', $a, $c));
        $instance->addPackage('contao-components/ace', $d);
        $instance->addPackage('contao-components/chosen', $e);
        $instance->addPackage('contao-components/colorbox', $f);
        $instance->addPackage('contao-components/colorpicker', $g);
        $instance->addPackage('contao-components/contao', $h);
        $instance->addPackage('contao-components/datepicker', $i);
        $instance->addPackage('contao-components/dropzone', $j);
        $instance->addPackage('contao-components/jquery', $k);
        $instance->addPackage('contao-components/jquery-ui', $l);
        $instance->addPackage('contao-components/mediabox', $m);
        $instance->addPackage('contao-components/mootools', $n);
        $instance->addPackage('contao-components/simplemodal', $o);
        $instance->addPackage('contao-components/swipe', $p);
        $instance->addPackage('contao-components/tablesort', $q);
        $instance->addPackage('contao-components/tablesorter', $r);
        $instance->addPackage('contao-components/tinymce4', $s);
        $instance->addPackage('contao-components/ace', $d);
        $instance->addPackage('contao-components/chosen', $e);
        $instance->addPackage('contao-components/colorbox', $f);
        $instance->addPackage('contao-components/colorpicker', $g);
        $instance->addPackage('contao-components/contao', $h);
        $instance->addPackage('contao-components/datepicker', $i);
        $instance->addPackage('contao-components/dropzone', $j);
        $instance->addPackage('contao-components/jquery', $k);
        $instance->addPackage('contao-components/jquery-ui', $l);
        $instance->addPackage('contao-components/mediabox', $m);
        $instance->addPackage('contao-components/mootools', $n);
        $instance->addPackage('contao-components/simplemodal', $o);
        $instance->addPackage('contao-components/swipe', $p);
        $instance->addPackage('contao-components/tablesort', $q);
        $instance->addPackage('contao-components/tablesorter', $r);
        $instance->addPackage('contao-components/tinymce4', $s);

        return $instance;
    }

    /*
     * Gets the public 'cache.system' shared service.
     *
     * @return \Symfony\Component\Cache\Adapter\AdapterInterface
     */
    protected function getCache_SystemService()
    {
        return $this->services['cache.system'] = \Symfony\Component\Cache\Adapter\AbstractAdapter::createSystemCache('nssyRLJguL', 0, $this->getParameter('container.build_id'), ($this->targetDir.''.'/pools/system'), ($this->privates['monolog.logger.cache'] ?? $this->getMonolog_Logger_CacheService()));
    }

    /*
     * Gets the public 'contao.assets.assets_context' shared service.
     *
     * @return \Contao\CoreBundle\Asset\ContaoContext
     */
    protected function getContao_Assets_AssetsContextService()
    {
        $a = ($this->services['contao.framework'] ?? $this->getContao_FrameworkService());

        if (isset($this->services['contao.assets.assets_context'])) {
            return $this->services['contao.assets.assets_context'];
        }

        return $this->services['contao.assets.assets_context'] = new \Contao\CoreBundle\Asset\ContaoContext(($this->services['request_stack'] ?? ($this->services['request_stack'] = new \Symfony\Component\HttpFoundation\RequestStack())), $a, 'staticPlugins', false);
    }

    /*
     * Gets the public 'contao.csrf.token_manager' shared service.
     *
     * @return \Contao\CoreBundle\Csrf\ContaoCsrfTokenManager
     */
    protected function getContao_Csrf_TokenManagerService()
    {
        return $this->services['contao.csrf.token_manager'] = new \Contao\CoreBundle\Csrf\ContaoCsrfTokenManager(($this->services['request_stack'] ?? ($this->services['request_stack'] = new \Symfony\Component\HttpFoundation\RequestStack())), 'csrf_', ($this->privates['security.csrf.token_generator'] ?? ($this->privates['security.csrf.token_generator'] = new \Symfony\Component\Security\Csrf\TokenGenerator\UriSafeTokenGenerator())), ($this->privates['contao.csrf.token_storage'] ?? ($this->privates['contao.csrf.token_storage'] = new \Contao\CoreBundle\Csrf\MemoryTokenStorage())), NULL, 'contao_csrf_token');
    }

    /*
     * Gets the public 'contao.framework' shared service.
     *
     * @return \Contao\CoreBundle\Framework\ContaoFramework
     */
    protected function getContao_FrameworkService()
    {
        $a = ($this->services['contao.security.token_checker'] ?? $this->getContao_Security_TokenCheckerService());

        if (isset($this->services['contao.framework'])) {
            return $this->services['contao.framework'];
        }
        $b = ($this->services['router'] ?? $this->getRouterService());

        if (isset($this->services['contao.framework'])) {
            return $this->services['contao.framework'];
        }

        $this->services['contao.framework'] = $instance = new \Contao\CoreBundle\Framework\ContaoFramework(($this->services['request_stack'] ?? ($this->services['request_stack'] = new \Symfony\Component\HttpFoundation\RequestStack())), ($this->services['contao.routing.scope_matcher'] ?? $this->getContao_Routing_ScopeMatcherService()), $a, ($this->services['.container.private.filesystem'] ?? ($this->services['.container.private.filesystem'] = new \Symfony\Component\Filesystem\Filesystem())), $b, \dirname(__DIR__, 4), 8183, true);

        $instance->setContainer($this);
        $instance->setHookListeners(['initializeSystem' => [255 => [0 => [0 => 'contao.listener.MGEESJ7', 1 => 'onInitializeSystem'], 1 => [0 => 'contao.listener.fE48e1G', 1 => 'onInitializeSystem']], 0 => [0 => [0 => 'contao.listener.data_container.preview_link', 1 => 'unloadModuleWithoutPreviewScript']]], 'loadDataContainer' => [0 => [0 => [0 => 'contao.listener.data_container.preview_link', 1 => 'unloadTableWithoutPreviewScript'], 1 => [0 => 'contao.listener.data_container.record_preview', 1 => 'registerDeleteCallbacks'], 2 => [0 => 'contao.listener.data_container.toggle_nodes_label', 1 => '__invoke'], 3 => [0 => 'contao.listener.data_container_callback', 1 => 'onLoadDataContainer']]], 'replaceInsertTags' => [0 => [0 => [0 => 'contao.listener.insert_tags.asset', 1 => 'onReplaceInsertTags'], 1 => [0 => 'contao.listener.insert_tags.date', 1 => '__invoke'], 2 => [0 => 'contao.listener.insert_tags.translation', 1 => 'onReplaceInsertTags'], 3 => [0 => 'contao_faq.listener.insert_tags', 1 => 'onReplaceInsertTags'], 4 => [0 => 'contao_news.listener.insert_tags', 1 => '__invoke'], 5 => [0 => 'contao_calendar.listener.insert_tags', 1 => '__invoke']]], 'addCustomRegexp' => [0 => [0 => [0 => 'contao.listener.widget.custom_rgxp', 1 => '__invoke'], 1 => [0 => 'contao.listener.widget.http_url', 1 => '__invoke']]], 'getContentElement' => [0 => [0 => [0 => 'InspiredMinds\\ContaoWowJs\\EventListener\\HookListener', 1 => 'onGetContentElement']]], 'parseWidget' => [0 => [0 => [0 => 'InspiredMinds\\ContaoWowJs\\EventListener\\HookListener', 1 => 'onParseWidget']]], 'generatePage' => [0 => [0 => [0 => 'contao_news.listener.generate_page', 1 => '__invoke'], 1 => [0 => 'contao_calendar.listener.generate_page', 1 => '__invoke']]]]);

        return $instance;
    }

    /*
     * Gets the public 'contao.intl.locales' shared service.
     *
     * @return \Contao\CoreBundle\Intl\Locales
     */
    protected function getContao_Intl_LocalesService()
    {
        $a = ($this->services['translator'] ?? $this->getTranslatorService());

        if (isset($this->services['contao.intl.locales'])) {
            return $this->services['contao.intl.locales'];
        }
        $b = ($this->services['contao.framework'] ?? $this->getContao_FrameworkService());

        if (isset($this->services['contao.intl.locales'])) {
            return $this->services['contao.intl.locales'];
        }

        return $this->services['contao.intl.locales'] = new \Contao\CoreBundle\Intl\Locales($a, ($this->services['request_stack'] ?? ($this->services['request_stack'] = new \Symfony\Component\HttpFoundation\RequestStack())), $b, [0 => 'en', 1 => 'nl', 2 => 'fr', 3 => 'fa', 4 => 'cs', 5 => 'pl', 6 => 'es', 7 => 'tr', 8 => 'sr', 9 => 'sl', 10 => 'it', 11 => 'ru', 12 => 'pt', 13 => 'lv', 14 => 'sv', 15 => 'de', 16 => 'ja', 17 => 'af', 18 => 'af_NA', 19 => 'af_ZA', 20 => 'agq', 21 => 'agq_CM', 22 => 'ak', 23 => 'ak_GH', 24 => 'am', 25 => 'am_ET', 26 => 'ar', 27 => 'ar_001', 28 => 'ar_AE', 29 => 'ar_BH', 30 => 'ar_DJ', 31 => 'ar_DZ', 32 => 'ar_EG', 33 => 'ar_EH', 34 => 'ar_ER', 35 => 'ar_IL', 36 => 'ar_IQ', 37 => 'ar_JO', 38 => 'ar_KM', 39 => 'ar_KW', 40 => 'ar_LB', 41 => 'ar_LY', 42 => 'ar_MA', 43 => 'ar_MR', 44 => 'ar_OM', 45 => 'ar_PS', 46 => 'ar_QA', 47 => 'ar_SA', 48 => 'ar_SD', 49 => 'ar_SO', 50 => 'ar_SS', 51 => 'ar_SY', 52 => 'ar_TD', 53 => 'ar_TN', 54 => 'ar_YE', 55 => 'as', 56 => 'as_IN', 57 => 'asa', 58 => 'asa_TZ', 59 => 'ast', 60 => 'ast_ES', 61 => 'az', 62 => 'az_Cyrl', 63 => 'az_Cyrl_AZ', 64 => 'az_Latn', 65 => 'az_Latn_AZ', 66 => 'bas', 67 => 'bas_CM', 68 => 'be', 69 => 'be_BY', 70 => 'bem', 71 => 'bem_ZM', 72 => 'bez', 73 => 'bez_TZ', 74 => 'bg', 75 => 'bg_BG', 76 => 'bm', 77 => 'bm_ML', 78 => 'bn', 79 => 'bn_BD', 80 => 'bn_IN', 81 => 'bo', 82 => 'bo_CN', 83 => 'bo_IN', 84 => 'br', 85 => 'br_FR', 86 => 'brx', 87 => 'brx_IN', 88 => 'bs', 89 => 'bs_Cyrl', 90 => 'bs_Cyrl_BA', 91 => 'bs_Latn', 92 => 'bs_Latn_BA', 93 => 'ca', 94 => 'ca_AD', 95 => 'ca_ES', 96 => 'ca_FR', 97 => 'ca_IT', 98 => 'ccp', 99 => 'ccp_BD', 100 => 'ccp_IN', 101 => 'ce', 102 => 'ce_RU', 103 => 'cgg', 104 => 'cgg_UG', 105 => 'chr', 106 => 'chr_US', 107 => 'ckb', 108 => 'ckb_IQ', 109 => 'ckb_IR', 110 => 'cs_CZ', 111 => 'cy', 112 => 'cy_GB', 113 => 'da', 114 => 'da_DK', 115 => 'da_GL', 116 => 'dav', 117 => 'dav_KE', 118 => 'de_AT', 119 => 'de_BE', 120 => 'de_CH', 121 => 'de_DE', 122 => 'de_IT', 123 => 'de_LI', 124 => 'de_LU', 125 => 'dje', 126 => 'dje_NE', 127 => 'dsb', 128 => 'dsb_DE', 129 => 'dua', 130 => 'dua_CM', 131 => 'dyo', 132 => 'dyo_SN', 133 => 'dz', 134 => 'dz_BT', 135 => 'ebu', 136 => 'ebu_KE', 137 => 'ee', 138 => 'ee_GH', 139 => 'ee_TG', 140 => 'el', 141 => 'el_CY', 142 => 'el_GR', 143 => 'en_001', 144 => 'en_150', 145 => 'en_AG', 146 => 'en_AI', 147 => 'en_AS', 148 => 'en_AT', 149 => 'en_AU', 150 => 'en_BB', 151 => 'en_BE', 152 => 'en_BI', 153 => 'en_BM', 154 => 'en_BS', 155 => 'en_BW', 156 => 'en_BZ', 157 => 'en_CA', 158 => 'en_CC', 159 => 'en_CH', 160 => 'en_CK', 161 => 'en_CM', 162 => 'en_CX', 163 => 'en_CY', 164 => 'en_DE', 165 => 'en_DG', 166 => 'en_DK', 167 => 'en_DM', 168 => 'en_ER', 169 => 'en_FI', 170 => 'en_FJ', 171 => 'en_FK', 172 => 'en_FM', 173 => 'en_GB', 174 => 'en_GD', 175 => 'en_GG', 176 => 'en_GH', 177 => 'en_GI', 178 => 'en_GM', 179 => 'en_GU', 180 => 'en_GY', 181 => 'en_HK', 182 => 'en_IE', 183 => 'en_IL', 184 => 'en_IM', 185 => 'en_IN', 186 => 'en_IO', 187 => 'en_JE', 188 => 'en_JM', 189 => 'en_KE', 190 => 'en_KI', 191 => 'en_KN', 192 => 'en_KY', 193 => 'en_LC', 194 => 'en_LR', 195 => 'en_LS', 196 => 'en_MG', 197 => 'en_MH', 198 => 'en_MO', 199 => 'en_MP', 200 => 'en_MS', 201 => 'en_MT', 202 => 'en_MU', 203 => 'en_MW', 204 => 'en_MY', 205 => 'en_NA', 206 => 'en_NF', 207 => 'en_NG', 208 => 'en_NL', 209 => 'en_NR', 210 => 'en_NU', 211 => 'en_NZ', 212 => 'en_PG', 213 => 'en_PH', 214 => 'en_PK', 215 => 'en_PN', 216 => 'en_PR', 217 => 'en_PW', 218 => 'en_RW', 219 => 'en_SB', 220 => 'en_SC', 221 => 'en_SD', 222 => 'en_SE', 223 => 'en_SG', 224 => 'en_SH', 225 => 'en_SI', 226 => 'en_SL', 227 => 'en_SS', 228 => 'en_SX', 229 => 'en_SZ', 230 => 'en_TC', 231 => 'en_TK', 232 => 'en_TO', 233 => 'en_TT', 234 => 'en_TV', 235 => 'en_TZ', 236 => 'en_UG', 237 => 'en_UM', 238 => 'en_US', 239 => 'en_US_POSIX', 240 => 'en_VC', 241 => 'en_VG', 242 => 'en_VI', 243 => 'en_VU', 244 => 'en_WS', 245 => 'en_ZA', 246 => 'en_ZM', 247 => 'en_ZW', 248 => 'eo', 249 => 'es_419', 250 => 'es_AR', 251 => 'es_BO', 252 => 'es_BR', 253 => 'es_BZ', 254 => 'es_CL', 255 => 'es_CO', 256 => 'es_CR', 257 => 'es_CU', 258 => 'es_DO', 259 => 'es_EA', 260 => 'es_EC', 261 => 'es_ES', 262 => 'es_GQ', 263 => 'es_GT', 264 => 'es_HN', 265 => 'es_IC', 266 => 'es_MX', 267 => 'es_NI', 268 => 'es_PA', 269 => 'es_PE', 270 => 'es_PH', 271 => 'es_PR', 272 => 'es_PY', 273 => 'es_SV', 274 => 'es_US', 275 => 'es_UY', 276 => 'es_VE', 277 => 'et', 278 => 'et_EE', 279 => 'eu', 280 => 'eu_ES', 281 => 'ewo', 282 => 'ewo_CM', 283 => 'fa_AF', 284 => 'fa_IR', 285 => 'ff', 286 => 'fi', 287 => 'fi_FI', 288 => 'fil', 289 => 'fil_PH', 290 => 'fo', 291 => 'fo_DK', 292 => 'fo_FO', 293 => 'fr_BE', 294 => 'fr_BF', 295 => 'fr_BI', 296 => 'fr_BJ', 297 => 'fr_BL', 298 => 'fr_CA', 299 => 'fr_CD', 300 => 'fr_CF', 301 => 'fr_CG', 302 => 'fr_CH', 303 => 'fr_CI', 304 => 'fr_CM', 305 => 'fr_DJ', 306 => 'fr_DZ', 307 => 'fr_FR', 308 => 'fr_GA', 309 => 'fr_GF', 310 => 'fr_GN', 311 => 'fr_GP', 312 => 'fr_GQ', 313 => 'fr_HT', 314 => 'fr_KM', 315 => 'fr_LU', 316 => 'fr_MA', 317 => 'fr_MC', 318 => 'fr_MF', 319 => 'fr_MG', 320 => 'fr_ML', 321 => 'fr_MQ', 322 => 'fr_MR', 323 => 'fr_MU', 324 => 'fr_NC', 325 => 'fr_NE', 326 => 'fr_PF', 327 => 'fr_PM', 328 => 'fr_RE', 329 => 'fr_RW', 330 => 'fr_SC', 331 => 'fr_SN', 332 => 'fr_SY', 333 => 'fr_TD', 334 => 'fr_TG', 335 => 'fr_TN', 336 => 'fr_VU', 337 => 'fr_WF', 338 => 'fr_YT', 339 => 'fur', 340 => 'fur_IT', 341 => 'fy', 342 => 'fy_NL', 343 => 'ga', 344 => 'ga_IE', 345 => 'gd', 346 => 'gd_GB', 347 => 'gl', 348 => 'gl_ES', 349 => 'gsw', 350 => 'gsw_CH', 351 => 'gsw_FR', 352 => 'gsw_LI', 353 => 'gu', 354 => 'gu_IN', 355 => 'guz', 356 => 'guz_KE', 357 => 'gv', 358 => 'gv_IM', 359 => 'ha', 360 => 'ha_GH', 361 => 'ha_NE', 362 => 'ha_NG', 363 => 'haw', 364 => 'haw_US', 365 => 'he', 366 => 'he_IL', 367 => 'hi', 368 => 'hi_IN', 369 => 'hr', 370 => 'hr_BA', 371 => 'hr_HR', 372 => 'hsb', 373 => 'hsb_DE', 374 => 'hu', 375 => 'hu_HU', 376 => 'hy', 377 => 'hy_AM', 378 => 'ia', 379 => 'ia_001', 380 => 'id', 381 => 'id_ID', 382 => 'ig', 383 => 'ig_NG', 384 => 'ii', 385 => 'ii_CN', 386 => 'is', 387 => 'is_IS', 388 => 'it_CH', 389 => 'it_IT', 390 => 'it_SM', 391 => 'it_VA', 392 => 'ja_JP', 393 => 'jgo', 394 => 'jgo_CM', 395 => 'jmc', 396 => 'jmc_TZ', 397 => 'jv', 398 => 'jv_ID', 399 => 'ka', 400 => 'ka_GE', 401 => 'kab', 402 => 'kab_DZ', 403 => 'kam', 404 => 'kam_KE', 405 => 'kde', 406 => 'kde_TZ', 407 => 'kea', 408 => 'kea_CV', 409 => 'khq', 410 => 'khq_ML', 411 => 'ki', 412 => 'ki_KE', 413 => 'kk', 414 => 'kk_KZ', 415 => 'kkj', 416 => 'kkj_CM', 417 => 'kl', 418 => 'kl_GL', 419 => 'kln', 420 => 'kln_KE', 421 => 'km', 422 => 'km_KH', 423 => 'kn', 424 => 'kn_IN', 425 => 'ko', 426 => 'ko_KP', 427 => 'ko_KR', 428 => 'kok', 429 => 'kok_IN', 430 => 'ks', 431 => 'ks_IN', 432 => 'ksb', 433 => 'ksb_TZ', 434 => 'ksf', 435 => 'ksf_CM', 436 => 'ksh', 437 => 'ksh_DE', 438 => 'ku', 439 => 'ku_TR', 440 => 'kw', 441 => 'kw_GB', 442 => 'ky', 443 => 'ky_KG', 444 => 'lag', 445 => 'lag_TZ', 446 => 'lb', 447 => 'lb_LU', 448 => 'lg', 449 => 'lg_UG', 450 => 'lkt', 451 => 'lkt_US', 452 => 'ln', 453 => 'ln_AO', 454 => 'ln_CD', 455 => 'ln_CF', 456 => 'ln_CG', 457 => 'lo', 458 => 'lo_LA', 459 => 'lrc', 460 => 'lrc_IQ', 461 => 'lrc_IR', 462 => 'lt', 463 => 'lt_LT', 464 => 'lu', 465 => 'lu_CD', 466 => 'luo', 467 => 'luo_KE', 468 => 'luy', 469 => 'luy_KE', 470 => 'lv_LV', 471 => 'mas', 472 => 'mas_KE', 473 => 'mas_TZ', 474 => 'mer', 475 => 'mer_KE', 476 => 'mfe', 477 => 'mfe_MU', 478 => 'mg', 479 => 'mg_MG', 480 => 'mgh', 481 => 'mgh_MZ', 482 => 'mgo', 483 => 'mgo_CM', 484 => 'mi', 485 => 'mi_NZ', 486 => 'mk', 487 => 'mk_MK', 488 => 'ml', 489 => 'ml_IN', 490 => 'mn', 491 => 'mn_MN', 492 => 'mr', 493 => 'mr_IN', 494 => 'ms', 495 => 'ms_BN', 496 => 'ms_MY', 497 => 'ms_SG', 498 => 'mt', 499 => 'mt_MT', 500 => 'mua', 501 => 'mua_CM', 502 => 'my', 503 => 'my_MM', 504 => 'mzn', 505 => 'mzn_IR', 506 => 'naq', 507 => 'naq_NA', 508 => 'nb', 509 => 'nb_NO', 510 => 'nb_SJ', 511 => 'nd', 512 => 'nd_ZW', 513 => 'nds', 514 => 'nds_DE', 515 => 'nds_NL', 516 => 'ne', 517 => 'ne_IN', 518 => 'ne_NP', 519 => 'nl_AW', 520 => 'nl_BE', 521 => 'nl_BQ', 522 => 'nl_CW', 523 => 'nl_NL', 524 => 'nl_SR', 525 => 'nl_SX', 526 => 'nmg', 527 => 'nmg_CM', 528 => 'nn', 529 => 'nn_NO', 530 => 'nnh', 531 => 'nnh_CM', 532 => 'nus', 533 => 'nus_SS', 534 => 'nyn', 535 => 'nyn_UG', 536 => 'om', 537 => 'om_ET', 538 => 'om_KE', 539 => 'or', 540 => 'or_IN', 541 => 'os', 542 => 'os_GE', 543 => 'os_RU', 544 => 'pa', 545 => 'pa_Arab', 546 => 'pa_Arab_PK', 547 => 'pa_Guru', 548 => 'pa_Guru_IN', 549 => 'pl_PL', 550 => 'ps', 551 => 'ps_AF', 552 => 'pt_AO', 553 => 'pt_BR', 554 => 'pt_CH', 555 => 'pt_CV', 556 => 'pt_GQ', 557 => 'pt_GW', 558 => 'pt_LU', 559 => 'pt_MO', 560 => 'pt_MZ', 561 => 'pt_PT', 562 => 'pt_ST', 563 => 'pt_TL', 564 => 'qu', 565 => 'qu_BO', 566 => 'qu_EC', 567 => 'qu_PE', 568 => 'rm', 569 => 'rm_CH', 570 => 'rn', 571 => 'rn_BI', 572 => 'ro', 573 => 'ro_MD', 574 => 'ro_RO', 575 => 'rof', 576 => 'rof_TZ', 577 => 'ru_BY', 578 => 'ru_KG', 579 => 'ru_KZ', 580 => 'ru_MD', 581 => 'ru_RU', 582 => 'ru_UA', 583 => 'rw', 584 => 'rw_RW', 585 => 'rwk', 586 => 'rwk_TZ', 587 => 'sah', 588 => 'sah_RU', 589 => 'saq', 590 => 'saq_KE', 591 => 'sbp', 592 => 'sbp_TZ', 593 => 'sd', 594 => 'sd_PK', 595 => 'se', 596 => 'se_FI', 597 => 'se_NO', 598 => 'se_SE', 599 => 'seh', 600 => 'seh_MZ', 601 => 'ses', 602 => 'ses_ML', 603 => 'sg', 604 => 'sg_CF', 605 => 'shi', 606 => 'shi_Latn', 607 => 'shi_Latn_MA', 608 => 'shi_Tfng', 609 => 'shi_Tfng_MA', 610 => 'si', 611 => 'si_LK', 612 => 'sk', 613 => 'sk_SK', 614 => 'sl_SI', 615 => 'smn', 616 => 'smn_FI', 617 => 'sn', 618 => 'sn_ZW', 619 => 'so', 620 => 'so_DJ', 621 => 'so_ET', 622 => 'so_KE', 623 => 'so_SO', 624 => 'sq', 625 => 'sq_AL', 626 => 'sq_MK', 627 => 'sq_XK', 628 => 'sr_Cyrl', 629 => 'sr_Cyrl_BA', 630 => 'sr_Cyrl_ME', 631 => 'sr_Cyrl_RS', 632 => 'sr_Cyrl_XK', 633 => 'sr_Latn', 634 => 'sr_Latn_BA', 635 => 'sr_Latn_ME', 636 => 'sr_Latn_RS', 637 => 'sr_Latn_XK', 638 => 'sv_AX', 639 => 'sv_FI', 640 => 'sv_SE', 641 => 'sw', 642 => 'sw_CD', 643 => 'sw_KE', 644 => 'sw_TZ', 645 => 'sw_UG', 646 => 'ta', 647 => 'ta_IN', 648 => 'ta_LK', 649 => 'ta_MY', 650 => 'ta_SG', 651 => 'te', 652 => 'te_IN', 653 => 'teo', 654 => 'teo_KE', 655 => 'teo_UG', 656 => 'tg', 657 => 'tg_TJ', 658 => 'th', 659 => 'th_TH', 660 => 'ti', 661 => 'ti_ER', 662 => 'ti_ET', 663 => 'tk', 664 => 'tk_TM', 665 => 'to', 666 => 'to_TO', 667 => 'tr_CY', 668 => 'tr_TR', 669 => 'tt', 670 => 'tt_RU', 671 => 'twq', 672 => 'twq_NE', 673 => 'tzm', 674 => 'tzm_MA', 675 => 'ug', 676 => 'ug_CN', 677 => 'uk', 678 => 'uk_UA', 679 => 'ur', 680 => 'ur_IN', 681 => 'ur_PK', 682 => 'uz', 683 => 'uz_Arab', 684 => 'uz_Arab_AF', 685 => 'uz_Cyrl', 686 => 'uz_Cyrl_UZ', 687 => 'uz_Latn', 688 => 'uz_Latn_UZ', 689 => 'vai', 690 => 'vai_Latn', 691 => 'vai_Latn_LR', 692 => 'vai_Vaii', 693 => 'vai_Vaii_LR', 694 => 'vi', 695 => 'vi_VN', 696 => 'vun', 697 => 'vun_TZ', 698 => 'wae', 699 => 'wae_CH', 700 => 'wo', 701 => 'wo_SN', 702 => 'xh', 703 => 'xh_ZA', 704 => 'xog', 705 => 'xog_UG', 706 => 'yav', 707 => 'yav_CM', 708 => 'yi', 709 => 'yi_001', 710 => 'yo', 711 => 'yo_BJ', 712 => 'yo_NG', 713 => 'yue', 714 => 'yue_Hans', 715 => 'yue_Hans_CN', 716 => 'yue_Hant', 717 => 'yue_Hant_HK', 718 => 'zgh', 719 => 'zgh_MA', 720 => 'zh', 721 => 'zh_Hans', 722 => 'zh_Hans_CN', 723 => 'zh_Hans_HK', 724 => 'zh_Hans_MO', 725 => 'zh_Hans_SG', 726 => 'zh_Hant', 727 => 'zh_Hant_HK', 728 => 'zh_Hant_MO', 729 => 'zh_Hant_TW', 730 => 'zu', 731 => 'zu_ZA'], $this->parameters['contao.locales'], [], [], 'en');
    }

    /*
     * Gets the public 'contao.resource_finder' shared service.
     *
     * @return \Contao\CoreBundle\Config\ResourceFinder
     */
    protected function getContao_ResourceFinderService()
    {
        return $this->services['contao.resource_finder'] = new \Contao\CoreBundle\Config\ResourceFinder($this->parameters['contao.resources_paths']);
    }

    /*
     * Gets the public 'contao.routing.nested_404_matcher' shared service.
     *
     * @return \Symfony\Cmf\Component\Routing\NestedMatcher\NestedMatcher
     */
    protected function getContao_Routing_Nested404MatcherService()
    {
        $a = ($this->privates['contao.routing.route_404_provider'] ?? $this->getContao_Routing_Route404ProviderService());

        if (isset($this->services['contao.routing.nested_404_matcher'])) {
            return $this->services['contao.routing.nested_404_matcher'];
        }

        $this->services['contao.routing.nested_404_matcher'] = $instance = new \Symfony\Cmf\Component\Routing\NestedMatcher\NestedMatcher($a, ($this->privates['contao.routing.url_matcher'] ?? ($this->privates['contao.routing.url_matcher'] = new \Contao\CoreBundle\Routing\Matcher\UrlMatcher())));

        $instance->addRouteFilter(($this->privates['contao.routing.matcher.domain_filter'] ?? ($this->privates['contao.routing.matcher.domain_filter'] = new \Contao\CoreBundle\Routing\Matcher\DomainFilter())));
        $instance->addRouteFilter(($this->privates['contao.routing.matcher.published_filter'] ?? $this->getContao_Routing_Matcher_PublishedFilterService()));

        return $instance;
    }

    /*
     * Gets the public 'contao.routing.nested_matcher' shared service.
     *
     * @return \Contao\CoreBundle\Routing\Matcher\LegacyMatcher
     */
    protected function getContao_Routing_NestedMatcherService()
    {
        $a = ($this->services['contao.framework'] ?? $this->getContao_FrameworkService());

        if (isset($this->services['contao.routing.nested_matcher'])) {
            return $this->services['contao.routing.nested_matcher'];
        }
        $b = ($this->privates['contao.routing.route_provider'] ?? $this->getContao_Routing_RouteProviderService());

        if (isset($this->services['contao.routing.nested_matcher'])) {
            return $this->services['contao.routing.nested_matcher'];
        }
        $c = ($this->privates['contao.routing.matcher.published_filter'] ?? $this->getContao_Routing_Matcher_PublishedFilterService());

        if (isset($this->services['contao.routing.nested_matcher'])) {
            return $this->services['contao.routing.nested_matcher'];
        }
        $d = new \Symfony\Cmf\Component\Routing\NestedMatcher\NestedMatcher($b, ($this->privates['contao.routing.url_matcher'] ?? ($this->privates['contao.routing.url_matcher'] = new \Contao\CoreBundle\Routing\Matcher\UrlMatcher())));
        $d->addRouteFilter(($this->privates['contao.routing.matcher.domain_filter'] ?? ($this->privates['contao.routing.matcher.domain_filter'] = new \Contao\CoreBundle\Routing\Matcher\DomainFilter())));
        $d->addRouteFilter($c);
        $d->addRouteFilter(new \Contao\CoreBundle\Routing\Matcher\LanguageFilter());

        return $this->services['contao.routing.nested_matcher'] = new \Contao\CoreBundle\Routing\Matcher\LegacyMatcher($a, $d, '.html', false);
    }

    /*
     * Gets the public 'contao.routing.page_registry' shared service.
     *
     * @return \Contao\CoreBundle\Routing\Page\PageRegistry
     */
    protected function getContao_Routing_PageRegistryService()
    {
        $a = ($this->services['doctrine.dbal.default_connection'] ?? $this->getDoctrine_Dbal_DefaultConnectionService());

        if (isset($this->services['contao.routing.page_registry'])) {
            return $this->services['contao.routing.page_registry'];
        }

        $this->services['contao.routing.page_registry'] = $instance = new \Contao\CoreBundle\Routing\Page\PageRegistry($a);

        $b = ($this->services['Contao\\CoreBundle\\Controller\\Page\\ErrorPageController'] ?? $this->getErrorPageControllerService());

        $instance->add('error_401', new \Contao\CoreBundle\Routing\Page\RouteConfig(false, NULL, NULL, [], [], ['_controller' => 'Contao\\CoreBundle\\Controller\\Page\\ErrorPageController'], []), NULL, $b);
        $instance->add('error_403', new \Contao\CoreBundle\Routing\Page\RouteConfig(false, NULL, NULL, [], [], ['_controller' => 'Contao\\CoreBundle\\Controller\\Page\\ErrorPageController'], []), NULL, $b);
        $instance->add('error_404', new \Contao\CoreBundle\Routing\Page\RouteConfig(false, NULL, NULL, [], [], ['_controller' => 'Contao\\CoreBundle\\Controller\\Page\\ErrorPageController'], []), NULL, $b);
        $instance->add('error_503', new \Contao\CoreBundle\Routing\Page\RouteConfig(false, NULL, NULL, [], [], ['_controller' => 'Contao\\CoreBundle\\Controller\\Page\\ErrorPageController'], []), NULL, $b);
        $instance->add('root', new \Contao\CoreBundle\Routing\Page\RouteConfig(NULL, NULL, NULL, [], [], ['_controller' => 'Contao\\CoreBundle\\Controller\\Page\\RootPageController'], []), NULL, false);

        return $instance;
    }

    /*
     * Gets the public 'contao.routing.scope_matcher' shared service.
     *
     * @return \Contao\CoreBundle\Routing\ScopeMatcher
     */
    protected function getContao_Routing_ScopeMatcherService()
    {
        return $this->services['contao.routing.scope_matcher'] = new \Contao\CoreBundle\Routing\ScopeMatcher(($this->privates['contao.routing.backend_matcher'] ?? $this->getContao_Routing_BackendMatcherService()), ($this->privates['contao.routing.frontend_matcher'] ?? $this->getContao_Routing_FrontendMatcherService()));
    }

    /*
     * Gets the public 'contao.security.token_checker' shared service.
     *
     * @return \Contao\CoreBundle\Security\Authentication\Token\TokenChecker
     */
    protected function getContao_Security_TokenCheckerService()
    {
        $a = ($this->services['security.firewall.map'] ?? $this->getSecurity_Firewall_MapService());

        if (isset($this->services['contao.security.token_checker'])) {
            return $this->services['contao.security.token_checker'];
        }
        $b = ($this->services['doctrine.dbal.default_connection'] ?? $this->getDoctrine_Dbal_DefaultConnectionService());

        if (isset($this->services['contao.security.token_checker'])) {
            return $this->services['contao.security.token_checker'];
        }

        return $this->services['contao.security.token_checker'] = new \Contao\CoreBundle\Security\Authentication\Token\TokenChecker(($this->services['request_stack'] ?? ($this->services['request_stack'] = new \Symfony\Component\HttpFoundation\RequestStack())), $a, ($this->services['.container.private.security.token_storage'] ?? $this->get_Container_Private_Security_TokenStorageService()), ($this->services['.container.private.session'] ?? $this->get_Container_Private_SessionService()), ($this->services['security.authentication.trust_resolver'] ?? $this->getSecurity_Authentication_TrustResolverService()), ($this->privates['security.access.simple_role_voter'] ?? ($this->privates['security.access.simple_role_voter'] = new \Symfony\Component\Security\Core\Authorization\Voter\RoleVoter())), $b);
    }

    /*
     * Gets the public 'contao.twig.extension' shared service.
     *
     * @return \Contao\CoreBundle\Twig\Extension\ContaoExtension
     */
    protected function getContao_Twig_ExtensionService()
    {
        $a = ($this->services['.container.private.twig'] ?? $this->get_Container_Private_TwigService());

        if (isset($this->services['contao.twig.extension'])) {
            return $this->services['contao.twig.extension'];
        }
        $b = ($this->services['contao.twig.filesystem_loader'] ?? $this->getContao_Twig_FilesystemLoaderService());

        if (isset($this->services['contao.twig.extension'])) {
            return $this->services['contao.twig.extension'];
        }

        return $this->services['contao.twig.extension'] = new \Contao\CoreBundle\Twig\Extension\ContaoExtension($a, $b);
    }

    /*
     * Gets the public 'contao.twig.filesystem_loader' shared service.
     *
     * @return \Contao\CoreBundle\Twig\Loader\ContaoFilesystemLoader
     */
    protected function getContao_Twig_FilesystemLoaderService()
    {
        $a = ($this->services['doctrine.dbal.default_connection'] ?? $this->getDoctrine_Dbal_DefaultConnectionService());

        if (isset($this->services['contao.twig.filesystem_loader'])) {
            return $this->services['contao.twig.filesystem_loader'];
        }
        $b = ($this->privates['contao.twig.loader.theme_namespace'] ?? ($this->privates['contao.twig.loader.theme_namespace'] = new \Contao\CoreBundle\Twig\Loader\ThemeNamespace()));

        return $this->services['contao.twig.filesystem_loader'] = new \Contao\CoreBundle\Twig\Loader\ContaoFilesystemLoader(($this->services['cache.system'] ?? $this->getCache_SystemService()), new \Contao\CoreBundle\Twig\Loader\TemplateLocator(\dirname(__DIR__, 4), $this->parameters['kernel.bundles'], $this->parameters['kernel.bundles_metadata'], $b, $a), $b, \dirname(__DIR__, 4));
    }

    /*
     * Gets the public 'debug.stopwatch' shared service.
     *
     * @return \Symfony\Component\Stopwatch\Stopwatch
     */
    protected function getDebug_StopwatchService()
    {
        return $this->services['debug.stopwatch'] = new \Symfony\Component\Stopwatch\Stopwatch(true);
    }

    /*
     * Gets the public 'doctrine.dbal.default_connection' shared service.
     *
     * @return \Doctrine\DBAL\Connection
     */
    protected function getDoctrine_Dbal_DefaultConnectionService()
    {
        $a = ($this->privates['doctrine.dbal.default_connection.event_manager'] ?? $this->getDoctrine_Dbal_DefaultConnection_EventManagerService());

        if (isset($this->services['doctrine.dbal.default_connection'])) {
            return $this->services['doctrine.dbal.default_connection'];
        }
        $b = new \Doctrine\DBAL\Configuration();
        $b->setSchemaManagerFactory(new \Doctrine\DBAL\Schema\LegacySchemaManagerFactory());
        $b->setMiddlewares([]);

        return $this->services['doctrine.dbal.default_connection'] = (new \Doctrine\Bundle\DoctrineBundle\ConnectionFactory($this->parameters['doctrine.dbal.connection_factory.types'], new \Doctrine\DBAL\Tools\DsnParser(['db2' => 'ibm_db2', 'mssql' => 'pdo_sqlsrv', 'mysql' => 'pdo_mysql', 'mysql2' => 'pdo_mysql', 'postgres' => 'pdo_pgsql', 'postgresql' => 'pdo_pgsql', 'pgsql' => 'pdo_pgsql', 'sqlite' => 'pdo_sqlite', 'sqlite3' => 'pdo_sqlite'])))->createConnection(['driver' => 'pdo_mysql', 'url' => $this->getEnv('DATABASE_URL'), 'charset' => 'utf8mb4', 'host' => 'localhost', 'port' => NULL, 'user' => 'root', 'password' => NULL, 'driverOptions' => [1002 => 'SET SESSION sql_mode=(SELECT CONCAT(@@sql_mode, \',TRADITIONAL\'))', 1013 => false], 'defaultTableOptions' => ['charset' => 'utf8mb4', 'collation' => 'utf8mb4_unicode_ci', 'engine' => 'InnoDB', 'row_format' => 'DYNAMIC', 'collate' => 'utf8mb4_unicode_ci']], $b, $a, []);
    }

    /*
     * Gets the public 'event_dispatcher' shared service.
     *
     * @return \Symfony\Component\EventDispatcher\EventDispatcher
     */
    protected function getEventDispatcherService()
    {
        $this->services['event_dispatcher'] = $instance = new \Symfony\Component\EventDispatcher\EventDispatcher();

        $instance->addListener('kernel.request', [0 => function () {
            return ($this->privates['nelmio_cors.cors_listener'] ?? $this->getNelmioCors_CorsListenerService());
        }, 1 => 'onKernelRequest'], 250);
        $instance->addListener('kernel.response', [0 => function () {
            return ($this->privates['nelmio_cors.cors_listener'] ?? $this->getNelmioCors_CorsListenerService());
        }, 1 => 'onKernelResponse'], 0);
        $instance->addListener('kernel.response', [0 => function () {
            return ($this->privates['nelmio_cors.cacheable_response_vary_listener'] ?? ($this->privates['nelmio_cors.cacheable_response_vary_listener'] = new \Nelmio\CorsBundle\EventListener\CacheableResponseVaryListener()));
        }, 1 => 'onResponse'], -10);
        $instance->addListener('kernel.response', [0 => function () {
            return ($this->privates['nelmio_security.content_type_listener'] ?? ($this->privates['nelmio_security.content_type_listener'] = new \Nelmio\SecurityBundle\EventListener\ContentTypeListener(true)));
        }, 1 => 'onKernelResponse'], 0);
        $instance->addListener('kernel.response', [0 => function () {
            return ($this->privates['nelmio_security.referrer_policy_listener'] ?? $this->getNelmioSecurity_ReferrerPolicyListenerService());
        }, 1 => 'onKernelResponse'], 0);
        $instance->addListener('kernel.request', [0 => function () {
            return ($this->privates['contao.listener.backend_locale'] ?? $this->getContao_Listener_BackendLocaleService());
        }, 1 => '__invoke'], 7);
        $instance->addListener('kernel.response', [0 => function () {
            return ($this->privates['contao.listener.backend_noindex'] ?? $this->getContao_Listener_BackendNoindexService());
        }, 1 => '__invoke'], 0);
        $instance->addListener('kernel.request', [0 => function () {
            return ($this->privates['contao.listener.backend_preview_redirect'] ?? $this->getContao_Listener_BackendPreviewRedirectService());
        }, 1 => '__invoke'], 0);
        $instance->addListener('kernel.request', [0 => function () {
            return ($this->privates['contao.listener.backend_rebuild_cache_message'] ?? $this->getContao_Listener_BackendRebuildCacheMessageService());
        }, 1 => '__invoke'], 0);
        $instance->addListener('kernel.response', [0 => function () {
            return ($this->privates['contao.listener.clear_session_data'] ?? ($this->privates['contao.listener.clear_session_data'] = new \Contao\CoreBundle\EventListener\ClearSessionDataListener()));
        }, 1 => '__invoke'], -768);
        $instance->addListener('kernel.terminate', [0 => function () {
            return ($this->privates['contao.listener.command_scheduler'] ?? $this->load('getContao_Listener_CommandSchedulerService'));
        }, 1 => '__invoke'], 0);
        $instance->addListener('kernel.exception', [0 => function () {
            return ($this->privates['contao.listener.exception_converter'] ?? ($this->privates['contao.listener.exception_converter'] = new \Contao\CoreBundle\EventListener\ExceptionConverterListener()));
        }, 1 => '__invoke'], 96);
        $instance->addListener('Contao\\CoreBundle\\Event\\FilterPageTypeEvent', [0 => function () {
            return ($this->privates['contao.listener.filter_page_type'] ?? $this->load('getContao_Listener_FilterPageTypeService'));
        }, 1 => '__invoke'], 0);
        $instance->addListener('kernel.response', [0 => function () {
            return ($this->privates['contao.listener.initialize_controller'] ?? ($this->privates['contao.listener.initialize_controller'] = new \Contao\CoreBundle\EventListener\InitializeControllerListener()));
        }, 1 => '__invoke'], 1000);
        $instance->addListener('kernel.request', [0 => function () {
            return ($this->privates['contao.listener.insecure_installation'] ?? ($this->privates['contao.listener.insecure_installation'] = new \Contao\CoreBundle\EventListener\InsecureInstallationListener($this->getEnv('APP_SECRET'), (\dirname(__DIR__, 4).'/public'))));
        }, 1 => '__invoke'], 0);
        $instance->addListener('kernel.response', [0 => function () {
            return ($this->privates['contao.listener.interest_cohort'] ?? $this->getContao_Listener_InterestCohortService());
        }, 1 => '__invoke'], 0);
        $instance->addListener('Contao\\CoreBundle\\Event\\JsonLdEvent', [0 => function () {
            return ($this->privates['contao.listener.json_ld_schema'] ?? ($this->privates['contao.listener.json_ld_schema'] = new \Contao\CoreBundle\EventListener\ContaoJsonLdSchemaListener()));
        }, 1 => '__invoke'], 0);
        $instance->addListener('kernel.request', [0 => function () {
            return ($this->privates['contao.listener.legacy_login_constants'] ?? $this->getContao_Listener_LegacyLoginConstantsService());
        }, 1 => '__invoke'], 7);
        $instance->addListener('kernel.exception', [0 => function () {
            return ($this->privates['contao.listener.legacy_login_constants'] ?? $this->getContao_Listener_LegacyLoginConstantsService());
        }, 1 => '__invoke'], 96);
        $instance->addListener('kernel.response', [0 => function () {
            return ($this->privates['contao.listener.make_response_private'] ?? $this->getContao_Listener_MakeResponsePrivateService());
        }, 1 => 'disableSymfonyAutoCacheControl'], -896);
        $instance->addListener('kernel.response', [0 => function () {
            return ($this->privates['contao.listener.make_response_private'] ?? $this->getContao_Listener_MakeResponsePrivateService());
        }, 1 => 'makeResponsePrivate'], -1012);
        $instance->addListener('contao.backend_menu_build', [0 => function () {
            return ($this->privates['contao.listener.menu.backend'] ?? $this->load('getContao_Listener_Menu_BackendService'));
        }, 1 => '__invoke'], 10);
        $instance->addListener('contao.backend_menu_build', [0 => function () {
            return ($this->privates['contao.listener.menu.backend_logout'] ?? $this->load('getContao_Listener_Menu_BackendLogoutService'));
        }, 1 => '__invoke'], 0);
        $instance->addListener('contao.backend_menu_build', [0 => function () {
            return ($this->privates['contao.listener.menu.backend_preview'] ?? $this->load('getContao_Listener_Menu_BackendPreviewService'));
        }, 1 => '__invoke'], 0);
        $instance->addListener('kernel.response', [0 => function () {
            return ($this->privates['contao.listener.merge_http_headers'] ?? $this->getContao_Listener_MergeHttpHeadersService());
        }, 1 => '__invoke'], 256);
        $instance->addListener('kernel.response', [0 => function () {
            return ($this->privates['contao.listener.page_trail_cache_tags'] ?? $this->getContao_Listener_PageTrailCacheTagsService());
        }, 1 => '__invoke'], 0);
        $instance->addListener('kernel.exception', [0 => function () {
            return ($this->privates['contao.listener.pretty_error_screen'] ?? $this->load('getContao_Listener_PrettyErrorScreenService'));
        }, 1 => '__invoke'], -96);
        $instance->addListener('kernel.request', [0 => function () {
            return ($this->privates['contao.listener.preview_authentication'] ?? $this->getContao_Listener_PreviewAuthenticationService());
        }, 1 => '__invoke'], 7);
        $instance->addListener('kernel.response', [0 => function () {
            return ($this->privates['contao.listener.preview_toolbar'] ?? $this->getContao_Listener_PreviewToolbarService());
        }, 1 => '__invoke'], 0);
        $instance->addListener('contao.preview_url_convert', [0 => function () {
            return ($this->privates['contao.listener.preview_url_convert'] ?? $this->load('getContao_Listener_PreviewUrlConvertService'));
        }, 1 => '__invoke'], 0);
        $instance->addListener('contao.preview_url_create', [0 => function () {
            return ($this->privates['contao.listener.preview_url_create'] ?? $this->load('getContao_Listener_PreviewUrlCreateService'));
        }, 1 => '__invoke'], 0);
        $instance->addListener('kernel.request', [0 => function () {
            return ($this->privates['contao.listener.referer_id'] ?? $this->getContao_Listener_RefererIdService());
        }, 1 => '__invoke'], 20);
        $instance->addListener('kernel.request', [0 => function () {
            return ($this->privates['contao.listener.request_token'] ?? $this->getContao_Listener_RequestTokenService());
        }, 1 => '__invoke'], 14);
        $instance->addListener('kernel.exception', [0 => function () {
            return ($this->privates['contao.listener.response_exception'] ?? ($this->privates['contao.listener.response_exception'] = new \Contao\CoreBundle\EventListener\ResponseExceptionListener()));
        }, 1 => '__invoke'], 64);
        $instance->addListener('contao.robots_txt', [0 => function () {
            return ($this->privates['contao.listener.robots_txt'] ?? $this->load('getContao_Listener_RobotsTxtService'));
        }, 1 => '__invoke'], 0);
        $instance->addListener('kernel.terminate', [0 => function () {
            return ($this->privates['contao.listener.search_index'] ?? $this->load('getContao_Listener_SearchIndexService'));
        }, 1 => '__invoke'], 0);
        $instance->addListener('Symfony\\Component\\Security\\Http\\Event\\LogoutEvent', [0 => function () {
            return ($this->privates['contao.listener.security.logout_success'] ?? $this->load('getContao_Listener_Security_LogoutSuccessService'));
        }, 1 => '__invoke'], 0);
        $instance->addListener('security.switch_user', [0 => function () {
            return ($this->privates['contao.listener.security.switch_user'] ?? $this->load('getContao_Listener_Security_SwitchUserService'));
        }, 1 => '__invoke'], 0);
        $instance->addListener('kernel.request', [0 => function () {
            return ($this->privates['contao.listener.security.two_factor_frontend'] ?? $this->getContao_Listener_Security_TwoFactorFrontendService());
        }, 1 => '__invoke'], 0);
        $instance->addListener('kernel.request', [0 => function () {
            return ($this->privates['contao.listener.service_unavailable'] ?? $this->getContao_Listener_ServiceUnavailableService());
        }, 1 => '__invoke'], 6);
        $instance->addListener('kernel.response', [0 => function () {
            return ($this->privates['contao.listener.store_referer'] ?? $this->getContao_Listener_StoreRefererService());
        }, 1 => '__invoke'], 0);
        $instance->addListener('kernel.request', [0 => function () {
            return ($this->privates['contao.listener.user_session'] ?? $this->getContao_Listener_UserSessionService());
        }, 1 => '__invoke'], 0);
        $instance->addListener('kernel.request', [0 => function () {
            return ($this->privates['contao.twig.loader.auto_refresh_template_hierarchy_listener'] ?? $this->getContao_Twig_Loader_AutoRefreshTemplateHierarchyListenerService());
        }, 1 => '__invoke'], 0);
        $instance->addListener('contao.backend_menu_build', [0 => function () {
            return ($this->privates['contao_manager.listener.backend_menu'] ?? $this->load('getContaoManager_Listener_BackendMenuService'));
        }, 1 => '__invoke'], 0);
        $instance->addListener('contao_installation.initialize_application', [0 => function () {
            return ($this->privates['contao_manager.listener.initialize_application'] ?? ($this->privates['contao_manager.listener.initialize_application'] = new \Contao\ManagerBundle\EventListener\InitializeApplicationListener(\dirname(__DIR__, 4))));
        }, 1 => '__invoke'], -128);
        $instance->addListener('console.terminate', [0 => function () {
            return ($this->privates['contao_manager.listener.install_command'] ?? ($this->privates['contao_manager.listener.install_command'] = new \Contao\ManagerBundle\EventListener\InstallCommandListener(\dirname(__DIR__, 4))));
        }, 1 => '__invoke'], 0);
        $instance->addListener('dc-general.factory.build-data-definition', [0 => function () {
            return ($this->privates['MenAtWork\\MultiColumnWizardBundle\\EventListener\\DcGeneral\\UpdateDataDefinition'] ?? ($this->privates['MenAtWork\\MultiColumnWizardBundle\\EventListener\\DcGeneral\\UpdateDataDefinition'] = new \MenAtWork\MultiColumnWizardBundle\EventListener\DcGeneral\UpdateDataDefinition()));
        }, 1 => 'addMcwFields'], -5000);
        $instance->addListener('men-at-work.multi-column-wizard-bundle.get-options', [0 => function () {
            return ($this->privates['MenAtWork\\MultiColumnWizardBundle\\EventListener\\Mcw\\GetOptionsBridge'] ?? $this->load('getGetOptionsBridgeService'));
        }, 1 => 'executeEvent'], 0);
        $instance->addListener('men-at-work.multi-column-wizard-bundle.get-tiny-mce', [0 => function () {
            return ($this->privates['MenAtWork\\MultiColumnWizardBundle\\EventListener\\Mcw\\TinyMce'] ?? ($this->privates['MenAtWork\\MultiColumnWizardBundle\\EventListener\\Mcw\\TinyMce'] = new \MenAtWork\MultiColumnWizardBundle\EventListener\Mcw\TinyMce()));
        }, 1 => 'executeEvent'], 0);
        $instance->addListener('men-at-work.multi-column-wizard-bundle.get-date-picker', [0 => function () {
            return ($this->privates['MenAtWork\\MultiColumnWizardBundle\\EventListener\\Mcw\\DatePicker'] ?? ($this->privates['MenAtWork\\MultiColumnWizardBundle\\EventListener\\Mcw\\DatePicker'] = new \MenAtWork\MultiColumnWizardBundle\EventListener\Mcw\DatePicker()));
        }, 1 => 'executeEvent'], 0);
        $instance->addListener('men-at-work.multi-column-wizard-bundle.get-color-picker', [0 => function () {
            return ($this->privates['MenAtWork\\MultiColumnWizardBundle\\EventListener\\Mcw\\ColorPicker'] ?? $this->load('getColorPickerService'));
        }, 1 => 'executeEvent'], 0);
        $instance->addListener('men-at-work.multi-column-wizard-bundle.get-dca-picker-wizard', [0 => function () {
            return ($this->privates['MenAtWork\\MultiColumnWizardBundle\\EventListener\\Mcw\\DcaPickerWizard'] ?? ($this->privates['MenAtWork\\MultiColumnWizardBundle\\EventListener\\Mcw\\DcaPickerWizard'] = new \MenAtWork\MultiColumnWizardBundle\EventListener\Mcw\DcaPickerWizard()));
        }, 1 => 'executeEvent'], 0);
        $instance->addListener('men-at-work.multi-column-wizard-bundle.create-widget', [0 => function () {
            return ($this->privates['MenAtWork\\MultiColumnWizardBundle\\EventListener\\Mcw\\CreateWidget'] ?? ($this->privates['MenAtWork\\MultiColumnWizardBundle\\EventListener\\Mcw\\CreateWidget'] = new \MenAtWork\MultiColumnWizardBundle\EventListener\Mcw\CreateWidget()));
        }, 1 => 'createWidgetContao'], 0);
        $instance->addListener('men-at-work.multi-column-wizard-bundle.create-widget', [0 => function () {
            return ($this->privates['MenAtWork\\MultiColumnWizardBundle\\EventListener\\Mcw\\CreateWidget'] ?? ($this->privates['MenAtWork\\MultiColumnWizardBundle\\EventListener\\Mcw\\CreateWidget'] = new \MenAtWork\MultiColumnWizardBundle\EventListener\Mcw\CreateWidget()));
        }, 1 => 'createWidgetDcGeneral'], 0);
        $instance->addListener('contao_installation.initialize_application', [0 => function () {
            return ($this->privates['contao_installation.listener.initialize_application'] ?? $this->load('getContaoInstallation_Listener_InitializeApplicationService'));
        }, 1 => '__invoke'], 0);
        $instance->addListener('contao.preview_url_convert', [0 => function () {
            return ($this->privates['contao_news.listener.preview_url_convert'] ?? $this->load('getContaoNews_Listener_PreviewUrlConvertService'));
        }, 1 => '__invoke'], 0);
        $instance->addListener('contao.preview_url_create', [0 => function () {
            return ($this->privates['contao_news.listener.preview_url_create'] ?? $this->load('getContaoNews_Listener_PreviewUrlCreateService'));
        }, 1 => '__invoke'], 0);
        $instance->addListener('contao.preview_url_convert', [0 => function () {
            return ($this->privates['contao_calendar.listener.preview_url_convert'] ?? $this->load('getContaoCalendar_Listener_PreviewUrlConvertService'));
        }, 1 => '__invoke'], 0);
        $instance->addListener('contao.preview_url_create', [0 => function () {
            return ($this->privates['contao_calendar.listener.preview_url_create'] ?? $this->load('getContaoCalendar_Listener_PreviewUrlCreateService'));
        }, 1 => '__invoke'], 0);
        $instance->addListener('kernel.response', [0 => function () {
            return ($this->privates['response_listener'] ?? ($this->privates['response_listener'] = new \Symfony\Component\HttpKernel\EventListener\ResponseListener('UTF-8', false)));
        }, 1 => 'onKernelResponse'], 0);
        $instance->addListener('kernel.response', [0 => function () {
            return ($this->privates['streamed_response_listener'] ?? ($this->privates['streamed_response_listener'] = new \Symfony\Component\HttpKernel\EventListener\StreamedResponseListener()));
        }, 1 => 'onKernelResponse'], -1024);
        $instance->addListener('kernel.request', [0 => function () {
            return ($this->privates['locale_listener'] ?? $this->getLocaleListenerService());
        }, 1 => 'setDefaultLocale'], 100);
        $instance->addListener('kernel.request', [0 => function () {
            return ($this->privates['locale_listener'] ?? $this->getLocaleListenerService());
        }, 1 => 'onKernelRequest'], 16);
        $instance->addListener('kernel.finish_request', [0 => function () {
            return ($this->privates['locale_listener'] ?? $this->getLocaleListenerService());
        }, 1 => 'onKernelFinishRequest'], 0);
        $instance->addListener('kernel.request', [0 => function () {
            return ($this->privates['validate_request_listener'] ?? ($this->privates['validate_request_listener'] = new \Symfony\Component\HttpKernel\EventListener\ValidateRequestListener()));
        }, 1 => 'onKernelRequest'], 256);
        $instance->addListener('kernel.controller_arguments', [0 => function () {
            return ($this->privates['exception_listener'] ?? $this->getExceptionListenerService());
        }, 1 => 'onControllerArguments'], 0);
        $instance->addListener('kernel.exception', [0 => function () {
            return ($this->privates['exception_listener'] ?? $this->getExceptionListenerService());
        }, 1 => 'logKernelException'], 0);
        $instance->addListener('kernel.exception', [0 => function () {
            return ($this->privates['exception_listener'] ?? $this->getExceptionListenerService());
        }, 1 => 'onKernelException'], -128);
        $instance->addListener('kernel.response', [0 => function () {
            return ($this->privates['exception_listener'] ?? $this->getExceptionListenerService());
        }, 1 => 'removeCspHeader'], -128);
        $instance->addListener('kernel.request', [0 => function () {
            return ($this->privates['locale_aware_listener'] ?? $this->getLocaleAwareListenerService());
        }, 1 => 'onKernelRequest'], 15);
        $instance->addListener('kernel.finish_request', [0 => function () {
            return ($this->privates['locale_aware_listener'] ?? $this->getLocaleAwareListenerService());
        }, 1 => 'onKernelFinishRequest'], -15);
        $instance->addListener('console.error', [0 => function () {
            return ($this->privates['console.error_listener'] ?? $this->load('getConsole_ErrorListenerService'));
        }, 1 => 'onConsoleError'], -128);
        $instance->addListener('console.terminate', [0 => function () {
            return ($this->privates['console.error_listener'] ?? $this->load('getConsole_ErrorListenerService'));
        }, 1 => 'onConsoleTerminate'], -128);
        $instance->addListener('console.error', [0 => function () {
            return ($this->privates['console.suggest_missing_package_subscriber'] ?? ($this->privates['console.suggest_missing_package_subscriber'] = new \Symfony\Bundle\FrameworkBundle\EventListener\SuggestMissingPackageSubscriber()));
        }, 1 => 'onConsoleError'], 0);
        $instance->addListener('Symfony\\Component\\Mailer\\Event\\MessageEvent', [0 => function () {
            return ($this->privates['mailer.envelope_listener'] ?? ($this->privates['mailer.envelope_listener'] = new \Symfony\Component\Mailer\EventListener\EnvelopeListener(NULL, NULL)));
        }, 1 => 'onMessage'], -255);
        $instance->addListener('Symfony\\Component\\Mailer\\Event\\MessageEvent', [0 => function () {
            return ($this->privates['mailer.message_logger_listener'] ?? ($this->privates['mailer.message_logger_listener'] = new \Symfony\Component\Mailer\EventListener\MessageLoggerListener()));
        }, 1 => 'onMessage'], -255);
        $instance->addListener('kernel.response', [0 => function () {
            return ($this->privates['esi_listener'] ?? $this->getEsiListenerService());
        }, 1 => 'onKernelResponse'], 0);
        $instance->addListener('kernel.request', [0 => function () {
            return ($this->privates['fragment.listener'] ?? $this->getFragment_ListenerService());
        }, 1 => 'onKernelRequest'], 48);
        $instance->addListener('kernel.request', [0 => function () {
            return ($this->privates['debug.debug_handlers_listener'] ?? $this->getDebug_DebugHandlersListenerService());
        }, 1 => 'configure'], 2048);
        $instance->addListener('console.command', [0 => function () {
            return ($this->privates['debug.debug_handlers_listener'] ?? $this->getDebug_DebugHandlersListenerService());
        }, 1 => 'configure'], 2048);
        $instance->addListener('kernel.request', [0 => function () {
            return ($this->privates['router_listener'] ?? $this->getRouterListenerService());
        }, 1 => 'onKernelRequest'], 32);
        $instance->addListener('kernel.finish_request', [0 => function () {
            return ($this->privates['router_listener'] ?? $this->getRouterListenerService());
        }, 1 => 'onKernelFinishRequest'], 0);
        $instance->addListener('kernel.exception', [0 => function () {
            return ($this->privates['router_listener'] ?? $this->getRouterListenerService());
        }, 1 => 'onKernelException'], -64);
        $instance->addListener('kernel.request', [0 => function () {
            return ($this->privates['session_listener'] ?? $this->getSessionListenerService());
        }, 1 => 'onKernelRequest'], 128);
        $instance->addListener('kernel.response', [0 => function () {
            return ($this->privates['session_listener'] ?? $this->getSessionListenerService());
        }, 1 => 'onKernelResponse'], -1000);
        $instance->addListener('kernel.finish_request', [0 => function () {
            return ($this->privates['session_listener'] ?? $this->getSessionListenerService());
        }, 1 => 'onFinishRequest'], 0);
        $instance->addListener('console.command', [0 => function () {
            return ($this->privates['monolog.handler.console'] ?? $this->getMonolog_Handler_ConsoleService());
        }, 1 => 'onCommand'], 255);
        $instance->addListener('console.terminate', [0 => function () {
            return ($this->privates['monolog.handler.console'] ?? $this->getMonolog_Handler_ConsoleService());
        }, 1 => 'onTerminate'], -255);
        $instance->addListener('fos_http_cache.error.proxy_unreachable', [0 => function () {
            return ($this->privates['fos_http_cache.event_listener.log'] ?? $this->load('getFosHttpCache_EventListener_LogService'));
        }, 1 => 'onProxyUnreachableError'], 0);
        $instance->addListener('fos_http_cache.error.response', [0 => function () {
            return ($this->privates['fos_http_cache.event_listener.log'] ?? $this->load('getFosHttpCache_EventListener_LogService'));
        }, 1 => 'onProxyResponseError'], 0);
        $instance->addListener('kernel.response', [0 => function () {
            return ($this->privates['fos_http_cache.event_listener.tag'] ?? $this->getFosHttpCache_EventListener_TagService());
        }, 1 => 'onKernelResponse'], 0);
        $instance->addListener('kernel.terminate', [0 => function () {
            return ($this->privates['fos_http_cache.event_listener.invalidation'] ?? $this->load('getFosHttpCache_EventListener_InvalidationService'));
        }, 1 => 'onKernelTerminate'], 0);
        $instance->addListener('kernel.exception', [0 => function () {
            return ($this->privates['fos_http_cache.event_listener.invalidation'] ?? $this->load('getFosHttpCache_EventListener_InvalidationService'));
        }, 1 => 'onKernelException'], 0);
        $instance->addListener('console.terminate', [0 => function () {
            return ($this->privates['fos_http_cache.event_listener.invalidation'] ?? $this->load('getFosHttpCache_EventListener_InvalidationService'));
        }, 1 => 'onConsoleTerminate'], 0);
        $instance->addListener('kernel.response', [0 => function () {
            return ($this->privates['nelmio_security.clickjacking_listener'] ?? $this->getNelmioSecurity_ClickjackingListenerService());
        }, 1 => 'onKernelResponse'], 0);
        $instance->addListener('kernel.request', [0 => function () {
            return ($this->privates['nelmio_security.csp_listener'] ?? $this->getNelmioSecurity_CspListenerService());
        }, 1 => 'onKernelRequest'], 512);
        $instance->addListener('kernel.response', [0 => function () {
            return ($this->privates['nelmio_security.csp_listener'] ?? $this->getNelmioSecurity_CspListenerService());
        }, 1 => 'onKernelResponse'], 0);
        $instance->addListener('kernel.response', [0 => function () {
            return ($this->privates['nelmio_security.xss_protection_listener'] ?? $this->getNelmioSecurity_XssProtectionListenerService());
        }, 1 => 'onKernelResponse'], 0);
        $instance->addListener('security.authentication.success', [0 => function () {
            return ($this->privates['scheb_two_factor.security.authentication_success_event_suppressor'] ?? ($this->privates['scheb_two_factor.security.authentication_success_event_suppressor'] = new \Scheb\TwoFactorBundle\Security\TwoFactor\Event\AuthenticationSuccessEventSuppressor()));
        }, 1 => 'onLogin'], 9223372036854775806);
        $instance->addListener('Symfony\\Component\\Security\\Http\\Event\\CheckPassportEvent', [0 => function () {
            return ($this->privates['scheb_two_factor.security.listener.check_two_factor_code'] ?? $this->load('getSchebTwoFactor_Security_Listener_CheckTwoFactorCodeService'));
        }, 1 => 'checkPassport'], 0);
        $instance->addListener('Symfony\\Component\\Security\\Http\\Event\\LoginSuccessEvent', [0 => function () {
            return ($this->privates['scheb_two_factor.security.listener.suppress_remember_me'] ?? ($this->privates['scheb_two_factor.security.listener.suppress_remember_me'] = new \Scheb\TwoFactorBundle\Security\Http\EventListener\SuppressRememberMeListener()));
        }, 1 => 'onSuccessfulLogin'], -63);
        $instance->addListener('kernel.response', [0 => function () {
            return ($this->privates['scheb_two_factor.trusted_cookie_response_listener'] ?? $this->getSchebTwoFactor_TrustedCookieResponseListenerService());
        }, 1 => 'onKernelResponse'], 0);
        $instance->addListener('Symfony\\Component\\Security\\Http\\Event\\LoginSuccessEvent', [0 => function () {
            return ($this->privates['scheb_two_factor.security.listener.trusted_device'] ?? $this->load('getSchebTwoFactor_Security_Listener_TrustedDeviceService'));
        }, 1 => 'onSuccessfulLogin'], 0);
        $instance->addListener('Symfony\\Component\\Security\\Http\\Event\\CheckPassportEvent', [0 => function () {
            return ($this->privates['scheb_two_factor.security.listener.check_backup_code'] ?? $this->load('getSchebTwoFactor_Security_Listener_CheckBackupCodeService'));
        }, 1 => 'checkPassport'], 16);
        $instance->addListener('Symfony\\Component\\Mailer\\Event\\MessageEvent', [0 => function () {
            return ($this->privates['twig.mailer.message_listener'] ?? $this->load('getTwig_Mailer_MessageListenerService'));
        }, 1 => 'onMessage'], 0);
        $instance->addListener('kernel.request', [0 => function () {
            return ($this->privates['security.firewall'] ?? $this->getSecurity_FirewallService());
        }, 1 => 'configureLogoutUrlGenerator'], 8);
        $instance->addListener('kernel.request', [0 => function () {
            return ($this->privates['security.firewall'] ?? $this->getSecurity_FirewallService());
        }, 1 => 'onKernelRequest'], 8);
        $instance->addListener('kernel.finish_request', [0 => function () {
            return ($this->privates['security.firewall'] ?? $this->getSecurity_FirewallService());
        }, 1 => 'onKernelFinishRequest'], 0);
        $instance->addListener('kernel.response', [0 => function () {
            return ($this->privates['security.rememberme.response_listener'] ?? ($this->privates['security.rememberme.response_listener'] = new \Symfony\Component\Security\Http\RememberMe\ResponseListener()));
        }, 1 => 'onKernelResponse'], 0);
        $instance->addListener('security.authentication.success', [0 => function () {
            return ($this->privates['security.authentication.provider_preparation_listener.two_factor.contao_backend'] ?? $this->getSecurity_Authentication_ProviderPreparationListener_TwoFactor_ContaoBackendService());
        }, 1 => 'onLogin'], 9223372036854775807);
        $instance->addListener('scheb_two_factor.authentication.require', [0 => function () {
            return ($this->privates['security.authentication.provider_preparation_listener.two_factor.contao_backend'] ?? $this->getSecurity_Authentication_ProviderPreparationListener_TwoFactor_ContaoBackendService());
        }, 1 => 'onAccessDenied'], 0);
        $instance->addListener('scheb_two_factor.authentication.form', [0 => function () {
            return ($this->privates['security.authentication.provider_preparation_listener.two_factor.contao_backend'] ?? $this->getSecurity_Authentication_ProviderPreparationListener_TwoFactor_ContaoBackendService());
        }, 1 => 'onTwoFactorForm'], 0);
        $instance->addListener('kernel.response', [0 => function () {
            return ($this->privates['security.authentication.provider_preparation_listener.two_factor.contao_backend'] ?? $this->getSecurity_Authentication_ProviderPreparationListener_TwoFactor_ContaoBackendService());
        }, 1 => 'onKernelResponse'], 1);
        $instance->addListener('security.authentication.success', [0 => function () {
            return ($this->privates['security.authentication.provider_preparation_listener.two_factor.contao_frontend'] ?? $this->getSecurity_Authentication_ProviderPreparationListener_TwoFactor_ContaoFrontendService());
        }, 1 => 'onLogin'], 9223372036854775807);
        $instance->addListener('scheb_two_factor.authentication.require', [0 => function () {
            return ($this->privates['security.authentication.provider_preparation_listener.two_factor.contao_frontend'] ?? $this->getSecurity_Authentication_ProviderPreparationListener_TwoFactor_ContaoFrontendService());
        }, 1 => 'onAccessDenied'], 0);
        $instance->addListener('scheb_two_factor.authentication.form', [0 => function () {
            return ($this->privates['security.authentication.provider_preparation_listener.two_factor.contao_frontend'] ?? $this->getSecurity_Authentication_ProviderPreparationListener_TwoFactor_ContaoFrontendService());
        }, 1 => 'onTwoFactorForm'], 0);
        $instance->addListener('kernel.response', [0 => function () {
            return ($this->privates['security.authentication.provider_preparation_listener.two_factor.contao_frontend'] ?? $this->getSecurity_Authentication_ProviderPreparationListener_TwoFactor_ContaoFrontendService());
        }, 1 => 'onKernelResponse'], 1);
        $instance->addListener('kernel.request', [0 => function () {
            return ($this->privates['contao.listener.csrf_token_cookie'] ?? $this->getContao_Listener_CsrfTokenCookieService());
        }, 1 => 'onKernelRequest'], 36);
        $instance->addListener('kernel.response', [0 => function () {
            return ($this->privates['contao.listener.csrf_token_cookie'] ?? $this->getContao_Listener_CsrfTokenCookieService());
        }, 1 => 'onKernelResponse'], -1006);
        $instance->addListener('console.command', [0 => function () {
            return ($this->privates['contao.listener.csrf_token_cookie'] ?? $this->getContao_Listener_CsrfTokenCookieService());
        }, 1 => 'onCommand'], 36);
        $instance->addListener('Contao\\CoreBundle\\Filesystem\\Dbafs\\RetrieveDbafsMetadataEvent', [0 => function () {
            return ($this->privates['contao.listener.dbafs_metadata'] ?? ($this->privates['contao.listener.dbafs_metadata'] = new \Contao\CoreBundle\EventListener\DbafsMetadataSubscriber()));
        }, 1 => 'enhanceMetadata'], 0);
        $instance->addListener('Contao\\CoreBundle\\Filesystem\\Dbafs\\StoreDbafsMetadataEvent', [0 => function () {
            return ($this->privates['contao.listener.dbafs_metadata'] ?? ($this->privates['contao.listener.dbafs_metadata'] = new \Contao\CoreBundle\EventListener\DbafsMetadataSubscriber()));
        }, 1 => 'normalizeMetadata'], 0);
        $instance->addListener('kernel.request', [0 => function () {
            return ($this->privates['contao.listener.locale'] ?? $this->getContao_Listener_LocaleService());
        }, 1 => 'onKernelRequest'], 20);
        $instance->addListener('kernel.request', [0 => function () {
            return ($this->privates['contao.listener.locale'] ?? $this->getContao_Listener_LocaleService());
        }, 1 => 'setTranslatorLocale'], 100);
        $instance->addListener('kernel.request', [0 => function () {
            return ($this->privates['contao.listener.subrequest_cache'] ?? ($this->privates['contao.listener.subrequest_cache'] = new \Contao\CoreBundle\EventListener\SubrequestCacheSubscriber()));
        }, 1 => 'onKernelRequest'], 255);
        $instance->addListener('kernel.response', [0 => function () {
            return ($this->privates['contao.listener.subrequest_cache'] ?? ($this->privates['contao.listener.subrequest_cache'] = new \Contao\CoreBundle\EventListener\SubrequestCacheSubscriber()));
        }, 1 => 'onKernelResponse'], -255);
        $instance->addListener('Symfony\\Component\\Security\\Http\\Event\\LogoutEvent', [0 => function () {
            return ($this->privates['security.logout.listener.csrf_token_clearing'] ?? $this->load('getSecurity_Logout_Listener_CsrfTokenClearingService'));
        }, 1 => 'onLogout'], 0);

        return $instance;
    }

    /*
     * Gets the public 'fos_http_cache.cache_manager' shared service.
     *
     * @return \FOS\HttpCacheBundle\CacheManager
     */
    protected function getFosHttpCache_CacheManagerService()
    {
        $a = ($this->services['router'] ?? $this->getRouterService());

        if (isset($this->services['fos_http_cache.cache_manager'])) {
            return $this->services['fos_http_cache.cache_manager'];
        }

        $this->services['fos_http_cache.cache_manager'] = $instance = new \FOS\HttpCacheBundle\CacheManager(($this->services['fos_http_cache.proxy_client.symfony'] ?? $this->getFosHttpCache_ProxyClient_SymfonyService()), $a);

        if ($this->has('event_dispatcher')) {
            $instance->setEventDispatcher(($this->services['event_dispatcher'] ?? $this->getEventDispatcherService()));
        }
        $instance->setGenerateUrlType(0);

        return $instance;
    }

    /*
     * Gets the public 'fos_http_cache.http.symfony_response_tagger' shared service.
     *
     * @return \FOS\HttpCacheBundle\Http\SymfonyResponseTagger
     */
    protected function getFosHttpCache_Http_SymfonyResponseTaggerService()
    {
        return $this->services['fos_http_cache.http.symfony_response_tagger'] = new \FOS\HttpCacheBundle\Http\SymfonyResponseTagger(['header_formatter' => new \FOS\HttpCache\TagHeaderFormatter\MaxHeaderValueLengthFormatter(new \FOS\HttpCache\TagHeaderFormatter\CommaSeparatedTagHeaderFormatter('X-Cache-Tags', ','), 4096), 'strict' => false]);
    }

    /*
     * Gets the public 'fos_http_cache.proxy_client.symfony' shared service.
     *
     * @return \FOS\HttpCache\ProxyClient\Symfony
     */
    protected function getFosHttpCache_ProxyClient_SymfonyService()
    {
        return $this->services['fos_http_cache.proxy_client.symfony'] = new \FOS\HttpCache\ProxyClient\Symfony(new \FOS\HttpCache\SymfonyCache\KernelDispatcher(($this->services['kernel'] ?? $this->get('kernel', 1))), $this->parameters['fos_http_cache.proxy_client.symfony.options']);
    }

    /*
     * Gets the public 'http_kernel' shared service.
     *
     * @return \Symfony\Component\HttpKernel\HttpKernel
     */
    protected function getHttpKernelService()
    {
        $a = ($this->services['event_dispatcher'] ?? $this->getEventDispatcherService());

        if (isset($this->services['http_kernel'])) {
            return $this->services['http_kernel'];
        }

        return $this->services['http_kernel'] = new \Symfony\Component\HttpKernel\HttpKernel($a, new \Contao\CoreBundle\HttpKernel\ControllerResolver(new \Symfony\Bundle\FrameworkBundle\Controller\ControllerResolver($this, ($this->privates['monolog.logger.request'] ?? $this->getMonolog_Logger_RequestService())), ($this->privates['contao.fragment.registry'] ?? $this->getContao_Fragment_RegistryService())), ($this->services['request_stack'] ?? ($this->services['request_stack'] = new \Symfony\Component\HttpFoundation\RequestStack())), new \Symfony\Component\HttpKernel\Controller\ArgumentResolver(new \Symfony\Component\HttpKernel\ControllerMetadata\ArgumentMetadataFactory(), new RewindableGenerator(function () {
            yield 0 => ($this->privates['contao.model_argument_resolver'] ?? $this->load('getContao_ModelArgumentResolverService'));
            yield 1 => ($this->privates['argument_resolver.request_attribute'] ?? ($this->privates['argument_resolver.request_attribute'] = new \Symfony\Component\HttpKernel\Controller\ArgumentResolver\RequestAttributeValueResolver()));
            yield 2 => ($this->privates['argument_resolver.request'] ?? ($this->privates['argument_resolver.request'] = new \Symfony\Component\HttpKernel\Controller\ArgumentResolver\RequestValueResolver()));
            yield 3 => ($this->privates['argument_resolver.session'] ?? ($this->privates['argument_resolver.session'] = new \Symfony\Component\HttpKernel\Controller\ArgumentResolver\SessionValueResolver()));
            yield 4 => ($this->privates['security.user_value_resolver'] ?? $this->load('getSecurity_UserValueResolverService'));
            yield 5 => ($this->privates['argument_resolver.service'] ?? $this->load('getArgumentResolver_ServiceService'));
            yield 6 => ($this->privates['argument_resolver.default'] ?? ($this->privates['argument_resolver.default'] = new \Symfony\Component\HttpKernel\Controller\ArgumentResolver\DefaultValueResolver()));
            yield 7 => ($this->privates['argument_resolver.variadic'] ?? ($this->privates['argument_resolver.variadic'] = new \Symfony\Component\HttpKernel\Controller\ArgumentResolver\VariadicValueResolver()));
        }, 8)));
    }

    /*
     * Gets the public 'knp_menu.matcher' shared service.
     *
     * @return \Knp\Menu\Matcher\Matcher
     */
    protected function getKnpMenu_MatcherService()
    {
        return $this->services['knp_menu.matcher'] = new \Knp\Menu\Matcher\Matcher(new RewindableGenerator(function () {
            yield 0 => ($this->privates['knp_menu.voter.router'] ?? $this->load('getKnpMenu_Voter_RouterService'));
        }, 1));
    }

    /*
     * Gets the public 'monolog.logger.deprecation' shared service.
     *
     * @return \Symfony\Bridge\Monolog\Logger
     */
    protected function getMonolog_Logger_DeprecationService()
    {
        $this->services['monolog.logger.deprecation'] = $instance = new \Symfony\Bridge\Monolog\Logger('deprecation');

        $instance->pushProcessor(($this->privates['contao.monolog.processor'] ?? $this->getContao_Monolog_ProcessorService()));
        $instance->pushHandler(new \Monolog\Handler\NullHandler(100, true));
        $instance->pushHandler(($this->privates['monolog.handler.console'] ?? $this->getMonolog_Handler_ConsoleService()));
        $instance->pushHandler(($this->privates['contao.monolog.handler'] ?? $this->getContao_Monolog_HandlerService()));

        return $instance;
    }

    /*
     * Gets the public 'request_stack' shared service.
     *
     * @return \Symfony\Component\HttpFoundation\RequestStack
     */
    protected function getRequestStackService()
    {
        return $this->services['request_stack'] = new \Symfony\Component\HttpFoundation\RequestStack();
    }

    /*
     * Gets the public 'router' shared service.
     *
     * @return \Symfony\Cmf\Component\Routing\ChainRouter
     */
    protected function getRouterService()
    {
        $a = ($this->privates['monolog.logger'] ?? $this->getMonolog_LoggerService());

        $this->services['router'] = $instance = new \Symfony\Cmf\Component\Routing\ChainRouter($a);

        $b = ($this->privates['router.request_context'] ?? $this->getRouter_RequestContextService());
        $c = new \Symfony\Bridge\Monolog\Logger('router');
        $c->pushProcessor(($this->privates['contao.monolog.processor'] ?? $this->getContao_Monolog_ProcessorService()));
        $c->pushHandler(($this->privates['monolog.handler.console'] ?? $this->getMonolog_Handler_ConsoleService()));
        $c->pushHandler(($this->privates['monolog.handler.main'] ?? $this->getMonolog_Handler_MainService()));
        $c->pushHandler(($this->privates['contao.monolog.handler'] ?? $this->getContao_Monolog_HandlerService()));

        $d = new \Symfony\Bundle\FrameworkBundle\Routing\Router((new \Symfony\Component\DependencyInjection\Argument\ServiceLocator($this->getService, [
            'routing.loader' => ['services', 'routing.loader', 'getRouting_LoaderService', true],
        ], [
            'routing.loader' => 'Symfony\\Component\\Config\\Loader\\LoaderInterface',
        ]))->withContext('router.default', $this), 'contao_manager.routing.route_loader::loadFromPlugins', ['cache_dir' => $this->targetDir.'', 'debug' => false, 'generator_class' => 'Symfony\\Component\\Routing\\Generator\\CompiledUrlGenerator', 'generator_dumper_class' => 'Symfony\\Component\\Routing\\Generator\\Dumper\\CompiledUrlGeneratorDumper', 'matcher_class' => 'Symfony\\Bundle\\FrameworkBundle\\Routing\\RedirectableCompiledUrlMatcher', 'matcher_dumper_class' => 'Symfony\\Component\\Routing\\Matcher\\Dumper\\CompiledUrlMatcherDumper', 'strict_requirements' => false, 'resource_type' => 'service'], $b, ($this->privates['parameter_bag'] ?? ($this->privates['parameter_bag'] = new \Symfony\Component\DependencyInjection\ParameterBag\ContainerBag($this))), $c, 'en');
        $d->setConfigCacheFactory(($this->privates['config_cache_factory'] ?? ($this->privates['config_cache_factory'] = new \Symfony\Component\Config\ResourceCheckerConfigCacheFactory())));
        $d->addExpressionLanguageProvider(($this->privates['router.expression_language_provider'] ?? $this->getRouter_ExpressionLanguageProviderService()));
        $e = ($this->privates['contao.routing.route_provider'] ?? $this->getContao_Routing_RouteProviderService());

        $f = new \Contao\CoreBundle\Routing\PageUrlGenerator($e, ($this->services['contao.routing.page_registry'] ?? $this->getContao_Routing_PageRegistryService()), $a);
        $g = ($this->services['event_dispatcher'] ?? $this->getEventDispatcherService());
        $h = new \Symfony\Cmf\Component\Routing\DynamicRouter($b, ($this->services['contao.routing.nested_matcher'] ?? $this->getContao_Routing_NestedMatcherService()), $f, '', $g, $e);
        $h->addRouteEnhancer(new \Contao\CoreBundle\Routing\Enhancer\InputEnhancer(($this->services['contao.framework'] ?? $this->getContao_FrameworkService())), 0);

        $instance->setContext($b);
        $instance->add($d, '100');
        $instance->add(new \Symfony\Cmf\Component\Routing\DynamicRouter($b, ($this->services['contao.routing.nested_404_matcher'] ?? $this->getContao_Routing_Nested404MatcherService()), $f, '', $g, ($this->privates['contao.routing.route_404_provider'] ?? $this->getContao_Routing_Route404ProviderService())), -200);
        $instance->add($h, 20);
        $instance->add(new \Symfony\Cmf\Component\Routing\DynamicRouter($b, new \Contao\CoreBundle\Routing\Matcher\UrlMatcher(), new \Symfony\Cmf\Component\Routing\ProviderBasedGenerator(new \Contao\CoreBundle\Routing\LegacyRouteProvider(($this->privates['contao.routing.frontend_loader'] ?? ($this->privates['contao.routing.frontend_loader'] = new \Contao\CoreBundle\Routing\FrontendLoader(false, '.html')))), $a), '', $g), 0);

        return $instance;
    }

    /*
     * Gets the public 'security.authentication.trust_resolver' shared service.
     *
     * @return \Scheb\TwoFactorBundle\Security\Authentication\AuthenticationTrustResolver
     */
    protected function getSecurity_Authentication_TrustResolverService()
    {
        return $this->services['security.authentication.trust_resolver'] = new \Scheb\TwoFactorBundle\Security\Authentication\AuthenticationTrustResolver(new \Symfony\Component\Security\Core\Authentication\AuthenticationTrustResolver());
    }

    /*
     * Gets the public 'security.firewall.map' shared service.
     *
     * @return \Symfony\Bundle\SecurityBundle\Security\FirewallMap
     */
    protected function getSecurity_Firewall_MapService()
    {
        $a = ($this->privates['.service_locator.f6V.Y6Q'] ?? $this->get_ServiceLocator_F6V_Y6QService());

        if (isset($this->services['security.firewall.map'])) {
            return $this->services['security.firewall.map'];
        }

        return $this->services['security.firewall.map'] = new \Symfony\Bundle\SecurityBundle\Security\FirewallMap($a, new RewindableGenerator(function () {
            yield 'security.firewall.map.context.contao_install' => ($this->privates['.security.request_matcher.2lQKaAK'] ?? ($this->privates['.security.request_matcher.2lQKaAK'] = new \Symfony\Component\HttpFoundation\RequestMatcher('^/contao/install$')));
            yield 'security.firewall.map.context.contao_backend' => ($this->privates['contao.routing.backend_matcher'] ?? $this->getContao_Routing_BackendMatcherService());
            yield 'security.firewall.map.context.contao_frontend' => ($this->privates['contao.routing.frontend_matcher'] ?? $this->getContao_Routing_FrontendMatcherService());
        }, 3));
    }

    /*
     * Gets the public 'security.helper' shared service.
     *
     * @return \Symfony\Component\Security\Core\Security
     */
    protected function getSecurity_HelperService()
    {
        return $this->services['security.helper'] = new \Symfony\Component\Security\Core\Security(new \Symfony\Component\DependencyInjection\Argument\ServiceLocator($this->getService, [
            'security.authorization_checker' => ['services', '.container.private.security.authorization_checker', 'get_Container_Private_Security_AuthorizationCheckerService', false],
            'security.token_storage' => ['services', '.container.private.security.token_storage', 'get_Container_Private_Security_TokenStorageService', false],
        ], [
            'security.authorization_checker' => '?',
            'security.token_storage' => '?',
        ]));
    }

    /*
     * Gets the public 'security.logout_url_generator' shared service.
     *
     * @return \Symfony\Component\Security\Http\Logout\LogoutUrlGenerator
     */
    protected function getSecurity_LogoutUrlGeneratorService()
    {
        $a = ($this->services['router'] ?? $this->getRouterService());

        if (isset($this->services['security.logout_url_generator'])) {
            return $this->services['security.logout_url_generator'];
        }

        $this->services['security.logout_url_generator'] = $instance = new \Symfony\Component\Security\Http\Logout\LogoutUrlGenerator(($this->services['request_stack'] ?? ($this->services['request_stack'] = new \Symfony\Component\HttpFoundation\RequestStack())), $a, ($this->services['.container.private.security.token_storage'] ?? $this->get_Container_Private_Security_TokenStorageService()));

        $instance->registerListener('contao_backend', 'contao_backend_logout', 'logout', '_csrf_token', NULL, NULL);
        $instance->registerListener('contao_frontend', 'contao_frontend_logout', 'logout', '_csrf_token', NULL, NULL);

        return $instance;
    }

    /*
     * Gets the public 'translator' shared service.
     *
     * @return \Contao\CoreBundle\Translation\Translator
     */
    protected function getTranslatorService()
    {
        $a = ($this->services['contao.framework'] ?? $this->getContao_FrameworkService());

        if (isset($this->services['translator'])) {
            return $this->services['translator'];
        }

        return $this->services['translator'] = new \Contao\CoreBundle\Translation\Translator(($this->privates['translator.default'] ?? $this->getTranslator_DefaultService()), $a, ($this->services['contao.resource_finder'] ?? $this->getContao_ResourceFinderService()));
    }

    /*
     * Gets the public 'uri_signer' shared service.
     *
     * @return \Symfony\Component\HttpKernel\UriSigner
     */
    protected function getUriSignerService()
    {
        return $this->services['uri_signer'] = new \Symfony\Component\HttpKernel\UriSigner($this->getEnv('APP_SECRET'));
    }

    /*
     * Gets the private '.service_locator.ZTa9e0W' shared service.
     *
     * @return \Symfony\Component\DependencyInjection\ServiceLocator
     */
    protected function get_ServiceLocator_ZTa9e0WService()
    {
        return $this->privates['.service_locator.ZTa9e0W'] = new \Symfony\Component\DependencyInjection\Argument\ServiceLocator($this->getService, [
            'contao.cache.entity_tags' => ['services', 'contao.cache.entity_tags', 'getContao_Cache_EntityTagsService', true],
            'contao.csrf.token_manager' => ['services', 'contao.csrf.token_manager', 'getContao_Csrf_TokenManagerService', false],
            'contao.framework' => ['services', 'contao.framework', 'getContao_FrameworkService', false],
            'doctrine' => ['services', 'doctrine', 'getDoctrineService', true],
            'event_dispatcher' => ['services', 'event_dispatcher', 'getEventDispatcherService', false],
            'fos_http_cache.http.symfony_response_tagger' => ['services', 'fos_http_cache.http.symfony_response_tagger', 'getFosHttpCache_Http_SymfonyResponseTaggerService', false],
            'http_kernel' => ['services', 'http_kernel', 'getHttpKernelService', false],
            'logger' => ['privates', 'monolog.logger', 'getMonolog_LoggerService', false],
            'parameter_bag' => ['privates', 'parameter_bag', 'getParameterBagService', false],
            'request_stack' => ['services', 'request_stack', 'getRequestStackService', false],
            'router' => ['services', 'router', 'getRouterService', false],
            'security.authorization_checker' => ['services', '.container.private.security.authorization_checker', 'get_Container_Private_Security_AuthorizationCheckerService', false],
            'security.csrf.token_manager' => ['services', '.container.private.security.csrf.token_manager', 'get_Container_Private_Security_Csrf_TokenManagerService', true],
            'security.token_storage' => ['services', '.container.private.security.token_storage', 'get_Container_Private_Security_TokenStorageService', false],
            'session' => ['privates', '.session.deprecated', 'get_Session_DeprecatedService', true],
            'twig' => ['services', '.container.private.twig', 'get_Container_Private_TwigService', false],
        ], [
            'contao.cache.entity_tags' => '?',
            'contao.csrf.token_manager' => 'Contao\\CoreBundle\\Csrf\\ContaoCsrfTokenManager',
            'contao.framework' => '?',
            'doctrine' => '?',
            'event_dispatcher' => '?',
            'fos_http_cache.http.symfony_response_tagger' => '?',
            'http_kernel' => '?',
            'logger' => '?',
            'parameter_bag' => '?',
            'request_stack' => '?',
            'router' => '?',
            'security.authorization_checker' => '?',
            'security.csrf.token_manager' => '?',
            'security.token_storage' => '?',
            'session' => '.session.deprecated',
            'twig' => '?',
        ]);
    }

    /*
     * Gets the private '.service_locator.f6V.Y6Q' shared service.
     *
     * @return \Symfony\Component\DependencyInjection\ServiceLocator
     */
    protected function get_ServiceLocator_F6V_Y6QService()
    {
        return $this->privates['.service_locator.f6V.Y6Q'] = new \Symfony\Component\DependencyInjection\Argument\ServiceLocator($this->getService, [
            'security.firewall.map.context.contao_backend' => ['privates', 'security.firewall.map.context.contao_backend', 'getSecurity_Firewall_Map_Context_ContaoBackendService', true],
            'security.firewall.map.context.contao_frontend' => ['privates', 'security.firewall.map.context.contao_frontend', 'getSecurity_Firewall_Map_Context_ContaoFrontendService', true],
            'security.firewall.map.context.contao_install' => ['privates', 'security.firewall.map.context.contao_install', 'getSecurity_Firewall_Map_Context_ContaoInstallService', true],
        ], [
            'security.firewall.map.context.contao_backend' => '?',
            'security.firewall.map.context.contao_frontend' => '?',
            'security.firewall.map.context.contao_install' => '?',
        ]);
    }

    /*
     * Gets the private 'annotations.cache_adapter' shared service.
     *
     * @return \Symfony\Component\Cache\Adapter\PhpArrayAdapter
     */
    protected function getAnnotations_CacheAdapterService()
    {
        return \Symfony\Component\Cache\Adapter\PhpArrayAdapter::create(($this->targetDir.''.'/annotations.php'), ($this->privates['cache.annotations'] ?? $this->getCache_AnnotationsService()));
    }

    /*
     * Gets the private 'cache.annotations' shared service.
     *
     * @return \Symfony\Component\Cache\Adapter\AdapterInterface
     */
    protected function getCache_AnnotationsService()
    {
        return $this->privates['cache.annotations'] = \Symfony\Component\Cache\Adapter\AbstractAdapter::createSystemCache('6vwQ7DEOGA', 0, $this->getParameter('container.build_id'), ($this->targetDir.''.'/pools/system'), ($this->privates['monolog.logger.cache'] ?? $this->getMonolog_Logger_CacheService()));
    }

    /*
     * Gets the private 'contao.fragment.registry' shared service.
     *
     * @return \Contao\CoreBundle\Fragment\FragmentRegistry
     */
    protected function getContao_Fragment_RegistryService()
    {
        $this->privates['contao.fragment.registry'] = $instance = new \Contao\CoreBundle\Fragment\FragmentRegistry();

        $instance->add('contao.frontend_module.root_page_dependent_modules', ($this->privates['contao.fragment._config_yQxn9v4'] ?? ($this->privates['contao.fragment._config_yQxn9v4'] = new \Contao\CoreBundle\Fragment\FragmentConfig('contao.fragment._contao.frontend_module.root_page_dependent_modules', 'forward', ['ignore_errors' => false]))));
        $instance->add('contao.frontend_module.template', ($this->privates['contao.fragment._config_UbRP2PT'] ?? ($this->privates['contao.fragment._config_UbRP2PT'] = new \Contao\CoreBundle\Fragment\FragmentConfig('contao.fragment._contao.frontend_module.template', 'forward', ['ignore_errors' => false]))));
        $instance->add('contao.frontend_module.two_factor', ($this->privates['contao.fragment._config_Ie.W_bF'] ?? ($this->privates['contao.fragment._config_Ie.W_bF'] = new \Contao\CoreBundle\Fragment\FragmentConfig('contao.fragment._contao.frontend_module.two_factor', 'forward', ['ignore_errors' => false]))));
        $instance->add('contao.content_element.markdown', ($this->privates['contao.fragment._config_Bd8Hjso'] ?? ($this->privates['contao.fragment._config_Bd8Hjso'] = new \Contao\CoreBundle\Fragment\FragmentConfig('contao.fragment._contao.content_element.markdown', 'forward', ['ignore_errors' => false]))));
        $instance->add('contao.content_element.template', ($this->privates['contao.fragment._config_s7uzikD'] ?? ($this->privates['contao.fragment._config_s7uzikD'] = new \Contao\CoreBundle\Fragment\FragmentConfig('contao.fragment._contao.content_element.template', 'forward', ['ignore_errors' => false]))));

        return $instance;
    }

    /*
     * Gets the private 'contao.listener.backend_locale' shared service.
     *
     * @return \Contao\CoreBundle\EventListener\BackendLocaleListener
     */
    protected function getContao_Listener_BackendLocaleService()
    {
        $a = ($this->services['security.helper'] ?? $this->getSecurity_HelperService());

        if (isset($this->privates['contao.listener.backend_locale'])) {
            return $this->privates['contao.listener.backend_locale'];
        }
        $b = ($this->services['translator'] ?? $this->getTranslatorService());

        if (isset($this->privates['contao.listener.backend_locale'])) {
            return $this->privates['contao.listener.backend_locale'];
        }

        return $this->privates['contao.listener.backend_locale'] = new \Contao\CoreBundle\EventListener\BackendLocaleListener($a, $b);
    }

    /*
     * Gets the private 'contao.listener.backend_noindex' shared service.
     *
     * @return \Contao\CoreBundle\EventListener\BackendNoindexListener
     */
    protected function getContao_Listener_BackendNoindexService()
    {
        return $this->privates['contao.listener.backend_noindex'] = new \Contao\CoreBundle\EventListener\BackendNoindexListener(($this->services['contao.routing.scope_matcher'] ?? $this->getContao_Routing_ScopeMatcherService()));
    }

    /*
     * Gets the private 'contao.listener.backend_preview_redirect' shared service.
     *
     * @return \Contao\CoreBundle\EventListener\BackendPreviewRedirectListener
     */
    protected function getContao_Listener_BackendPreviewRedirectService()
    {
        return $this->privates['contao.listener.backend_preview_redirect'] = new \Contao\CoreBundle\EventListener\BackendPreviewRedirectListener(($this->services['contao.routing.scope_matcher'] ?? $this->getContao_Routing_ScopeMatcherService()));
    }

    /*
     * Gets the private 'contao.listener.backend_rebuild_cache_message' shared service.
     *
     * @return \Contao\CoreBundle\EventListener\BackendRebuildCacheMessageListener
     */
    protected function getContao_Listener_BackendRebuildCacheMessageService()
    {
        $a = ($this->services['translator'] ?? $this->getTranslatorService());

        if (isset($this->privates['contao.listener.backend_rebuild_cache_message'])) {
            return $this->privates['contao.listener.backend_rebuild_cache_message'];
        }

        return $this->privates['contao.listener.backend_rebuild_cache_message'] = new \Contao\CoreBundle\EventListener\BackendRebuildCacheMessageListener(($this->services['contao.routing.scope_matcher'] ?? $this->getContao_Routing_ScopeMatcherService()), ($this->services['cache.system'] ?? $this->getCache_SystemService()), $a);
    }

    /*
     * Gets the private 'contao.listener.csrf_token_cookie' shared service.
     *
     * @return \Contao\CoreBundle\EventListener\CsrfTokenCookieSubscriber
     */
    protected function getContao_Listener_CsrfTokenCookieService()
    {
        return $this->privates['contao.listener.csrf_token_cookie'] = new \Contao\CoreBundle\EventListener\CsrfTokenCookieSubscriber(($this->services['contao.csrf.token_manager'] ?? $this->getContao_Csrf_TokenManagerService()), ($this->privates['contao.csrf.token_storage'] ?? ($this->privates['contao.csrf.token_storage'] = new \Contao\CoreBundle\Csrf\MemoryTokenStorage())), 'csrf_');
    }

    /*
     * Gets the private 'contao.listener.interest_cohort' shared service.
     *
     * @return \Contao\CoreBundle\EventListener\InterestCohortListener
     */
    protected function getContao_Listener_InterestCohortService()
    {
        return $this->privates['contao.listener.interest_cohort'] = new \Contao\CoreBundle\EventListener\InterestCohortListener(($this->services['contao.routing.scope_matcher'] ?? $this->getContao_Routing_ScopeMatcherService()));
    }

    /*
     * Gets the private 'contao.listener.legacy_login_constants' shared service.
     *
     * @return \Contao\CoreBundle\EventListener\LegacyLoginConstantsListener
     */
    protected function getContao_Listener_LegacyLoginConstantsService()
    {
        $a = ($this->services['contao.framework'] ?? $this->getContao_FrameworkService());

        if (isset($this->privates['contao.listener.legacy_login_constants'])) {
            return $this->privates['contao.listener.legacy_login_constants'];
        }

        return $this->privates['contao.listener.legacy_login_constants'] = new \Contao\CoreBundle\EventListener\LegacyLoginConstantsListener($a);
    }

    /*
     * Gets the private 'contao.listener.locale' shared service.
     *
     * @return \Contao\CoreBundle\EventListener\LocaleSubscriber
     */
    protected function getContao_Listener_LocaleService()
    {
        $a = ($this->services['translator'] ?? $this->getTranslatorService());

        if (isset($this->privates['contao.listener.locale'])) {
            return $this->privates['contao.listener.locale'];
        }
        $b = ($this->services['contao.intl.locales'] ?? $this->getContao_Intl_LocalesService());

        if (isset($this->privates['contao.listener.locale'])) {
            return $this->privates['contao.listener.locale'];
        }

        return $this->privates['contao.listener.locale'] = new \Contao\CoreBundle\EventListener\LocaleSubscriber($a, ($this->services['contao.routing.scope_matcher'] ?? $this->getContao_Routing_ScopeMatcherService()), $b);
    }

    /*
     * Gets the private 'contao.listener.make_response_private' shared service.
     *
     * @return \Contao\CoreBundle\EventListener\MakeResponsePrivateListener
     */
    protected function getContao_Listener_MakeResponsePrivateService()
    {
        return $this->privates['contao.listener.make_response_private'] = new \Contao\CoreBundle\EventListener\MakeResponsePrivateListener(($this->services['contao.routing.scope_matcher'] ?? $this->getContao_Routing_ScopeMatcherService()));
    }

    /*
     * Gets the private 'contao.listener.merge_http_headers' shared service.
     *
     * @return \Contao\CoreBundle\EventListener\MergeHttpHeadersListener
     */
    protected function getContao_Listener_MergeHttpHeadersService()
    {
        $a = ($this->services['contao.framework'] ?? $this->getContao_FrameworkService());

        if (isset($this->privates['contao.listener.merge_http_headers'])) {
            return $this->privates['contao.listener.merge_http_headers'];
        }

        return $this->privates['contao.listener.merge_http_headers'] = new \Contao\CoreBundle\EventListener\MergeHttpHeadersListener($a);
    }

    /*
     * Gets the private 'contao.listener.page_trail_cache_tags' shared service.
     *
     * @return \Contao\CoreBundle\EventListener\PageTrailCacheTagsListener
     */
    protected function getContao_Listener_PageTrailCacheTagsService()
    {
        return $this->privates['contao.listener.page_trail_cache_tags'] = new \Contao\CoreBundle\EventListener\PageTrailCacheTagsListener(($this->services['contao.routing.scope_matcher'] ?? $this->getContao_Routing_ScopeMatcherService()), ($this->services['fos_http_cache.http.symfony_response_tagger'] ?? $this->getFosHttpCache_Http_SymfonyResponseTaggerService()));
    }

    /*
     * Gets the private 'contao.listener.preview_authentication' shared service.
     *
     * @return \Contao\CoreBundle\EventListener\PreviewAuthenticationListener
     */
    protected function getContao_Listener_PreviewAuthenticationService()
    {
        $a = ($this->services['contao.security.token_checker'] ?? $this->getContao_Security_TokenCheckerService());

        if (isset($this->privates['contao.listener.preview_authentication'])) {
            return $this->privates['contao.listener.preview_authentication'];
        }
        $b = ($this->services['router'] ?? $this->getRouterService());

        if (isset($this->privates['contao.listener.preview_authentication'])) {
            return $this->privates['contao.listener.preview_authentication'];
        }

        return $this->privates['contao.listener.preview_authentication'] = new \Contao\CoreBundle\EventListener\PreviewAuthenticationListener(($this->services['contao.routing.scope_matcher'] ?? $this->getContao_Routing_ScopeMatcherService()), $a, $b, ($this->services['uri_signer'] ?? ($this->services['uri_signer'] = new \Symfony\Component\HttpKernel\UriSigner($this->getEnv('APP_SECRET')))));
    }

    /*
     * Gets the private 'contao.listener.preview_toolbar' shared service.
     *
     * @return \Contao\CoreBundle\EventListener\PreviewToolbarListener
     */
    protected function getContao_Listener_PreviewToolbarService()
    {
        $a = ($this->services['contao.security.token_checker'] ?? $this->getContao_Security_TokenCheckerService());

        if (isset($this->privates['contao.listener.preview_toolbar'])) {
            return $this->privates['contao.listener.preview_toolbar'];
        }
        $b = ($this->services['.container.private.twig'] ?? $this->get_Container_Private_TwigService());

        if (isset($this->privates['contao.listener.preview_toolbar'])) {
            return $this->privates['contao.listener.preview_toolbar'];
        }
        $c = ($this->services['router'] ?? $this->getRouterService());

        if (isset($this->privates['contao.listener.preview_toolbar'])) {
            return $this->privates['contao.listener.preview_toolbar'];
        }

        return $this->privates['contao.listener.preview_toolbar'] = new \Contao\CoreBundle\EventListener\PreviewToolbarListener(($this->services['contao.routing.scope_matcher'] ?? $this->getContao_Routing_ScopeMatcherService()), $a, $b, $c, '/preview.php');
    }

    /*
     * Gets the private 'contao.listener.referer_id' shared service.
     *
     * @return \Contao\CoreBundle\EventListener\RefererIdListener
     */
    protected function getContao_Listener_RefererIdService()
    {
        return $this->privates['contao.listener.referer_id'] = new \Contao\CoreBundle\EventListener\RefererIdListener(new \Symfony\Component\Security\Csrf\TokenGenerator\UriSafeTokenGenerator(48), ($this->services['contao.routing.scope_matcher'] ?? $this->getContao_Routing_ScopeMatcherService()));
    }

    /*
     * Gets the private 'contao.listener.request_token' shared service.
     *
     * @return \Contao\CoreBundle\EventListener\RequestTokenListener
     */
    protected function getContao_Listener_RequestTokenService()
    {
        $a = ($this->services['contao.framework'] ?? $this->getContao_FrameworkService());

        if (isset($this->privates['contao.listener.request_token'])) {
            return $this->privates['contao.listener.request_token'];
        }

        return $this->privates['contao.listener.request_token'] = new \Contao\CoreBundle\EventListener\RequestTokenListener($a, ($this->services['contao.routing.scope_matcher'] ?? $this->getContao_Routing_ScopeMatcherService()), ($this->services['contao.csrf.token_manager'] ?? $this->getContao_Csrf_TokenManagerService()), 'contao_csrf_token', 'csrf_');
    }

    /*
     * Gets the private 'contao.listener.security.two_factor_frontend' shared service.
     *
     * @return \Contao\CoreBundle\EventListener\Security\TwoFactorFrontendListener
     */
    protected function getContao_Listener_Security_TwoFactorFrontendService()
    {
        $a = ($this->services['contao.framework'] ?? $this->getContao_FrameworkService());

        if (isset($this->privates['contao.listener.security.two_factor_frontend'])) {
            return $this->privates['contao.listener.security.two_factor_frontend'];
        }

        return $this->privates['contao.listener.security.two_factor_frontend'] = new \Contao\CoreBundle\EventListener\Security\TwoFactorFrontendListener($a, ($this->services['contao.routing.scope_matcher'] ?? $this->getContao_Routing_ScopeMatcherService()), ($this->services['.container.private.security.token_storage'] ?? $this->get_Container_Private_Security_TokenStorageService()), $this->parameters['scheb_two_factor.security_tokens']);
    }

    /*
     * Gets the private 'contao.listener.service_unavailable' shared service.
     *
     * @return \Contao\CoreBundle\EventListener\ServiceUnavailableListener
     */
    protected function getContao_Listener_ServiceUnavailableService()
    {
        return $this->privates['contao.listener.service_unavailable'] = new \Contao\CoreBundle\EventListener\ServiceUnavailableListener(($this->services['contao.routing.scope_matcher'] ?? $this->getContao_Routing_ScopeMatcherService()));
    }

    /*
     * Gets the private 'contao.listener.store_referer' shared service.
     *
     * @return \Contao\CoreBundle\EventListener\StoreRefererListener
     */
    protected function getContao_Listener_StoreRefererService()
    {
        $a = ($this->services['security.helper'] ?? $this->getSecurity_HelperService());

        if (isset($this->privates['contao.listener.store_referer'])) {
            return $this->privates['contao.listener.store_referer'];
        }

        return $this->privates['contao.listener.store_referer'] = new \Contao\CoreBundle\EventListener\StoreRefererListener($a, ($this->services['contao.routing.scope_matcher'] ?? $this->getContao_Routing_ScopeMatcherService()));
    }

    /*
     * Gets the private 'contao.listener.user_session' shared service.
     *
     * @return \Contao\CoreBundle\EventListener\UserSessionListener
     */
    protected function getContao_Listener_UserSessionService()
    {
        $a = ($this->services['doctrine.dbal.default_connection'] ?? $this->getDoctrine_Dbal_DefaultConnectionService());

        if (isset($this->privates['contao.listener.user_session'])) {
            return $this->privates['contao.listener.user_session'];
        }
        $b = ($this->services['security.helper'] ?? $this->getSecurity_HelperService());

        if (isset($this->privates['contao.listener.user_session'])) {
            return $this->privates['contao.listener.user_session'];
        }
        $c = ($this->services['event_dispatcher'] ?? $this->getEventDispatcherService());

        if (isset($this->privates['contao.listener.user_session'])) {
            return $this->privates['contao.listener.user_session'];
        }

        return $this->privates['contao.listener.user_session'] = new \Contao\CoreBundle\EventListener\UserSessionListener($a, $b, ($this->services['contao.routing.scope_matcher'] ?? $this->getContao_Routing_ScopeMatcherService()), $c);
    }

    /*
     * Gets the private 'contao.monolog.handler' shared service.
     *
     * @return \Contao\CoreBundle\Monolog\ContaoTableHandler
     */
    protected function getContao_Monolog_HandlerService()
    {
        $this->privates['contao.monolog.handler'] = $instance = new \Contao\CoreBundle\Monolog\ContaoTableHandler();

        $instance->setContainer($this);

        return $instance;
    }

    /*
     * Gets the private 'contao.monolog.processor' shared service.
     *
     * @return \Contao\CoreBundle\Monolog\ContaoTableProcessor
     */
    protected function getContao_Monolog_ProcessorService()
    {
        return $this->privates['contao.monolog.processor'] = new \Contao\CoreBundle\Monolog\ContaoTableProcessor(($this->services['request_stack'] ?? ($this->services['request_stack'] = new \Symfony\Component\HttpFoundation\RequestStack())), ($this->services['.container.private.security.token_storage'] ?? $this->get_Container_Private_Security_TokenStorageService()), ($this->services['contao.routing.scope_matcher'] ?? $this->getContao_Routing_ScopeMatcherService()));
    }

    /*
     * Gets the private 'contao.routing.backend_matcher' shared service.
     *
     * @return \Symfony\Component\HttpFoundation\RequestMatcher
     */
    protected function getContao_Routing_BackendMatcherService()
    {
        $this->privates['contao.routing.backend_matcher'] = $instance = new \Symfony\Component\HttpFoundation\RequestMatcher();

        $instance->matchAttribute('_scope', 'backend');

        return $instance;
    }

    /*
     * Gets the private 'contao.routing.frontend_matcher' shared service.
     *
     * @return \Symfony\Component\HttpFoundation\RequestMatcher
     */
    protected function getContao_Routing_FrontendMatcherService()
    {
        $this->privates['contao.routing.frontend_matcher'] = $instance = new \Symfony\Component\HttpFoundation\RequestMatcher();

        $instance->matchAttribute('_scope', 'frontend');

        return $instance;
    }

    /*
     * Gets the private 'contao.routing.matcher.published_filter' shared service.
     *
     * @return \Contao\CoreBundle\Routing\Matcher\PublishedFilter
     */
    protected function getContao_Routing_Matcher_PublishedFilterService()
    {
        $a = ($this->services['contao.security.token_checker'] ?? $this->getContao_Security_TokenCheckerService());

        if (isset($this->privates['contao.routing.matcher.published_filter'])) {
            return $this->privates['contao.routing.matcher.published_filter'];
        }

        return $this->privates['contao.routing.matcher.published_filter'] = new \Contao\CoreBundle\Routing\Matcher\PublishedFilter($a);
    }

    /*
     * Gets the private 'contao.routing.route_404_provider' shared service.
     *
     * @return \Contao\CoreBundle\Routing\Route404Provider
     */
    protected function getContao_Routing_Route404ProviderService()
    {
        $a = ($this->services['contao.framework'] ?? $this->getContao_FrameworkService());

        if (isset($this->privates['contao.routing.route_404_provider'])) {
            return $this->privates['contao.routing.route_404_provider'];
        }
        $b = ($this->services['contao.routing.page_registry'] ?? $this->getContao_Routing_PageRegistryService());

        if (isset($this->privates['contao.routing.route_404_provider'])) {
            return $this->privates['contao.routing.route_404_provider'];
        }

        return $this->privates['contao.routing.route_404_provider'] = new \Contao\CoreBundle\Routing\Route404Provider($a, new \Contao\CoreBundle\Routing\Candidates\LocaleCandidates($b), $b);
    }

    /*
     * Gets the private 'contao.routing.route_provider' shared service.
     *
     * @return \Contao\CoreBundle\Routing\RouteProvider
     */
    protected function getContao_Routing_RouteProviderService()
    {
        $a = ($this->services['contao.framework'] ?? $this->getContao_FrameworkService());

        if (isset($this->privates['contao.routing.route_provider'])) {
            return $this->privates['contao.routing.route_provider'];
        }
        $b = ($this->services['contao.routing.page_registry'] ?? $this->getContao_Routing_PageRegistryService());

        if (isset($this->privates['contao.routing.route_provider'])) {
            return $this->privates['contao.routing.route_provider'];
        }

        return $this->privates['contao.routing.route_provider'] = new \Contao\CoreBundle\Routing\RouteProvider($a, new \Contao\CoreBundle\Routing\Candidates\LegacyCandidates(false, '.html'), $b, true, false);
    }

    /*
     * Gets the private 'contao.security.access_decision_manager' shared service.
     *
     * @return \Contao\CoreBundle\Security\Authentication\AccessDecisionManager
     */
    protected function getContao_Security_AccessDecisionManagerService()
    {
        $a = ($this->services['security.firewall.map'] ?? $this->getSecurity_Firewall_MapService());

        if (isset($this->privates['contao.security.access_decision_manager'])) {
            return $this->privates['contao.security.access_decision_manager'];
        }

        return $this->privates['contao.security.access_decision_manager'] = new \Contao\CoreBundle\Security\Authentication\AccessDecisionManager(new \Symfony\Component\Security\Core\Authorization\AccessDecisionManager(new RewindableGenerator(function () {
            yield 0 => ($this->privates['security.access.authenticated_voter'] ?? $this->load('getSecurity_Access_AuthenticatedVoterService'));
            yield 1 => ($this->privates['scheb_two_factor.security.access.authenticated_voter'] ?? ($this->privates['scheb_two_factor.security.access.authenticated_voter'] = new \Scheb\TwoFactorBundle\Security\Authorization\Voter\TwoFactorInProgressVoter()));
            yield 2 => ($this->privates['security.access.simple_role_voter'] ?? ($this->privates['security.access.simple_role_voter'] = new \Symfony\Component\Security\Core\Authorization\Voter\RoleVoter()));
            yield 3 => ($this->privates['security.access.expression_voter'] ?? $this->load('getSecurity_Access_ExpressionVoterService'));
            yield 4 => ($this->privates['contao.security.backend_access_voter'] ?? $this->load('getContao_Security_BackendAccessVoterService'));
            yield 5 => ($this->privates['contao.security.member_group_voter'] ?? ($this->privates['contao.security.member_group_voter'] = new \Contao\CoreBundle\Security\Voter\MemberGroupVoter()));
        }, 6), new \Symfony\Component\Security\Core\Authorization\Strategy\AffirmativeStrategy(false)), new \Symfony\Component\Security\Core\Authorization\AccessDecisionManager(new RewindableGenerator(function () {
            yield 0 => ($this->privates['security.access.authenticated_voter'] ?? $this->load('getSecurity_Access_AuthenticatedVoterService'));
            yield 1 => ($this->privates['scheb_two_factor.security.access.authenticated_voter'] ?? ($this->privates['scheb_two_factor.security.access.authenticated_voter'] = new \Scheb\TwoFactorBundle\Security\Authorization\Voter\TwoFactorInProgressVoter()));
            yield 2 => ($this->privates['security.access.simple_role_voter'] ?? ($this->privates['security.access.simple_role_voter'] = new \Symfony\Component\Security\Core\Authorization\Voter\RoleVoter()));
            yield 3 => ($this->privates['security.access.expression_voter'] ?? $this->load('getSecurity_Access_ExpressionVoterService'));
            yield 4 => ($this->privates['contao.security.backend_access_voter'] ?? $this->load('getContao_Security_BackendAccessVoterService'));
            yield 5 => ($this->privates['contao.security.member_group_voter'] ?? ($this->privates['contao.security.member_group_voter'] = new \Contao\CoreBundle\Security\Voter\MemberGroupVoter()));
        }, 6), 'priority'), ($this->services['request_stack'] ?? ($this->services['request_stack'] = new \Symfony\Component\HttpFoundation\RequestStack())), $a);
    }

    /*
     * Gets the private 'contao.twig.loader.auto_refresh_template_hierarchy_listener' shared service.
     *
     * @return \Contao\CoreBundle\Twig\Loader\AutoRefreshTemplateHierarchyListener
     */
    protected function getContao_Twig_Loader_AutoRefreshTemplateHierarchyListenerService()
    {
        $a = ($this->services['contao.twig.filesystem_loader'] ?? $this->getContao_Twig_FilesystemLoaderService());

        if (isset($this->privates['contao.twig.loader.auto_refresh_template_hierarchy_listener'])) {
            return $this->privates['contao.twig.loader.auto_refresh_template_hierarchy_listener'];
        }

        return $this->privates['contao.twig.loader.auto_refresh_template_hierarchy_listener'] = new \Contao\CoreBundle\Twig\Loader\AutoRefreshTemplateHierarchyListener($a, 'prod');
    }

    /*
     * Gets the private 'debug.debug_handlers_listener' shared service.
     *
     * @return \Symfony\Component\HttpKernel\EventListener\DebugHandlersListener
     */
    protected function getDebug_DebugHandlersListenerService()
    {
        return $this->privates['debug.debug_handlers_listener'] = new \Symfony\Component\HttpKernel\EventListener\DebugHandlersListener(NULL, NULL, NULL, 0, false, false, ($this->services['monolog.logger.deprecation'] ?? $this->getMonolog_Logger_DeprecationService()));
    }

    /*
     * Gets the private 'doctrine.dbal.default_connection.event_manager' shared service.
     *
     * @return \Symfony\Bridge\Doctrine\ContainerAwareEventManager
     */
    protected function getDoctrine_Dbal_DefaultConnection_EventManagerService()
    {
        return $this->privates['doctrine.dbal.default_connection.event_manager'] = new \Symfony\Bridge\Doctrine\ContainerAwareEventManager(new \Symfony\Component\DependencyInjection\Argument\ServiceLocator($this->getService, [
            'contao.listener.doctrine_schema' => ['privates', 'contao.listener.doctrine_schema', 'getContao_Listener_DoctrineSchemaService', true],
            'contao.listener.doctrine_schema.adjust_search_url_length' => ['privates', 'contao.listener.doctrine_schema.adjust_search_url_length', 'getContao_Listener_DoctrineSchema_AdjustSearchUrlLengthService', true],
            'contao_manager.listener.doctrine_alter_table' => ['privates', 'contao_manager.listener.doctrine_alter_table', 'getContaoManager_Listener_DoctrineAlterTableService', true],
            'doctrine.orm.default_listeners.attach_entity_listeners' => ['privates', 'doctrine.orm.default_listeners.attach_entity_listeners', 'getDoctrine_Orm_DefaultListeners_AttachEntityListenersService', true],
            'doctrine.orm.listeners.doctrine_dbal_cache_adapter_schema_subscriber' => ['privates', 'doctrine.orm.listeners.doctrine_dbal_cache_adapter_schema_subscriber', 'getDoctrine_Orm_Listeners_DoctrineDbalCacheAdapterSchemaSubscriberService', true],
            'doctrine.orm.listeners.doctrine_token_provider_schema_subscriber' => ['privates', 'doctrine.orm.listeners.doctrine_token_provider_schema_subscriber', 'getDoctrine_Orm_Listeners_DoctrineTokenProviderSchemaSubscriberService', true],
            'doctrine.orm.listeners.pdo_cache_adapter_doctrine_schema_subscriber' => ['privates', 'doctrine.orm.listeners.pdo_cache_adapter_doctrine_schema_subscriber', 'getDoctrine_Orm_Listeners_PdoCacheAdapterDoctrineSchemaSubscriberService', true],
        ], [
            'contao.listener.doctrine_schema' => '?',
            'contao.listener.doctrine_schema.adjust_search_url_length' => '?',
            'contao_manager.listener.doctrine_alter_table' => '?',
            'doctrine.orm.default_listeners.attach_entity_listeners' => '?',
            'doctrine.orm.listeners.doctrine_dbal_cache_adapter_schema_subscriber' => '?',
            'doctrine.orm.listeners.doctrine_token_provider_schema_subscriber' => '?',
            'doctrine.orm.listeners.pdo_cache_adapter_doctrine_schema_subscriber' => '?',
        ]), [0 => 'doctrine.orm.listeners.doctrine_dbal_cache_adapter_schema_subscriber', 1 => 'doctrine.orm.listeners.pdo_cache_adapter_doctrine_schema_subscriber', 2 => 'doctrine.orm.listeners.doctrine_token_provider_schema_subscriber', 3 => [0 => [0 => 'loadClassMetadata'], 1 => 'doctrine.orm.default_listeners.attach_entity_listeners'], 4 => [0 => [0 => 'postGenerateSchema'], 1 => 'contao.listener.doctrine_schema'], 5 => [0 => [0 => 'onSchemaAlterTableRenameColumn'], 1 => 'contao_manager.listener.doctrine_alter_table'], 6 => [0 => [0 => 'postGenerateSchema'], 1 => 'contao.listener.doctrine_schema.adjust_search_url_length']]);
    }

    /*
     * Gets the private 'esi_listener' shared service.
     *
     * @return \Symfony\Component\HttpKernel\EventListener\SurrogateListener
     */
    protected function getEsiListenerService()
    {
        return $this->privates['esi_listener'] = new \Symfony\Component\HttpKernel\EventListener\SurrogateListener(($this->privates['esi'] ?? ($this->privates['esi'] = new \Symfony\Component\HttpKernel\HttpCache\Esi())));
    }

    /*
     * Gets the private 'exception_listener' shared service.
     *
     * @return \Symfony\Component\HttpKernel\EventListener\ErrorListener
     */
    protected function getExceptionListenerService()
    {
        return $this->privates['exception_listener'] = new \Symfony\Component\HttpKernel\EventListener\ErrorListener('error_controller', ($this->privates['monolog.logger.request'] ?? $this->getMonolog_Logger_RequestService()), false, []);
    }

    /*
     * Gets the private 'fos_http_cache.event_listener.tag' shared service.
     *
     * @return \FOS\HttpCacheBundle\EventListener\TagListener
     */
    protected function getFosHttpCache_EventListener_TagService()
    {
        $a = ($this->services['fos_http_cache.cache_manager'] ?? $this->getFosHttpCache_CacheManagerService());

        if (isset($this->privates['fos_http_cache.event_listener.tag'])) {
            return $this->privates['fos_http_cache.event_listener.tag'];
        }

        return $this->privates['fos_http_cache.event_listener.tag'] = new \FOS\HttpCacheBundle\EventListener\TagListener($a, ($this->services['fos_http_cache.http.symfony_response_tagger'] ?? $this->getFosHttpCache_Http_SymfonyResponseTaggerService()), new \FOS\HttpCacheBundle\Http\RuleMatcher(new \FOS\HttpCacheBundle\Http\RequestMatcher\CacheableRequestMatcher(), new \FOS\HttpCacheBundle\Http\ResponseMatcher\CacheableResponseMatcher([])), ($this->privates['fos_http_cache.rule_matcher.must_invalidate'] ?? $this->getFosHttpCache_RuleMatcher_MustInvalidateService()), NULL);
    }

    /*
     * Gets the private 'fos_http_cache.rule_matcher.must_invalidate' shared service.
     *
     * @return \FOS\HttpCacheBundle\Http\RuleMatcher
     */
    protected function getFosHttpCache_RuleMatcher_MustInvalidateService()
    {
        return $this->privates['fos_http_cache.rule_matcher.must_invalidate'] = new \FOS\HttpCacheBundle\Http\RuleMatcher(new \FOS\HttpCacheBundle\Http\RequestMatcher\UnsafeRequestMatcher(), new \FOS\HttpCacheBundle\Http\ResponseMatcher\NonErrorResponseMatcher());
    }

    /*
     * Gets the private 'fragment.listener' shared service.
     *
     * @return \Symfony\Component\HttpKernel\EventListener\FragmentListener
     */
    protected function getFragment_ListenerService()
    {
        return $this->privates['fragment.listener'] = new \Symfony\Component\HttpKernel\EventListener\FragmentListener(($this->services['uri_signer'] ?? ($this->services['uri_signer'] = new \Symfony\Component\HttpKernel\UriSigner($this->getEnv('APP_SECRET')))), '/_fragment');
    }

    /*
     * Gets the private 'locale_aware_listener' shared service.
     *
     * @return \Symfony\Component\HttpKernel\EventListener\LocaleAwareListener
     */
    protected function getLocaleAwareListenerService()
    {
        return $this->privates['locale_aware_listener'] = new \Symfony\Component\HttpKernel\EventListener\LocaleAwareListener(new RewindableGenerator(function () {
            yield 0 => ($this->privates['slugger'] ?? ($this->privates['slugger'] = new \Symfony\Component\String\Slugger\AsciiSlugger('en')));
            yield 1 => ($this->privates['translator.default'] ?? $this->getTranslator_DefaultService());
            yield 2 => ($this->services['translator'] ?? $this->getTranslatorService());
        }, 3), ($this->services['request_stack'] ?? ($this->services['request_stack'] = new \Symfony\Component\HttpFoundation\RequestStack())));
    }

    /*
     * Gets the private 'locale_listener' shared service.
     *
     * @return \Symfony\Component\HttpKernel\EventListener\LocaleListener
     */
    protected function getLocaleListenerService()
    {
        $a = ($this->services['router'] ?? $this->getRouterService());

        if (isset($this->privates['locale_listener'])) {
            return $this->privates['locale_listener'];
        }

        return $this->privates['locale_listener'] = new \Symfony\Component\HttpKernel\EventListener\LocaleListener(($this->services['request_stack'] ?? ($this->services['request_stack'] = new \Symfony\Component\HttpFoundation\RequestStack())), 'en', $a, false, []);
    }

    /*
     * Gets the private 'monolog.handler.console' shared service.
     *
     * @return \Symfony\Bridge\Monolog\Handler\ConsoleHandler
     */
    protected function getMonolog_Handler_ConsoleService()
    {
        $this->privates['monolog.handler.console'] = $instance = new \Symfony\Bridge\Monolog\Handler\ConsoleHandler(NULL, true, [], []);

        $instance->pushProcessor(($this->privates['monolog.processor.psr_log_message'] ?? ($this->privates['monolog.processor.psr_log_message'] = new \Monolog\Processor\PsrLogMessageProcessor())));

        return $instance;
    }

    /*
     * Gets the private 'monolog.handler.main' shared service.
     *
     * @return \Monolog\Handler\FingersCrossedHandler
     */
    protected function getMonolog_Handler_MainService()
    {
        $a = new \Monolog\Handler\RotatingFileHandler((\dirname(__DIR__, 3).'/logs/prod.log'), 10, 200, true, NULL, false);
        $a->pushProcessor(($this->privates['monolog.processor.psr_log_message'] ?? ($this->privates['monolog.processor.psr_log_message'] = new \Monolog\Processor\PsrLogMessageProcessor())));
        $a->setFilenameFormat('{filename}-{date}', 'Y-m-d');

        return $this->privates['monolog.handler.main'] = new \Monolog\Handler\FingersCrossedHandler($a, new \Symfony\Bridge\Monolog\Handler\FingersCrossed\HttpCodeActivationStrategy(($this->services['request_stack'] ?? ($this->services['request_stack'] = new \Symfony\Component\HttpFoundation\RequestStack())), [0 => ['code' => 400, 'urls' => []], 1 => ['code' => 401, 'urls' => []], 2 => ['code' => 403, 'urls' => []], 3 => ['code' => 404, 'urls' => []], 4 => ['code' => 503, 'urls' => []]], new \Monolog\Handler\FingersCrossed\ErrorLevelActivationStrategy(400)), 0, true, true, NULL);
    }

    /*
     * Gets the private 'monolog.logger' shared service.
     *
     * @return \Symfony\Bridge\Monolog\Logger
     */
    protected function getMonolog_LoggerService()
    {
        $this->privates['monolog.logger'] = $instance = new \Symfony\Bridge\Monolog\Logger('app');

        $instance->pushProcessor(($this->privates['contao.monolog.processor'] ?? $this->getContao_Monolog_ProcessorService()));
        $instance->useMicrosecondTimestamps(true);
        $instance->pushHandler(($this->privates['monolog.handler.console'] ?? $this->getMonolog_Handler_ConsoleService()));
        $instance->pushHandler(($this->privates['monolog.handler.main'] ?? $this->getMonolog_Handler_MainService()));
        $instance->pushHandler(($this->privates['contao.monolog.handler'] ?? $this->getContao_Monolog_HandlerService()));

        return $instance;
    }

    /*
     * Gets the private 'monolog.logger.cache' shared service.
     *
     * @return \Symfony\Bridge\Monolog\Logger
     */
    protected function getMonolog_Logger_CacheService()
    {
        $this->privates['monolog.logger.cache'] = $instance = new \Symfony\Bridge\Monolog\Logger('cache');

        $instance->pushProcessor(($this->privates['contao.monolog.processor'] ?? $this->getContao_Monolog_ProcessorService()));
        $instance->pushHandler(($this->privates['monolog.handler.console'] ?? $this->getMonolog_Handler_ConsoleService()));
        $instance->pushHandler(($this->privates['monolog.handler.main'] ?? $this->getMonolog_Handler_MainService()));
        $instance->pushHandler(($this->privates['contao.monolog.handler'] ?? $this->getContao_Monolog_HandlerService()));

        return $instance;
    }

    /*
     * Gets the private 'monolog.logger.request' shared service.
     *
     * @return \Symfony\Bridge\Monolog\Logger
     */
    protected function getMonolog_Logger_RequestService()
    {
        $this->privates['monolog.logger.request'] = $instance = new \Symfony\Bridge\Monolog\Logger('request');

        $instance->pushProcessor(($this->privates['contao.monolog.processor'] ?? $this->getContao_Monolog_ProcessorService()));
        $instance->pushHandler(($this->privates['monolog.handler.console'] ?? $this->getMonolog_Handler_ConsoleService()));
        $instance->pushHandler(($this->privates['monolog.handler.main'] ?? $this->getMonolog_Handler_MainService()));
        $instance->pushHandler(($this->privates['contao.monolog.handler'] ?? $this->getContao_Monolog_HandlerService()));

        return $instance;
    }

    /*
     * Gets the private 'nelmio_cors.cors_listener' shared service.
     *
     * @return \Nelmio\CorsBundle\EventListener\CorsListener
     */
    protected function getNelmioCors_CorsListenerService()
    {
        $a = ($this->services['doctrine.dbal.default_connection'] ?? $this->getDoctrine_Dbal_DefaultConnectionService());

        if (isset($this->privates['nelmio_cors.cors_listener'])) {
            return $this->privates['nelmio_cors.cors_listener'];
        }

        return $this->privates['nelmio_cors.cors_listener'] = new \Nelmio\CorsBundle\EventListener\CorsListener(new \Nelmio\CorsBundle\Options\Resolver([0 => new \Nelmio\CorsBundle\Options\ConfigProvider([], $this->parameters['nelmio_cors.defaults']), 1 => new \Contao\CoreBundle\Cors\WebsiteRootsConfigProvider($a)]));
    }

    /*
     * Gets the private 'nelmio_security.clickjacking_listener' shared service.
     *
     * @return \Nelmio\SecurityBundle\EventListener\ClickjackingListener
     */
    protected function getNelmioSecurity_ClickjackingListenerService()
    {
        return $this->privates['nelmio_security.clickjacking_listener'] = new \Nelmio\SecurityBundle\EventListener\ClickjackingListener($this->parameters['nelmio_security.clickjacking.paths'], []);
    }

    /*
     * Gets the private 'nelmio_security.csp_listener' shared service.
     *
     * @return \Nelmio\SecurityBundle\EventListener\ContentSecurityPolicyListener
     */
    protected function getNelmioSecurity_CspListenerService()
    {
        $a = new \Nelmio\SecurityBundle\ContentSecurityPolicy\PolicyManager();

        return $this->privates['nelmio_security.csp_listener'] = new \Nelmio\SecurityBundle\EventListener\ContentSecurityPolicyListener(\Nelmio\SecurityBundle\ContentSecurityPolicy\DirectiveSet::fromConfig($a, ['enabled' => true, 'hosts' => [], 'content_types' => [], 'report_endpoint' => ['log_channel' => NULL, 'log_formatter' => 'nelmio_security.csp_report.log_formatter', 'log_level' => 'notice', 'filters' => ['domains' => true, 'schemes' => true, 'browser_bugs' => true, 'injected_scripts' => true], 'dismiss' => []], 'compat_headers' => true, 'report_logger_service' => 'logger', 'hash' => ['algorithm' => 'sha256']], 'report'), \Nelmio\SecurityBundle\ContentSecurityPolicy\DirectiveSet::fromConfig($a, ['enabled' => true, 'hosts' => [], 'content_types' => [], 'report_endpoint' => ['log_channel' => NULL, 'log_formatter' => 'nelmio_security.csp_report.log_formatter', 'log_level' => 'notice', 'filters' => ['domains' => true, 'schemes' => true, 'browser_bugs' => true, 'injected_scripts' => true], 'dismiss' => []], 'compat_headers' => true, 'report_logger_service' => 'logger', 'hash' => ['algorithm' => 'sha256']], 'enforce'), new \Nelmio\SecurityBundle\ContentSecurityPolicy\NonceGenerator(16), ($this->privates['nelmio_security.sha_computer'] ?? ($this->privates['nelmio_security.sha_computer'] = new \Nelmio\SecurityBundle\ContentSecurityPolicy\ShaComputer('sha256'))), true, [], []);
    }

    /*
     * Gets the private 'nelmio_security.referrer_policy_listener' shared service.
     *
     * @return \Nelmio\SecurityBundle\EventListener\ReferrerPolicyListener
     */
    protected function getNelmioSecurity_ReferrerPolicyListenerService()
    {
        return $this->privates['nelmio_security.referrer_policy_listener'] = new \Nelmio\SecurityBundle\EventListener\ReferrerPolicyListener($this->parameters['nelmio_security.referrer_policy.policies']);
    }

    /*
     * Gets the private 'nelmio_security.xss_protection_listener' shared service.
     *
     * @return \Nelmio\SecurityBundle\EventListener\XssProtectionListener
     */
    protected function getNelmioSecurity_XssProtectionListenerService()
    {
        return $this->privates['nelmio_security.xss_protection_listener'] = \Nelmio\SecurityBundle\EventListener\XssProtectionListener::fromConfig(['enabled' => true, 'mode_block' => true, 'report_uri' => NULL]);
    }

    /*
     * Gets the private 'parameter_bag' shared service.
     *
     * @return \Symfony\Component\DependencyInjection\ParameterBag\ContainerBag
     */
    protected function getParameterBagService()
    {
        return $this->privates['parameter_bag'] = new \Symfony\Component\DependencyInjection\ParameterBag\ContainerBag($this);
    }

    /*
     * Gets the private 'router.expression_language_provider' shared service.
     *
     * @return \Symfony\Component\Routing\Matcher\ExpressionLanguageProvider
     */
    protected function getRouter_ExpressionLanguageProviderService()
    {
        return $this->privates['router.expression_language_provider'] = new \Symfony\Component\Routing\Matcher\ExpressionLanguageProvider(new \Symfony\Component\DependencyInjection\Argument\ServiceLocator($this->getService, [
            'env' => ['privates', 'container.getenv', 'getContainer_GetenvService', true],
        ], [
            'env' => 'Closure',
        ]));
    }

    /*
     * Gets the private 'router.request_context' shared service.
     *
     * @return \Symfony\Component\Routing\RequestContext
     */
    protected function getRouter_RequestContextService()
    {
        $this->privates['router.request_context'] = $instance = \Symfony\Component\Routing\RequestContext::fromUri('', 'localhost', 'http', 80, 443);

        $instance->setParameter('_functions', ($this->privates['router.expression_language_provider'] ?? $this->getRouter_ExpressionLanguageProviderService()));

        return $instance;
    }

    /*
     * Gets the private 'router_listener' shared service.
     *
     * @return \Symfony\Component\HttpKernel\EventListener\RouterListener
     */
    protected function getRouterListenerService()
    {
        $a = ($this->services['router'] ?? $this->getRouterService());

        if (isset($this->privates['router_listener'])) {
            return $this->privates['router_listener'];
        }

        return $this->privates['router_listener'] = new \Symfony\Component\HttpKernel\EventListener\RouterListener($a, ($this->services['request_stack'] ?? ($this->services['request_stack'] = new \Symfony\Component\HttpFoundation\RequestStack())), ($this->privates['router.request_context'] ?? $this->getRouter_RequestContextService()), ($this->privates['monolog.logger.request'] ?? $this->getMonolog_Logger_RequestService()), \dirname(__DIR__, 4), false);
    }

    /*
     * Gets the private 'scheb_two_factor.provider_preparation_recorder' shared service.
     *
     * @return \Scheb\TwoFactorBundle\Security\TwoFactor\Provider\TokenPreparationRecorder
     */
    protected function getSchebTwoFactor_ProviderPreparationRecorderService()
    {
        return $this->privates['scheb_two_factor.provider_preparation_recorder'] = new \Scheb\TwoFactorBundle\Security\TwoFactor\Provider\TokenPreparationRecorder(($this->services['.container.private.security.token_storage'] ?? $this->get_Container_Private_Security_TokenStorageService()));
    }

    /*
     * Gets the private 'scheb_two_factor.provider_registry' shared service.
     *
     * @return \Scheb\TwoFactorBundle\Security\TwoFactor\Provider\TwoFactorProviderRegistry
     */
    protected function getSchebTwoFactor_ProviderRegistryService()
    {
        return $this->privates['scheb_two_factor.provider_registry'] = new \Scheb\TwoFactorBundle\Security\TwoFactor\Provider\TwoFactorProviderRegistry(new RewindableGenerator(function () {
            yield 'contao' => ($this->privates['contao.security.two_factor.provider'] ?? $this->load('getContao_Security_TwoFactor_ProviderService'));
        }, 1));
    }

    /*
     * Gets the private 'scheb_two_factor.trusted_cookie_response_listener' shared service.
     *
     * @return \Scheb\TwoFactorBundle\Security\TwoFactor\Trusted\TrustedCookieResponseListener
     */
    protected function getSchebTwoFactor_TrustedCookieResponseListenerService($lazyLoad = true)
    {
        if ($lazyLoad) {
            return $this->privates['scheb_two_factor.trusted_cookie_response_listener'] = $this->createProxy('TrustedCookieResponseListener_c7f9b85', function () {
                return \TrustedCookieResponseListener_c7f9b85::staticProxyConstructor(function (&$wrappedInstance, \ProxyManager\Proxy\LazyLoadingInterface $proxy) {
                    $wrappedInstance = $this->getSchebTwoFactor_TrustedCookieResponseListenerService(false);

                    $proxy->setProxyInitializer(null);

                    return true;
                });
            });
        }

        include_once \dirname(__DIR__, 4).'/vendor/scheb/2fa-trusted-device/Security/TwoFactor/Trusted/TrustedCookieResponseListener.php';

        return new \Scheb\TwoFactorBundle\Security\TwoFactor\Trusted\TrustedCookieResponseListener(($this->privates['scheb_two_factor.trusted_token_storage'] ?? $this->getSchebTwoFactor_TrustedTokenStorageService()), 5184000, 'trusted_device', NULL, 'lax', '/', NULL);
    }

    /*
     * Gets the private 'scheb_two_factor.trusted_token_storage' shared service.
     *
     * @return \Scheb\TwoFactorBundle\Security\TwoFactor\Trusted\TrustedDeviceTokenStorage
     */
    protected function getSchebTwoFactor_TrustedTokenStorageService($lazyLoad = true)
    {
        if ($lazyLoad) {
            return $this->privates['scheb_two_factor.trusted_token_storage'] = $this->createProxy('TrustedDeviceTokenStorage_fc7b3c4', function () {
                return \TrustedDeviceTokenStorage_fc7b3c4::staticProxyConstructor(function (&$wrappedInstance, \ProxyManager\Proxy\LazyLoadingInterface $proxy) {
                    $wrappedInstance = $this->getSchebTwoFactor_TrustedTokenStorageService(false);

                    $proxy->setProxyInitializer(null);

                    return true;
                });
            });
        }

        include_once \dirname(__DIR__, 4).'/vendor/scheb/2fa-trusted-device/Security/TwoFactor/Trusted/TrustedDeviceTokenStorage.php';
        include_once \dirname(__DIR__, 4).'/vendor/scheb/2fa-trusted-device/Security/TwoFactor/Trusted/TrustedDeviceTokenEncoder.php';
        include_once \dirname(__DIR__, 4).'/vendor/scheb/2fa-trusted-device/Security/TwoFactor/Trusted/JwtTokenEncoder.php';

        return new \Scheb\TwoFactorBundle\Security\TwoFactor\Trusted\TrustedDeviceTokenStorage(($this->services['request_stack'] ?? ($this->services['request_stack'] = new \Symfony\Component\HttpFoundation\RequestStack())), new \Scheb\TwoFactorBundle\Security\TwoFactor\Trusted\TrustedDeviceTokenEncoder(new \Scheb\TwoFactorBundle\Security\TwoFactor\Trusted\JwtTokenEncoder($this->getEnv('APP_SECRET')), 5184000), 'trusted_device');
    }

    /*
     * Gets the private 'security.authentication.provider_preparation_listener.two_factor.contao_backend' shared service.
     *
     * @return \Scheb\TwoFactorBundle\Security\TwoFactor\Provider\TwoFactorProviderPreparationListener
     */
    protected function getSecurity_Authentication_ProviderPreparationListener_TwoFactor_ContaoBackendService()
    {
        return $this->privates['security.authentication.provider_preparation_listener.two_factor.contao_backend'] = new \Scheb\TwoFactorBundle\Security\TwoFactor\Provider\TwoFactorProviderPreparationListener(($this->privates['scheb_two_factor.provider_registry'] ?? $this->getSchebTwoFactor_ProviderRegistryService()), ($this->privates['scheb_two_factor.provider_preparation_recorder'] ?? $this->getSchebTwoFactor_ProviderPreparationRecorderService()), ($this->privates['monolog.logger'] ?? $this->getMonolog_LoggerService()), 'contao_backend', true, false);
    }

    /*
     * Gets the private 'security.authentication.provider_preparation_listener.two_factor.contao_frontend' shared service.
     *
     * @return \Scheb\TwoFactorBundle\Security\TwoFactor\Provider\TwoFactorProviderPreparationListener
     */
    protected function getSecurity_Authentication_ProviderPreparationListener_TwoFactor_ContaoFrontendService()
    {
        return $this->privates['security.authentication.provider_preparation_listener.two_factor.contao_frontend'] = new \Scheb\TwoFactorBundle\Security\TwoFactor\Provider\TwoFactorProviderPreparationListener(($this->privates['scheb_two_factor.provider_registry'] ?? $this->getSchebTwoFactor_ProviderRegistryService()), ($this->privates['scheb_two_factor.provider_preparation_recorder'] ?? $this->getSchebTwoFactor_ProviderPreparationRecorderService()), ($this->privates['monolog.logger'] ?? $this->getMonolog_LoggerService()), 'contao_frontend', true, false);
    }

    /*
     * Gets the private 'security.firewall' shared service.
     *
     * @return \Symfony\Bundle\SecurityBundle\EventListener\FirewallListener
     */
    protected function getSecurity_FirewallService()
    {
        $a = ($this->services['security.firewall.map'] ?? $this->getSecurity_Firewall_MapService());

        if (isset($this->privates['security.firewall'])) {
            return $this->privates['security.firewall'];
        }
        $b = ($this->services['event_dispatcher'] ?? $this->getEventDispatcherService());

        if (isset($this->privates['security.firewall'])) {
            return $this->privates['security.firewall'];
        }

        return $this->privates['security.firewall'] = new \Symfony\Bundle\SecurityBundle\EventListener\FirewallListener($a, $b, ($this->services['security.logout_url_generator'] ?? $this->getSecurity_LogoutUrlGeneratorService()));
    }

    /*
     * Gets the private 'session.factory' shared service.
     *
     * @return \Symfony\Component\HttpFoundation\Session\SessionFactory
     */
    protected function getSession_FactoryService()
    {
        $a = ($this->privates['session_listener'] ?? $this->getSessionListenerService());

        if (isset($this->privates['session.factory'])) {
            return $this->privates['session.factory'];
        }

        return $this->privates['session.factory'] = new \Symfony\Component\HttpFoundation\Session\SessionFactory(($this->services['request_stack'] ?? ($this->services['request_stack'] = new \Symfony\Component\HttpFoundation\RequestStack())), $this->load('getSession_Storage_Factory_ServiceService'), [0 => $a, 1 => 'onSessionUsage']);
    }

    /*
     * Gets the private 'session_listener' shared service.
     *
     * @return \Symfony\Component\HttpKernel\EventListener\SessionListener
     */
    protected function getSessionListenerService()
    {
        return $this->privates['session_listener'] = new \Symfony\Component\HttpKernel\EventListener\SessionListener(new \Symfony\Component\DependencyInjection\Argument\ServiceLocator($this->getService, [
            'initialized_session' => ['services', '.container.private.session', NULL, false],
            'logger' => ['privates', 'monolog.logger', 'getMonolog_LoggerService', false],
            'request_stack' => ['services', 'request_stack', 'getRequestStackService', false],
            'session' => ['services', '.container.private.session', 'get_Container_Private_SessionService', false],
            'session_factory' => ['privates', 'session.factory', 'getSession_FactoryService', false],
            'session_storage' => ['privates', 'session.storage.native', 'getSession_Storage_NativeService', true],
        ], [
            'initialized_session' => '?',
            'logger' => '?',
            'request_stack' => '?',
            'session' => '?',
            'session_factory' => '?',
            'session_storage' => '?',
        ]), false, $this->parameters['session.storage.options']);
    }

    /*
     * Gets the private 'translator.default' shared service.
     *
     * @return \Symfony\Bundle\FrameworkBundle\Translation\Translator
     */
    protected function getTranslator_DefaultService()
    {
        $this->privates['translator.default'] = $instance = new \Symfony\Bundle\FrameworkBundle\Translation\Translator(new \Symfony\Component\DependencyInjection\Argument\ServiceLocator($this->getService, [
            'translation.loader.csv' => ['privates', 'translation.loader.csv', 'getTranslation_Loader_CsvService', true],
            'translation.loader.dat' => ['privates', 'translation.loader.dat', 'getTranslation_Loader_DatService', true],
            'translation.loader.ini' => ['privates', 'translation.loader.ini', 'getTranslation_Loader_IniService', true],
            'translation.loader.json' => ['privates', 'translation.loader.json', 'getTranslation_Loader_JsonService', true],
            'translation.loader.mo' => ['privates', 'translation.loader.mo', 'getTranslation_Loader_MoService', true],
            'translation.loader.php' => ['privates', 'translation.loader.php', 'getTranslation_Loader_PhpService', true],
            'translation.loader.po' => ['privates', 'translation.loader.po', 'getTranslation_Loader_PoService', true],
            'translation.loader.qt' => ['privates', 'translation.loader.qt', 'getTranslation_Loader_QtService', true],
            'translation.loader.res' => ['privates', 'translation.loader.res', 'getTranslation_Loader_ResService', true],
            'translation.loader.xliff' => ['privates', 'translation.loader.xliff', 'getTranslation_Loader_XliffService', true],
            'translation.loader.yml' => ['privates', 'translation.loader.yml', 'getTranslation_Loader_YmlService', true],
        ], [
            'translation.loader.csv' => '?',
            'translation.loader.dat' => '?',
            'translation.loader.ini' => '?',
            'translation.loader.json' => '?',
            'translation.loader.mo' => '?',
            'translation.loader.php' => '?',
            'translation.loader.po' => '?',
            'translation.loader.qt' => '?',
            'translation.loader.res' => '?',
            'translation.loader.xliff' => '?',
            'translation.loader.yml' => '?',
        ]), new \Symfony\Component\Translation\Formatter\MessageFormatter(new \Symfony\Component\Translation\IdentityTranslator()), 'en', ['translation.loader.php' => [0 => 'php'], 'translation.loader.yml' => [0 => 'yaml', 1 => 'yml'], 'translation.loader.xliff' => [0 => 'xlf', 1 => 'xliff'], 'translation.loader.po' => [0 => 'po'], 'translation.loader.mo' => [0 => 'mo'], 'translation.loader.qt' => [0 => 'ts'], 'translation.loader.csv' => [0 => 'csv'], 'translation.loader.res' => [0 => 'res'], 'translation.loader.dat' => [0 => 'dat'], 'translation.loader.ini' => [0 => 'ini'], 'translation.loader.json' => [0 => 'json']], ['cache_dir' => ($this->targetDir.''.'/translations'), 'debug' => false, 'resource_files' => ['af' => [0 => (\dirname(__DIR__, 4).'/vendor/symfony/security-core/Resources/translations/security.af.xlf')], 'ar' => [0 => (\dirname(__DIR__, 4).'/vendor/symfony/security-core/Resources/translations/security.ar.xlf'), 1 => (\dirname(__DIR__, 4).'/vendor/knplabs/knp-time-bundle/src/Resources/translations/time.ar.xliff')], 'az' => [0 => (\dirname(__DIR__, 4).'/vendor/symfony/security-core/Resources/translations/security.az.xlf')], 'be' => [0 => (\dirname(__DIR__, 4).'/vendor/symfony/security-core/Resources/translations/security.be.xlf')], 'bg' => [0 => (\dirname(__DIR__, 4).'/vendor/symfony/security-core/Resources/translations/security.bg.xlf'), 1 => (\dirname(__DIR__, 4).'/vendor/knplabs/knp-time-bundle/src/Resources/translations/time.bg.xliff')], 'bs' => [0 => (\dirname(__DIR__, 4).'/vendor/symfony/security-core/Resources/translations/security.bs.xlf')], 'ca' => [0 => (\dirname(__DIR__, 4).'/vendor/symfony/security-core/Resources/translations/security.ca.xlf'), 1 => (\dirname(__DIR__, 4).'/vendor/knplabs/knp-time-bundle/src/Resources/translations/time.ca.xliff')], 'cs' => [0 => (\dirname(__DIR__, 4).'/vendor/symfony/security-core/Resources/translations/security.cs.xlf'), 1 => (\dirname(__DIR__, 4).'/vendor/scheb/2fa-bundle/Resources/translations/SchebTwoFactorBundle.cs.yml'), 2 => (\dirname(__DIR__, 4).'/vendor/knplabs/knp-time-bundle/src/Resources/translations/time.cs.xliff'), 3 => (\dirname(__DIR__, 4).'/vendor/contao/manager-bundle/src/Resources/translations/ContaoManagerBundle.cs.xlf'), 4 => (\dirname(__DIR__, 4).'/vendor/contao/installation-bundle/src/Resources/translations/ContaoInstallationBundle.cs.xlf')], 'da' => [0 => (\dirname(__DIR__, 4).'/vendor/symfony/security-core/Resources/translations/security.da.xlf'), 1 => (\dirname(__DIR__, 4).'/vendor/knplabs/knp-time-bundle/src/Resources/translations/time.da.xliff')], 'de' => [0 => (\dirname(__DIR__, 4).'/vendor/symfony/security-core/Resources/translations/security.de.xlf'), 1 => (\dirname(__DIR__, 4).'/vendor/scheb/2fa-bundle/Resources/translations/SchebTwoFactorBundle.de.yml'), 2 => (\dirname(__DIR__, 4).'/vendor/knplabs/knp-time-bundle/src/Resources/translations/time.de.xliff'), 3 => (\dirname(__DIR__, 4).'/vendor/contao/manager-bundle/src/Resources/translations/ContaoManagerBundle.de.xlf'), 4 => (\dirname(__DIR__, 4).'/vendor/contao/installation-bundle/src/Resources/translations/ContaoInstallationBundle.de.xlf')], 'el' => [0 => (\dirname(__DIR__, 4).'/vendor/symfony/security-core/Resources/translations/security.el.xlf')], 'en' => [0 => (\dirname(__DIR__, 4).'/vendor/symfony/security-core/Resources/translations/security.en.xlf'), 1 => (\dirname(__DIR__, 4).'/vendor/scheb/2fa-bundle/Resources/translations/SchebTwoFactorBundle.en.yml'), 2 => (\dirname(__DIR__, 4).'/vendor/knplabs/knp-time-bundle/src/Resources/translations/time.en.xliff'), 3 => (\dirname(__DIR__, 4).'/vendor/contao/manager-bundle/src/Resources/translations/ContaoManagerBundle.en.xlf'), 4 => (\dirname(__DIR__, 4).'/vendor/contao/installation-bundle/src/Resources/translations/ContaoInstallationBundle.en.xlf')], 'es' => [0 => (\dirname(__DIR__, 4).'/vendor/symfony/security-core/Resources/translations/security.es.xlf'), 1 => (\dirname(__DIR__, 4).'/vendor/scheb/2fa-bundle/Resources/translations/SchebTwoFactorBundle.es.yml'), 2 => (\dirname(__DIR__, 4).'/vendor/knplabs/knp-time-bundle/src/Resources/translations/time.es.xliff'), 3 => (\dirname(__DIR__, 4).'/vendor/contao/manager-bundle/src/Resources/translations/ContaoManagerBundle.es.xlf'), 4 => (\dirname(__DIR__, 4).'/vendor/contao/installation-bundle/src/Resources/translations/ContaoInstallationBundle.es.xlf')], 'et' => [0 => (\dirname(__DIR__, 4).'/vendor/symfony/security-core/Resources/translations/security.et.xlf')], 'eu' => [0 => (\dirname(__DIR__, 4).'/vendor/symfony/security-core/Resources/translations/security.eu.xlf'), 1 => (\dirname(__DIR__, 4).'/vendor/knplabs/knp-time-bundle/src/Resources/translations/time.eu.xliff')], 'fa' => [0 => (\dirname(__DIR__, 4).'/vendor/symfony/security-core/Resources/translations/security.fa.xlf')], 'fi' => [0 => (\dirname(__DIR__, 4).'/vendor/symfony/security-core/Resources/translations/security.fi.xlf'), 1 => (\dirname(__DIR__, 4).'/vendor/knplabs/knp-time-bundle/src/Resources/translations/time.fi.xliff')], 'fr' => [0 => (\dirname(__DIR__, 4).'/vendor/symfony/security-core/Resources/translations/security.fr.xlf'), 1 => (\dirname(__DIR__, 4).'/vendor/scheb/2fa-bundle/Resources/translations/SchebTwoFactorBundle.fr.yml'), 2 => (\dirname(__DIR__, 4).'/vendor/knplabs/knp-time-bundle/src/Resources/translations/time.fr.xliff'), 3 => (\dirname(__DIR__, 4).'/vendor/contao/manager-bundle/src/Resources/translations/ContaoManagerBundle.fr.xlf'), 4 => (\dirname(__DIR__, 4).'/vendor/contao/installation-bundle/src/Resources/translations/ContaoInstallationBundle.fr.xlf')], 'gl' => [0 => (\dirname(__DIR__, 4).'/vendor/symfony/security-core/Resources/translations/security.gl.xlf')], 'he' => [0 => (\dirname(__DIR__, 4).'/vendor/symfony/security-core/Resources/translations/security.he.xlf')], 'hr' => [0 => (\dirname(__DIR__, 4).'/vendor/symfony/security-core/Resources/translations/security.hr.xlf'), 1 => (\dirname(__DIR__, 4).'/vendor/scheb/2fa-bundle/Resources/translations/SchebTwoFactorBundle.hr.yml')], 'hu' => [0 => (\dirname(__DIR__, 4).'/vendor/symfony/security-core/Resources/translations/security.hu.xlf'), 1 => (\dirname(__DIR__, 4).'/vendor/scheb/2fa-bundle/Resources/translations/SchebTwoFactorBundle.hu.yml'), 2 => (\dirname(__DIR__, 4).'/vendor/knplabs/knp-time-bundle/src/Resources/translations/time.hu.xliff')], 'hy' => [0 => (\dirname(__DIR__, 4).'/vendor/symfony/security-core/Resources/translations/security.hy.xlf')], 'id' => [0 => (\dirname(__DIR__, 4).'/vendor/symfony/security-core/Resources/translations/security.id.xlf'), 1 => (\dirname(__DIR__, 4).'/vendor/knplabs/knp-time-bundle/src/Resources/translations/time.id.xliff')], 'it' => [0 => (\dirname(__DIR__, 4).'/vendor/symfony/security-core/Resources/translations/security.it.xlf'), 1 => (\dirname(__DIR__, 4).'/vendor/knplabs/knp-time-bundle/src/Resources/translations/time.it.xliff'), 2 => (\dirname(__DIR__, 4).'/vendor/contao/manager-bundle/src/Resources/translations/ContaoManagerBundle.it.xlf'), 3 => (\dirname(__DIR__, 4).'/vendor/contao/installation-bundle/src/Resources/translations/ContaoInstallationBundle.it.xlf')], 'ja' => [0 => (\dirname(__DIR__, 4).'/vendor/symfony/security-core/Resources/translations/security.ja.xlf'), 1 => (\dirname(__DIR__, 4).'/vendor/knplabs/knp-time-bundle/src/Resources/translations/time.ja.xliff'), 2 => (\dirname(__DIR__, 4).'/vendor/contao/manager-bundle/src/Resources/translations/ContaoManagerBundle.ja.xlf'), 3 => (\dirname(__DIR__, 4).'/vendor/contao/installation-bundle/src/Resources/translations/ContaoInstallationBundle.ja.xlf')], 'lb' => [0 => (\dirname(__DIR__, 4).'/vendor/symfony/security-core/Resources/translations/security.lb.xlf')], 'lt' => [0 => (\dirname(__DIR__, 4).'/vendor/symfony/security-core/Resources/translations/security.lt.xlf'), 1 => (\dirname(__DIR__, 4).'/vendor/knplabs/knp-time-bundle/src/Resources/translations/time.lt.xliff')], 'lv' => [0 => (\dirname(__DIR__, 4).'/vendor/symfony/security-core/Resources/translations/security.lv.xlf'), 1 => (\dirname(__DIR__, 4).'/vendor/contao/manager-bundle/src/Resources/translations/ContaoManagerBundle.lv.xlf'), 2 => (\dirname(__DIR__, 4).'/vendor/contao/installation-bundle/src/Resources/translations/ContaoInstallationBundle.lv.xlf')], 'mn' => [0 => (\dirname(__DIR__, 4).'/vendor/symfony/security-core/Resources/translations/security.mn.xlf')], 'my' => [0 => (\dirname(__DIR__, 4).'/vendor/symfony/security-core/Resources/translations/security.my.xlf')], 'nb' => [0 => (\dirname(__DIR__, 4).'/vendor/symfony/security-core/Resources/translations/security.nb.xlf'), 1 => (\dirname(__DIR__, 4).'/vendor/knplabs/knp-time-bundle/src/Resources/translations/time.nb.xliff')], 'nl' => [0 => (\dirname(__DIR__, 4).'/vendor/symfony/security-core/Resources/translations/security.nl.xlf'), 1 => (\dirname(__DIR__, 4).'/vendor/scheb/2fa-bundle/Resources/translations/SchebTwoFactorBundle.nl.yml'), 2 => (\dirname(__DIR__, 4).'/vendor/knplabs/knp-time-bundle/src/Resources/translations/time.nl.xliff'), 3 => (\dirname(__DIR__, 4).'/vendor/contao/manager-bundle/src/Resources/translations/ContaoManagerBundle.nl.xlf'), 4 => (\dirname(__DIR__, 4).'/vendor/contao/installation-bundle/src/Resources/translations/ContaoInstallationBundle.nl.xlf')], 'nn' => [0 => (\dirname(__DIR__, 4).'/vendor/symfony/security-core/Resources/translations/security.nn.xlf'), 1 => (\dirname(__DIR__, 4).'/vendor/knplabs/knp-time-bundle/src/Resources/translations/time.nn.xliff')], 'no' => [0 => (\dirname(__DIR__, 4).'/vendor/symfony/security-core/Resources/translations/security.no.xlf')], 'pl' => [0 => (\dirname(__DIR__, 4).'/vendor/symfony/security-core/Resources/translations/security.pl.xlf'), 1 => (\dirname(__DIR__, 4).'/vendor/scheb/2fa-bundle/Resources/translations/SchebTwoFactorBundle.pl.yml'), 2 => (\dirname(__DIR__, 4).'/vendor/knplabs/knp-time-bundle/src/Resources/translations/time.pl.xliff'), 3 => (\dirname(__DIR__, 4).'/vendor/contao/manager-bundle/src/Resources/translations/ContaoManagerBundle.pl.xlf'), 4 => (\dirname(__DIR__, 4).'/vendor/contao/installation-bundle/src/Resources/translations/ContaoInstallationBundle.pl.xlf')], 'pt' => [0 => (\dirname(__DIR__, 4).'/vendor/symfony/security-core/Resources/translations/security.pt.xlf'), 1 => (\dirname(__DIR__, 4).'/vendor/knplabs/knp-time-bundle/src/Resources/translations/time.pt.xliff'), 2 => (\dirname(__DIR__, 4).'/vendor/contao/manager-bundle/src/Resources/translations/ContaoManagerBundle.pt.xlf'), 3 => (\dirname(__DIR__, 4).'/vendor/contao/installation-bundle/src/Resources/translations/ContaoInstallationBundle.pt.xlf')], 'pt_BR' => [0 => (\dirname(__DIR__, 4).'/vendor/symfony/security-core/Resources/translations/security.pt_BR.xlf'), 1 => (\dirname(__DIR__, 4).'/vendor/knplabs/knp-time-bundle/src/Resources/translations/time.pt_BR.xliff')], 'ro' => [0 => (\dirname(__DIR__, 4).'/vendor/symfony/security-core/Resources/translations/security.ro.xlf'), 1 => (\dirname(__DIR__, 4).'/vendor/scheb/2fa-bundle/Resources/translations/SchebTwoFactorBundle.ro.yml'), 2 => (\dirname(__DIR__, 4).'/vendor/knplabs/knp-time-bundle/src/Resources/translations/time.ro.xliff')], 'ru' => [0 => (\dirname(__DIR__, 4).'/vendor/symfony/security-core/Resources/translations/security.ru.xlf'), 1 => (\dirname(__DIR__, 4).'/vendor/scheb/2fa-bundle/Resources/translations/SchebTwoFactorBundle.ru.yml'), 2 => (\dirname(__DIR__, 4).'/vendor/knplabs/knp-time-bundle/src/Resources/translations/time.ru.xliff'), 3 => (\dirname(__DIR__, 4).'/vendor/contao/manager-bundle/src/Resources/translations/ContaoManagerBundle.ru.xlf'), 4 => (\dirname(__DIR__, 4).'/vendor/contao/installation-bundle/src/Resources/translations/ContaoInstallationBundle.ru.xlf')], 'sk' => [0 => (\dirname(__DIR__, 4).'/vendor/symfony/security-core/Resources/translations/security.sk.xlf'), 1 => (\dirname(__DIR__, 4).'/vendor/scheb/2fa-bundle/Resources/translations/SchebTwoFactorBundle.sk.yml'), 2 => (\dirname(__DIR__, 4).'/vendor/knplabs/knp-time-bundle/src/Resources/translations/time.sk.xliff')], 'sl' => [0 => (\dirname(__DIR__, 4).'/vendor/symfony/security-core/Resources/translations/security.sl.xlf'), 1 => (\dirname(__DIR__, 4).'/vendor/knplabs/knp-time-bundle/src/Resources/translations/time.sl.xliff'), 2 => (\dirname(__DIR__, 4).'/vendor/contao/manager-bundle/src/Resources/translations/ContaoManagerBundle.sl.xlf')], 'sq' => [0 => (\dirname(__DIR__, 4).'/vendor/symfony/security-core/Resources/translations/security.sq.xlf')], 'sr_Cyrl' => [0 => (\dirname(__DIR__, 4).'/vendor/symfony/security-core/Resources/translations/security.sr_Cyrl.xlf')], 'sr_Latn' => [0 => (\dirname(__DIR__, 4).'/vendor/symfony/security-core/Resources/translations/security.sr_Latn.xlf')], 'sv' => [0 => (\dirname(__DIR__, 4).'/vendor/symfony/security-core/Resources/translations/security.sv.xlf'), 1 => (\dirname(__DIR__, 4).'/vendor/scheb/2fa-bundle/Resources/translations/SchebTwoFactorBundle.sv.yml'), 2 => (\dirname(__DIR__, 4).'/vendor/knplabs/knp-time-bundle/src/Resources/translations/time.sv.xliff'), 3 => (\dirname(__DIR__, 4).'/vendor/contao/manager-bundle/src/Resources/translations/ContaoManagerBundle.sv.xlf'), 4 => (\dirname(__DIR__, 4).'/vendor/contao/installation-bundle/src/Resources/translations/ContaoInstallationBundle.sv.xlf')], 'th' => [0 => (\dirname(__DIR__, 4).'/vendor/symfony/security-core/Resources/translations/security.th.xlf'), 1 => (\dirname(__DIR__, 4).'/vendor/knplabs/knp-time-bundle/src/Resources/translations/time.th.xliff')], 'tl' => [0 => (\dirname(__DIR__, 4).'/vendor/symfony/security-core/Resources/translations/security.tl.xlf')], 'tr' => [0 => (\dirname(__DIR__, 4).'/vendor/symfony/security-core/Resources/translations/security.tr.xlf'), 1 => (\dirname(__DIR__, 4).'/vendor/knplabs/knp-time-bundle/src/Resources/translations/time.tr.xliff'), 2 => (\dirname(__DIR__, 4).'/vendor/contao/manager-bundle/src/Resources/translations/ContaoManagerBundle.tr.xlf'), 3 => (\dirname(__DIR__, 4).'/vendor/contao/installation-bundle/src/Resources/translations/ContaoInstallationBundle.tr.xlf')], 'uk' => [0 => (\dirname(__DIR__, 4).'/vendor/symfony/security-core/Resources/translations/security.uk.xlf'), 1 => (\dirname(__DIR__, 4).'/vendor/scheb/2fa-bundle/Resources/translations/SchebTwoFactorBundle.uk.yml'), 2 => (\dirname(__DIR__, 4).'/vendor/knplabs/knp-time-bundle/src/Resources/translations/time.uk.xliff')], 'ur' => [0 => (\dirname(__DIR__, 4).'/vendor/symfony/security-core/Resources/translations/security.ur.xlf')], 'uz' => [0 => (\dirname(__DIR__, 4).'/vendor/symfony/security-core/Resources/translations/security.uz.xlf')], 'vi' => [0 => (\dirname(__DIR__, 4).'/vendor/symfony/security-core/Resources/translations/security.vi.xlf'), 1 => (\dirname(__DIR__, 4).'/vendor/knplabs/knp-time-bundle/src/Resources/translations/time.vi.xliff')], 'zh_CN' => [0 => (\dirname(__DIR__, 4).'/vendor/symfony/security-core/Resources/translations/security.zh_CN.xlf'), 1 => (\dirname(__DIR__, 4).'/vendor/knplabs/knp-time-bundle/src/Resources/translations/time.zh_CN.xliff')], 'zh_TW' => [0 => (\dirname(__DIR__, 4).'/vendor/symfony/security-core/Resources/translations/security.zh_TW.xlf'), 1 => (\dirname(__DIR__, 4).'/vendor/knplabs/knp-time-bundle/src/Resources/translations/time.zh_TW.xliff')], 'bs_Latn_BA' => [0 => (\dirname(__DIR__, 4).'/vendor/knplabs/knp-time-bundle/src/Resources/translations/time.bs_Latn_BA.xliff')], 'eo' => [0 => (\dirname(__DIR__, 4).'/vendor/knplabs/knp-time-bundle/src/Resources/translations/time.eo.xliff')], 'hr_HR' => [0 => (\dirname(__DIR__, 4).'/vendor/knplabs/knp-time-bundle/src/Resources/translations/time.hr_HR.xliff')], 'ky' => [0 => (\dirname(__DIR__, 4).'/vendor/knplabs/knp-time-bundle/src/Resources/translations/time.ky.xliff')], 'pt_PT' => [0 => (\dirname(__DIR__, 4).'/vendor/knplabs/knp-time-bundle/src/Resources/translations/time.pt_PT.xliff')], 'sr_Latin' => [0 => (\dirname(__DIR__, 4).'/vendor/knplabs/knp-time-bundle/src/Resources/translations/time.sr_Latin.xliff')], 'zh' => [0 => (\dirname(__DIR__, 4).'/vendor/knplabs/knp-time-bundle/src/Resources/translations/time.zh.xliff')], 'zh_HK' => [0 => (\dirname(__DIR__, 4).'/vendor/knplabs/knp-time-bundle/src/Resources/translations/time.zh_HK.xliff')], 'sr' => [0 => (\dirname(__DIR__, 4).'/vendor/contao/manager-bundle/src/Resources/translations/ContaoManagerBundle.sr.xlf'), 1 => (\dirname(__DIR__, 4).'/vendor/contao/installation-bundle/src/Resources/translations/ContaoInstallationBundle.sr.xlf')]], 'scanned_directories' => [0 => (\dirname(__DIR__, 4).'/vendor/symfony/security-core/Resources/translations'), 1 => (\dirname(__DIR__, 4).'/vendor/scheb/2fa-bundle/Resources/translations'), 2 => (\dirname(__DIR__, 4).'/vendor/knplabs/knp-time-bundle/src/Resources/translations'), 3 => (\dirname(__DIR__, 4).'/vendor/contao/manager-bundle/src/Resources/translations'), 4 => (\dirname(__DIR__, 4).'/vendor/contao/installation-bundle/src/Resources/translations'), 5 => (\dirname(__DIR__, 4).'/vendor/doctrine/doctrine-bundle/translations'), 6 => (\dirname(__DIR__, 4).'/vendor/symfony/framework-bundle/translations'), 7 => (\dirname(__DIR__, 4).'/vendor/symfony/monolog-bundle/translations'), 8 => (\dirname(__DIR__, 4).'/vendor/friendsofsymfony/http-cache-bundle/src/translations'), 9 => (\dirname(__DIR__, 4).'/vendor/nelmio/cors-bundle/translations'), 10 => (\dirname(__DIR__, 4).'/vendor/nelmio/security-bundle/translations'), 11 => (\dirname(__DIR__, 4).'/vendor/twig/extra-bundle/translations'), 12 => (\dirname(__DIR__, 4).'/vendor/knplabs/knp-menu-bundle/src/translations'), 13 => (\dirname(__DIR__, 4).'/vendor/symfony-cmf/routing-bundle/src/translations'), 14 => (\dirname(__DIR__, 4).'/vendor/symfony/twig-bundle/translations'), 15 => (\dirname(__DIR__, 4).'/vendor/terminal42/service-annotation-bundle/src/translations'), 16 => (\dirname(__DIR__, 4).'/vendor/symfony/security-bundle/translations'), 17 => (\dirname(__DIR__, 4).'/vendor/contao/core-bundle/src/translations'), 18 => (\dirname(__DIR__, 4).'/vendor/league/flysystem-bundle/src/translations'), 19 => (\dirname(__DIR__, 4).'/vendor/madeyourday/contao-rocksolid-antispam/src/translations'), 20 => (\dirname(__DIR__, 4).'/vendor/tabularasadev/contao-petitescdc/src/translations'), 21 => (\dirname(__DIR__, 4).'/vendor/menatwork/contao-multicolumnwizard-bundle/src/translations'), 22 => (\dirname(__DIR__, 4).'/vendor/inspiredminds/contao-wowjs/src/translations'), 23 => (\dirname(__DIR__, 4).'/system/modules/Subcolumns/translations'), 24 => (\dirname(__DIR__, 4).'/system/modules/mobile_menu/translations'), 25 => (\dirname(__DIR__, 4).'/vendor/contao/faq-bundle/src/translations'), 26 => (\dirname(__DIR__, 4).'/vendor/tabularasadev/contao-typechamp/src/translations'), 27 => (\dirname(__DIR__, 4).'/vendor/contao/comments-bundle/src/translations'), 28 => (\dirname(__DIR__, 4).'/vendor/marcel-mathias-nolte/contao-jquery-in-backend/src/translations'), 29 => (\dirname(__DIR__, 4).'/system/modules/store_uuid/translations'), 30 => (\dirname(__DIR__, 4).'/vendor/contao/news-bundle/src/translations'), 31 => (\dirname(__DIR__, 4).'/vendor/tabularasadev/contao-fonctions/src/translations'), 32 => (\dirname(__DIR__, 4).'/vendor/contao/listing-bundle/src/translations'), 33 => (\dirname(__DIR__, 4).'/vendor/contao/calendar-bundle/src/translations'), 34 => (\dirname(__DIR__, 4).'/vendor/contao/newsletter-bundle/src/translations'), 35 => (\dirname(__DIR__, 4).'/vendor/bugbuster/contao-cron-bundle/src/translations'), 36 => (\dirname(__DIR__, 4).'/system/modules/dk_mmenu/translations'), 37 => (\dirname(__DIR__, 4).'/system/modules/mailusername/translations'), 38 => (\dirname(__DIR__, 4).'/vendor/madeyourday/contao-rocksolid-slider/src/translations'), 39 => (\dirname(__DIR__, 4).'/translations')], 'cache_vary' => ['scanned_directories' => [0 => 'vendor/symfony/security-core/Resources/translations', 1 => 'vendor/scheb/2fa-bundle/Resources/translations', 2 => 'vendor/knplabs/knp-time-bundle/src/Resources/translations', 3 => 'vendor/contao/manager-bundle/src/Resources/translations', 4 => 'vendor/contao/installation-bundle/src/Resources/translations', 5 => 'vendor/doctrine/doctrine-bundle/translations', 6 => 'vendor/symfony/framework-bundle/translations', 7 => 'vendor/symfony/monolog-bundle/translations', 8 => 'vendor/friendsofsymfony/http-cache-bundle/src/translations', 9 => 'vendor/nelmio/cors-bundle/translations', 10 => 'vendor/nelmio/security-bundle/translations', 11 => 'vendor/twig/extra-bundle/translations', 12 => 'vendor/knplabs/knp-menu-bundle/src/translations', 13 => 'vendor/symfony-cmf/routing-bundle/src/translations', 14 => 'vendor/symfony/twig-bundle/translations', 15 => 'vendor/terminal42/service-annotation-bundle/src/translations', 16 => 'vendor/symfony/security-bundle/translations', 17 => 'vendor/contao/core-bundle/src/translations', 18 => 'vendor/league/flysystem-bundle/src/translations', 19 => 'vendor/madeyourday/contao-rocksolid-antispam/src/translations', 20 => 'vendor/tabularasadev/contao-petitescdc/src/translations', 21 => 'vendor/menatwork/contao-multicolumnwizard-bundle/src/translations', 22 => 'vendor/inspiredminds/contao-wowjs/src/translations', 23 => 'system/modules/Subcolumns/translations', 24 => 'system/modules/mobile_menu/translations', 25 => 'vendor/contao/faq-bundle/src/translations', 26 => 'vendor/tabularasadev/contao-typechamp/src/translations', 27 => 'vendor/contao/comments-bundle/src/translations', 28 => 'vendor/marcel-mathias-nolte/contao-jquery-in-backend/src/translations', 29 => 'system/modules/store_uuid/translations', 30 => 'vendor/contao/news-bundle/src/translations', 31 => 'vendor/tabularasadev/contao-fonctions/src/translations', 32 => 'vendor/contao/listing-bundle/src/translations', 33 => 'vendor/contao/calendar-bundle/src/translations', 34 => 'vendor/contao/newsletter-bundle/src/translations', 35 => 'vendor/bugbuster/contao-cron-bundle/src/translations', 36 => 'system/modules/dk_mmenu/translations', 37 => 'system/modules/mailusername/translations', 38 => 'vendor/madeyourday/contao-rocksolid-slider/src/translations', 39 => 'translations']]], []);

        $instance->setConfigCacheFactory(($this->privates['config_cache_factory'] ?? ($this->privates['config_cache_factory'] = new \Symfony\Component\Config\ResourceCheckerConfigCacheFactory())));
        $instance->setFallbackLocales([0 => 'en']);

        return $instance;
    }

    /*
     * Gets the public 'contao.controller.backend_csv_import' alias.
     *
     * @return object The "Contao\CoreBundle\Controller\BackendCsvImportController" service.
     */
    protected function getContao_Controller_BackendCsvImportService()
    {
        trigger_deprecation('contao/core-bundle', '4.9', 'Using the "contao.controller.backend_csv_import" service ID has been deprecated and will no longer work in Contao 5.0. Please use "Contao\\CoreBundle\\Controller\\BackendCsvImportController" instead.');

        return $this->get('Contao\\CoreBundle\\Controller\\BackendCsvImportController');
    }

    /*
     * Gets the public 'contao.controller.images' alias.
     *
     * @return object The "Contao\CoreBundle\Controller\ImagesController" service.
     */
    protected function getContao_Controller_ImagesService()
    {
        trigger_deprecation('contao/core-bundle', '4.9', 'Using the "contao.controller.images" service ID has been deprecated and will no longer work in Contao 5.0. Please use "Contao\\CoreBundle\\Controller\\ImagesController" instead.');

        return $this->get('Contao\\CoreBundle\\Controller\\ImagesController');
    }

    /*
     * Gets the public 'contao.controller.insert_tags' alias.
     *
     * @return object The "Contao\CoreBundle\Controller\InsertTagsController" service.
     */
    protected function getContao_Controller_InsertTagsService()
    {
        trigger_deprecation('contao/core-bundle', '4.9', 'Using the "contao.controller.insert_tags" service ID has been deprecated and will no longer work in Contao 5.0. Please use "Contao\\CoreBundle\\Controller\\InsertTagsController" instead.');

        return $this->get('Contao\\CoreBundle\\Controller\\InsertTagsController');
    }

    /*
     * Gets the public 'Contao\CoreBundle\EventListener\DataContainer\ContentCompositionListener' alias.
     *
     * @return object The "contao.listener.data_container.content_composition" service.
     */
    protected function getContentCompositionListenerService()
    {
        trigger_deprecation('contao/core-bundle', '4.13', 'Using the "Contao\\CoreBundle\\EventListener\\DataContainer\\ContentCompositionListener" service ID has been deprecated and will no longer work in Contao 5.0. Please use "contao.listener.data_container.content_composition" instead.');

        return $this->get('contao.listener.data_container.content_composition');
    }

    /*
     * Gets the public 'Contao\CoreBundle\EventListener\DataContainer\PageTypeOptionsListener' alias.
     *
     * @return object The "contao.listener.data_container.page_type_options" service.
     */
    protected function getPageTypeOptionsListenerService()
    {
        trigger_deprecation('contao/core-bundle', '4.13', 'Using the "Contao\\CoreBundle\\EventListener\\DataContainer\\PageTypeOptionsListener" service ID has been deprecated and will no longer work in Contao 5.0. Please use "contao.listener.data_container.page_type_options" instead.');

        return $this->get('contao.listener.data_container.page_type_options');
    }

    /*
     * Gets the public 'Contao\CoreBundle\EventListener\DataContainer\PageUrlListener' alias.
     *
     * @return object The "contao.listener.data_container.page_url" service.
     */
    protected function getPageUrlListenerService()
    {
        trigger_deprecation('contao/core-bundle', '4.13', 'Using the "Contao\\CoreBundle\\EventListener\\DataContainer\\PageUrlListener" service ID has been deprecated and will no longer work in Contao 5.0. Please use "contao.listener.data_container.page_url" instead.');

        return $this->get('contao.listener.data_container.page_url');
    }

    /*
     * Gets the public 'contao.cache.clear_internal' alias.
     *
     * @return object The "contao.cache.clearer" service.
     */
    protected function getContao_Cache_ClearInternalService()
    {
        trigger_deprecation('contao/core-bundle', '4.13', 'Using the "contao.cache.clear_internal" service ID has been deprecated and will no longer work in Contao 5.0. Please use "contao.cache.clearer" instead.');

        return $this->get('contao.cache.clearer');
    }

    /*
     * Gets the public 'contao.cache.warm_internal' alias.
     *
     * @return object The "contao.cache.warmer" service.
     */
    protected function getContao_Cache_WarmInternalService()
    {
        trigger_deprecation('contao/core-bundle', '4.13', 'Using the "contao.cache.warm_internal" service ID has been deprecated and will no longer work in Contao 5.0. Please use "contao.cache.warmer" instead.');

        return $this->get('contao.cache.warmer');
    }

    /*
     * Gets the public 'contao.crawl.escargot_factory' alias.
     *
     * @return object The "contao.crawl.escargot.factory" service.
     */
    protected function getContao_Crawl_EscargotFactoryService()
    {
        trigger_deprecation('contao/core-bundle', '4.13', 'Using the "contao.crawl.escargot_factory" service ID has been deprecated and will no longer work in Contao 5.0. Please use "contao.crawl.escargot.factory" instead.');

        return $this->get('contao.crawl.escargot.factory');
    }

    /*
     * Gets the public 'contao.image.image_factory' alias.
     *
     * @return object The "contao.image.factory" service.
     */
    protected function getContao_Image_ImageFactoryService()
    {
        trigger_deprecation('contao/core-bundle', '4.13', 'Using the "contao.image.image_factory" service ID has been deprecated and will no longer work in Contao 5.0. Please use "contao.image.factory" instead.');

        return $this->get('contao.image.factory');
    }

    /*
     * Gets the public 'contao.image.image_sizes' alias.
     *
     * @return object The "contao.image.sizes" service.
     */
    protected function getContao_Image_ImageSizesService()
    {
        trigger_deprecation('contao/core-bundle', '4.13', 'Using the "contao.image.image_sizes" service ID has been deprecated and will no longer work in Contao 5.0. Please use "contao.image.sizes" instead.');

        return $this->get('contao.image.sizes');
    }

    /*
     * Gets the public 'contao.image.resizer' alias.
     *
     * @return object The "contao.image.legacy_resizer" service.
     */
    protected function getContao_Image_ResizerService()
    {
        trigger_deprecation('contao/core-bundle', '4.13', 'Using the "contao.image.resizer" service ID has been deprecated and will no longer work in Contao 5.0. Please use "contao.image.legacy_resizer" instead.');

        return $this->get('contao.image.legacy_resizer');
    }

    /*
     * Gets the public 'contao.opt-in' alias.
     *
     * @return object The "contao.opt_in" service.
     */
    protected function getContao_OptinService()
    {
        trigger_deprecation('contao/core-bundle', '4.13', 'Using the "contao.opt-in" service ID has been deprecated and will no longer work in Contao 5.0. Please use "contao.opt_in" instead.');

        return $this->get('contao.opt_in');
    }

    /*
     * Gets the public 'Contao\CoreBundle\Cron\Cron' alias.
     *
     * @return object The "contao.cron" service.
     */
    protected function getCronService()
    {
        trigger_deprecation('contao/core-bundle', '4.13', 'Using the "Contao\\CoreBundle\\Cron\\Cron" service ID has been deprecated and will no longer work in Contao 5.0. Please use "contao.cron" instead.');

        return $this->get('contao.cron');
    }

    /*
     * Gets the public 'Contao\CoreBundle\Image\Studio\FigureRenderer' alias.
     *
     * @return object The "contao.image.studio.figure_renderer" service.
     */
    protected function getFigureRendererService()
    {
        trigger_deprecation('contao/core-bundle', '4.13', 'Using the "Contao\\CoreBundle\\Image\\Studio\\FigureRenderer" service ID has been deprecated and will no longer work in Contao 5.0. Please use "contao.image.studio.figure_renderer" instead.');

        return $this->get('contao.image.studio.figure_renderer');
    }

    /*
     * Gets the public 'Contao\CoreBundle\Routing\ResponseContext\CoreResponseContextFactory' alias.
     *
     * @return object The "contao.routing.response_context_factory" service.
     */
    protected function getCoreResponseContextFactoryService()
    {
        trigger_deprecation('contao/core-bundle', '4.13', 'Using the "Contao\\CoreBundle\\Routing\\ResponseContext\\CoreResponseContextFactory" service ID has been deprecated and will no longer work in Contao 5.0. Please use "contao.routing.response_context_factory" instead.');

        return $this->get('contao.routing.response_context_factory');
    }

    /*
     * Gets the public 'Contao\CoreBundle\Security\TwoFactor\BackupCodeManager' alias.
     *
     * @return object The "contao.security.two_factor.backup_code_manager" service.
     */
    protected function getBackupCodeManagerService()
    {
        trigger_deprecation('contao/core-bundle', '4.13', 'Using the "Contao\\CoreBundle\\Security\\TwoFactor\\BackupCodeManager" service ID has been deprecated and will no longer work in Contao 5.0. Please use "contao.security.two_factor.backup_code_manager" instead.');

        return $this->get('contao.security.two_factor.backup_code_manager');
    }

    /*
     * Gets the public 'Contao\CoreBundle\Twig\Extension\ContaoExtension' alias.
     *
     * @return object The "contao.twig.extension" service.
     */
    protected function getContaoExtensionService()
    {
        trigger_deprecation('contao/core-bundle', '4.13', 'Using the "Contao\\CoreBundle\\Twig\\Extension\\ContaoExtension" service ID has been deprecated and will no longer work in Contao 5.0. Please use "contao.twig.extension" instead.');

        return $this->get('contao.twig.extension');
    }

    /*
     * Gets the public 'Contao\CoreBundle\Util\SimpleTokenParser' alias.
     *
     * @return object The "contao.string.simple_token_parser" service.
     */
    protected function getSimpleTokenParserService()
    {
        trigger_deprecation('contao/core-bundle', '4.13', 'Using the "Contao\\CoreBundle\\Util\\SimpleTokenParser" service ID has been deprecated and will no longer work in Contao 5.0. Please use "contao.string.simple_token_parser" instead.');

        return $this->get('contao.string.simple_token_parser');
    }

    /*
     * Gets the public 'contao_manager.routing_loader' alias.
     *
     * @return object The "contao_manager.routing.route_loader" service.
     */
    protected function getContaoManager_RoutingLoaderService()
    {
        trigger_deprecation('contao/manager-bundle', '4.13', 'Using the "contao_manager.routing_loader" service ID has been deprecated and will no longer work in Contao 5.0. Please use "contao_manager.routing.route_loader" instead.');

        return $this->get('contao_manager.routing.route_loader');
    }

    /*
     * Gets the public 'contao.install_tool' alias.
     *
     * @return object The "contao_installation.install_tool" service.
     */
    protected function getContao_InstallToolService()
    {
        trigger_deprecation('contao/installation-bundle', '4.13', 'Using the "contao.install_tool" service ID has been deprecated and will no longer work in Contao 5.0. Please use "contao_installation.install_tool" instead.');

        return $this->get('contao_installation.install_tool');
    }

    /*
     * Gets the public 'contao.install_tool_user' alias.
     *
     * @return object The "contao_installation.install_tool_user" service.
     */
    protected function getContao_InstallToolUserService()
    {
        trigger_deprecation('contao/installation-bundle', '4.13', 'Using the "contao.install_tool_user" service ID has been deprecated and will no longer work in Contao 5.0. Please use "contao_installation.install_tool_user" instead.');

        return $this->get('contao_installation.install_tool_user');
    }

    /*
     * Gets the public 'contao.installer' alias.
     *
     * @return object The "contao_installation.database.installer" service.
     */
    protected function getContao_InstallerService()
    {
        trigger_deprecation('contao/installation-bundle', '4.13', 'Using the "contao.installer" service ID has been deprecated and will no longer work in Contao 5.0. Please use "contao_installation.database.installer" instead.');

        return $this->get('contao_installation.database.installer');
    }

    /*
     * Gets the public 'cache_clearer' alias.
     *
     * @return object The ".container.private.cache_clearer" service.
     */
    protected function getCacheClearerService()
    {
        trigger_deprecation('symfony/framework-bundle', '5.2', 'Accessing the "cache_clearer" service directly from the container is deprecated, use dependency injection instead.');

        return $this->get('.container.private.cache_clearer');
    }

    /*
     * Gets the public 'filesystem' alias.
     *
     * @return object The ".container.private.filesystem" service.
     */
    protected function getFilesystemService()
    {
        trigger_deprecation('symfony/framework-bundle', '5.2', 'Accessing the "filesystem" service directly from the container is deprecated, use dependency injection instead.');

        return $this->get('.container.private.filesystem');
    }

    /*
     * Gets the public 'security.csrf.token_manager' alias.
     *
     * @return object The ".container.private.security.csrf.token_manager" service.
     */
    protected function getSecurity_Csrf_TokenManagerService()
    {
        trigger_deprecation('symfony/framework-bundle', '5.2', 'Accessing the "security.csrf.token_manager" service directly from the container is deprecated, use dependency injection instead.');

        return $this->get('.container.private.security.csrf.token_manager');
    }

    /*
     * Gets the public 'twig' alias.
     *
     * @return object The ".container.private.twig" service.
     */
    protected function getTwigService()
    {
        trigger_deprecation('symfony/twig-bundle', '5.2', 'Accessing the "twig" service directly from the container is deprecated, use dependency injection instead.');

        return $this->get('.container.private.twig');
    }

    /*
     * Gets the public 'security.authorization_checker' alias.
     *
     * @return object The ".container.private.security.authorization_checker" service.
     */
    protected function getSecurity_AuthorizationCheckerService()
    {
        trigger_deprecation('symfony/security-bundle', '5.3', 'Accessing the "security.authorization_checker" service directly from the container is deprecated, use dependency injection instead.');

        return $this->get('.container.private.security.authorization_checker');
    }

    /*
     * Gets the public 'security.token_storage' alias.
     *
     * @return object The ".container.private.security.token_storage" service.
     */
    protected function getSecurity_TokenStorageService()
    {
        trigger_deprecation('symfony/security-bundle', '5.3', 'Accessing the "security.token_storage" service directly from the container is deprecated, use dependency injection instead.');

        return $this->get('.container.private.security.token_storage');
    }

    /*
     * Gets the public 'security.encoder_factory' alias.
     *
     * @return object The ".container.private.security.encoder_factory" service.
     */
    protected function getSecurity_EncoderFactoryService()
    {
        trigger_deprecation('symfony/security-bundle', '5.3', 'Accessing the "security.encoder_factory" service directly from the container is deprecated, use dependency injection instead.');

        return $this->get('.container.private.security.encoder_factory');
    }

    /*
     * Gets the public 'security.password_encoder' alias.
     *
     * @return object The ".container.private.security.password_encoder" service.
     */
    protected function getSecurity_PasswordEncoderService()
    {
        trigger_deprecation('symfony/security-bundle', '5.3', 'Accessing the "security.password_encoder" service directly from the container is deprecated, use dependency injection instead.');

        return $this->get('.container.private.security.password_encoder');
    }

    /*
     * Gets the public 'session' alias.
     *
     * @return object The ".container.private.session" service.
     */
    protected function getSessionService()
    {
        trigger_deprecation('symfony/framework-bundle', '5.3', 'Accessing the "session" service directly from the container is deprecated, use dependency injection instead.');

        return $this->get('.container.private.session');
    }

    /**
     * @return array|bool|float|int|string|\UnitEnum|null
     */
    public function getParameter(string $name)
    {
        if (isset($this->buildParameters[$name])) {
            return $this->buildParameters[$name];
        }

        if (!(isset($this->parameters[$name]) || isset($this->loadedDynamicParameters[$name]) || \array_key_exists($name, $this->parameters))) {
            throw new InvalidArgumentException(sprintf('The parameter "%s" must be defined.', $name));
        }
        if (isset($this->loadedDynamicParameters[$name])) {
            return $this->loadedDynamicParameters[$name] ? $this->dynamicParameters[$name] : $this->getDynamicParameter($name);
        }

        return $this->parameters[$name];
    }

    public function hasParameter(string $name): bool
    {
        if (isset($this->buildParameters[$name])) {
            return true;
        }

        return isset($this->parameters[$name]) || isset($this->loadedDynamicParameters[$name]) || \array_key_exists($name, $this->parameters);
    }

    public function setParameter(string $name, $value): void
    {
        throw new LogicException('Impossible to call set() on a frozen ParameterBag.');
    }

    public function getParameterBag(): ParameterBagInterface
    {
        if (null === $this->parameterBag) {
            $parameters = $this->parameters;
            foreach ($this->loadedDynamicParameters as $name => $loaded) {
                $parameters[$name] = $loaded ? $this->dynamicParameters[$name] : $this->getDynamicParameter($name);
            }
            foreach ($this->buildParameters as $name => $value) {
                $parameters[$name] = $value;
            }
            $this->parameterBag = new FrozenParameterBag($parameters);
        }

        return $this->parameterBag;
    }

    private $loadedDynamicParameters = [
        'kernel.runtime_environment' => false,
        'kernel.build_dir' => false,
        'kernel.cache_dir' => false,
        'doctrine.orm.proxy_dir' => false,
        'kernel.secret' => false,
    ];
    private $dynamicParameters = [];

    private function getDynamicParameter(string $name)
    {
        switch ($name) {
            case 'kernel.runtime_environment': $value = $this->getEnv('default:kernel.environment:APP_RUNTIME_ENV'); break;
            case 'kernel.build_dir': $value = $this->targetDir.''; break;
            case 'kernel.cache_dir': $value = $this->targetDir.''; break;
            case 'doctrine.orm.proxy_dir': $value = ($this->targetDir.''.'/doctrine/orm/Proxies'); break;
            case 'kernel.secret': $value = $this->getEnv('APP_SECRET'); break;
            default: throw new InvalidArgumentException(sprintf('The dynamic parameter "%s" must be defined.', $name));
        }
        $this->loadedDynamicParameters[$name] = true;

        return $this->dynamicParameters[$name] = $value;
    }

    protected function getDefaultParameters(): array
    {
        return [
            'kernel.project_dir' => \dirname(__DIR__, 4),
            'kernel.environment' => 'prod',
            'kernel.debug' => false,
            'kernel.logs_dir' => (\dirname(__DIR__, 3).'/logs'),
            'kernel.bundles' => [
                'DoctrineBundle' => 'Doctrine\\Bundle\\DoctrineBundle\\DoctrineBundle',
                'FrameworkBundle' => 'Symfony\\Bundle\\FrameworkBundle\\FrameworkBundle',
                'MonologBundle' => 'Symfony\\Bundle\\MonologBundle\\MonologBundle',
                'FOSHttpCacheBundle' => 'FOS\\HttpCacheBundle\\FOSHttpCacheBundle',
                'NelmioCorsBundle' => 'Nelmio\\CorsBundle\\NelmioCorsBundle',
                'NelmioSecurityBundle' => 'Nelmio\\SecurityBundle\\NelmioSecurityBundle',
                'SchebTwoFactorBundle' => 'Scheb\\TwoFactorBundle\\SchebTwoFactorBundle',
                'TwigExtraBundle' => 'Twig\\Extra\\TwigExtraBundle\\TwigExtraBundle',
                'KnpMenuBundle' => 'Knp\\Bundle\\MenuBundle\\KnpMenuBundle',
                'KnpTimeBundle' => 'Knp\\Bundle\\TimeBundle\\KnpTimeBundle',
                'CmfRoutingBundle' => 'Symfony\\Cmf\\Bundle\\RoutingBundle\\CmfRoutingBundle',
                'TwigBundle' => 'Symfony\\Bundle\\TwigBundle\\TwigBundle',
                'Terminal42ServiceAnnotationBundle' => 'Terminal42\\ServiceAnnotationBundle\\Terminal42ServiceAnnotationBundle',
                'SecurityBundle' => 'Symfony\\Bundle\\SecurityBundle\\SecurityBundle',
                'ContaoCoreBundle' => 'Contao\\CoreBundle\\ContaoCoreBundle',
                'FlysystemBundle' => 'League\\FlysystemBundle\\FlysystemBundle',
                'ContaoManagerBundle' => 'Contao\\ManagerBundle\\ContaoManagerBundle',
                'RockSolidAntispamBundle' => 'MadeYourDay\\RockSolidAntispam\\RockSolidAntispamBundle',
                'ContaoPetitescdcBundle' => 'trdev\\ContaoPetitescdcBundle\\ContaoPetitescdcBundle',
                'MultiColumnWizardBundle' => 'MenAtWork\\MultiColumnWizardBundle\\MultiColumnWizardBundle',
                'ContaoWowJsBundle' => 'InspiredMinds\\ContaoWowJs\\ContaoWowJsBundle',
                'Subcolumns' => 'Contao\\CoreBundle\\HttpKernel\\Bundle\\ContaoModuleBundle',
                'mobile_menu' => 'Contao\\CoreBundle\\HttpKernel\\Bundle\\ContaoModuleBundle',
                'ContaoFaqBundle' => 'Contao\\FaqBundle\\ContaoFaqBundle',
                'ContaoTypechampBundle' => 'trdev\\ContaoTypechampBundle\\ContaoTypechampBundle',
                'ContaoCommentsBundle' => 'Contao\\CommentsBundle\\ContaoCommentsBundle',
                'JQueryInContaoBackendBundle' => 'MarcelMathiasNolte\\JQueryInContaoBackendBundle\\JQueryInContaoBackendBundle',
                'store_uuid' => 'Contao\\CoreBundle\\HttpKernel\\Bundle\\ContaoModuleBundle',
                'ContaoInstallationBundle' => 'Contao\\InstallationBundle\\ContaoInstallationBundle',
                'ContaoNewsBundle' => 'Contao\\NewsBundle\\ContaoNewsBundle',
                'ContaoFonctionsBundle' => 'trdev\\ContaoFonctionsBundle\\ContaoFonctionsBundle',
                'ContaoListingBundle' => 'Contao\\ListingBundle\\ContaoListingBundle',
                'ContaoCalendarBundle' => 'Contao\\CalendarBundle\\ContaoCalendarBundle',
                'ContaoNewsletterBundle' => 'Contao\\NewsletterBundle\\ContaoNewsletterBundle',
                'BugBusterCronBundle' => 'BugBuster\\CronBundle\\BugBusterCronBundle',
                'dk_mmenu' => 'Contao\\CoreBundle\\HttpKernel\\Bundle\\ContaoModuleBundle',
                'mailusername' => 'Contao\\CoreBundle\\HttpKernel\\Bundle\\ContaoModuleBundle',
                'RockSolidSliderBundle' => 'MadeYourDay\\RockSolidSlider\\RockSolidSliderBundle',
            ],
            'kernel.bundles_metadata' => [
                'DoctrineBundle' => [
                    'path' => (\dirname(__DIR__, 4).'/vendor/doctrine/doctrine-bundle'),
                    'namespace' => 'Doctrine\\Bundle\\DoctrineBundle',
                ],
                'FrameworkBundle' => [
                    'path' => (\dirname(__DIR__, 4).'/vendor/symfony/framework-bundle'),
                    'namespace' => 'Symfony\\Bundle\\FrameworkBundle',
                ],
                'MonologBundle' => [
                    'path' => (\dirname(__DIR__, 4).'/vendor/symfony/monolog-bundle'),
                    'namespace' => 'Symfony\\Bundle\\MonologBundle',
                ],
                'FOSHttpCacheBundle' => [
                    'path' => (\dirname(__DIR__, 4).'/vendor/friendsofsymfony/http-cache-bundle/src'),
                    'namespace' => 'FOS\\HttpCacheBundle',
                ],
                'NelmioCorsBundle' => [
                    'path' => (\dirname(__DIR__, 4).'/vendor/nelmio/cors-bundle'),
                    'namespace' => 'Nelmio\\CorsBundle',
                ],
                'NelmioSecurityBundle' => [
                    'path' => (\dirname(__DIR__, 4).'/vendor/nelmio/security-bundle'),
                    'namespace' => 'Nelmio\\SecurityBundle',
                ],
                'SchebTwoFactorBundle' => [
                    'path' => (\dirname(__DIR__, 4).'/vendor/scheb/2fa-bundle'),
                    'namespace' => 'Scheb\\TwoFactorBundle',
                ],
                'TwigExtraBundle' => [
                    'path' => (\dirname(__DIR__, 4).'/vendor/twig/extra-bundle'),
                    'namespace' => 'Twig\\Extra\\TwigExtraBundle',
                ],
                'KnpMenuBundle' => [
                    'path' => (\dirname(__DIR__, 4).'/vendor/knplabs/knp-menu-bundle/src'),
                    'namespace' => 'Knp\\Bundle\\MenuBundle',
                ],
                'KnpTimeBundle' => [
                    'path' => (\dirname(__DIR__, 4).'/vendor/knplabs/knp-time-bundle/src'),
                    'namespace' => 'Knp\\Bundle\\TimeBundle',
                ],
                'CmfRoutingBundle' => [
                    'path' => (\dirname(__DIR__, 4).'/vendor/symfony-cmf/routing-bundle/src'),
                    'namespace' => 'Symfony\\Cmf\\Bundle\\RoutingBundle',
                ],
                'TwigBundle' => [
                    'path' => (\dirname(__DIR__, 4).'/vendor/symfony/twig-bundle'),
                    'namespace' => 'Symfony\\Bundle\\TwigBundle',
                ],
                'Terminal42ServiceAnnotationBundle' => [
                    'path' => (\dirname(__DIR__, 4).'/vendor/terminal42/service-annotation-bundle/src'),
                    'namespace' => 'Terminal42\\ServiceAnnotationBundle',
                ],
                'SecurityBundle' => [
                    'path' => (\dirname(__DIR__, 4).'/vendor/symfony/security-bundle'),
                    'namespace' => 'Symfony\\Bundle\\SecurityBundle',
                ],
                'ContaoCoreBundle' => [
                    'path' => (\dirname(__DIR__, 4).'/vendor/contao/core-bundle/src'),
                    'namespace' => 'Contao\\CoreBundle',
                ],
                'FlysystemBundle' => [
                    'path' => (\dirname(__DIR__, 4).'/vendor/league/flysystem-bundle/src'),
                    'namespace' => 'League\\FlysystemBundle',
                ],
                'ContaoManagerBundle' => [
                    'path' => (\dirname(__DIR__, 4).'/vendor/contao/manager-bundle/src'),
                    'namespace' => 'Contao\\ManagerBundle',
                ],
                'RockSolidAntispamBundle' => [
                    'path' => (\dirname(__DIR__, 4).'/vendor/madeyourday/contao-rocksolid-antispam/src'),
                    'namespace' => 'MadeYourDay\\RockSolidAntispam',
                ],
                'ContaoPetitescdcBundle' => [
                    'path' => (\dirname(__DIR__, 4).'/vendor/tabularasadev/contao-petitescdc/src'),
                    'namespace' => 'trdev\\ContaoPetitescdcBundle',
                ],
                'MultiColumnWizardBundle' => [
                    'path' => (\dirname(__DIR__, 4).'/vendor/menatwork/contao-multicolumnwizard-bundle/src'),
                    'namespace' => 'MenAtWork\\MultiColumnWizardBundle',
                ],
                'ContaoWowJsBundle' => [
                    'path' => (\dirname(__DIR__, 4).'/vendor/inspiredminds/contao-wowjs/src'),
                    'namespace' => 'InspiredMinds\\ContaoWowJs',
                ],
                'Subcolumns' => [
                    'path' => (\dirname(__DIR__, 4).'/system/modules/Subcolumns'),
                    'namespace' => 'Contao\\CoreBundle\\HttpKernel\\Bundle',
                ],
                'mobile_menu' => [
                    'path' => (\dirname(__DIR__, 4).'/system/modules/mobile_menu'),
                    'namespace' => 'Contao\\CoreBundle\\HttpKernel\\Bundle',
                ],
                'ContaoFaqBundle' => [
                    'path' => (\dirname(__DIR__, 4).'/vendor/contao/faq-bundle/src'),
                    'namespace' => 'Contao\\FaqBundle',
                ],
                'ContaoTypechampBundle' => [
                    'path' => (\dirname(__DIR__, 4).'/vendor/tabularasadev/contao-typechamp/src'),
                    'namespace' => 'trdev\\ContaoTypechampBundle',
                ],
                'ContaoCommentsBundle' => [
                    'path' => (\dirname(__DIR__, 4).'/vendor/contao/comments-bundle/src'),
                    'namespace' => 'Contao\\CommentsBundle',
                ],
                'JQueryInContaoBackendBundle' => [
                    'path' => (\dirname(__DIR__, 4).'/vendor/marcel-mathias-nolte/contao-jquery-in-backend/src'),
                    'namespace' => 'MarcelMathiasNolte\\JQueryInContaoBackendBundle',
                ],
                'store_uuid' => [
                    'path' => (\dirname(__DIR__, 4).'/system/modules/store_uuid'),
                    'namespace' => 'Contao\\CoreBundle\\HttpKernel\\Bundle',
                ],
                'ContaoInstallationBundle' => [
                    'path' => (\dirname(__DIR__, 4).'/vendor/contao/installation-bundle/src'),
                    'namespace' => 'Contao\\InstallationBundle',
                ],
                'ContaoNewsBundle' => [
                    'path' => (\dirname(__DIR__, 4).'/vendor/contao/news-bundle/src'),
                    'namespace' => 'Contao\\NewsBundle',
                ],
                'ContaoFonctionsBundle' => [
                    'path' => (\dirname(__DIR__, 4).'/vendor/tabularasadev/contao-fonctions/src'),
                    'namespace' => 'trdev\\ContaoFonctionsBundle',
                ],
                'ContaoListingBundle' => [
                    'path' => (\dirname(__DIR__, 4).'/vendor/contao/listing-bundle/src'),
                    'namespace' => 'Contao\\ListingBundle',
                ],
                'ContaoCalendarBundle' => [
                    'path' => (\dirname(__DIR__, 4).'/vendor/contao/calendar-bundle/src'),
                    'namespace' => 'Contao\\CalendarBundle',
                ],
                'ContaoNewsletterBundle' => [
                    'path' => (\dirname(__DIR__, 4).'/vendor/contao/newsletter-bundle/src'),
                    'namespace' => 'Contao\\NewsletterBundle',
                ],
                'BugBusterCronBundle' => [
                    'path' => (\dirname(__DIR__, 4).'/vendor/bugbuster/contao-cron-bundle/src'),
                    'namespace' => 'BugBuster\\CronBundle',
                ],
                'dk_mmenu' => [
                    'path' => (\dirname(__DIR__, 4).'/system/modules/dk_mmenu'),
                    'namespace' => 'Contao\\CoreBundle\\HttpKernel\\Bundle',
                ],
                'mailusername' => [
                    'path' => (\dirname(__DIR__, 4).'/system/modules/mailusername'),
                    'namespace' => 'Contao\\CoreBundle\\HttpKernel\\Bundle',
                ],
                'RockSolidSliderBundle' => [
                    'path' => (\dirname(__DIR__, 4).'/vendor/madeyourday/contao-rocksolid-slider/src'),
                    'namespace' => 'MadeYourDay\\RockSolidSlider',
                ],
            ],
            'kernel.charset' => 'UTF-8',
            'kernel.container_class' => 'Contao_ManagerBundle_HttpKernel_ContaoKernelProdContainer',
            'database_host' => 'bn22546-011.eu.clouddb.ovh.net',
            'database_port' => 35415,
            'database_user' => 'petitescdc',
            'database_password' => 'JfKdbcJoCH6xbna3',
            'database_name' => 'petitescdc',
            'secret' => 'a4ca96226857a1d4c21c6c447c7703aa0866dad631b49a324ac57e7b0a67021a',
            'mailer_transport' => 'sendmail',
            'mailer_host' => '127.0.0.1',
            'mailer_user' => NULL,
            'mailer_password' => NULL,
            'mailer_port' => 25,
            'mailer_encryption' => NULL,
            'locale' => 'en',
            'container.dumper.inline_class_loader' => true,
            'env(DATABASE_URL)' => 'pdo-mysql://petitescdc:JfKdbcJoCH6xbna3@bn22546-011.eu.clouddb.ovh.net:35415/petitescdc',
            'env(APP_SECRET)' => 'a4ca96226857a1d4c21c6c447c7703aa0866dad631b49a324ac57e7b0a67021a',
            'env(MAILER_DSN)' => 'native://default',
            'contao.backend.route_prefix' => '/contao',
            'doctrine.dbal.configuration.class' => 'Doctrine\\DBAL\\Configuration',
            'doctrine.data_collector.class' => 'Doctrine\\Bundle\\DoctrineBundle\\DataCollector\\DoctrineDataCollector',
            'doctrine.dbal.connection.event_manager.class' => 'Symfony\\Bridge\\Doctrine\\ContainerAwareEventManager',
            'doctrine.dbal.connection_factory.class' => 'Doctrine\\Bundle\\DoctrineBundle\\ConnectionFactory',
            'doctrine.dbal.events.mysql_session_init.class' => 'Doctrine\\DBAL\\Event\\Listeners\\MysqlSessionInit',
            'doctrine.dbal.events.oracle_session_init.class' => 'Doctrine\\DBAL\\Event\\Listeners\\OracleSessionInit',
            'doctrine.class' => 'Doctrine\\Bundle\\DoctrineBundle\\Registry',
            'doctrine.entity_managers' => [
                'default' => 'doctrine.orm.default_entity_manager',
            ],
            'doctrine.default_entity_manager' => 'default',
            'doctrine.dbal.connection_factory.types' => [
                'binary_string' => [
                    'class' => 'Contao\\CoreBundle\\Doctrine\\DBAL\\Types\\BinaryStringType',
                ],
                'uuid' => [
                    'class' => 'Symfony\\Bridge\\Doctrine\\Types\\UuidType',
                ],
                'ulid' => [
                    'class' => 'Symfony\\Bridge\\Doctrine\\Types\\UlidType',
                ],
            ],
            'doctrine.connections' => [
                'default' => 'doctrine.dbal.default_connection',
            ],
            'doctrine.default_connection' => 'default',
            'doctrine.orm.configuration.class' => 'Doctrine\\ORM\\Configuration',
            'doctrine.orm.entity_manager.class' => 'Doctrine\\ORM\\EntityManager',
            'doctrine.orm.manager_configurator.class' => 'Doctrine\\Bundle\\DoctrineBundle\\ManagerConfigurator',
            'doctrine.orm.cache.array.class' => 'Doctrine\\Common\\Cache\\ArrayCache',
            'doctrine.orm.cache.apc.class' => 'Doctrine\\Common\\Cache\\ApcCache',
            'doctrine.orm.cache.memcache.class' => 'Doctrine\\Common\\Cache\\MemcacheCache',
            'doctrine.orm.cache.memcache_host' => 'localhost',
            'doctrine.orm.cache.memcache_port' => 11211,
            'doctrine.orm.cache.memcache_instance.class' => 'Memcache',
            'doctrine.orm.cache.memcached.class' => 'Doctrine\\Common\\Cache\\MemcachedCache',
            'doctrine.orm.cache.memcached_host' => 'localhost',
            'doctrine.orm.cache.memcached_port' => 11211,
            'doctrine.orm.cache.memcached_instance.class' => 'Memcached',
            'doctrine.orm.cache.redis.class' => 'Doctrine\\Common\\Cache\\RedisCache',
            'doctrine.orm.cache.redis_host' => 'localhost',
            'doctrine.orm.cache.redis_port' => 6379,
            'doctrine.orm.cache.redis_instance.class' => 'Redis',
            'doctrine.orm.cache.xcache.class' => 'Doctrine\\Common\\Cache\\XcacheCache',
            'doctrine.orm.cache.wincache.class' => 'Doctrine\\Common\\Cache\\WinCacheCache',
            'doctrine.orm.cache.zenddata.class' => 'Doctrine\\Common\\Cache\\ZendDataCache',
            'doctrine.orm.metadata.driver_chain.class' => 'Doctrine\\Persistence\\Mapping\\Driver\\MappingDriverChain',
            'doctrine.orm.metadata.annotation.class' => 'Doctrine\\ORM\\Mapping\\Driver\\AnnotationDriver',
            'doctrine.orm.metadata.xml.class' => 'Doctrine\\ORM\\Mapping\\Driver\\SimplifiedXmlDriver',
            'doctrine.orm.metadata.yml.class' => 'Doctrine\\ORM\\Mapping\\Driver\\SimplifiedYamlDriver',
            'doctrine.orm.metadata.php.class' => 'Doctrine\\ORM\\Mapping\\Driver\\PHPDriver',
            'doctrine.orm.metadata.staticphp.class' => 'Doctrine\\ORM\\Mapping\\Driver\\StaticPHPDriver',
            'doctrine.orm.metadata.attribute.class' => 'Doctrine\\ORM\\Mapping\\Driver\\AttributeDriver',
            'doctrine.orm.proxy_cache_warmer.class' => 'Symfony\\Bridge\\Doctrine\\CacheWarmer\\ProxyCacheWarmer',
            'form.type_guesser.doctrine.class' => 'Symfony\\Bridge\\Doctrine\\Form\\DoctrineOrmTypeGuesser',
            'doctrine.orm.validator.unique.class' => 'Symfony\\Bridge\\Doctrine\\Validator\\Constraints\\UniqueEntityValidator',
            'doctrine.orm.validator_initializer.class' => 'Symfony\\Bridge\\Doctrine\\Validator\\DoctrineInitializer',
            'doctrine.orm.security.user.provider.class' => 'Symfony\\Bridge\\Doctrine\\Security\\User\\EntityUserProvider',
            'doctrine.orm.listeners.resolve_target_entity.class' => 'Doctrine\\ORM\\Tools\\ResolveTargetEntityListener',
            'doctrine.orm.listeners.attach_entity_listeners.class' => 'Doctrine\\ORM\\Tools\\AttachEntityListenersListener',
            'doctrine.orm.naming_strategy.default.class' => 'Doctrine\\ORM\\Mapping\\DefaultNamingStrategy',
            'doctrine.orm.naming_strategy.underscore.class' => 'Doctrine\\ORM\\Mapping\\UnderscoreNamingStrategy',
            'doctrine.orm.quote_strategy.default.class' => 'Doctrine\\ORM\\Mapping\\DefaultQuoteStrategy',
            'doctrine.orm.quote_strategy.ansi.class' => 'Doctrine\\ORM\\Mapping\\AnsiQuoteStrategy',
            'doctrine.orm.entity_listener_resolver.class' => 'Doctrine\\Bundle\\DoctrineBundle\\Mapping\\ContainerEntityListenerResolver',
            'doctrine.orm.second_level_cache.default_cache_factory.class' => 'Doctrine\\ORM\\Cache\\DefaultCacheFactory',
            'doctrine.orm.second_level_cache.default_region.class' => 'Doctrine\\ORM\\Cache\\Region\\DefaultRegion',
            'doctrine.orm.second_level_cache.filelock_region.class' => 'Doctrine\\ORM\\Cache\\Region\\FileLockRegion',
            'doctrine.orm.second_level_cache.logger_chain.class' => 'Doctrine\\ORM\\Cache\\Logging\\CacheLoggerChain',
            'doctrine.orm.second_level_cache.logger_statistics.class' => 'Doctrine\\ORM\\Cache\\Logging\\StatisticsCacheLogger',
            'doctrine.orm.second_level_cache.cache_configuration.class' => 'Doctrine\\ORM\\Cache\\CacheConfiguration',
            'doctrine.orm.second_level_cache.regions_configuration.class' => 'Doctrine\\ORM\\Cache\\RegionsConfiguration',
            'doctrine.orm.auto_generate_proxy_classes' => false,
            'doctrine.orm.enable_lazy_ghost_objects' => false,
            'doctrine.orm.proxy_namespace' => 'Proxies',
            'event_dispatcher.event_aliases' => [
                'Symfony\\Component\\Console\\Event\\ConsoleCommandEvent' => 'console.command',
                'Symfony\\Component\\Console\\Event\\ConsoleErrorEvent' => 'console.error',
                'Symfony\\Component\\Console\\Event\\ConsoleSignalEvent' => 'console.signal',
                'Symfony\\Component\\Console\\Event\\ConsoleTerminateEvent' => 'console.terminate',
                'Symfony\\Component\\HttpKernel\\Event\\ControllerArgumentsEvent' => 'kernel.controller_arguments',
                'Symfony\\Component\\HttpKernel\\Event\\ControllerEvent' => 'kernel.controller',
                'Symfony\\Component\\HttpKernel\\Event\\ResponseEvent' => 'kernel.response',
                'Symfony\\Component\\HttpKernel\\Event\\FinishRequestEvent' => 'kernel.finish_request',
                'Symfony\\Component\\HttpKernel\\Event\\RequestEvent' => 'kernel.request',
                'Symfony\\Component\\HttpKernel\\Event\\ViewEvent' => 'kernel.view',
                'Symfony\\Component\\HttpKernel\\Event\\ExceptionEvent' => 'kernel.exception',
                'Symfony\\Component\\HttpKernel\\Event\\TerminateEvent' => 'kernel.terminate',
                'Nelmio\\SecurityBundle\\ContentSecurityPolicy\\Violation\\ReportEvent' => 'csp.violation.report',
                'Symfony\\Component\\Security\\Core\\Event\\AuthenticationSuccessEvent' => 'security.authentication.success',
                'Symfony\\Component\\Security\\Core\\Event\\AuthenticationFailureEvent' => 'security.authentication.failure',
                'Symfony\\Component\\Security\\Http\\Event\\InteractiveLoginEvent' => 'security.interactive_login',
                'Symfony\\Component\\Security\\Http\\Event\\SwitchUserEvent' => 'security.switch_user',
                'Contao\\CoreBundle\\Event\\GenerateSymlinksEvent' => 'contao.generate_symlinks',
                'Contao\\CoreBundle\\Event\\MenuEvent' => 'contao.backend_menu_build',
                'Contao\\CoreBundle\\Event\\PreviewUrlCreateEvent' => 'contao.preview_url_create',
                'Contao\\CoreBundle\\Event\\PreviewUrlConvertEvent' => 'contao.preview_url_convert',
                'Contao\\CoreBundle\\Event\\RobotsTxtEvent' => 'contao.robots_txt',
                'Contao\\CoreBundle\\Event\\SlugValidCharactersEvent' => 'contao.slug_valid_characters',
                'Contao\\InstallationBundle\\Event\\InitializeApplicationEvent' => 'contao_installation.initialize_application',
            ],
            'fragment.renderer.hinclude.global_template' => NULL,
            'fragment.path' => '/_fragment',
            'kernel.http_method_override' => true,
            'kernel.trusted_hosts' => [

            ],
            'kernel.default_locale' => 'en',
            'kernel.enabled_locales' => [

            ],
            'kernel.error_controller' => 'error_controller',
            'debug.file_link_format' => NULL,
            'asset.request_context.base_path' => NULL,
            'asset.request_context.secure' => NULL,
            'translator.logging' => false,
            'translator.default_path' => (\dirname(__DIR__, 4).'/translations'),
            'debug.error_handler.throw_at' => 0,
            'router.request_context.host' => 'localhost',
            'router.request_context.scheme' => 'http',
            'router.request_context.base_url' => '',
            'router.resource' => 'contao_manager.routing.route_loader::loadFromPlugins',
            'request_listener.http_port' => 80,
            'request_listener.https_port' => 443,
            'session.metadata.storage_key' => '_sf2_meta',
            'session.storage.options' => [
                'cache_limiter' => '0',
                'cookie_secure' => 'auto',
                'cookie_httponly' => true,
                'cookie_samesite' => 'lax',
                'gc_probability' => 1,
            ],
            'session.save_path' => NULL,
            'session.metadata.update_threshold' => 0,
            'data_collector.templates' => [

            ],
            'monolog.use_microseconds' => true,
            'monolog.swift_mailer.handlers' => [

            ],
            'monolog.handlers_to_channels' => [
                'monolog.handler.deprecation' => [
                    'type' => 'inclusive',
                    'elements' => [
                        0 => 'deprecation',
                    ],
                ],
                'monolog.handler.console' => NULL,
                'monolog.handler.main' => [
                    'type' => 'exclusive',
                    'elements' => [
                        0 => 'deprecation',
                    ],
                ],
                'monolog.handler.contao' => NULL,
            ],
            'fos_http_cache.cacheable.response.additional_status' => [

            ],
            'fos_http_cache.proxy_client.symfony.options' => [
                'tags_header' => 'X-Cache-Tags',
                'tags_method' => 'PURGETAGS',
                'purge_method' => 'PURGE',
            ],
            'fos_http_cache.cache_manager.generate_url_type' => 0,
            'fos_http_cache.compiler_pass.tag_annotations' => false,
            'fos_http_cache.tag_handler.response_header' => 'X-Cache-Tags',
            'fos_http_cache.tag_handler.separator' => ',',
            'fos_http_cache.tag_handler.strict' => false,
            'nelmio_cors.map' => [

            ],
            'nelmio_cors.defaults' => [
                'allow_origin' => [

                ],
                'allow_credentials' => false,
                'allow_headers' => [

                ],
                'allow_private_network' => false,
                'expose_headers' => [

                ],
                'allow_methods' => [

                ],
                'max_age' => 0,
                'hosts' => [

                ],
                'origin_regex' => false,
                'forced_allow_origin_value' => NULL,
                'skip_same_as_origin' => true,
            ],
            'nelmio_cors.cors_listener.class' => 'Nelmio\\CorsBundle\\EventListener\\CorsListener',
            'nelmio_cors.options_resolver.class' => 'Nelmio\\CorsBundle\\Options\\Resolver',
            'nelmio_cors.options_provider.config.class' => 'Nelmio\\CorsBundle\\Options\\ConfigProvider',
            'nelmio_security.clickjacking.paths' => [
                '^/.*' => [
                    'header' => 'SAMEORIGIN',
                ],
            ],
            'nelmio_security.clickjacking.content_types' => [

            ],
            'nelmio_security.nonce_generator.number_of_bytes' => 16,
            'nelmio_security.csp.hash_algorithm' => 'sha256',
            'nelmio_security.csp.report_log_level' => 'notice',
            'nelmio_security.content_type.nosniff' => true,
            'nelmio_security.referrer_policy.policies' => [
                0 => 'no-referrer-when-downgrade',
                1 => 'strict-origin-when-cross-origin',
            ],
            'scheb_two_factor.model_manager_name' => NULL,
            'scheb_two_factor.security_tokens' => [
                0 => 'Symfony\\Component\\Security\\Core\\Authentication\\Token\\UsernamePasswordToken',
                1 => 'Symfony\\Component\\Security\\Guard\\Token\\PostAuthenticationGuardToken',
                2 => 'Symfony\\Component\\Security\\Http\\Authenticator\\Token\\PostAuthenticationToken',
            ],
            'scheb_two_factor.ip_whitelist' => [

            ],
            'scheb_two_factor.trusted_device.enabled' => true,
            'scheb_two_factor.trusted_device.cookie_name' => 'trusted_device',
            'scheb_two_factor.trusted_device.lifetime' => 5184000,
            'scheb_two_factor.trusted_device.extend_lifetime' => false,
            'scheb_two_factor.trusted_device.cookie_secure' => NULL,
            'scheb_two_factor.trusted_device.cookie_same_site' => 'lax',
            'scheb_two_factor.trusted_device.cookie_domain' => NULL,
            'scheb_two_factor.trusted_device.cookie_path' => '/',
            'knp_menu.renderer.list.options' => [

            ],
            'knp_menu.twig.extension.class' => 'Knp\\Menu\\Twig\\MenuExtension',
            'knp_menu.renderer.twig.class' => 'Knp\\Menu\\Renderer\\TwigRenderer',
            'knp_menu.renderer.twig.options' => [

            ],
            'knp_menu.renderer.twig.template' => '@KnpMenu/menu.html.twig',
            'knp_menu.default_renderer' => 'twig',
            'time.datetime_formatter.class' => 'Knp\\Bundle\\TimeBundle\\DateTimeFormatter',
            'time.twig.extension.time.class' => 'Knp\\Bundle\\TimeBundle\\Twig\\Extension\\TimeExtension',
            'time.templating.helper.time.class' => 'Knp\\Bundle\\TimeBundle\\Templating\\Helper\\TimeHelper',
            'cmf_routing.replace_symfony_router' => true,
            'twig.form.resources' => [
                0 => 'form_div_layout.html.twig',
            ],
            'twig.default_path' => (\dirname(__DIR__, 4).'/templates'),
            'security.role_hierarchy.roles' => [

            ],
            'security.access.denied_url' => NULL,
            'security.authentication.manager.erase_credentials' => true,
            'security.authentication.session_strategy.strategy' => 'migrate',
            'security.access.always_authenticate_before_granting' => false,
            'security.authentication.hide_user_not_found' => true,
            'security.firewalls' => [
                0 => 'contao_install',
                1 => 'contao_backend',
                2 => 'contao_frontend',
            ],
            'security.contao_backend._indexed_authenticators' => [

            ],
            'security.contao_frontend._indexed_authenticators' => [

            ],
            'contao.web_dir' => (\dirname(__DIR__, 4).'/public'),
            'contao.upload_path' => 'files',
            'contao.editable_files' => 'css,csv,html,ini,js,json,less,md,scss,svg,svgz,ts,txt,xliff,xml,yml,yaml',
            'contao.preview_script' => '/preview.php',
            'contao.csrf_cookie_prefix' => 'csrf_',
            'contao.csrf_token_name' => 'contao_csrf_token',
            'contao.pretty_error_screens' => true,
            'contao.error_level' => 8183,
            'contao.locales' => [
                0 => 'en',
                1 => 'nl',
                2 => 'fr',
                3 => 'fa',
                4 => 'cs',
                5 => 'pl',
                6 => 'es',
                7 => 'tr',
                8 => 'sr',
                9 => 'sl',
                10 => 'it',
                11 => 'ru',
                12 => 'pt',
                13 => 'lv',
                14 => 'sv',
                15 => 'de',
                16 => 'ja',
            ],
            'contao.image.bypass_cache' => false,
            'contao.image.target_dir' => (\dirname(__DIR__, 4).'/assets/images'),
            'contao.image.valid_extensions' => [
                0 => 'jpg',
                1 => 'jpeg',
                2 => 'gif',
                3 => 'png',
                4 => 'tif',
                5 => 'tiff',
                6 => 'bmp',
                7 => 'svg',
                8 => 'svgz',
                9 => 'webp',
            ],
            'contao.image.imagine_options' => [
                'jpeg_quality' => 80,
                'jpeg_sampling_factors' => [
                    0 => 2,
                    1 => 1,
                    2 => 1,
                ],
                'interlace' => 'plane',
            ],
            'contao.image.reject_large_uploads' => false,
            'contao.image.preview.target_dir' => (\dirname(__DIR__, 4).'/assets/previews'),
            'contao.image.preview.default_size' => 512,
            'contao.image.preview.max_size' => 1024,
            'contao.security.two_factor.enforce_backend' => false,
            'contao.localconfig' => [

            ],
            'contao.backend.attributes' => [

            ],
            'contao.backend.custom_css' => [

            ],
            'contao.backend.custom_js' => [

            ],
            'contao.backend.badge_title' => '',
            'contao.intl.locales' => [

            ],
            'contao.intl.enabled_locales' => [

            ],
            'contao.intl.countries' => [

            ],
            'contao.insert_tags.allowed_tags' => [
                0 => '*',
            ],
            'contao.sanitizer.allowed_url_protocols' => [
                0 => 'http',
                1 => 'https',
                2 => 'ftp',
                3 => 'mailto',
                4 => 'tel',
                5 => 'data',
                6 => 'skype',
                7 => 'whatsapp',
            ],
            'contao.search.default_indexer.enable' => true,
            'contao.search.index_protected' => false,
            'contao.legacy_routing' => true,
            'contao.prepend_locale' => false,
            'contao.url_suffix' => '.html',
            'contao_manager.manager_path' => NULL,
            'kernel.packages' => [
                'ausi/slug-generator' => '1.1.1',
                'bacon/bacon-qr-code' => '2.0.8',
                'beberlei/assert' => '3.3.2',
                'bugbuster/contao-cron-bundle' => '1.5.7',
                'clue/stream-filter' => '1.7.0',
                'codefog/contao-mobile_menu' => '2.7.3',
                'composer/ca-bundle' => '1.5.1',
                'composer/pcre' => '1.0.1',
                'composer/semver' => '3.4.2',
                'composer/xdebug-handler' => '2.0.5',
                'contao-community-alliance/composer-plugin' => '3.2.4',
                'contao-components/ace' => '1.35.4',
                'contao-components/chosen' => '1.2.5',
                'contao-components/colorbox' => '1.6.4.2',
                'contao-components/colorpicker' => '1.5.3',
                'contao-components/contao' => '9.3.6',
                'contao-components/datepicker' => '2.3.2',
                'contao-components/dropzone' => '5.9.3',
                'contao-components/installer' => '1.4.1',
                'contao-components/jquery' => '3.7.1',
                'contao-components/jquery-ui' => '1.13.2',
                'contao-components/mediabox' => '1.5.4.3',
                'contao-components/mootools' => '1.6.0.9',
                'contao-components/simplemodal' => '2.1.2',
                'contao-components/swipe' => '2.2.2',
                'contao-components/tablesort' => '4.0.2',
                'contao-components/tablesorter' => '2.31.3.1',
                'contao-components/tinymce4' => '5.10.9',
                'contao/calendar-bundle' => '4.13.46',
                'contao/comments-bundle' => '4.13.46',
                'contao/conflicts' => 'dev-main',
                'contao/core-bundle' => '4.13.46',
                'contao/faq-bundle' => '4.13.46',
                'contao/image' => '1.2.1',
                'contao/imagine-svg' => '1.0.3',
                'contao/installation-bundle' => '4.13.46',
                'contao/listing-bundle' => '4.13.46',
                'contao/managed-edition' => '1.0.0+no-version-set',
                'contao/manager-bundle' => '4.13.46',
                'contao/manager-plugin' => '2.13.2',
                'contao/news-bundle' => '4.13.46',
                'contao/newsletter-bundle' => '4.13.46',
                'dasprid/enum' => '1.0.5',
                'dflydev/dot-access-data' => '3.0.3',
                'dklemmt/contao_dk_mmenu' => '2.1.1',
                'doctrine/annotations' => '1.14.3',
                'doctrine/cache' => '2.2.0',
                'doctrine/collections' => '1.8.0',
                'doctrine/common' => '3.4.4',
                'doctrine/dbal' => '3.8.7',
                'doctrine/deprecations' => '1.1.3',
                'doctrine/doctrine-bundle' => '2.12.0',
                'doctrine/event-manager' => '1.2.0',
                'doctrine/inflector' => '2.0.10',
                'doctrine/instantiator' => '1.5.0',
                'doctrine/lexer' => '2.1.1',
                'doctrine/orm' => '2.19.6',
                'doctrine/persistence' => '2.5.7',
                'doctrine/sql-formatter' => '1.3.0',
                'dragonmantank/cron-expression' => '2.3.1',
                'egulias/email-validator' => '3.2.6',
                'friendsofphp/php-cs-fixer' => '2.19.3',
                'friendsofphp/proxy-manager-lts' => '1.0.18',
                'friendsofsymfony/http-cache' => '2.16.2',
                'friendsofsymfony/http-cache-bundle' => '2.17.1',
                'fritzmg/contao-store-uuid' => '1.1.0',
                'heimrichhannot/subcolumns' => '3.1.9',
                'imagine/imagine' => '1.3.5',
                'inspiredminds/contao-wowjs' => '1.1.7',
                'knplabs/knp-menu' => '3.3.0',
                'knplabs/knp-menu-bundle' => '3.2.0',
                'knplabs/knp-time-bundle' => '1.20.0',
                'laminas/laminas-code' => '4.7.1',
                'lcobucci/clock' => '2.0.0',
                'lcobucci/jwt' => '4.3.0',
                'league/commonmark' => '2.5.1',
                'league/config' => '1.2.0',
                'league/flysystem' => '2.5.0',
                'league/flysystem-bundle' => '2.4.0',
                'league/mime-type-detection' => '1.15.0',
                'madeyourday/contao-rocksolid-antispam' => '2.1.0',
                'madeyourday/contao-rocksolid-slider' => '2.2.6',
                'marcel-mathias-nolte/contao-jquery-in-backend' => '0.5',
                'matthiasmullie/minify' => '1.3.73',
                'matthiasmullie/path-converter' => '1.1.3',
                'menatwork/contao-multicolumnwizard-bundle' => '3.5.9',
                'monolog/monolog' => '2.9.3',
                'nelmio/cors-bundle' => '2.5.0',
                'nelmio/security-bundle' => '2.12.0',
                'nette/schema' => '1.2.5',
                'nette/utils' => '3.2.10',
                'nikic/php-parser' => '4.19.1',
                'npm-asset/jquery.panzoom' => '3.2.3',
                'nyholm/psr7' => '1.8.1',
                'paragonie/constant_time_encoding' => '2.7.0',
                'paragonie/random_compat' => '9.99.100',
                'php-cs-fixer/diff' => '1.3.1',
                'php-http/client-common' => '2.7.1',
                'php-http/discovery' => '1.19.4',
                'php-http/httplug' => '2.4.0',
                'php-http/message' => '1.16.1',
                'php-http/message-factory' => '1.1.0',
                'php-http/promise' => '1.3.1',
                'phpspec/php-diff' => '1.1.3',
                'psr/cache' => '1.0.1',
                'psr/container' => '1.1.2',
                'psr/event-dispatcher' => '1.0.0',
                'psr/http-client' => '1.0.3',
                'psr/http-factory' => '1.1.0',
                'psr/http-message' => '1.1',
                'psr/log' => '1.1.4',
                'scheb/2fa-backup-code' => '5.13.2',
                'scheb/2fa-bundle' => '5.13.2',
                'scheb/2fa-trusted-device' => '5.13.2',
                'scrivo/highlight.php' => '9.18.1.10',
                'scssphp/scssphp' => '1.12.1',
                'sensiolabs/ansi-to-html' => '1.2.1',
                'simplepie/simplepie' => '1.8.0',
                'spatie/schema-org' => '3.9.0',
                'spomky-labs/otphp' => '10.0.3',
                'symfony-cmf/routing' => '2.3.4',
                'symfony-cmf/routing-bundle' => '2.5.1',
                'symfony/asset' => '5.4.21',
                'symfony/cache' => '5.4.25',
                'symfony/cache-contracts' => '2.5.2',
                'symfony/config' => '5.4.21',
                'symfony/console' => '5.4.24',
                'symfony/debug' => '4.4.44',
                'symfony/debug-bundle' => '5.4.21',
                'symfony/dependency-injection' => '5.4.25',
                'symfony/deprecation-contracts' => '2.5.2',
                'symfony/doctrine-bridge' => '5.4.25',
                'symfony/dom-crawler' => '5.4.25',
                'symfony/dotenv' => '5.4.22',
                'symfony/error-handler' => '5.4.24',
                'symfony/event-dispatcher' => '5.4.22',
                'symfony/event-dispatcher-contracts' => '2.5.2',
                'symfony/expression-language' => '5.4.21',
                'symfony/filesystem' => '5.4.25',
                'symfony/finder' => '5.4.21',
                'symfony/framework-bundle' => '5.4.25',
                'symfony/http-client' => '5.4.25',
                'symfony/http-client-contracts' => '2.5.2',
                'symfony/http-foundation' => '5.4.25',
                'symfony/http-kernel' => '5.4.25',
                'symfony/intl' => '5.4.25',
                'symfony/lock' => '5.4.25',
                'symfony/mailer' => '5.4.22',
                'symfony/mime' => '5.4.23',
                'symfony/monolog-bridge' => '5.4.22',
                'symfony/monolog-bundle' => '3.8.0',
                'symfony/options-resolver' => '5.4.21',
                'symfony/password-hasher' => '5.4.21',
                'symfony/polyfill-ctype' => '1.27.0',
                'symfony/polyfill-intl-grapheme' => '1.27.0',
                'symfony/polyfill-intl-idn' => '1.27.0',
                'symfony/polyfill-intl-normalizer' => '1.27.0',
                'symfony/polyfill-mbstring' => '1.27.0',
                'symfony/polyfill-php70' => '1.20.0',
                'symfony/polyfill-php72' => '1.27.0',
                'symfony/polyfill-php73' => '1.27.0',
                'symfony/polyfill-php80' => '1.27.0',
                'symfony/polyfill-php81' => '1.27.0',
                'symfony/polyfill-uuid' => '1.30.0',
                'symfony/process' => '5.4.24',
                'symfony/property-access' => '5.4.22',
                'symfony/property-info' => '5.4.24',
                'symfony/proxy-manager-bridge' => '5.4.21',
                'symfony/routing' => '5.4.25',
                'symfony/security-bundle' => '5.4.22',
                'symfony/security-core' => '5.4.22',
                'symfony/security-csrf' => '5.4.21',
                'symfony/security-guard' => '5.4.22',
                'symfony/security-http' => '5.4.23',
                'symfony/service-contracts' => '2.5.2',
                'symfony/stopwatch' => '5.4.21',
                'symfony/string' => '5.4.22',
                'symfony/templating' => '5.4.21',
                'symfony/translation' => '5.4.24',
                'symfony/translation-contracts' => '2.5.2',
                'symfony/twig-bridge' => '5.4.22',
                'symfony/twig-bundle' => '5.4.21',
                'symfony/uid' => '5.4.40',
                'symfony/var-dumper' => '5.4.25',
                'symfony/var-exporter' => '5.4.21',
                'symfony/web-profiler-bundle' => '5.4.24',
                'symfony/yaml' => '5.4.23',
                'tabularasadev/contao-fonctions' => 'dev-main',
                'tabularasadev/contao-petitescdc' => 'dev-main',
                'tabularasadev/contao-typechamp' => '1.0.3',
                'terminal42/contao-mailusername' => '1.0.9',
                'terminal42/escargot' => '1.5.3',
                'terminal42/service-annotation-bundle' => '1.1.6',
                'thecodingmachine/safe' => '1.3.3',
                'toflar/psr6-symfony-http-cache-store' => '3.0.1',
                'twig/extra-bundle' => '3.10.0',
                'twig/twig' => '3.10.3',
                'ua-parser/uap-php' => '3.9.14',
                'webignition/disallowed-character-terminated-string' => '2.0',
                'webignition/robots-txt-file' => '3.0',
                'wikimedia/less.php' => '1.8.2',
            ],
            'contao.resources_paths' => [
                0 => (\dirname(__DIR__, 4).'/vendor/contao/core-bundle/src/Resources/contao'),
                1 => (\dirname(__DIR__, 4).'/vendor/contao/manager-bundle/src/Resources/contao'),
                2 => (\dirname(__DIR__, 4).'/vendor/madeyourday/contao-rocksolid-antispam/src/Resources/contao'),
                3 => (\dirname(__DIR__, 4).'/vendor/tabularasadev/contao-petitescdc/src/Resources/contao'),
                4 => (\dirname(__DIR__, 4).'/vendor/menatwork/contao-multicolumnwizard-bundle/src/Resources/contao'),
                5 => (\dirname(__DIR__, 4).'/vendor/inspiredminds/contao-wowjs/src/Resources/contao'),
                6 => (\dirname(__DIR__, 4).'/system/modules/Subcolumns'),
                7 => (\dirname(__DIR__, 4).'/system/modules/mobile_menu'),
                8 => (\dirname(__DIR__, 4).'/vendor/contao/faq-bundle/src/Resources/contao'),
                9 => (\dirname(__DIR__, 4).'/vendor/contao/comments-bundle/src/Resources/contao'),
                10 => (\dirname(__DIR__, 4).'/vendor/marcel-mathias-nolte/contao-jquery-in-backend/src/Resources/contao'),
                11 => (\dirname(__DIR__, 4).'/system/modules/store_uuid'),
                12 => (\dirname(__DIR__, 4).'/vendor/contao/news-bundle/src/Resources/contao'),
                13 => (\dirname(__DIR__, 4).'/vendor/tabularasadev/contao-fonctions/src/Resources/contao'),
                14 => (\dirname(__DIR__, 4).'/vendor/contao/listing-bundle/src/Resources/contao'),
                15 => (\dirname(__DIR__, 4).'/vendor/contao/calendar-bundle/src/Resources/contao'),
                16 => (\dirname(__DIR__, 4).'/vendor/contao/newsletter-bundle/src/Resources/contao'),
                17 => (\dirname(__DIR__, 4).'/vendor/bugbuster/contao-cron-bundle/src/Resources/contao'),
                18 => (\dirname(__DIR__, 4).'/system/modules/dk_mmenu'),
                19 => (\dirname(__DIR__, 4).'/system/modules/mailusername'),
                20 => (\dirname(__DIR__, 4).'/vendor/madeyourday/contao-rocksolid-slider/src/Resources/contao'),
            ],
            'console.command.ids' => [
                0 => 'console.command.public_alias.fos_http_cache.command.invalidate_path',
                1 => 'console.command.public_alias.fos_http_cache.command.invalidate_regex',
                2 => 'console.command.public_alias.fos_http_cache.command.refresh_path',
                3 => 'console.command.public_alias.fos_http_cache.command.clear',
            ],
        ];
    }

    protected function throw($message)
    {
        throw new RuntimeException($message);
    }
}
