class Carte {
    constructor(id) {
        //Variables
        this.mapId = id;
        this.version = "<!#FV> 0.2.0 </#FV>";
        this.modeEdition = false;
        this.map = $(this.mapId).craftmap({
            image: {
                width: $(this.mapId)[0].getAttribute("width"),
                height: $(this.mapId)[0].getAttribute("height"),
            },
            preloader: false,
        });
        this.toast = Swal.mixin({
            toast: true,
            position: "bottom-start",
            showConfirmButton: false,
            timer: 2000,
            timerProgressBar: true,
            didOpen: (toast) => {
                toast.onmouseenter = Swal.stopTimer;
                toast.onmouseleave = Swal.resumeTimer;
            },
        });

        // Fonctions
        for (const key of Object.getOwnPropertyNames(Object.getPrototypeOf(this))) {
            const method = this[key];
            if (typeof method === "function" && key !== "constructor") {
                this[key] = method.bind(this);
            }
        }

        // Événements
        $("#modeEdition").on("click", this.toggleEdition);
        $(id).on("click", this.clickMap);
        $(".marker").on("click", this.clickMap);
        $("#formItem").on("submit", this.postForm);

        console.log(`Carte V${this.version}`);
        return this;
    }

    clickMap(event) {
        if (this.modeEdition) {
            if ($(event.target).hasClass("marker")) {
                const coord = $(event.target).data("coords").split(",");
                $("input[name=id]").val($(event.target).data("id"));
                $("input[name=name]").val($(event.target).data("name"));
                $("input[name=posX]").val(coord[0]);
                $("input[name=posY]").val(coord[1]);
            } else {
                $("input[name=id]").val("");
                $("input[name=name]").val("");
                $("input[name=posX]").val(event.offsetX);
                $("input[name=posY]").val(event.offsetY);
            }
            console.log(this.map);
        }
    }

    editItem(event) {
        event.preventDefault();

        let parent = $(event.target).closest("div.marker");
        console.log(parent);
    }

    async postForm(event) {
        if (event) {
            event.preventDefault();
        }

        const formData = $(event.target).serialize(),
            carte = this;

        // Make an AJAX request
        $.ajax({
            type: "POST",
            url: document.location.href, // Replace with the actual backend script URL
            data: formData,
            success: function (response) {
                // Handle the success response
                carte.toast.fire({
                    icon: "success",
                    title: `Point ajouté/modifié`,
                });
            },
            error: function (error) {
                // Handle the error
                carte.toast.fire({
                    icon: "error",
                    title: `Une erreur s'est produite. Vérifiez la console.`,
                });
                console.error(error);
            },
        });
    }

    async prepareYT() {
        console.log("Prepare YT");

        // Attendre que la bibliothèque YouTube Embed API soit chargée
        if (typeof YT === "undefined" || typeof YT.Player === "undefined") {
            setTimeout(() => this.prepareYT(), 1000);
            return;
        }

        let players = [];
        const videosW = window.screen.width > 350 ? 350 : window.screen.width * 0.95,
            videosH = (videosW * 9) / 16;
        console.log(videosW, videosH);

        $(".players").each(function (index, item) {
            const idVid = $(item).data("id");
            players.push(
                new YT.Player(item, {
                    width: videosW,
                    height: videosH,
                    videoId: idVid,
                })
            );
        });
    }

    toggleEdition(event) {
        if (event) {
            event.preventDefault();
        }

        let str = "OFF",
            cursor = "move";

        this.modeEdition = !this.modeEdition;
        if (this.modeEdition == true) {
            str = "ON";
            cursor = "pointer";
        }
        $(this.mapId).css("cursor", cursor);
        $("#formItem").toggle();
        $("#modeEdition").toggleClass("actif");
        $("#modeEdition span").text(str);
    }
}

let map = null;

function onYouTubeIframeAPIReady() {
    map.prepareYT();
}

jQuery("document").ready(function ($) {
    map = new Carte("#map");
});
