/*
<!#CR>
************************************************************************************************************************
*                                                    Copyrigths ©                                                      *
* -------------------------------------------------------------------------------------------------------------------- *
*          Authors Names    > Jimmy Nogherot                                                                           *
*          Authors Email    > jimmy@tabularasa.fr                                                                      *
*          Company Name     > Tabularasa                                                                               *
*          Company Email    > jimmy@tabularasa.fr                                                                      *
*          Company Websites > https://tabularasa.fr                                                                    *
* -------------------------------------------------------------------------------------------------------------------- *
*                                           File and License Informations                                              *
* -------------------------------------------------------------------------------------------------------------------- *
*          File Name        > <!#FN> frontendModules.js </#FN>
*          File Birth       > <!#FB> 2020/10/05 15:04:12.484 </#FB>                                                    *
*          File Mod         > <!#FT> 2023/05/10 17:01:35.191 </#FT>                                                    *
*          License          > <!#LT> BSD-3-Clause-Attribution </#LT>
*                             <!#LU> https://spdx.org/licenses/BSD-3-Clause-Attribution.html </#LU>
*                             <!#LD> This file may not be redistributed in whole or significant part. </#LD>
*          File Version     > <!#FV> 1.0.39 </#FV>
*                                                                                                                      *
******************************************* VSCode Extension: Version Boss *********************************************
</#CR>
*/

let MASQUES = [];

jQuery("document").ready(function ($) {
    var version = "frontendModules.js <!#FV> 1.0.39 </#FV>";
    //console.log(version);

    //#region Viewer photosphere pour les photos 360°
    if ($(".photosphere").length > 0) {
        $(".photosphere").each(function () {
            var image = $(this).data("image"),
                titre = $(this).data("titre"),
                viewer = new PhotoSphereViewer.Viewer({
                    container: this.id,
                    panorama: image,
                    caption: titre,
                    autorotateDelay: 500,
                });
        });
    }
    //#endregion

    //#region Bouton pour remonter en haut de page
    if ($("#goTop").length > 0) {
        window.onscroll = function () {
            if (document.body.scrollTop > 20 || document.documentElement.scrollTop > 20) {
                $("#goTop").show();
            } else {
                $("#goTop").hide();
            }
        };
        $("#goTop").on("click", function () {
            $("html,body").animate(
                {
                    scrollTop: 0,
                },
                "slow"
            );
        });
    }
    //#endregion

    //#region Champ date avec un masque
    if ($(".maskDateAuto").length > 0) {
        var idt = 0;
        $(".maskDateAuto input,input.maskDateAuto").each(function () {
            var parent = this,
                child = $(parent).clone().insertBefore(parent),
                child = child[0],
                baseDate = $(this).val();
            child.name = "dta_" + idt++;
            $(parent).hide();
            var momentFormat = "DD/MM/YYYY";
            //console.log(baseDate);
            var masque = IMask(child, {
                mask: Date,
                pattern: momentFormat,
                lazy: false,
                min: new Date(1900, 0, 1),
                max: new Date(2099, 0, 1),

                format: function (date) {
                    return moment(date).format(momentFormat);
                },
                parse: function (str) {
                    var dt = moment(str, momentFormat);
                    parent.value = dt.format("X");
                    return dt;
                },

                blocks: {
                    YYYY: {
                        mask: IMask.MaskedRange,
                        from: 1900,
                        to: 2099,
                    },
                    MM: {
                        mask: IMask.MaskedRange,
                        from: 1,
                        to: 12,
                    },
                    DD: {
                        mask: IMask.MaskedRange,
                        from: 1,
                        to: 31,
                    },
                },
            });

            if (baseDate != "") {
                masque.value = moment(baseDate, "X").format(momentFormat);
            }

            MASQUES.push(masque);
        });
    }

    /*Initialisation des champs date*/
    if ($(".champDate, .champDateU").length > 0) {
        $(".champDate input, .champDateU input").each(function () {
            var altFormat = "j F Y",
                hasTime = false;

            if ($(this).data("format")) {
                var format = $(this).data("format");
            } else {
                var format = "Y-m-d";

                if ($(this).hasClass("champDateU")) {
                    format = "U";
                }
            }

            if ($(this).hasClass("hasTime")) {
                altFormat += " H:i";
                hasTime = true;
            }

            $(this).flatpickr({
                locale: "fr",
                enableTime: hasTime,
                altInput: true,
                altFormat: altFormat,
                dateFormat: format,
            });
        });
    }
    if ($(".champDateH").length > 0) {
        $(".champDateH input").each(function () {
            var def = this.value ? this.value : "2:00";
            $(this).flatpickr({
                enableTime: true,
                noCalendar: true,
                dateFormat: "H:i",
                defaultDate: def,
                time_24hr: true,
            });
        });
    }
    //#endregion

    //#region Chronomètre / Compte à rebours
    var countTime = function (item) {
            if (item.toString().length < 13) return countTime(item * 10);
            else return item;
        },
        timeDiff = function (dateStart, dateEnd) {
            let start = countTime(dateStart),
                end = countTime(dateEnd);
            var difference = end - start;
            var daysDifference = Math.floor(difference / 1000 / 60 / 60 / 24);
            difference -= daysDifference * 1000 * 60 * 60 * 24;
            var hoursDifference = Math.floor(difference / 1000 / 60 / 60);
            difference -= hoursDifference * 1000 * 60 * 60;
            var minutesDifference = Math.floor(difference / 1000 / 60);
            difference -= minutesDifference * 1000 * 60;
            var secondsDifference = Math.floor(difference / 1000);

            var res = [];
            res["j"] = daysDifference;
            res["h"] = hoursDifference.toString().padStart(2, "0");
            res["m"] = minutesDifference.toString().padStart(2, "0");
            res["s"] = secondsDifference.toString().padStart(2, "0");

            return res;
        },
        majCompteur = function (item) {
            var date = $(item).data("end"),
                format = $(item).data("format"),
                diffs = timeDiff(Date.now(), date),
                texte = format,
                texte = texte.replace("%j", diffs["j"]).replace("%h", diffs["h"]).replace("%m", diffs["m"]).replace("%s", diffs["s"]);

            $(item).html(texte);
            setTimeout(function () {
                majCompteur(item);
            }, 1000);
        };

    if ($(".compteARebours").length > 0) {
        $(".compteARebours").each(function () {
            majCompteur(this);
        });
    }
    //#endregion

    //#region Champs Tags
    $(".tagsInput").each(function () {
        tags = $(this).tagsInput({
            width: "100%",
            height: "auto",
            defaultText: "ajouter un tag (appuyez sur la touche TAB pour valider votre tag)",
        });
    });
    //#endregion

    //#region LazyLoading
    $("img.lazyload").lazyload();
    //#endregion

    //#region Capitalisation, UpperCase et LowerCase
    if ($(".toUpper").length > 0) {
        $("input.toUpper").on("keyup", function () {
            this.value = this.value.toUpperCase();
        });
    }

    if ($(".toLower").length > 0) {
        $("input.toLower ").on("keyup", function () {
            this.value = this.value.toLowerCase();
        });
    }

    if ($(".toCapitalize").length > 0) {
        $("input.toCapitalize ").on("keyup", function () {
            let val = this.value.toLowerCase();
            this.value = val.charAt(0).toUpperCase() + val.slice(1);
        });
    }
    //#endregion

    //#region Header Fixe
    var stickyHeader = function () {
        if ($(window).scrollTop() > 0) {
            $("#header").addClass("sticky");
        } else {
            $("#header").removeClass("sticky");
        }
    };
    $(window).scroll(stickyHeader);
    //#endregion

    //#region Texte défilant
    if ($("#tagline").length > 0) {
        let boucle = $("#tagline").data("boucle") == "1" ? true : false,
            speedAv = $("#tagline").data("vitesseav") ? $("#tagline").data("vitesseav") : 100,
            speedAr = $("#tagline").data("vitessear") ? $("#tagline").data("vitessear") : 75;
        var t = new Typed("#tagline p", {
            stringsElement: "#typed-strings",
            typeSpeed: speedAv,
            backSpeed: speedAr,
            loop: boucle,
        });
    }
    //#endregion

    //#region Bouton pour signaler un bug
    $("#signaleUnBug").on("click", function (event) {
        event.preventDefault();
        Swal.fire({
            title: "Signaler un bug",
            text: "Vous rencontrez un bug, un blocage ou une erreur en particulier ? Décrivez-nous le problème.",
            input: "textarea",
            showCloseButton: true,
            confirmButtonText: "Envoyer",
            showLoaderOnConfirm: true,
            preConfirm: (desc) => {
                return new Promise(function (resolve) {
                    const Toast = Swal.mixin({
                        toast: true,
                        position: "top-end",
                        showConfirmButton: false,
                        timer: 3000,
                        timerProgressBar: true,
                    });
                    let rt = $('input[name="bug_requestToken"]').val(),
                        url = document.location.href,
                        datas = {
                            REQUEST_TOKEN: rt,
                            bugPost: "1",
                            description: desc,
                            url: url,
                        };
                    $.ajax({
                        type: "POST",
                        url: url,
                        data: datas,
                    })
                        .done(function (data) {
                            Toast.fire({
                                icon: "success",
                                title: "Message envoyé avec succès",
                            });
                        })
                        .fail(function (jqXHR, textStatus) {
                            Toast.fire({
                                icon: "error",
                                title: "Une erreur s'est produite",
                            });
                        });
                });
            },
        });
    });
    //#endregion

    //#region Afficher une petite notifications
    if ($(".showNotif").length > 0) {
        $(".showNotif").each(function () {
            const Toast = Swal.mixin({
                toast: true,
                position: "top",
                showConfirmButton: false,
                timerProgressBar: true,
                didOpen: (toast) => {
                    toast.addEventListener("mouseenter", Swal.stopTimer);
                    toast.addEventListener("mouseleave", Swal.resumeTimer);
                },
            });

            let conf = {};

            //console.log(this);

            if ($(this).data("titre") != "") {
                conf.title = $(this).data("titre");
            }

            if ($(this).data("niveau") != "") {
                conf.icon = $(this).data("niveau");
            }

            if ($(this).data("text") != "") {
                conf.text = $(this).data("text");
            }

            if ($(this).data("delais") != false && $(this).data("delais") > 0) {
                conf.timer = $(this).data("delais");
            } else {
                conf.showCloseButton = true;
            }

            //console.log(conf);

            Toast.fire(conf);
        });
    }
    //#endregion

    //#region Select avec largeur dynamique
    if ($("select.dynamicWidth").length > 0) {
        let changeSelectWidth = function (select) {
            let o = select.options[select.selectedIndex],
                s = document.createElement("span");
            s.textContent = o.textContent;
            let ostyles = getComputedStyle(select);
            s.style.fontFamily = ostyles.fontFamily;
            s.style.fontStyle = ostyles.fontStyle;
            s.style.fontWeight = ostyles.fontWeight;
            s.style.fontSize = ostyles.fontSize;
            s.style.textTransform = ostyles.textTransform;
            document.body.appendChild(s);
            select.style.width = s.offsetWidth + 40 + "px";
            document.body.removeChild(s);
        };
        $("select.dynamicWidth").on("change", function (e) {
            changeSelectWidth(e.target);
        });

        $("select.dynamicWidth").each(function () {
            changeSelectWidth(this);
        });
    }
    //#endregion

    //#region MinHeight pour le bloc main pour éviter qu'on ai un footer flotant
    let ecran = window.innerHeight,
        bodyH = $("body").height(),
        footT = $("#footer").offset().top;
    if (ecran > footT) {
        let diff = ecran - bodyH;
        $("#footer").css("margin-top", diff + "px");
    }
    //#endregion
});
