
var expireDays=999;

function saveData(name, value) {
	if (typeof(localStorage) != 'undefined') {
		localStorage.setItem(name, value);
	} else {
		createCookie(name, value, expireDays);
	}
}

function loadData(name) {
	var temp_value = '';
	if (typeof(localStorage) != 'undefined') {
		temp_value = localStorage.getItem(name);
	} else {
		temp_value = readCookie(name);
	}
	return temp_value;
}

function eraseData(name) {
	if (typeof(localStorage) != 'undefined') {
		localStorage.removeItem(name);
	} else {
		eraseCookie(name);
	}
}

function createCookie(name,value,days) {
	var expires = "";

	if (days) {
		var date = new Date();
		date.setTime(date.getTime() + (days * 24 * 60 * 60 * 1000));
		expires = "; expires=" + date.toGMTString();
	}
	else {
		expires = "";
	}
	document.cookie = name+"="+value+expires+"; path=/";
}

function readCookie(name) {
	var nameEQ = name + "=";
	var ca = document.cookie.split(';');
	for(var i=0;i < ca.length;i++) {
		var c = ca[i];
		while (c.charAt(0)==' ') {
			c = c.substring(1,c.length);
		} 
		if (c.indexOf(nameEQ) === 0) {
			return c.substring(nameEQ.length, c.length);
		}
	}
	return null;
}

function eraseCookie(name) {
	createCookie(name,"",-1);
}


